<a id="section-truth-and-connective-questions"></a>14.13. <a id="c14s13"></a>Truth questions and connective questions
---------------------------------------------------------------------------------------------------------------------

So far we have addressed only sentences which are statements. Lojban, like all human languages, needs also to deal with sentences which are questions. There are many ways of asking questions in Lojban, but some of these (like questions about quantity, tense, and emotion) are discussed in other chapters.

<a id="id-1.15.15.3.1" class="indexterm"></a>The simplest kind of question is of the type “Is it true that ...” where some statement follows. This type is called a “truth question” , and can be represented in English by [Example 14.92](../section-truth-and-connective-questions#example-random-id-bMjE) :

<div class="example">
<a id="example-random-id-bMjE"></a>

**Example 14.92. <a id="c14e13d1"></a>** 

Is it true that Fido is a dog?

Is Fido a dog?

</div>  

Note the two formulations. English truth questions can always be formed by prefixing “Is is true that” to the beginning of a statement; there is also usually a more idiomatic way involving putting the verb before its subject. “Is Fido a dog?” is the truth question corresponding to “Fido is a dog”. In Lojban, the equivalent mechanism is to prefix the cmavo _<a id="id-1.15.15.5.4.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ (of selma'o UI) to the statement:

<div class="interlinear-gloss-example example">
<a id="example-random-id-gKaM"></a>

**Example 14.93. <a id="c14e13d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>la</td><td>.faidon.</td><td>gerku</td></tr><tr class="gloss"><td>Is-it-true-that</td><td>that-named</td><td>Fido</td><td>is-a-dog?</td></tr></tbody></table>

</div>  

[Example 14.92](../section-truth-and-connective-questions#example-random-id-bMjE) and [Example 14.93](../section-truth-and-connective-questions#example-random-id-gKaM) are equivalent in meaning.

<a id="id-1.15.15.8.1" class="indexterm"></a><a id="id-1.15.15.8.2" class="indexterm"></a><a id="id-1.15.15.8.3" class="indexterm"></a>A truth question can be answered “yes” or “no” , depending on the truth or falsity, respectively, of the underlying statement. The standard way of saying “yes” in Lojban is _<a id="id-1.15.15.8.7.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ and of saying “no” is _<a id="id-1.15.15.8.9.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ _<a id="id-1.15.15.8.10.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_. (The reasons for this rule are explained in [Section 7.6](../section-ri-gohi-series).) In answer to [Example 14.93](../section-truth-and-connective-questions#example-random-id-gKaM) , the possible answers are:

<div class="interlinear-gloss-example example">
<a id="example-random-id-XSmq"></a>

**Example 14.94. <a id="c14e13d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go'i</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Fido is a dog.</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-WI3P"></a>

**Example 14.95. <a id="c14e13d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nago'i</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Fido is not a dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.15.12.1" class="indexterm"></a>Some English questions seemingly have the same form as the truth questions so far discussed. Consider

<div class="example">
<a id="example-random-id-mftC"></a>

**Example 14.96. <a id="c14e13d5"></a><a id="id-1.15.15.13.1.2" class="indexterm"></a>** 

Is Fido a dog or a cat?

</div>  

Superficially, [Example 14.96](../section-truth-and-connective-questions#example-random-id-mftC) seems like a truth question with the underlying statement:

<div class="example">
<a id="example-random-id-n6Ec"></a>

**Example 14.97. <a id="c14e13d6"></a><a id="id-1.15.15.15.1.2" class="indexterm"></a>** 

Fido is a dog or a cat.

</div>  

By translating [Example 14.97](../section-truth-and-connective-questions#example-random-id-n6Ec) into Lojban and prefixing _<a id="id-1.15.15.16.2.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ to signal a truth question, we get:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hz4S"></a>

**Example 14.98. <a id="c14e13d7"></a><a id="id-1.15.15.17.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>la</td><td>.faidon.</td><td>gerku</td><td>gi'onai</td><td>mlatu</td></tr><tr class="gloss"><td>Is-it-true-that</td><td>that-named</td><td>Fido</td><td>is-a-dog</td><td>or</td><td>is-a-cat</td><td>(but&nbsp;not&nbsp;both)?</td></tr></tbody></table>

</div>  

Given that Fido really is either a dog or a cat, the appropriate answer would be _<a id="id-1.15.15.18.1.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ ; if Fido were a fish, the appropriate answer would be _<a id="id-1.15.15.18.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ _<a id="id-1.15.15.18.3.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_.

But that is not what an English-speaker who utters [Example 14.96](../section-truth-and-connective-questions#example-random-id-mftC) is asking! The true significance of [Example 14.96](../section-truth-and-connective-questions#example-random-id-mftC) is that the speaker desires to know the truth value of either of the two underlying bridi (it is presupposed that only one is true).

<a id="id-1.15.15.20.1" class="indexterm"></a>Lojban has an elegant mechanism for rendering this kind of question which is very unlike that used in English. Instead of asking about the truth value of the connected bridi, Lojban users ask about the truth function which connects them. This is done by using a special question cmavo: there is one of these for each of the logical connective selma'o, as shown by the following table:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ge'i</p></td><td class="selmaho"><p class="selmaho">GA</p></td><td class="description"><p class="description">forethought connective question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">gi'i</p></td><td class="selmaho"><p class="selmaho">GIhA</p></td><td class="description"><p class="description">bridi-tail connective question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">gu'i</p></td><td class="selmaho"><p class="selmaho">GUhA</p></td><td class="description"><p class="description">tanru forethought connective question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">je'i</p></td><td class="selmaho"><p class="selmaho">JA</p></td><td class="description"><p class="description">tanru connective question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ji</p></td><td class="selmaho"><p class="selmaho">A</p></td><td class="description"><p class="description">sumti connective question</p></td></tr></tbody></table>

<a id="id-1.15.15.22.1" class="indexterm"></a>(This list unfortunately departs from the pretty regularity of the other cmavo for logical connection. The two-syllable selma'o, GIhA and GUhA, make use of the cmavo ending in “\-i” which is not used for a truth function, but _<a id="id-1.15.15.22.3.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ and _<a id="id-1.15.15.22.4.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ were not available, and different cmavo had to be chosen. This table must simply be memorized, like most other non-connective cmavo assignments.)

<a id="id-1.15.15.23.1" class="indexterm"></a>One correct translation of [Example 14.96](../section-truth-and-connective-questions#example-random-id-mftC) employs a question gihek:

<div class="interlinear-gloss-example example">
<a id="example-random-id-G1Xs"></a>

**Example 14.99. <a id="c14e13d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>gerku</td><td>gi'i</td><td>mlatu</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>is-a-dog</td><td>[truth-function?]</td><td>is-a-cat?</td></tr></tbody></table>

</div>  

Here are some plausible answers:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGPp"></a>

**Example 14.100. <a id="c14e13d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nagi'e</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice is not a dog and is a cat.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qGPq"></a>

**Example 14.101. <a id="c14e13d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi'enai</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice is a dog and is not a cat.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgrw"></a>

**Example 14.102. <a id="c14e13d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nagi'enai</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice is not a dog and is not a cat.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qGRz"></a>

**Example 14.103. <a id="c14e13d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nagi'o</td></tr><tr class="jbo"><td>gi'onai</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice is a dog or is a cat but not both (I'm not saying which).</p></td></tr></tbody></table>

</div>  

[Example 14.103](../section-truth-and-connective-questions#example-random-id-qGRz) is correct but uncooperative.

<a id="id-1.15.15.31.1" class="indexterm"></a><a id="id-1.15.15.31.2" class="indexterm"></a>As usual, Lojban questions are answered by filling in the blank left by the question. Here the blank is a logical connective, and therefore it is grammatical in Lojban to utter a bare logical connective without anything for it to connect.

The answer _<a id="id-1.15.15.32.1.1" class="indexterm"></a>[_gi'e_](../go01#valsi-gihe)_ , meaning that Alice is a dog and is a cat, is impossible in the real world, but for:

<div class="interlinear-gloss-example example">
<a id="example-random-id-xtIf"></a>

**Example 14.104. <a id="c14e13d13"></a><a id="id-1.15.15.33.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djica</td><td>tu'a</td><td>loi</td><td>ckafi</td></tr><tr class="gloss"><td>You</td><td>desire</td><td>something-about</td><td>a-mass-of</td><td>coffee</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ji</td><td>loi</td><td>tcati</td></tr><tr class="gloss"><td>[truth-function?]</td><td>a-mass-of</td><td>tea?</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Do you want coffee or tea?</p></td></tr></tbody></table>

</div>  

the answer _<a id="id-1.15.15.34.1.1" class="indexterm"></a>[_.e_](../go01#valsi-e)_ , meaning that I want both, is perfectly plausible, if not necessarily polite.

<a id="id-1.15.15.35.1" class="indexterm"></a><a id="id-1.15.15.35.2" class="indexterm"></a><a id="id-1.15.15.35.3" class="indexterm"></a><a id="id-1.15.15.35.4" class="indexterm"></a>The forethought questions _<a id="id-1.15.15.35.5.1" class="indexterm"></a>[_ge'i_](../go01#valsi-gehi)_ and _<a id="id-1.15.15.35.6.1" class="indexterm"></a>[_gu'i_](../go01#valsi-guhi)_ are used like the others, but ambiguity forbids the use of isolated forethought connectives as answers – they sound like the start of forethought-connected bridi. So although [Example 14.105](../section-truth-and-connective-questions#example-random-id-286J) is the forethought version of [Example 14.104](../section-truth-and-connective-questions#example-random-id-xtIf) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-286J"></a>

**Example 14.105. <a id="c14e13d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djica</td><td>tu'a</td><td>ge'i</td><td>loi</td><td>ckafi</td></tr><tr class="gloss"><td>You</td><td>desire</td><td>something-about</td><td>[truth-function?]</td><td>a-mass-of</td><td>coffee</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi</td><td>loi</td><td>tcati</td></tr><tr class="gloss"><td>[or]</td><td>a-mass-of</td><td>tea?</td></tr></tbody></table>

</div>  

the answer must be in afterthought form.

<a id="id-1.15.15.38.1" class="indexterm"></a>There are natural languages, notably Chinese, which employ the Lojbanic form of connective question. The Chinese sentence

<div class="example">
<a id="example-random-id-HyVv"></a>

**Example 14.106. <a id="c14e13d15"></a>** 

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zh" class="foreignphrase" lang="zh"><em xml:lang="zh" class="foreignphrase" lang="zh">你走还是跑？</em></span></td></tr><tr><td><span xml:lang="zh" class="foreignphrase" lang="zh"><em xml:lang="zh" class="foreignphrase" lang="zh">Nǐ zǒu háishì pǎo?</em></span></td></tr><tr><td>You walk [or?] run?</td></tr></tbody></table>

</div>  

means “Do you walk or run?” , and is exactly parallel to the Lojban:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3jIq"></a>

**Example 14.107. <a id="c14e13d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cadzu</td><td>gi'i</td><td>bajra</td></tr><tr class="gloss"><td>You</td><td>walk</td><td>[or?]</td><td>run?</td></tr></tbody></table>

</div>  

<a id="id-1.15.15.42.1" class="indexterm"></a>However, Chinese does not use logical connectives in the reply to such a question, so the resemblance, though striking, is superficial.

<a id="id-1.15.15.43.1" class="indexterm"></a><a id="id-1.15.15.43.2" class="indexterm"></a><a id="id-1.15.15.43.3" class="indexterm"></a><a id="id-1.15.15.43.4" class="indexterm"></a>Truth questions may be used in bridi connection. This form of sentence is perfectly legitimate, and can be interpreted by using the convention that a truth question is true if the answer is “yes” and false if the answer is _<a id="id-1.15.15.43.6.1" class="indexterm"></a>[_no_](../go01#valsi-no)_. Analogously, an imperative sentence (involving the special pro-sumti _<a id="id-1.15.15.43.7.1" class="indexterm"></a>[_ko_](../go01#valsi-ko)_ , which means “you” but marks the sentence as a command) is true if the command is obeyed, and false otherwise. A request of Abraham Lincoln's may be translated thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-BPv0"></a>

**Example 14.108. <a id="c14e13d17"></a><a id="id-1.15.15.44.1.2" class="indexterm"></a><a id="id-1.15.15.44.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ganai</td><td>ti</td><td>ckafi</td><td>gi</td><td>ko</td><td>bevri</td><td>loi</td><td>tcati</td><td>mi</td></tr><tr class="gloss"><td>If</td><td>this</td><td>is-coffee</td><td>then</td><td>[you!]</td><td>bring</td><td>a-mass-of</td><td>tea</td><td>to-me,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>ganai</td><td>ti</td><td>tcati</td><td>gi</td><td>ko</td><td>bevri</td><td>loi</td><td>ckafi</td><td>mi</td></tr><tr class="gloss"><td>and</td><td>if</td><td>this</td><td>is-tea</td><td>then</td><td>[you!]</td><td>bring</td><td>a-mass-of</td><td>coffee</td><td>to-me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">If this is coffee, bring me tea; but if this is tea, bring me coffee.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.15.45.1" class="indexterm"></a><a id="id-1.15.15.45.2" class="indexterm"></a>In logical terms, however, “but” is the same as “and” ; the difference is that the sentence after a “but” is felt to be in tension or opposition to the sentence before it. Lojban represents this distinction by adding the discursive cmavo _<a id="id-1.15.15.45.6.1" class="indexterm"></a>[_ku'i_](../go01#valsi-kuhi)_ (of selma'o UI), which is explained in [Section 13.12](../section-discursives) , to the logical _<a id="id-1.15.15.45.8.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.15.45.9.1" class="indexterm"></a>[_je_](../go01#valsi-je)_.)