<a id="section-three-part-tanru"></a>5.3. <a id="c5s3"></a>Three-part tanru grouping with _bo_
----------------------------------------------------------------------------------------------

The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">bo</p></td><td class="selmaho"><p class="selmaho">BO</p></td><td class="description"><p class="description">closest scope grouping</p></td></tr></tbody></table>

<a id="id-1.6.5.4.1" class="indexterm"></a>Consider the English sentence:

<div class="interlinear-gloss-example example">
<a id="example-random-id-gCLr"></a>

**Example 5.16. <a id="id-1.6.5.5.1.1" class="indexterm"></a><a id="c5e3d1"></a>** 

That's a little girls' school.

</div>  

What does it mean? Two possible readings are:

<div class="interlinear-gloss-example example">
<a id="example-random-id-5UBW"></a>

**Example 5.17. <a id="id-1.6.5.7.1.1" class="indexterm"></a><a id="c5e3d2"></a>** 

That's a little school for girls.

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-5UBJ"></a>

**Example 5.18. <a id="id-1.6.5.8.1.1" class="indexterm"></a><a id="c5e3d3"></a>** 

That's a school for little girls.

</div>  

<a id="id-1.6.5.9.1" class="indexterm"></a>This ambiguity is quite different from the simple tanru ambiguity described in [Section 5.2](../section-simple-tanru). We understand that “girls' school” means “a school where girls are the students”, and not “a school where girls are the teachers” or “a school which is a girl” (!). Likewise, we understand that “little girl” means “girl who is small”. This is an ambiguity of grouping. Is “girls' school” to be taken as a unit, with “little” specifying the type of girls' school? Or is “little girl” to be taken as a unit, specifying the type of school? In English speech, different tones of voice, or exaggerated speech rhythm showing the grouping, are used to make the distinction; English writing usually leaves it unrepresented.

Lojban makes no use of tones of voice for any purpose; explicit words are used to do the work. The cmavo _<a id="id-1.6.5.10.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ (which belongs to selma'o BO) may be placed between the two brivla which are most closely associated. Therefore, a Lojban translation of [Example 5.17](../section-three-part-tanru#example-random-id-5UBW) would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nwuU"></a>

**Example 5.19. <a id="c5e3d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-small</td><td>girl</td><td>-</td><td>school.</td></tr></tbody></table>

</div>  

[Example 5.18](../section-three-part-tanru#example-random-id-5UBJ) might be translated:

<div class="interlinear-gloss-example example">
<a id="example-random-id-jquh"></a>

**Example 5.20. <a id="c5e3d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td>bo</td><td>nixli</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-small</td><td>-</td><td>girl</td><td>school.</td></tr></tbody></table>

</div>  

The _<a id="id-1.6.5.14.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is represented in the literal translation by a bracketed hyphen (not to be confused with the bare hyphen used as a placeholder in other glosses) because in written English a hyphen is sometimes used for the same purpose: “a big dog-catcher” would be quite different from a “big-dog catcher” (presumably someone who catches only big dogs).

<a id="id-1.6.5.15.1" class="indexterm"></a>Analysis of [Example 5.19](../section-three-part-tanru#example-random-id-nwuU) and [Example 5.20](../section-three-part-tanru#example-random-id-jquh) reveals a tanru nested within a tanru. In [Example 5.19](../section-three-part-tanru#example-random-id-nwuU), the main tanru has a seltau of _<a id="id-1.6.5.15.5.1" class="indexterm"></a>[_cmalu_](../go01#valsi-cmalu)_ and a tertau of _<a id="id-1.6.5.15.6.1" class="indexterm"></a>nixli bo ckule_; the tertau is itself a tanru with _<a id="id-1.6.5.15.7.1" class="indexterm"></a>[_nixli_](../go01#valsi-nixli)_ as the seltau and _<a id="id-1.6.5.15.8.1" class="indexterm"></a>[_ckule_](../go01#valsi-ckule)_ as the tertau. In [Example 5.20](../section-three-part-tanru#example-random-id-jquh), on the other hand, the seltau is _<a id="id-1.6.5.15.10.1" class="indexterm"></a>cmalu bo nixli_ (itself a tanru), whereas the tertau is _<a id="id-1.6.5.15.11.1" class="indexterm"></a>[_ckule_](../go01#valsi-ckule)_. This structure of tanru nested within tanru forms the basis for all the more complex types of selbri that will be explained below.

What about [Example 5.21](../section-three-part-tanru#example-random-id-9FPm) ? What does it mean?

<div class="interlinear-gloss-example example">
<a id="example-random-id-9FPm"></a>

**Example 5.21. <a id="c5e3d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td>nixli</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-small</td><td>girl</td><td>school.</td></tr></tbody></table>

</div>  

<a id="id-1.6.5.18.1" class="indexterm"></a><a id="id-1.6.5.18.2" class="indexterm"></a>The rules of Lojban do not leave this sentence ambiguous, as the rules of English do with [Example 5.16](../section-three-part-tanru#example-random-id-gCLr). The choice made by the language designers is to say that [Example 5.21](../section-three-part-tanru#example-random-id-9FPm) means the same as [Example 5.20](../section-three-part-tanru#example-random-id-jquh). This is true no matter what three brivla are used: the leftmost two are always grouped together. This rule is called the “left-grouping rule”. Left-grouping in seemingly ambiguous structures is quite common – though not universal – in other contexts in Lojban.

Another way to express the English meaning of [Example 5.19](../section-three-part-tanru#example-random-id-nwuU) and [Example 5.20](../section-three-part-tanru#example-random-id-jquh), using parentheses to mark grouping, is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ERBx"></a>

**Example 5.22. <a id="c5e3d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td></td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-small</td><td>type-of</td><td>(girl</td><td>type-of</td><td>school).</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-ERBQ"></a>

**Example 5.23. <a id="c5e3d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td>bo</td><td>nixli</td><td></td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-(small</td><td>type-of</td><td>girl)</td><td>type-of</td><td>school.</td></tr></tbody></table>

</div>  

Because “type-of” is implicit in the Lojban tanru form, it has no Lojban equivalent.

Note: It is perfectly legal, though pointless, to insert _<a id="id-1.6.5.23.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ into a simple tanru:

<div class="interlinear-gloss-example example">
<a id="example-random-id-q6br"></a>

**Example 5.24. <a id="c5e3d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>klama</td><td>bo</td><td>jubme</td></tr><tr class="gloss"><td>That</td><td>is-a-goer</td><td>-</td><td>table.</td></tr></tbody></table>

</div>  

is a legal Lojban bridi that means exactly the same thing as [Example 5.13](../section-simple-tanru#example-random-id-aIfM), and is ambiguous in exactly the same ways. The cmavo _<a id="id-1.6.5.25.2.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ serves only to resolve grouping ambiguity: it says nothing about the more basic ambiguity present in all tanru.