<a id="section-tenses"></a>2.17. <a id="c2s17"></a>Tenses
---------------------------------------------------------

<a id="id-1.3.19.2.1" class="indexterm"></a><a id="id-1.3.19.2.2" class="indexterm"></a>In English, every verb is tagged for the grammatical category called tense: past, present, or future. The sentence

<div class="example">
<a id="example-random-id-xIVa"></a>

**Example 2.87. <a id="c2e17d1"></a>** 

John went to the store

</div>  

necessarily happens at some time in the past, whereas

<div class="example">
<a id="example-random-id-1Acu"></a>

**Example 2.88. <a id="c2e17d2"></a>** 

John is going to the store

</div>  

is necessarily happening right now.

<a id="id-1.3.19.7.1" class="indexterm"></a>The Lojban sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1xz"></a>

**Example 2.89. <a id="c2e17d3"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">la djan.</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">klama</p></td><td><p class="sumti">le zarci</p></td></tr><tr class="gloss"><td><p class="sumti">John</p></td><td><p class="elidable">-</p></td><td><p class="selbri">goes/went/will-go</p></td><td><p class="sumti">to-the store</p></td></tr></tbody></table>

</div>  

serves as a translation of either [Example 2.87](../section-tenses#example-random-id-xIVa) or [Example 2.88](../section-tenses#example-random-id-1Acu), and of many other possible English sentences as well. It is not marked for tense, and can refer to an event in the past, the present or the future. This rule does not mean that Lojban has no way of representing the time of an event. A close translation of [Example 2.87](../section-tenses#example-random-id-xIVa) would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1Y5"></a>

**Example 2.90. <a id="c2e17d4"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">la djan.</p></td><td><p class="cmavo">pu</p></td><td><p class="selbri">klama</p></td><td><p class="sumti">le zarci</p></td></tr><tr class="gloss"><td><p class="sumti">John</p></td><td><p class="cmavo">[past]</p></td><td><p class="selbri">goes</p></td><td><p class="sumti">to-the store</p></td></tr></tbody></table>

</div>  

where the tag _<a id="id-1.3.19.11.1.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ forces the sentence to refer to a time in the past. Similarly,

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1Y8"></a>

**Example 2.91. <a id="c2e17d5"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">la djan.</p></td><td><p class="cmavo">ca</p></td><td><p class="selbri">klama</p></td><td><p class="sumti">le zarci</p></td></tr><tr class="gloss"><td><p class="sumti">John</p></td><td><p class="cmavo">[present]</p></td><td><p class="selbri">goes</p></td><td><p class="sumti">to-the store</p></td></tr></tbody></table>

</div>  

necessarily refers to the present, because of the tag _<a id="id-1.3.19.13.1.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_. Tags used in this way always appear at the very beginning of the selbri, just after the _<a id="id-1.3.19.13.2.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_, and they may make a _<a id="id-1.3.19.13.3.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ unnecessary, since tags cannot be absorbed into tanru. Such tags serve as an equivalent to English tenses and adverbs. In Lojban, tense information is completely optional. If unspecified, the appropriate tense is picked up from context.

<a id="id-1.3.19.14.1" class="indexterm"></a>Lojban also extends the notion of “tense” to refer not only to time but to space. The following example uses the tag _<a id="id-1.3.19.14.3.1" class="indexterm"></a>[_vu_](../go01#valsi-vu)_ to specify that the event it describes happens far away from the speaker:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k20b"></a>

**Example 2.92. <a id="c2e17d6"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">do</p></td><td><p class="selbri">vu vecnu</p></td><td><p class="sumti">zo'e</p></td></tr><tr class="gloss"><td><p class="sumti">You</p></td><td><p class="selbri">yonder sell</p></td><td><p class="sumti">something-unspecified.</p></td></tr></tbody></table>

</div>  

In addition, tense tags (either for time or space) can be prefixed to the selbri of a description, producing a tensed sumti:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k26N"></a>

**Example 2.93. <a id="c2e17d7"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">le pu bajra</p></td><td><p class="elidable">[ku]</p></td><td><p class="elidable">cu</p></td><td><p class="selbri">tavla</p></td></tr><tr class="gloss"><td><p class="sumti">The earlier/former/past runner</p></td><td><p class="elidable">-</p></td><td><p class="elidable">-</p></td><td><p class="selbri">talked/talks.</p></td></tr></tbody></table>

</div>  

(Since Lojban tense is optional, we don't know when he or she talks.)

Tensed sumti with space tags correspond roughly to the English use of “this” or “that” as adjectives, as in the following example, which uses the tag _<a id="id-1.3.19.19.3.1" class="indexterm"></a>[_vi_](../go01#valsi-vi)_ meaning “nearby”:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k28N"></a>

**Example 2.94. <a id="c2e17d8"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">le vi bajra</p></td><td><p class="elidable">[ku]</p></td><td><p class="elidable">cu</p></td><td><p class="selbri">tavla</p></td></tr><tr class="gloss"><td><p class="sumti">The nearby runner</p></td><td><p class="elidable">-</p></td><td><p class="elidable">-</p></td><td><p class="selbri">talks.</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This runner talks.</p></td></tr></tbody></table>

</div>  

Do not confuse the use of _<a id="id-1.3.19.21.1.1" class="indexterm"></a>[_vi_](../go01#valsi-vi)_ in [Example 2.94](../section-tenses#example-random-id-k28N) with the cmavo _<a id="id-1.3.19.21.3.1" class="indexterm"></a>[_ti_](../go01#valsi-ti)_, which also means “this”, but in the sense of “this thing”.

<a id="id-1.3.19.22.1" class="indexterm"></a>Furthermore, a tense tag can appear both on the selbri and within a description, as in the following example (where _<a id="id-1.3.19.22.2.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ is the tag for future time):

<div class="interlinear-gloss-example example">
<a id="example-random-id-k29L"></a>

**Example 2.95. <a id="c2e17d9"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">le ca vi tavla</p></td><td><p class="elidable">[ku]</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">ba vu tavla</p></td></tr><tr class="gloss"><td><p class="sumti">The [present] here talker</p></td><td><p class="elidable">-</p></td><td><p class="elidable">-</p></td><td><p class="selbri">[future] there talks.</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The one who is talking here will talk there.</p></td></tr></tbody></table>

</div>