<a id="section-tenses-vs-modals"></a>10.23. <a id="c10s23"></a>Tenses versus modals
-----------------------------------------------------------------------------------

<a id="id-1.11.25.2.1" class="indexterm"></a><a id="id-1.11.25.2.2" class="indexterm"></a><a id="id-1.11.25.2.3" class="indexterm"></a><a id="id-1.11.25.2.4" class="indexterm"></a>Grammatically, every use of tenses seen so far is exactly paralleled by some use of modals as explained in [Chapter 9](../chapter-sumti-tcita). Modals and tenses alike can be followed by sumti, can appear before the selbri, can be used in pure and mixed connections, can participate in JAI conversions. The parallelism is perfect. However, there is a deep difference in the semantics of tense constructs and modal constructs, grounded in historical differences between the two forms. Originally, modals and tenses were utterly different things in earlier versions of Loglan; only in Lojban have they become grammatically interchangeable. And even now, differences in semantics continue to be maintained.

<a id="id-1.11.25.3.1" class="indexterm"></a>The core distinction is that whereas the modal bridi

<div class="interlinear-gloss-example example">
<a id="example-random-id-YLmV"></a>

**Example 10.171. <a id="c10e23d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>do</td><td>mu'i</td><td>le</td><td>nu</td><td>do</td><td>nelci</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>like</td><td>you</td><td>with-motivation</td><td>the</td><td>event-of</td><td>you</td><td>like</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I like you because you like me.</p></td></tr></tbody></table>

</div>  

places the _<a id="id-1.11.25.5.1.1" class="indexterm"></a>le nu_ sumti in the x1 place of the gismu _<a id="id-1.11.25.5.3.1" class="indexterm"></a>[_mukti_](../go01#valsi-mukti)_ (which underlies the modal _<a id="id-1.11.25.5.4.1" class="indexterm"></a>[_mu'i_](../go01#valsi-muhi)_), namely the motivating event, the tensed bridi

<div class="interlinear-gloss-example example">
<a id="example-random-id-zXi8"></a>

**Example 10.172. <a id="c10e23d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>do</td><td>ba</td><td>le</td><td>nu</td><td>do</td><td>nelci</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>like</td><td>you</td><td>after</td><td>the</td><td>event-of</td><td>you</td><td>like</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I like you after you like me.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.25.7.1" class="indexterm"></a>places the _<a id="id-1.11.25.7.2.1" class="indexterm"></a>le nu_ sumti in the x2 place of the gismu _<a id="id-1.11.25.7.4.1" class="indexterm"></a>[_balvi_](../go01#valsi-balvi)_ (which underlies the tense _<a id="id-1.11.25.7.5.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_), namely the point of reference for the future tense. Paraphrases of [Example 10.171](../section-tenses-vs-modals#example-random-id-YLmV) and [Example 10.172](../section-tenses-vs-modals#example-random-id-zXi8) , employing the brivla _<a id="id-1.11.25.7.8.1" class="indexterm"></a>[_mukti_](../go01#valsi-mukti)_ and _<a id="id-1.11.25.7.9.1" class="indexterm"></a>[_balvi_](../go01#valsi-balvi)_ explicitly, would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JbEU"></a>

**Example 10.173. <a id="c10e23d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>do</td><td>nelci</td><td>mi</td><td>cu</td><td>mukti</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>The</td><td>event-of</td><td>you</td><td>like</td><td>me</td><td></td><td>motivates</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>do</td></tr><tr class="gloss"><td>I</td><td>like</td><td>you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Your liking me is the motive for my liking you.</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-8sjA"></a>

**Example 10.174. <a id="c10e23d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>mi</td><td>nelci</td><td>do</td><td>cu</td><td>balvi</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>The</td><td>event-of</td><td>I</td><td>like</td><td>you</td><td></td><td>is-after</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>nelci</td><td>mi</td></tr><tr class="gloss"><td>you</td><td>like</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My liking you follows (in time) your liking me.</p></td></tr></tbody></table>

</div>  

(Note that the paraphrase is not perfect due to the difference in what is claimed; [Example 10.173](../section-tenses-vs-modals#example-random-id-JbEU) and [Example 10.174](../section-tenses-vs-modals#example-random-id-8sjA) claim only the causal and temporal relationships between the events, not the existence of the events themselves.)

<a id="id-1.11.25.12.1" class="indexterm"></a>As a result, the afterthought sentence-connective forms of [Example 10.171](../section-tenses-vs-modals#example-random-id-YLmV) and [Example 10.172](../section-tenses-vs-modals#example-random-id-zXi8) are, respectively:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qewe"></a>

**Example 10.175. <a id="c10e23d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>do</td><td>.imu'ibo</td><td>do</td><td>nelci</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>like</td><td>you.</td><td>[That-is]&nbsp;Because</td><td>you</td><td>like</td><td>me.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qEWp"></a>

**Example 10.176. <a id="c10e23d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>nelci</td><td>mi</td><td>.ibabo</td><td>mi</td><td>nelci</td><td>do</td></tr><tr class="gloss"><td>You</td><td>like</td><td>me.</td><td>Afterward,</td><td>I</td><td>like</td><td>you.</td></tr></tbody></table>

</div>  

In [Example 10.175](../section-tenses-vs-modals#example-random-id-qewe) , the order of the two bridi _<a id="id-1.11.25.15.2.1" class="indexterm"></a>mi nelci do_ and _<a id="id-1.11.25.15.3.1" class="indexterm"></a>do nelci mi_ is the same as in [Example 10.171](../section-tenses-vs-modals#example-random-id-YLmV). In [Example 10.176](../section-tenses-vs-modals#example-random-id-qEWp) , however, the order is reversed: the origin point _<a id="id-1.11.25.15.6.1" class="indexterm"></a>do nelci mi_ physically appears before the future-time event _<a id="id-1.11.25.15.7.1" class="indexterm"></a>mi nelci do_. In both cases, the bridi characterizing the event in the x2 place appears before the bridi characterizing the event in the x1 place of _<a id="id-1.11.25.15.10.1" class="indexterm"></a>[_mukti_](../go01#valsi-mukti)_ or _<a id="id-1.11.25.15.11.1" class="indexterm"></a>[_balvi_](../go01#valsi-balvi)_.

<a id="id-1.11.25.16.1" class="indexterm"></a><a id="id-1.11.25.16.2" class="indexterm"></a><a id="id-1.11.25.16.3" class="indexterm"></a>In forethought connections, however, the asymmetry between modals and tenses is not found. The forethought equivalents of [Example 10.175](../section-tenses-vs-modals#example-random-id-qewe) and [Example 10.176](../section-tenses-vs-modals#example-random-id-qEWp) are

<div class="interlinear-gloss-example example">
<a id="example-random-id-ENKj"></a>

**Example 10.177. <a id="c10e23d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mu'igi</td><td>do</td><td>nelci</td><td>mi</td><td>gi</td><td>mi</td><td>nelci</td><td>do</td></tr><tr class="gloss"><td>Because</td><td>you</td><td>like</td><td>me</td><td>,</td><td>I</td><td>like</td><td>you.</td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-r7KK"></a>

**Example 10.178. <a id="c10e23d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bagi</td><td>do</td><td>nelci</td><td>mi</td><td>gi</td><td>mi</td><td>nelci</td><td>do</td></tr><tr class="gloss"><td>After</td><td>you</td><td>like</td><td>me</td><td>,</td><td>I</td><td>like</td><td>you.</td></tr></tbody></table>

</div>  

respectively.

<a id="id-1.11.25.21.1" class="indexterm"></a>The following modal sentence schemata (where X and Y represent sentences) all have the same meaning:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span class="grammar-template">X .i BAI bo Y</span></td></tr><tr><td><span class="grammar-template">BAI gi Y gi X</span></td></tr><tr><td><span class="grammar-template">X BAI le nu Y</span></td></tr></tbody></table>

<a id="id-1.11.25.23.1" class="indexterm"></a>whereas the following tensed sentence schemata also have the same meaning:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span class="grammar-template">X .i TENSE bo Y</span></td></tr><tr><td><span class="grammar-template">TENSE gi X gi Y</span></td></tr><tr><td><span class="grammar-template">Y TENSE le nu X</span></td></tr></tbody></table>

neglecting the question of what is claimed. In the modal sentence schemata, the modal tag is always followed by Y, the sentence representing the event in the x1 place of the gismu that underlies the BAI. In the tensed sentences, no such simple rule exists.