<a id="section-tense-connection"></a>10.16. <a id="c10s16"></a>Tense relations between sentences
------------------------------------------------------------------------------------------------

<a id="id-1.11.18.2.1" class="indexterm"></a>The sumtcita method, explained in [Section 10.12](../section-tcita) , of asserting a tense relationship between two events suffers from asymmetry. Specifically,

<div class="interlinear-gloss-example example">
<a id="example-random-id-vreo"></a>

**Example 10.109. <a id="c10e16d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>cu</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>The</td><td>child</td><td></td><td>walks-on</td><td>the</td><td>ice</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zu'a</td><td>le</td><td>nu</td><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>[left]</td><td>the</td><td>event-of</td><td>the</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The child walks on the ice to the left of where the man bites the dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.18.4.1" class="indexterm"></a><a id="id-1.11.18.4.2" class="indexterm"></a>which specifies an imaginary journey leftward from the man biting the dog to the child walking on the ice, claims only that the child walks on the ice. By the nature of _<a id="id-1.11.18.4.3.1" class="indexterm"></a>le nu_ , the man's biting the dog is merely referred to without being claimed. If it seems desirable to claim both, each event can be expressed as a main sentence bridi, with a special form of _<a id="id-1.11.18.4.4.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ connecting them:

<div class="interlinear-gloss-example example">
<a id="example-random-id-9Q0x"></a>

**Example 10.110. <a id="c10e16d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.izu'abo</td><td>le</td><td>verba</td><td>cu</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>[Left]</td><td>the</td><td>child</td><td></td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bites the dog. To the left, the child walks on the ice.</p></td></tr></tbody></table>

</div>  

_<a id="id-1.11.18.6.1.1" class="indexterm"></a>.izu'abo_ is a compound cmavo: the _<a id="id-1.11.18.6.2.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ separates the sentences and the _<a id="id-1.11.18.6.3.1" class="indexterm"></a>[_zu'a_](../go01#valsi-zuha)_ is the tense. The _<a id="id-1.11.18.6.4.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is required to prevent the _<a id="id-1.11.18.6.5.1" class="indexterm"></a>[_zu'a_](../go01#valsi-zuha)_ from gobbling up the following sumti, namely _<a id="id-1.11.18.6.6.1" class="indexterm"></a>le verba_.

<a id="id-1.11.18.7.1" class="indexterm"></a><a id="id-1.11.18.7.2" class="indexterm"></a><a id="id-1.11.18.7.3" class="indexterm"></a><a id="id-1.11.18.7.4" class="indexterm"></a>Note that the bridi in [Example 10.110](../section-tense-connection#example-random-id-9Q0x) appear in the reverse order from their appearance in [Example 10.109](../section-tense-connection#example-random-id-vreo). With _<a id="id-1.11.18.7.7.1" class="indexterm"></a>.izu'abo_ (and all other afterthought tense connectives) the sentence specifying the origin of the journey comes first. This is a natural order for sentences, but requires some care when converting between this form and the sumtcita form.

[Example 10.110](../section-tense-connection#example-random-id-9Q0x) means the same thing as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ne2C"></a>

**Example 10.111. <a id="c10e16d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td><td>.i</td><td>zu'a</td><td>la'edi'u</td></tr><tr class="gloss"><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td><td></td><td>[Left]</td><td>the-referent-of-the-last-sentence</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>cu</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>the</td><td>child</td><td></td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bites the dog. Left of what I just mentioned, the child walks on the ice.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.18.10.1" class="indexterm"></a>If the _<a id="id-1.11.18.10.2.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is omitted in [Example 10.110](../section-tense-connection#example-random-id-9Q0x) , the meaning changes:

<div class="interlinear-gloss-example example">
<a id="example-random-id-jThf"></a>

**Example 10.112. <a id="c10e16d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>zu'a</td><td>le</td><td>verba</td><td>cu</td><td></td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td></td><td>[Left]</td><td>the</td><td>child</td><td></td><td>[something]</td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bites the dog. To the left of the child, something walks on the ice.</p></td></tr></tbody></table>

</div>  

Here the first place of the second sentence is unspecified, because _<a id="id-1.11.18.12.1.1" class="indexterm"></a>[_zu'a_](../go01#valsi-zuha)_ has absorbed the sumti _<a id="id-1.11.18.12.2.1" class="indexterm"></a>le verba_.

Do not confuse either [Example 10.110](../section-tense-connection#example-random-id-9Q0x) or [Example 10.112](../section-tense-connection#example-random-id-jThf) with the following:<a id="id-1.11.18.13.3" class="indexterm"></a><a id="id-1.11.18.13.4" class="indexterm"></a>

<div class="interlinear-gloss-example example">
<a id="example-random-id-MzxF"></a>

**Example 10.113. <a id="c10e16d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>zu'aku</td><td>le</td><td>verba</td><td>cu</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td></td><td>[Left]</td><td>the</td><td>child</td><td></td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bites the dog. Left of me, the child walks on the ice.</p></td></tr></tbody></table>

</div>  

In [Example 10.113](../section-tense-connection#example-random-id-MzxF) , the origin point is the speaker, as is usual with _<a id="id-1.11.18.15.2.1" class="indexterm"></a>zu'aku_. [Example 10.110](../section-tense-connection#example-random-id-9Q0x) makes the origin point of the tense the event described by the first sentence.

<a id="id-1.11.18.16.1" class="indexterm"></a>Two sentences may also be connected in forethought by a tense relationship. Just like afterthought tense connection, forethought tense connection claims both sentences, and in addition claims that the time or space relationship specified by the tense holds between the events the two sentences describe.

<a id="id-1.11.18.17.1" class="indexterm"></a><a id="id-1.11.18.17.2" class="indexterm"></a><a id="id-1.11.18.17.3" class="indexterm"></a><a id="id-1.11.18.17.4" class="indexterm"></a>The origin sentence is placed first, preceded by a tense plus _<a id="id-1.11.18.17.5.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_. Another _<a id="id-1.11.18.17.6.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ is used to separate the sentences:

<div class="interlinear-gloss-example example">
<a id="example-random-id-9cXU"></a>

**Example 10.114. <a id="c10e16d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pugi</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>gi</td><td>mi</td><td>klama</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>[past]</td><td>I</td><td>go-to</td><td>the</td><td>market</td><td>[,]</td><td>I</td><td>go-to</td><td>the</td><td>house.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Before I go to the market, I go to the house.</p></td></tr></tbody></table>

</div>  

A parallel construction can be used to express a tense relationship between sumti:<a id="id-1.11.18.19.1" class="indexterm"></a><a id="id-1.11.18.19.2" class="indexterm"></a><a id="id-1.11.18.19.3" class="indexterm"></a>

<div class="interlinear-gloss-example example">
<a id="example-random-id-o3Yg"></a>

**Example 10.115. <a id="c10e16d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>pugi</td><td>le</td><td>zarci</td><td>gi</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>[past]</td><td>the</td><td>market</td><td>[,]</td><td>the</td><td>house.</td></tr></tbody></table>

</div>  

Because English does not have any direct way of expressing a tense-like relationship between nouns, [Example 10.115](../section-tense-connection#example-random-id-o3Yg) cannot be expressed in English without paraphrasing it either into [Example 10.114](../section-tense-connection#example-random-id-9cXU) or else into “I go to the house before the market” , which is ambiguous – is the market going?

<a id="id-1.11.18.22.1" class="indexterm"></a><a id="id-1.11.18.22.2" class="indexterm"></a><a id="id-1.11.18.22.3" class="indexterm"></a>Finally, a third forethought construction expresses a tense relationship between bridi-tails rather than whole bridi. (The construct known as a “bridi-tail” is explained fully in [Section 14.9](../section-compound-bridi) ; roughly speaking, it is a selbri, possibly with following sumti.) [Example 10.116](../section-tense-connection#example-random-id-vSCv) is equivalent in meaning to [Example 10.114](../section-tense-connection#example-random-id-9cXU) and [Example 10.115](../section-tense-connection#example-random-id-o3Yg) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-vSCv"></a>

**Example 10.116. <a id="c10e16d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pugi</td><td>klama</td><td>le</td><td>zarci</td><td>gi</td><td>klama</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market</td><td>[,]</td><td>go-to</td><td>the</td><td>house.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I, before going to the market, go to the house.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.18.24.1" class="indexterm"></a><a id="id-1.11.18.24.2" class="indexterm"></a>In both [Example 10.115](../section-tense-connection#example-random-id-o3Yg) and [Example 10.116](../section-tense-connection#example-random-id-vSCv) , the underlying sentences _<a id="id-1.11.18.24.5.1" class="indexterm"></a>mi klama le zarci_ and _<a id="id-1.11.18.24.6.1" class="indexterm"></a>mi klama le zdani_ are not claimed; only the relationship in time between them is claimed.

<a id="id-1.11.18.25.1" class="indexterm"></a><a id="id-1.11.18.25.2" class="indexterm"></a><a id="id-1.11.18.25.3" class="indexterm"></a><a id="id-1.11.18.25.4" class="indexterm"></a>Both the forethought and the afterthought forms are appropriate with PU, ZI, FAhA, VA, and ZAhO tenses. In all cases, the equivalent forms are (where X and Y stand for sentences, and TENSE for a tense cmavo):

<table><colgroup></colgroup><tbody><tr><td>subordinate</td><td><span class="grammar-template">X TENSE le nu Y</span></td></tr><tr><td>afterthought coordinate</td><td><span class="grammar-template">Y .i+TENSE+bo X</span></td></tr><tr><td>forethought coordinate</td><td><span class="grammar-template">TENSE+gi Y gi X</span></td></tr></tbody></table>