<a id="section-temporal-tenses"></a>10.4. <a id="c10s4"></a>Temporal tenses: PU and ZI
--------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pu</p></td><td class="selmaho"><p class="selmaho">PU</p></td><td class="description"><p class="description">past</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ca</p></td><td class="selmaho"><p class="selmaho">PU</p></td><td class="description"><p class="description">present</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ba</p></td><td class="selmaho"><p class="selmaho">PU</p></td><td class="description"><p class="description">future</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zi</p></td><td class="selmaho"><p class="selmaho">ZI</p></td><td class="description"><p class="description">short time distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">za</p></td><td class="selmaho"><p class="selmaho">ZI</p></td><td class="description"><p class="description">medium time distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zu</p></td><td class="selmaho"><p class="selmaho">ZI</p></td><td class="description"><p class="description">long time distance</p></td></tr></tbody></table>

<a id="id-1.11.6.4.1" class="indexterm"></a><a id="id-1.11.6.4.2" class="indexterm"></a><a id="id-1.11.6.4.3" class="indexterm"></a><a id="id-1.11.6.4.4" class="indexterm"></a><a id="id-1.11.6.4.5" class="indexterm"></a><a id="id-1.11.6.4.6" class="indexterm"></a><a id="id-1.11.6.4.7" class="indexterm"></a>Now that the reader understands spatial tenses, there are only two main facts to understand about temporal tenses: they work exactly like the spatial tenses, with selma'o PU and ZI standing in for FAhA and VA; and when both spatial and temporal tense cmavo are given in a single tense construct, the temporal tense is expressed first. (If space could be expressed before or after time at will, then certain constructions would be ambiguous.)

<div class="interlinear-gloss-example example">
<a id="example-random-id-ameb"></a>

**Example 10.15. <a id="c10e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>pu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[past]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bit the dog.</p></td></tr></tbody></table>

</div>  

means that to reach the dog-biting, you must take an imaginary journey through time, moving towards the past an unspecified distance. (Of course, this journey is even more imaginary than the ones talked about in the previous sections, since time-travel is not an available option.)

<a id="id-1.11.6.7.1" class="indexterm"></a><a id="id-1.11.6.7.2" class="indexterm"></a>Lojban recognizes three temporal directions: _<a id="id-1.11.6.7.3.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ for the past, _<a id="id-1.11.6.7.4.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_ for the present, and _<a id="id-1.11.6.7.5.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ for the future. (Etymologically, these derive from the corresponding gismu _<a id="id-1.11.6.7.6.1" class="indexterm"></a>[_purci_](../go01#valsi-purci)_ , _<a id="id-1.11.6.7.7.1" class="indexterm"></a>[_cabna_](../go01#valsi-cabna)_ , and _<a id="id-1.11.6.7.8.1" class="indexterm"></a>[_balvi_](../go01#valsi-balvi)_. See [Section 10.23](../section-tenses-vs-modals) for an explanation of the exact relationship between the cmavo and the gismu.) There are many more spatial directions, since there are FAhA cmavo for both absolute and relative directions as well as “direction-like relationships” like “surrounding” , “within” , “touching” , etc. (See [Section 10.27](../section-tense-selmaho-summary) for a complete list.) But there are really only two directions in time: forward and backward, toward the future and toward the past. Why, then, are there three cmavo of selma'o PU?

<a id="id-1.11.6.8.1" class="indexterm"></a><a id="id-1.11.6.8.2" class="indexterm"></a><a id="id-1.11.6.8.3" class="indexterm"></a><a id="id-1.11.6.8.4" class="indexterm"></a>The reason is that tense is subjective: human beings perceive space and time in a way that does not necessarily agree with objective measurements. We have a sense of “now” which includes part of the objective past and part of the objective future, and so we naturally segment the time line into three parts. The Lojban design recognizes this human reality by providing a separate time-direction cmavo for the “zero direction”. Similarly, there is a FAhA cmavo for the zero space direction: _<a id="id-1.11.6.8.7.1" class="indexterm"></a>[_bu'u_](../go01#valsi-buhu)_ , which means something like “coinciding”.

<a id="id-1.11.6.9.1" class="indexterm"></a><a id="id-1.11.6.9.2" class="indexterm"></a>(Technical note for readers conversant with relativity theory: The Lojban time tenses reflect time as seen by the speaker, who is assumed to be a “point-like observer” in the relativistic sense: they do not say anything about physical relationships of relativistic interval, still less about implicit causality. The nature of tense is not only subjective but also observer-based.)

Here are some examples of temporal tenses:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qDsX"></a>

**Example 10.16. <a id="c10e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>puzi</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[past-short-distance]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A short time ago, the man bit the dog.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qDt1"></a>

**Example 10.17. <a id="c10e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>pu</td><td>pu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[past]</td><td>[past]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Earlier than an earlier time than now, the man bit the dog.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The man had bitten the dog.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The man had been biting the dog.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qDtg"></a>

**Example 10.18. <a id="c10e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>ba</td><td>puzi</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[future]</td><td>[past-short]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Shortly earlier than some time later than now, the man will bite the dog.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Soon before then, the man will have bitten the dog.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The man will have just bitten the dog.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The man will just have been biting the dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.6.14.1" class="indexterm"></a>What about the analogue of an initial VA without a direction? Lojban does allow an initial ZI with or without following PUs:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qDu0"></a>

**Example 10.19. <a id="c10e4d5"></a><a id="id-1.11.6.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>zi</td><td>pu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[short]</td><td>[past]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Before a short time from or before now, the man bit or will bite the dog.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qDw0"></a>

**Example 10.20. <a id="c10e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>zu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[long]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A long time from or before now, the man will bite or bit the dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.6.17.1" class="indexterm"></a>[Example 10.19](../section-temporal-tenses#example-random-id-qDu0) and [Example 10.20](../section-temporal-tenses#example-random-id-qDw0) are perfectly legitimate, but may not be very much used: _<a id="id-1.11.6.17.4.1" class="indexterm"></a>[_zi_](../go01#valsi-zi)_ by itself signals an event that happens at a time close to the present, but without saying whether it is in the past or the future. A rough translation might be “about now, but not exactly now”.

Because we can move in any direction in space, we are comfortable with the idea of events happening in an unspecified space direction ( “nearby” or “far away”), but we live only from past to future, and the idea of an event which happens “nearby in time” is a peculiar one. Lojban provides lots of such possibilities that don't seem all that useful to English-speakers, even though you can put them together productively; this fact may be a limitation of English.

<a id="id-1.11.6.19.1" class="indexterm"></a>Finally, here are examples which combine temporal and spatial tense:

<div class="interlinear-gloss-example example">
<a id="example-random-id-vtUw"></a>

**Example 10.21. <a id="c10e4d7"></a><a id="id-1.11.6.20.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>puzu</td><td>vu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[past-long-time]</td><td>[long-space]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Long ago and far away, the man bit the dog.</p></td></tr></tbody></table>

</div>  

Alternatively,

<div class="interlinear-gloss-example example">
<a id="example-random-id-Jsw5"></a>

**Example 10.22. <a id="c10e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td><td>puzuvuku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>&nbsp;</td><td>bites</td><td>the</td><td>dog</td><td>[past-long-time-long-space].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man bit the dog long ago and far away.</p></td></tr></tbody></table>

</div>