<a id="section-tanru"></a>14.12. <a id="c14s12"></a>Logical connection within tanru
-----------------------------------------------------------------------------------

<a id="id-1.15.14.2.1" class="indexterm"></a>As noted at the beginning of [Section 14.9](../section-compound-bridi) , there is no logical connective in Lojban that joins selbri and nothing but selbri. However, it is possible to have logical connectives within a selbri, forming a kind of tanru that involves a logical connection. Consider the simple tanru _<a id="id-1.15.14.2.3.1" class="indexterm"></a>blanu zdani_ , blue house. Now anything that is a blue ball, in the most ordinary understanding of the phrase at least, is both blue and a ball. And indeed, instead of _<a id="id-1.15.14.2.4.1" class="indexterm"></a>blanu bolci_ , Lojbanists can say _<a id="id-1.15.14.2.5.1" class="indexterm"></a>blanu je bolci_ , using a jek connective within the tanru. (We saw jeks used in [Section 14.11](../section-termsets) also, but there they were always prefixed by _<a id="id-1.15.14.2.7.1" class="indexterm"></a>[_pe'e_](../go01#valsi-pehe)_ ; in this section they are used alone.) Here is a pair of examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGoH"></a>

**Example 14.78. <a id="c14e12d1"></a><a id="id-1.15.14.3.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>blanu</td><td>zdani</td></tr><tr class="gloss"><td>This</td><td>is-a-blue-type-of</td><td>house.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgoW"></a>

**Example 14.79. <a id="c14e12d2"></a><a id="id-1.15.14.4.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>blanu</td><td>je</td><td>zdani</td></tr><tr class="gloss"><td>This</td><td>is-blue</td><td>and</td><td>is-a-house.</td></tr></tbody></table>

</div>  

<a id="id-1.15.14.5.1" class="indexterm"></a><a id="id-1.15.14.5.2" class="indexterm"></a>But of course [Example 14.78](../section-tanru#example-random-id-qGoH) and [Example 14.79](../section-tanru#example-random-id-qgoW) are not necessarily equivalent in meaning! It is the most elementary point about Lojban tanru that [Example 14.78](../section-tanru#example-random-id-qGoH) might just as well mean

<div class="example">
<a id="example-random-id-DxVB"></a>

**Example 14.80. <a id="c14e12d3"></a>** 

This is a house for blue inhabitants.

</div>  

and [Example 14.79](../section-tanru#example-random-id-qgoW) certainly is not equivalent in meaning to [Example 14.80](../section-tanru#example-random-id-DxVB).

<a id="id-1.15.14.8.1" class="indexterm"></a>A full explanation of logical connection within tanru belongs rather to a discussion of selbri structure than to logical connectives in general. Why? Because although [Example 14.79](../section-tanru#example-random-id-qgoW) happens to mean the same as

<div class="interlinear-gloss-example example">
<a id="example-random-id-XXX6"></a>

**Example 14.81. <a id="c14e12d4"></a>** 

<a id="id-1.15.14.9.2.1" class="indexterm"></a>ti blanu gi'e zdani

</div>  

and therefore as

<div class="interlinear-gloss-example example">
<a id="example-random-id-HqYS"></a>

**Example 14.82. <a id="c14e12d5"></a>** 

<a id="id-1.15.14.11.2.1" class="indexterm"></a>ti blanu .ije ti zdani

</div>  

the rule of expansion into separate bridi simply does not always work for tanru connection. Supposing Alice to be a person who lives in blue houses, then

<div class="interlinear-gloss-example example">
<a id="example-random-id-DG5K"></a>

**Example 14.83. <a id="c14e12d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>cu</td><td></td><td>blanu</td><td>je</td><td>zdani</td><td></td><td>prenu</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td></td><td>is-a-(</td><td>blue</td><td>and</td><td>house</td><td>)</td><td>type-of-person.</td></tr></tbody></table>

</div>  

<a id="id-1.15.14.14.1" class="indexterm"></a>would be true, because tanru grouping with a jek has higher precedence than unmarked tanru grouping, but:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eh2i"></a>

**Example 14.84. <a id="c14e12d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>cu</td><td></td><td>blanu</td><td>prenu</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td></td><td>is-a</td><td>blue</td><td>person,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>la</td><td>.alis.</td><td>cu</td><td></td><td>zdani</td><td>prenu</td></tr><tr class="gloss"><td>and</td><td>that-named</td><td>Alice</td><td></td><td>is-a</td><td>house</td><td>person.</td></tr></tbody></table>

</div>  

is probably false, because the blueness is associated with the house, not with Alice, even leaving aside the question of what it means to say “Alice is a blue person”. (Perhaps she belongs to the Blue team, or is wearing blue clothes.) The semantic ambiguity of tanru make such logical manipulations impossible.

<a id="id-1.15.14.17.1" class="indexterm"></a>It suffices to note here, then, a few purely grammatical points about tanru logical connection. _<a id="id-1.15.14.17.2.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ may be appended to jeks as to eks, with the same rules:

<div class="interlinear-gloss-example example">
<a id="example-random-id-RNMY"></a>

**Example 14.85. <a id="c14e12d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.teris.</td><td>cu</td><td>ricfu</td><td>je</td><td>nakni</td><td>jabo</td><td>fetsi</td></tr><tr class="gloss"><td>That-named</td><td>Terry</td><td></td><td>is-rich</td><td>and</td><td>(male</td><td>or</td><td>female).</td></tr></tbody></table>

</div>  

<a id="id-1.15.14.19.1" class="indexterm"></a>The components of tanru may be grouped with _<a id="id-1.15.14.19.2.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ both before and after a logical connective:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JdID"></a>

**Example 14.86. <a id="c14e12d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.teris.</td><td>cu</td><td>[ke]</td><td>ricfu</td><td>ja</td><td>pindi</td><td>[ke'e]</td></tr><tr class="gloss"><td>That-named</td><td>Terry</td><td></td><td>(</td><td>is-rich</td><td>or</td><td>is-poor</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>je</td><td>ke</td><td>nakni</td><td>ja</td><td>fetsi</td><td>[ke'e]</td></tr><tr class="gloss"><td>and</td><td>(</td><td>male</td><td>or</td><td>female</td><td>).</td></tr></tbody></table>

</div>  

where the first _<a id="id-1.15.14.21.1.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ … _<a id="id-1.15.14.21.2.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ pair may be omitted altogether by the rule of left-grouping, but is optionally permitted. In any case, the last instance of _<a id="id-1.15.14.21.3.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ may be elided.

<a id="id-1.15.14.22.1" class="indexterm"></a><a id="id-1.15.14.22.2" class="indexterm"></a><a id="id-1.15.14.22.3" class="indexterm"></a><a id="id-1.15.14.22.4" class="indexterm"></a><a id="id-1.15.14.22.5" class="indexterm"></a>The syntax of jeks is:

> \[na\] \[se\] JA \[nai\]

parallel to eks and giheks.

<a id="id-1.15.14.25.1" class="indexterm"></a><a id="id-1.15.14.25.2" class="indexterm"></a><a id="id-1.15.14.25.3" class="indexterm"></a>Forethought tanru connection does not use geks, but uses guheks instead. Guheks have exactly the same form as geks:<a id="id-1.15.14.25.4" class="indexterm"></a><a id="id-1.15.14.25.5" class="indexterm"></a><a id="id-1.15.14.25.6" class="indexterm"></a>

> \[se\] GUhA \[nai\]

<a id="id-1.15.14.27.1" class="indexterm"></a><a id="id-1.15.14.27.2" class="indexterm"></a><a id="id-1.15.14.27.3" class="indexterm"></a>Using guheks in tanru connection (rather than geks) resolves what would otherwise be an unacceptable ambiguity between bridi-tail and tanru connection:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mjog"></a>

**Example 14.87. <a id="c14e12d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>gu'e</td><td>ricfu</td><td>gi</td><td>fetsi</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>is-both</td><td>rich</td><td>and</td><td>female.</td></tr></tbody></table>

</div>  

<a id="id-1.15.14.29.1" class="indexterm"></a><a id="id-1.15.14.29.2" class="indexterm"></a><a id="id-1.15.14.29.3" class="indexterm"></a><a id="id-1.15.14.29.4" class="indexterm"></a>Note that giks are used with guheks in exactly the same way they are used with geks. Like jeks, guheks bind more closely than unmarked tanru grouping does:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Gyrc"></a>

**Example 14.88. <a id="c14e12d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>gu'e</td><td>blanu</td><td>gi</td><td>zdani</td><td>prenu</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>is-a-(both</td><td>blue</td><td>and</td><td>a-house)</td><td>type-of-person.</td></tr></tbody></table>

</div>  

is the forethought version of [Example 14.83](../section-tanru#example-random-id-DG5K).

<a id="id-1.15.14.32.1" class="indexterm"></a><a id="id-1.15.14.32.2" class="indexterm"></a><a id="id-1.15.14.32.3" class="indexterm"></a><a id="id-1.15.14.32.4" class="indexterm"></a>A word of caution about the use of logically connected tanru within descriptions. English-based intuition can lead the speaker astray. In correctly reducing

<div class="interlinear-gloss-example example">
<a id="example-random-id-8wbd"></a>

**Example 14.89. <a id="c14e12d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>pa</td><td>mlatu</td><td>.ije</td><td>mi</td><td>viska</td><td>pa</td><td>gerku</td></tr><tr class="gloss"><td>I</td><td>see</td><td>a</td><td>cat,</td><td>and</td><td>I</td><td>see</td><td>a</td><td>dog.</td></tr></tbody></table>

</div>  

to

<div class="interlinear-gloss-example example">
<a id="example-random-id-qf3n"></a>

**Example 14.90. <a id="c14e12d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>pa</td><td>mlatu</td><td>.e</td><td>pa</td><td>gerku</td></tr><tr class="gloss"><td>I</td><td>see</td><td>a</td><td>cat</td><td>and</td><td>a</td><td>dog.</td></tr></tbody></table>

</div>  

there is a great temptation to reduce further to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ag8r"></a>

**Example 14.91. <a id="c14e12d14"></a><a id="id-1.15.14.37.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>pa</td><td>mlatu</td><td>je</td><td>gerku</td></tr><tr class="gloss"><td>I</td><td>see</td><td>a</td><td>cat</td><td>and</td><td>dog.</td></tr></tbody></table>

</div>  

But [Example 14.91](../section-tanru#example-random-id-ag8r) means that you see one thing which is both a cat and a dog simultaneously! A _<a id="id-1.15.14.38.2.1" class="indexterm"></a>mlatu je gerku_ is a catdog, a presumably non-existent creature who is both a _<a id="id-1.15.14.38.3.1" class="indexterm"></a>[_mlatu_](../go01#valsi-mlatu)_ and a _<a id="id-1.15.14.38.4.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_.