<a id="section-tanru-meanings"></a>12.2. <a id="c12s2"></a>The meaning of tanru: a necessary detour
---------------------------------------------------------------------------------------------------

The meaning of a lujvo is controlled by – but is not the same as – the meaning of the tanru from which the lujvo was constructed. The tanru corresponding to a lujvo is called its _<a id="id-1.13.4.2.1.1" class="indexterm"></a>[_veljvo_](../go01#valsi-veljvo)_ in Lojban, and since there is no concise English equivalent, that term will be used in this chapter. Furthermore, the left (modifier) part of a tanru will be called the _<a id="id-1.13.4.2.2.1" class="indexterm"></a>[_seltau_](../go01#valsi-seltau)_ , and the right (modified) part the _<a id="id-1.13.4.2.3.1" class="indexterm"></a>[_tertau_](../go01#valsi-tertau)_ , following the usage of [Chapter 5](../chapter-selbri). For brevity, we will speak of the seltau or tertau of a lujvo, meaning of course the seltau or tertau of the veljvo of that lujvo. (If this terminology is confusing, substituting “modifier” for _<a id="id-1.13.4.2.6.1" class="indexterm"></a>[_seltau_](../go01#valsi-seltau)_ and “modified” for _<a id="id-1.13.4.2.8.1" class="indexterm"></a>[_tertau_](../go01#valsi-tertau)_ may help.)

<a id="id-1.13.4.3.1" class="indexterm"></a>The place structure of a tanru is always the same as the place structure of its tertau. As a result, the meaning of the tanru is a modified version of the meaning of the tertau; the tanru will typically, but not always, refer to a subset of the things referred to by the tertau.

<a id="id-1.13.4.4.1" class="indexterm"></a><a id="id-1.13.4.4.2" class="indexterm"></a>The purpose of a tanru is to join concepts together without necessarily focusing on the exact meaning of the seltau. For example, in the _Iliad_ , the poet talks about “the wine-dark sea” , in which “wine” is a seltau relative to “dark” , and the pair of words is a seltau relative to “sea”. We're talking about the sea, not about wine or color. The other words are there to paint a scene in the listener's mind, in which the real action will occur, and to evoke relations to other sagas of the time similarly describing the sea. Logical inferences about wine or color will be rejected as irrelevant.

<a id="id-1.13.4.5.1" class="indexterm"></a>As a simple example, consider the rather non-obvious tanru _<a id="id-1.13.4.5.2.1" class="indexterm"></a>klama zdani_ , or “goer-house”. The gismu _<a id="id-1.13.4.5.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ has two places:

<div class="example">
<a id="example-random-id-xcfi"></a>

**Example 12.3. <a id="c12e2d1"></a>** 

> x1 is a nest/house/lair/den for inhabitant x2

</div>  

(but in this chapter we will use simply “house” , for brevity), and the gismu _<a id="id-1.13.4.7.2.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ has five:

<div class="example">
<a id="example-random-id-zUVg"></a>

**Example 12.4. <a id="c12e2d2"></a>** 

> x1 goes to destination x2 from origin point x3 via route x4 using means x5

</div>  

The tanru _<a id="id-1.13.4.9.1.1" class="indexterm"></a>klama zdani_ will also have two places, namely those of _<a id="id-1.13.4.9.2.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_. Since a _<a id="id-1.13.4.9.3.1" class="indexterm"></a>klama zdani_ is a type of _<a id="id-1.13.4.9.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ , we can assume that all goer-houses – whatever they may be – are also houses.

<a id="id-1.13.4.10.1" class="indexterm"></a><a id="id-1.13.4.10.2" class="indexterm"></a><a id="id-1.13.4.10.3" class="indexterm"></a>But is knowing the places of the tertau everything that is needed to understand the meaning of a tanru? No. To see why, let us switch to a less unlikely tanru: _<a id="id-1.13.4.10.4.1" class="indexterm"></a>gerku zdani_ , literally “dog house”. A tanru expresses a very loose relation: a _<a id="id-1.13.4.10.6.1" class="indexterm"></a>gerku zdani_ is a house that has something to do with some dog or dogs. What the precise relation might be is left unstated. Thus, the meaning of _<a id="id-1.13.4.10.7.1" class="indexterm"></a>lo gerku zdani_ can include all of the following: houses occupied by dogs, houses shaped by dogs, dogs which are also houses (e.g. houses for fleas), houses named after dogs, and so on. All that is essential is that the place structure of _<a id="id-1.13.4.10.8.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ continues to apply.

For something (call it z1) to qualify as a _<a id="id-1.13.4.11.1.1" class="indexterm"></a>gerku zdani_ in Lojban, it's got to be a house, first of all. For it to be a house, it's got to house someone (call that z2). Furthermore, there's got to be a dog somewhere (called g1). For g1 to count as a dog in Lojban, it's got to belong to some breed as well (called g2). And finally, for z1 to be in the first place of _<a id="id-1.13.4.11.2.1" class="indexterm"></a>gerku zdani_ , as opposed to just _<a id="id-1.13.4.11.3.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ , there's got to be some relationship (called r) between some place of _<a id="id-1.13.4.11.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ and some place of _<a id="id-1.13.4.11.5.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_. It doesn't matter which places, because if there's a relationship between some place of _<a id="id-1.13.4.11.6.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ and any place of _<a id="id-1.13.4.11.7.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ , then that relationship can be compounded with the relationship between the places of _<a id="id-1.13.4.11.8.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ - namely, _<a id="id-1.13.4.11.9.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ itself – to reach any of the other _<a id="id-1.13.4.11.10.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ places. Thus, if the relationship turns out to be between z2 and g2, we can still state r in terms of z1 and g1: “the relationship involves the dog g1, whose breed has to do with the occupant of the house z1”.

Doubtless to the relief of the reader, here's an illustration. We want to find out whether the White House (the one in which the U. S. President lives, that is) counts as a _<a id="id-1.13.4.12.1.1" class="indexterm"></a>gerku zdani_. We go through the five variables. The White House is the z1. It houses Bill Clinton as z2, as of this writing, so it counts as a _<a id="id-1.13.4.12.2.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_. Let's take a dog – say, Spot (g1). Spot has to have a breed; let's say it's a Saint Bernard (g2). Now, the White House counts as a _<a id="id-1.13.4.12.3.1" class="indexterm"></a>gerku zdani_ if there is any relationship (r) at all between the White House and Spot. (We'll choose the g1 and z1 places to relate by r; we could have chosen any other pair of places, and simply gotten a different relationship.)

<a id="id-1.13.4.13.1" class="indexterm"></a>The sky is the limit for r; it can be as complicated as “The other day, g1 (Spot) chased Socks, who is owned by Chelsea Clinton, who is the daughter of Bill Clinton, who lives in z1 (the White House)” or even worse. If no such r can be found, well, you take another dog, and keep going until no more dogs can be found. Only then can we say that the White House cannot fit into the first place of _<a id="id-1.13.4.13.3.1" class="indexterm"></a>gerku zdani_.

As we have seen, no less than five elements are involved in the definition of _<a id="id-1.13.4.14.1.1" class="indexterm"></a>gerku zdani_ : the house, the house dweller, the dog, the dog breed (everywhere a dog goes in Lojban, a dog breed follows), and the relationship between the house and the dog. Since tanru are explicitly ambiguous in Lojban, the relationship r cannot be expressed within a tanru (if it could, it wouldn't be a tanru any more!) All the other places, however, can be expressed – thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tUDa"></a>

**Example 12.5. <a id="c12e2d3"></a><a id="id-1.13.4.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>blabi</td><td>zdani</td><td>cu</td><td>gerku</td><td>be</td><td>fa</td><td>la</td><td>.spot.</td></tr><tr class="gloss"><td>That-named</td><td>White</td><td>House</td><td></td><td>is-a-dog</td><td>(</td><td>namely</td><td>that-named</td><td>Spot</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bei</td><td>la</td><td>.sankt.</td><td>.berNARD.</td><td>be'o</td></tr><tr class="gloss"><td>of-breed</td><td>that-named</td><td>Saint</td><td>Bernard</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zdani</td><td>la</td><td>.bil.</td><td>.klinton.</td></tr><tr class="gloss"><td>type-of-house-for</td><td>that-named</td><td>Bill</td><td>Clinton.</td></tr></tbody></table>

</div>  

<a id="id-1.13.4.16.1" class="indexterm"></a>Not the most elegant sentence ever written in either Lojban or English. Yet if there is any relation at all between Spot and the White House, [Example 12.5](../section-tanru-meanings#example-random-id-tUDa) is arguably true. If we concentrate on just one type of relation in interpreting the tanru _<a id="id-1.13.4.16.3.1" class="indexterm"></a>gerku zdani_ , then the meaning of _<a id="id-1.13.4.16.4.1" class="indexterm"></a>gerku zdani_ changes. So if we understand _<a id="id-1.13.4.16.5.1" class="indexterm"></a>gerku zdani_ as having the same meaning as the English word “doghouse” , the White House would no longer be a _<a id="id-1.13.4.16.7.1" class="indexterm"></a>gerku zdani_ with respect to Spot, because as far as we know Spot does not actually live in the White House, and the White House is not a doghouse (derogatory terms for incumbents notwithstanding).