<a id="section-symmetrical-asymmetrical"></a>12.5. <a id="c12s5"></a>Symmetrical and asymmetrical lujvo
-------------------------------------------------------------------------------------------------------

<a id="id-1.13.7.2.1" class="indexterm"></a><a id="id-1.13.7.2.2" class="indexterm"></a><a id="id-1.13.7.2.3" class="indexterm"></a>A common pattern, perhaps the most common pattern, of lujvo-making creates what is called a “symmetrical lujvo”. A symmetrical lujvo is one based on a tanru interpretation such that the first place of the seltau is equivalent to the first place of the tertau: each component of the tanru characterizes the same object. As an illustration of this, consider the lujvo _<a id="id-1.13.7.2.5.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ : it is intended to mean “both great and a soldier” - that is, “great soldier” , which is the interpretation we would tend to give its veljvo, _<a id="id-1.13.7.2.8.1" class="indexterm"></a>banli sonci_. The underlying gismu place structures are:

<div class="example">
<a id="example-random-id-7AFc"></a>

**Example 12.11. <a id="c12e5d1"></a><a id="id-1.13.7.3.1.2" class="indexterm"></a>** 

> _<a id="id-1.13.7.3.2.1.1.1.1" class="indexterm"></a>[_banli_](../go01#valsi-banli)_ b1 is great in property b2 by standard b3

> _<a id="id-1.13.7.3.3.1.1.1.1" class="indexterm"></a>[_sonci_](../go01#valsi-sonci)_ s1 is a soldier of army s2

</div>  

In this case the s1 place of _<a id="id-1.13.7.4.1.1" class="indexterm"></a>[_sonci_](../go01#valsi-sonci)_ is redundant, since it is equivalent to the b1 place of _<a id="id-1.13.7.4.2.1" class="indexterm"></a>[_banli_](../go01#valsi-banli)_. Therefore the place structure of _<a id="id-1.13.7.4.3.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ need not include places for both s1 and b1, as they refer to the same thing. So the place structure of _<a id="id-1.13.7.4.4.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ is at most

<div class="example">
<a id="example-random-id-UtwF"></a>

**Example 12.12. <a id="c12e5d2"></a>** 

> b1=s1 is a great soldier of army s2 in property b2 by standard b3

</div>  

<a id="id-1.13.7.6.1" class="indexterm"></a><a id="id-1.13.7.6.2" class="indexterm"></a>Some symmetrical veljvo have further equivalent places in addition to the respective first places. Consider the lujvo _<a id="id-1.13.7.6.3.1" class="indexterm"></a>[_tinju'i_](../go01#valsi-tinjuhi)_ , “to listen” ( “to hear attentively, to hear and pay attention”). The place structures of the gismu _<a id="id-1.13.7.6.6.1" class="indexterm"></a>[_tirna_](../go01#valsi-tirna)_ and _<a id="id-1.13.7.6.7.1" class="indexterm"></a>[_jundi_](../go01#valsi-jundi)_ are:

<div class="example">
<a id="example-random-id-rFiE"></a>

**Example 12.13. <a id="c12e5d3"></a>** 

> _<a id="id-1.13.7.7.2.1.1.1.1" class="indexterm"></a>[_tirna_](../go01#valsi-tirna)_ t1 hears sound t2 against background noise t3

> _<a id="id-1.13.7.7.3.1.1.1.1" class="indexterm"></a>[_jundi_](../go01#valsi-jundi)_ j1 pays attention to j2

</div>  

<a id="id-1.13.7.8.1" class="indexterm"></a>and the place structure of the lujvo is:

<div class="example">
<a id="example-random-id-EUr1"></a>

**Example 12.14. <a id="c12e5d4"></a><a id="id-1.13.7.9.1.2" class="indexterm"></a>** 

> j1=t1 listens to j2=t2 against background noise t3

</div>  

Why so? Because not only is the j1 place (the one who pays attention) equivalent to the t1 place (the hearer), but the j2 place (the thing paid attention to) is equivalent to the t2 place (the thing heard).

<a id="id-1.13.7.11.1" class="indexterm"></a><a id="id-1.13.7.11.2" class="indexterm"></a>A substantial minority of lujvo have the property that the first place of the seltau ( _<a id="id-1.13.7.11.3.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ in this case) is equivalent to a place other than the first place of the tertau; such lujvo are said to be “asymmetrical”. (There is a deliberate parallel here with the terms “asymmetrical tanru” and “symmetrical tanru” used in [Chapter 5](../chapter-selbri).)

<a id="id-1.13.7.12.1" class="indexterm"></a>In principle any asymmetrical lujvo could be expressed as a symmetrical lujvo. Consider _<a id="id-1.13.7.12.2.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ , discussed in [Section 12.3](../section-lujvo-meanings) , where we learned that the g1 place was equivalent to the z2 place. In order to get the places aligned, we could convert _<a id="id-1.13.7.12.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ to _<a id="id-1.13.7.12.5.1" class="indexterm"></a>se zdani_ (or _selzda_ when expressed as a lujvo). The place structure of _selzda_ is

<div class="example">
<a id="example-random-id-IXoj"></a>

**Example 12.15. <a id="c12e5d5"></a>** 

> s1 is housed by nest s2

</div>  

and so the three-part lujvo _gerselzda_ would have the place structure

<div class="example">
<a id="example-random-id-KqE4"></a>

**Example 12.16. <a id="c12e5d6"></a>** 

> s1=g1 is a dog housed in nest s2 of dog breed g2

</div>  

However, although _gerselzda_ is a valid lujvo, it doesn't translate “doghouse” ; its first place is the dog, not the doghouse. Furthermore, it is more complicated than necessary; _<a id="id-1.13.7.16.3.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ is simpler than _gerselzda_.

From the reader's or listener's point of view, it may not always be obvious whether a newly met lujvo is symmetrical or asymmetrical, and if the latter, what kind of asymmetrical lujvo. If the place structure of the lujvo isn't given in a dictionary or elsewhere, then plausibility must be applied, just as in interpreting tanru.

The lujvo _<a id="id-1.13.7.18.1.1" class="indexterm"></a>[_karcykla_](../go01#valsi-karcykla)_ , for example, is based on _<a id="id-1.13.7.18.2.1" class="indexterm"></a>karce klama_ , or “car goer”. The place structure of _<a id="id-1.13.7.18.4.1" class="indexterm"></a>[_karce_](../go01#valsi-karce)_ is:

<div class="example">
<a id="example-random-id-S7W3"></a>

**Example 12.17. <a id="c12e5d7"></a>** 

karce: ka1 is a car carrying ka2 propelled by ka3

</div>  

An asymmetrical interpretation of _<a id="id-1.13.7.20.1.1" class="indexterm"></a>[_karcykla_](../go01#valsi-karcykla)_ that is strictly analogous to the place structure of _<a id="id-1.13.7.20.2.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ , equating the kl2 (destination) and ka1 (car) places, would lead to the place structure

<div class="example">
<a id="example-random-id-GgxL"></a>

**Example 12.18. <a id="c12e5d8"></a>** 

> kl1 goes to car kl2=ka1 which carries ka2 propelled by ka3 from origin kl3 via route kl4 by means of kl5

</div>  

But in general we go about in cars, rather than going to cars, so a far more likely place structure treats the ka1 place as equivalent to the kl5 place, leading to

<div class="example">
<a id="example-random-id-QiHw"></a>

**Example 12.19. <a id="c12e5d9"></a><a id="id-1.13.7.23.1.2" class="indexterm"></a>** 

> kl1 goes to destination kl2 from origin kl3 via route kl4 by means of car kl5=ka1 carrying ka2 propelled by ka3.

</div>  

instead.