<a id="section-sumti-connection"></a>14.6. <a id="c14s6"></a>sumti connection
-----------------------------------------------------------------------------

<a id="id-1.15.8.2.1" class="indexterm"></a><a id="id-1.15.8.2.2" class="indexterm"></a><a id="id-1.15.8.2.3" class="indexterm"></a><a id="id-1.15.8.2.4" class="indexterm"></a>Geks and ijeks are sufficient to state every possible logical connection between two bridi. However, it is often the case that two bridi to be logically connected have one or more portions in common:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ecnq"></a>

**Example 14.25. <a id="c14e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>klama</td><td>le</td><td>zarci</td><td>.ije</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John goes to the market, and Alice goes to the market.</p></td></tr></tbody></table>

</div>  

Here only a single sumti differs between the two bridi. Lojban does not require that both bridi be expressed in full. Instead, a single bridi can be given which contains both of the different sumti and uses a logical connective from a different selma'o to combine the two sumti:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JTIm"></a>

**Example 14.26. <a id="c14e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>djan</td><td>.e</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>and</td><td>that-named</td><td>Alice</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

<a id="id-1.15.8.6.1" class="indexterm"></a><a id="id-1.15.8.6.2" class="indexterm"></a><a id="id-1.15.8.6.3" class="indexterm"></a>[Example 14.26](../section-sumti-connection#example-random-id-JTIm) means exactly the same thing as [Example 14.25](../section-sumti-connection#example-random-id-Ecnq) : one may be rigorously transformed into the other without any change of logical meaning. This rule is true in general for every different kind of logical connection in Lojban; all of them, with one exception (see [Section 14.12](../section-tanru)), can always be transformed into a logical connection between sentences that expresses the same truth function.

<a id="id-1.15.8.7.1" class="indexterm"></a><a id="id-1.15.8.7.2" class="indexterm"></a><a id="id-1.15.8.7.3" class="indexterm"></a>The afterthought logical connectives between sumti are eks, which contain a connective cmavo of selma'o A. If ijeks were used in [Example 14.26](../section-sumti-connection#example-random-id-JTIm) , the meaning would be changed:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7KHA"></a>

**Example 14.27. <a id="c14e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td></td><td>.ije</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[is/does-something].</td><td>And</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>that-named</td><td>Alice</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

leaving the reader uncertain why John is mentioned at all.

Any ek may be used between sumti, even if there is no direct English equivalent:

<div class="interlinear-gloss-example example">
<a id="example-random-id-BDLS"></a>

**Example 14.28. <a id="c14e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>.o</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>if-and-only-if</td><td>that-named</td><td>Alice</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John goes to the market if, and only if, Alice does.</p></td></tr></tbody></table>

</div>  

The second line of [Example 14.27](../section-sumti-connection#example-random-id-7KHA) is highly stilted English, but the first line (of which it is a literal translation) is excellent Lojban.

<a id="id-1.15.8.13.1" class="indexterm"></a><a id="id-1.15.8.13.2" class="indexterm"></a><a id="id-1.15.8.13.3" class="indexterm"></a>What about forethought sumti connection? As is the case for bridi connection, geks are appropriate. They are not the only selma'o of forethought logical-connectives, but are the most commonly used ones.

<div class="interlinear-gloss-example example">
<a id="example-random-id-YEa4"></a>

**Example 14.29. <a id="c14e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ga</td><td>la</td><td>.djan.</td><td>gi</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Either John or Alice (or both) goes to the market.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.8.15.1" class="indexterm"></a><a id="id-1.15.8.15.2" class="indexterm"></a>Of course, eks include all the same patterns of compound cmavo that ijeks do. When _<a id="id-1.15.8.15.3.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ or _<a id="id-1.15.8.15.4.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ is part of an ek, a special writing convention is invoked, as in the following example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-caoY"></a>

**Example 14.30. <a id="c14e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>na.a</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>only-if</td><td>that-named</td><td>Alice</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John goes to the market only if Alice does.</p></td></tr></tbody></table>

</div>  

Note the period in _<a id="id-1.15.8.17.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ _<a id="id-1.15.8.17.2.1" class="indexterm"></a>[_.a_](../go01#valsi-a)_. The cmavo of A begin with vowels, and therefore must always be preceded by a pause. It is conventional to write all connective compounds as single words (with no spaces), but this pause must still be marked in writing as in speech; otherwise, the _<a id="id-1.15.8.17.3.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ and _<a id="id-1.15.8.17.4.1" class="indexterm"></a>[_.a_](../go01#valsi-a)_ would tend to run together.