<a id="section-sumtcita"></a>14.18. <a id="c14s18"></a>Tenses, modals, and logical connection
---------------------------------------------------------------------------------------------

The tense and modal systems of Lojban interact with the logical connective system. No one chapter can explain all of these simultaneously, so each chapter must present its own view of the area of interaction with emphasis on its own concepts and terminology. In the examples of this chapter, the many tenses of various selma'o as well as the modals of selma'o BAI are represented by the simple time cmavo _<a id="id-1.15.20.2.1.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ , _<a id="id-1.15.20.2.2.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_ , and _<a id="id-1.15.20.2.3.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ (of selma'o PU) representing the past, the present, and the future respectively. Preceding a selbri, these cmavo state the time when the bridi was, is, or will be true (analogous to English verb tenses); preceding a sumti, they state that the event of the main bridi is before, simultaneous with, or after the event given by the sumti (which is generally a _<a id="id-1.15.20.2.4.1" class="indexterm"></a>le nu_ abstraction; see [Section 11.2](../section-events)).

<a id="id-1.15.20.3.1" class="indexterm"></a><a id="id-1.15.20.3.2" class="indexterm"></a>The two types of interaction between tenses and logical connectives are logically connected tenses and tensed logical connections. The former are fairly simple. Jeks may be used between tense cmavo to specify two connected bridi that differ only in tense:

<div class="interlinear-gloss-example example">
<a id="example-random-id-g6iT"></a>

**Example 14.155. <a id="c14e18d1"></a><a id="id-1.15.20.4.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.artr.</td><td>pu</td><td>nolraitru</td></tr><tr class="gloss"><td>That-named</td><td>Arthur</td><td>[past]</td><td>is-a-noblest-governor.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>la</td><td>.artr.</td><td>ba</td><td>nolraitru</td></tr><tr class="gloss"><td>And</td><td>that-named</td><td>Arthur</td><td>[future]</td><td>is-a-noblest-governor.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Arthur was a king, and Arthur will be a king.</p></td></tr></tbody></table>

</div>  

can be reduced to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PLgw"></a>

**Example 14.156. <a id="c14e18d2"></a><a id="id-1.15.20.6.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.artr.</td><td>pu</td><td>je</td><td>ba</td><td>nolraitru</td></tr><tr class="gloss"><td>That-named</td><td>Arthur</td><td>[past]</td><td>and</td><td>[future]</td><td>is-a-noblest-governor.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Arthur was and will be king.</p></td></tr></tbody></table>

</div>  

[Example 14.155](../section-sumtcita#example-random-id-g6iT) and [Example 14.156](../section-sumtcita#example-random-id-PLgw) are equivalent in meaning; neither says anything about whether Arthur is king now.

<a id="id-1.15.20.8.1" class="indexterm"></a>Non-logical connection with joiks is also possible between tenses:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Mcsi"></a>

**Example 14.157. <a id="c14e18d3"></a><a id="id-1.15.20.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>bi'o</td><td>ba</td><td>vasxu</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>from-...-to</td><td>[future]</td><td>breathe.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I breathe from a past time until a future time.</p></td></tr></tbody></table>

</div>  

The full tense system makes more interesting tense intervals expressible, such as “from a medium time ago until a long time from now”.

<a id="id-1.15.20.11.1" class="indexterm"></a><a id="id-1.15.20.11.2" class="indexterm"></a><a id="id-1.15.20.11.3" class="indexterm"></a><a id="id-1.15.20.11.4" class="indexterm"></a>No forethought connections between tenses are permitted by the grammar, nor is there any way to override the default left-grouping rule; these limitations are imposed to keep the tense grammar simpler. Whatever can be said with tenses or modals can be said with subordinate bridi stating the time, place, or mode explicitly, so it is reasonable to try to remove at least some complications.

<a id="id-1.15.20.12.1" class="indexterm"></a>Tensed logical connections are both more complex and more important than logical connections between tenses. Consider the English sentence:

<div class="example">
<a id="example-random-id-efav"></a>

**Example 14.158. <a id="c14e18d4"></a><a id="id-1.15.20.13.1.2" class="indexterm"></a>** 

I went to the market, and I bought food.

</div>  

The verbatim translation of [Example 14.158](../section-sumtcita#example-random-id-efav) , namely:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PMTu"></a>

**Example 14.159. <a id="c14e18d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td><td>.ije</td><td>mi</td><td>pu</td><td>tervecnu</td><td>lo</td><td>cidja</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td><td>And</td><td>I</td><td>[past]</td><td>buy</td><td>items-of</td><td>food.</td></tr></tbody></table>

</div>  

fails to fully represent a feature of the English, namely that the buying came after the going. (It also fails to represent that the buying was a consequence of the going, which can be expressed by a modal that is discussed in [Chapter 9](../chapter-sumti-tcita).) However, the tense information – that the event of my going to the market preceded the event of my buying food – can be added to the logical connective as follows. The _<a id="id-1.15.20.16.2.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.20.16.3.1" class="indexterm"></a>[_je_](../go01#valsi-je)_ is replaced by _<a id="id-1.15.20.16.4.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.20.16.5.1" class="indexterm"></a>[_je_](../go01#valsi-je)_ _<a id="id-1.15.20.16.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , and the tense cmavo _<a id="id-1.15.20.16.7.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ is inserted between _<a id="id-1.15.20.16.8.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.20.16.9.1" class="indexterm"></a>[_je_](../go01#valsi-je)_ and _<a id="id-1.15.20.16.10.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-BPG1"></a>

**Example 14.160. <a id="c14e18d6"></a><a id="id-1.15.20.17.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>babo</td><td>mi</td><td>pu</td><td>tervecnu</td><td>lo</td><td>cidja</td></tr><tr class="gloss"><td>And</td><td>[later]</td><td>I</td><td>[past]</td><td>buy</td><td>items-of</td><td>food.</td></tr></tbody></table>

</div>  

Here the _<a id="id-1.15.20.18.1.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ cmavo in the two bridi-tails express the time of both actions with respect to the speaker: in the past. The _<a id="id-1.15.20.18.2.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ relates the two items to one another: the second item is later than the first item. The grammar does not permit omitting the _<a id="id-1.15.20.18.3.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ ; if it were omitted, the _<a id="id-1.15.20.18.4.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ and the second _<a id="id-1.15.20.18.5.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ would run together to form a compound tense _<a id="id-1.15.20.18.6.1" class="indexterm"></a>[_bapu_](../go01#valsi-bapu)_ applying to the second bridi-tail only.

<a id="id-1.15.20.19.1" class="indexterm"></a><a id="id-1.15.20.19.2" class="indexterm"></a>Adding tense or modal information to a logical connective is permitted only in the following situations:

Between an ek (or joik) and _<a id="id-1.15.20.20.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-129L"></a>

**Example 14.161. <a id="c14e18d7"></a><a id="id-1.15.20.21.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan</td><td>.e</td><td>cabo</td><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>and</td><td>[simultaneous]</td><td>that-named</td><td>Alice</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John and Alice go to the market simultaneously.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.22.1" class="indexterm"></a><a id="id-1.15.20.22.2" class="indexterm"></a><a id="id-1.15.20.22.3" class="indexterm"></a><a id="id-1.15.20.22.4" class="indexterm"></a>Between an ek (or joik) and _<a id="id-1.15.20.22.5.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nydK"></a>

**Example 14.162. <a id="c14e18d8"></a><a id="id-1.15.20.23.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dzukla</td><td>le</td><td>zarci</td><td>.e</td><td>pu</td></tr><tr class="gloss"><td>I</td><td>walk-to</td><td>the</td><td>market</td><td>and</td><td>[earlier]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ke</td><td>le</td><td>zdani</td><td>.a</td><td>le</td><td>ckule</td><td>[ke'e]</td></tr><tr class="gloss"><td>(</td><td>the</td><td>house</td><td>or</td><td>the</td><td>school</td><td>).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I walk to the market and, before that, to the house or the school.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.24.1" class="indexterm"></a><a id="id-1.15.20.24.2" class="indexterm"></a>Between a gihek and _<a id="id-1.15.20.24.3.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-APPE"></a>

**Example 14.163. <a id="id-1.15.20.25.1.1" class="indexterm"></a><a id="c14e18d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dunda</td><td>le</td><td>cukta</td><td>gi'e</td><td>babo</td></tr><tr class="gloss"><td>I</td><td>give</td><td>the</td><td>book</td><td>and</td><td>[later]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lebna</td><td>lo</td><td>jdini</td><td>vau</td><td>do</td></tr><tr class="gloss"><td>take</td><td>some</td><td>money</td><td></td><td>from/to-you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I give you the book and then take some dollars (pounds, yen) from you.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.26.1" class="indexterm"></a><a id="id-1.15.20.26.2" class="indexterm"></a>Between a gihek and _<a id="id-1.15.20.26.3.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-A0yC"></a>

**Example 14.164. <a id="c14e18d10"></a><a id="id-1.15.20.27.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dzukla</td><td>le</td><td>zarci</td><td>gi'e</td><td>ca</td></tr><tr class="gloss"><td>I</td><td>walk-to</td><td>the</td><td>market</td><td>and</td><td>[simultaneous]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ke</td><td>cusku</td><td>zo'e</td><td>la</td><td>.djan.</td><td>[ke'e]</td></tr><tr class="gloss"><td>(</td><td>express</td><td>something</td><td>to-that-named</td><td>John.</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I walk to the market and at the same time talk to John.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.28.1" class="indexterm"></a><a id="id-1.15.20.28.2" class="indexterm"></a><a id="id-1.15.20.28.3" class="indexterm"></a><a id="id-1.15.20.28.4" class="indexterm"></a>Between an ijek (or ijoik) and _<a id="id-1.15.20.28.5.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-AhnP"></a>

**Example 14.165. <a id="c14e18d11"></a><a id="id-1.15.20.29.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>pa</td><td>nanmu</td><td>.ije</td><td>babo</td><td>mi</td><td>viska</td><td>pa</td><td>ninmu</td></tr><tr class="gloss"><td>I</td><td>see</td><td>a</td><td>man.</td><td>And</td><td>[later]</td><td>I</td><td>see</td><td>a</td><td>woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see a man, and then I see a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.30.1" class="indexterm"></a><a id="id-1.15.20.30.2" class="indexterm"></a><a id="id-1.15.20.30.3" class="indexterm"></a><a id="id-1.15.20.30.4" class="indexterm"></a><a id="id-1.15.20.30.5" class="indexterm"></a>Between an ijek (or ijoik) and _<a id="id-1.15.20.30.6.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-GBgP"></a>

**Example 14.166. <a id="c14e18d12"></a><a id="id-1.15.20.31.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>pa</td><td>nanmu</td><td>.ije</td><td>batu'e</td><td>mi</td><td>viska</td><td>pa</td><td>ninmu</td><td>[tu'u]</td></tr><tr class="gloss"><td>I</td><td>see</td><td>a</td><td>man.</td><td>And</td><td>[later]</td><td>I</td><td>see</td><td>a</td><td>woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see a man, and then I see a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.32.1" class="indexterm"></a><a id="id-1.15.20.32.2" class="indexterm"></a><a id="id-1.15.20.32.3" class="indexterm"></a><a id="id-1.15.20.32.4" class="indexterm"></a>And finally, between a jek (or joik) and _<a id="id-1.15.20.32.5.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , as in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ce09"></a>

**Example 14.167. <a id="c14e18d13"></a><a id="id-1.15.20.33.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>mikce</td><td>jebabo</td><td>ricfu</td></tr><tr class="gloss"><td>I</td><td>am-a-doctor</td><td>and-[later]</td><td>rich</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am a doctor and future rich person.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.34.1" class="indexterm"></a><a id="id-1.15.20.34.2" class="indexterm"></a><a id="id-1.15.20.34.3" class="indexterm"></a><a id="id-1.15.20.34.4" class="indexterm"></a>As can be seen from [Example 14.165](../section-sumtcita#example-random-id-AhnP) and [Example 14.166](../section-sumtcita#example-random-id-GBgP) , the choice between _<a id="id-1.15.20.34.7.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ and _<a id="id-1.15.20.34.8.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ (or _<a id="id-1.15.20.34.9.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_) is arbitrary when there are only two things to be connected. If there were no tense information to include, of course neither would be required; it is only the rule that tense information must always be sandwiched between the logical connective and a following _<a id="id-1.15.20.34.10.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , _<a id="id-1.15.20.34.11.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , or _<a id="id-1.15.20.34.12.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ that requires the use of one of these grouping cmavo in [Example 14.161](../section-sumtcita#example-random-id-129L) and [Example 14.163](../section-sumtcita#example-random-id-APPE) through [Example 14.167](../section-sumtcita#example-random-id-Ce09).

<a id="id-1.15.20.35.1" class="indexterm"></a><a id="id-1.15.20.35.2" class="indexterm"></a><a id="id-1.15.20.35.3" class="indexterm"></a><a id="id-1.15.20.35.4" class="indexterm"></a><a id="id-1.15.20.35.5" class="indexterm"></a><a id="id-1.15.20.35.6" class="indexterm"></a><a id="id-1.15.20.35.7" class="indexterm"></a>Non-logical connectives with _<a id="id-1.15.20.35.8.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ and _<a id="id-1.15.20.35.9.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ can include tense information in exactly the same way as logical connectives. Forethought connectives, however (except as noted below) are unable to do so, as are termsets or tense connectives. Mathematical operands and operators can also include tense information in their logical connectives as a result of their close parallelism with sumti and tanru components respectively:

<div class="interlinear-gloss-example example">
<a id="example-random-id-sgUo"></a>

**Example 14.168. <a id="c14e18d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>ci</td><td>.ebabo</td><td>vo</td><td>[ve'o]</td><td>tadni</td><td>cu</td><td>zvati</td><td>le</td><td>kumfa</td></tr><tr class="gloss"><td>(</td><td>3</td><td>and-[future]</td><td>4</td><td>)</td><td>students</td><td></td><td>are-at</td><td>the</td><td>room.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Three and, later, four students were in the room.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.20.37.1" class="indexterm"></a><a id="id-1.15.20.37.2" class="indexterm"></a>is a simple example. There is a special grammatical rule for use when a tense applies to both of the selbri in a forethought bridi-tail connection: the entire forethought construction can just be preceded by a tense. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-DxuA"></a>

**Example 14.169. <a id="c14e18d15"></a><a id="id-1.15.20.38.1.2" class="indexterm"></a><a id="id-1.15.20.38.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>ge</td><td>klama</td><td>le</td><td>zarci</td><td>gi</td><td>tervecnu</td><td>lo</td><td>cidja</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>both</td><td>go-to</td><td>the</td><td>market</td><td>and</td><td>buy</td><td>some</td><td>food</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market and bought some food.</p></td></tr></tbody></table>

</div>  

[Example 14.169](../section-sumtcita#example-random-id-DxuA) is similar to [Example 14.159](../section-sumtcita#example-random-id-PMTu). There is no time relationship specified between the going and the buying; both are simply set in the past.