<a id="section-subscripts-general"></a>19.6. <a id="c19s6"></a>Subscripts: XI
-----------------------------------------------------------------------------

The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">xi</p></td><td class="selmaho"><p class="selmaho">XI</p></td><td class="description"><p class="description">subscript</p></td></tr></tbody></table>

<a id="id-1.20.8.4.1" class="indexterm"></a>The cmavo _<a id="id-1.20.8.4.2.1" class="indexterm"></a>[_xi_](../go01#valsi-xi)_ (of selma'o XI) indicates that a subscript (a number, a lerfu string, or a parenthesized mekso) follows. Subscripts can be attached to almost any construction and are placed following the construction (or its terminator word, which is generally required). When attached to cmavo they are useful either to extend the finite cmavo list to infinite length, or to make more refined distinctions than the standard cmavo list permits. The remainder of this section mentions some places where subscripts might naturally be used.

Lojban gismu have at most five places:

<div class="interlinear-gloss-example example">
<a id="example-random-id-GuYz"></a>

**Example 19.24. <a id="c19e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cu</td><td>klama</td><td></td><td>le</td><td>zarci</td><td>&nbsp;</td><td>le</td><td>zdani</td><td>&nbsp;</td><td>le</td><td>dargu</td><td>&nbsp;</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>I</td><td>&nbsp;</td><td>go</td><td>to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>house</td><td>via</td><td>the</td><td>road</td><td>using</td><td>the</td><td>car.</td></tr></tbody></table>

</div>  

Consequently, selma'o SE (which operates on a selbri to change the order of its places) and selma'o FA (which provides place number tags for individual sumti) have only enough members to handle up to five places. Conversion of [Example 19.24](../section-subscripts-general#example-random-id-GuYz) , using _<a id="id-1.20.8.7.2.1" class="indexterm"></a>[_xe_](../go01#valsi-xe)_ to swap the x1 and x5 places, would produce:

<div class="interlinear-gloss-example example">
<a id="example-random-id-QPGC"></a>

**Example 19.25. <a id="c19e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>karce</td><td>cu</td><td>xe-klama</td><td></td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>The</td><td>car</td><td>&nbsp;</td><td>is-a-transportation-means</td><td>to</td><td>the</td><td>market</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>le</td><td>zdani</td><td>&nbsp;</td><td>le</td><td>dargu</td><td>&nbsp;</td><td>mi</td></tr><tr class="gloss"><td>from</td><td>the</td><td>house</td><td>via</td><td>the</td><td>road</td><td>for</td><td>me.</td></tr></tbody></table>

</div>  

And reordering of the place structures might produce:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PaKo"></a>

**Example 19.26. <a id="c19e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fo</td><td>le</td><td>dargu</td><td>fi</td><td>le</td><td>zdani</td><td>fa</td><td>mi</td></tr><tr class="gloss"><td>Via</td><td>the</td><td>road,</td><td>from</td><td>the</td><td>house,</td><td></td><td>I,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fe</td><td>le</td><td>zarci</td><td>fu</td><td>le</td><td>karce</td><td>cu</td><td>klama</td></tr><tr class="gloss"><td>to</td><td>the</td><td>market,</td><td>using</td><td>the</td><td>car,</td><td></td><td>go.</td></tr></tbody></table>

</div>  

[Example 19.24](../section-subscripts-general#example-random-id-GuYz) to [Example 19.26](../section-subscripts-general#example-random-id-PaKo) all mean the same thing. But consider the lujvo _<a id="id-1.20.8.11.3.1" class="indexterm"></a>[_nunkla_](../go01#valsi-nunkla)_ , formed by applying the abstraction operator _<a id="id-1.20.8.11.4.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ to _<a id="id-1.20.8.11.5.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-sMPn"></a>

**Example 19.27. <a id="c19e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la'e</td><td>di'u</td><td>cu</td><td>nunkla</td><td></td><td>mi</td></tr><tr class="gloss"><td>The-referent-of</td><td>the-previous-sentence</td><td></td><td>is-an-event-of-going</td><td>by</td><td>me</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>le</td><td>zarci</td><td>&nbsp;</td><td>le</td><td>zdani</td><td>&nbsp;</td><td>le</td><td>dargu</td><td>&nbsp;</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>house</td><td>via</td><td>the</td><td>road</td><td>using</td><td>the</td><td>car.</td></tr></tbody></table>

</div>  

<a id="id-1.20.8.13.1" class="indexterm"></a><a id="id-1.20.8.13.2" class="indexterm"></a><a id="id-1.20.8.13.3" class="indexterm"></a><a id="id-1.20.8.13.4" class="indexterm"></a><a id="id-1.20.8.13.5" class="indexterm"></a>[Example 19.27](../section-subscripts-general#example-random-id-sMPn) shows that _<a id="id-1.20.8.13.7.1" class="indexterm"></a>[_nunkla_](../go01#valsi-nunkla)_ has six places: the five places of _<a id="id-1.20.8.13.8.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ plus a new one (placed first) for the event itself. Performing transformations similar to that of [Example 19.25](../section-subscripts-general#example-random-id-QPGC) requires an additional conversion cmavo that exchanges the x1 and x6 places. The solution is to use any cmavo of SE with a subscript "6" ( [Section 19.6](../section-subscripts-general)):

<div class="interlinear-gloss-example example">
<a id="example-random-id-zGhw"></a>

**Example 19.28. <a id="c19e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>karce</td><td>cu</td><td>sexixa&nbsp;nunkla</td><td></td><td>mi</td></tr><tr class="gloss"><td>The</td><td>car</td><td></td><td>is-a-transportation-means-in-the-event-of-going</td><td>by</td><td>me</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>le</td><td>zarci</td><td>&nbsp;</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>house</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>le</td><td>dargu</td><td>la'edi'u</td></tr><tr class="gloss"><td>via</td><td>the</td><td>road</td><td>is-an-event-which-is-referred-to-by-the-last-sentence.</td></tr></tbody></table>

</div>  

Likewise, a sixth place tag can be created by using any cmavo of FA with a subscript:

<div class="interlinear-gloss-example example">
<a id="example-random-id-EW1n"></a>

**Example 19.29. <a id="c19e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fu</td><td>le</td><td>dargu</td><td>fo</td><td>le</td><td>zdani</td><td>fe</td><td>mi</td></tr><tr class="gloss"><td>Via</td><td>the</td><td>road,</td><td>from</td><td>the</td><td>house,</td><td>by</td><td>me,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fa</td><td>la'edi'u</td></tr><tr class="gloss"><td>&nbsp;</td><td>is-an-event-which</td><td>is-referred-to-by-the-last-sentence,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fi</td><td>le</td><td>zarci</td><td>faxixa</td><td>le</td><td>karce</td><td>cu</td><td>nunkla</td></tr><tr class="gloss"><td>to</td><td>the</td><td>market,</td><td>using</td><td>the</td><td>car,</td><td></td><td>is-an-event-of-going.</td></tr></tbody></table>

</div>  

[Example 19.27](../section-subscripts-general#example-random-id-sMPn) to [Example 19.29](../section-subscripts-general#example-random-id-EW1n) also all mean the same thing, and each is derived straightforwardly from any of the others, despite the tortured nature of the English glosses. In addition, any other member of SE or FA could be substituted into _<a id="id-1.20.8.17.3.1" class="indexterm"></a>sexixa_ and _<a id="id-1.20.8.17.4.1" class="indexterm"></a>faxixa_ without change of meaning: _<a id="id-1.20.8.17.5.1" class="indexterm"></a>vexixa_ means the same thing as _<a id="id-1.20.8.17.6.1" class="indexterm"></a>sexixa_.

<a id="id-1.20.8.18.1" class="indexterm"></a><a id="id-1.20.8.18.2" class="indexterm"></a><a id="id-1.20.8.18.3" class="indexterm"></a>Lojban provides two groups of pro-sumti, both belonging to selma'o KOhA. The ko'a-series cmavo are used to refer to explicitly specified sumti to which they have been bound using _<a id="id-1.20.8.18.4.1" class="indexterm"></a>[_goi_](../go01#valsi-goi)_. The da-series, on the other hand, are existentially or universally quantified variables. (These concepts are explained more fully in [Chapter 16](../chapter-quantifiers).) There are ten ko'a-series cmavo and 3 da-series cmavo available.

<a id="id-1.20.8.19.1" class="indexterm"></a><a id="id-1.20.8.19.2" class="indexterm"></a><a id="id-1.20.8.19.3" class="indexterm"></a>If more are required, any cmavo of the ko'a-series or the da-series can be subscripted:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Bday"></a>

**Example 19.30. <a id="c19e6d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>xi</td><td>vo</td></tr><tr class="gloss"><td>X</td><td>sub</td><td>4</td></tr></tbody></table>

</div>  

is the 4th bound variable of the 1st sequence of the da-series, and

<div class="interlinear-gloss-example example">
<a id="example-random-id-gfXT"></a>

**Example 19.31. <a id="c19e6d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ko'i</td><td>xi</td><td>paso</td></tr><tr class="gloss"><td>something-3</td><td>sub</td><td>19</td></tr></tbody></table>

</div>  

is the 19th free variable of the 3rd sequence of the ko'a-series. This convention allows 10 sequences of ko'a-type pro-sumti and 3 sequences of da-type pro-sumti, each with as many members as needed. Note that _<a id="id-1.20.8.23.1.1" class="indexterm"></a>daxivo_ and _<a id="id-1.20.8.23.2.1" class="indexterm"></a>dexivo_ are considered to be distinct pro-sumti, unlike the situation with _<a id="id-1.20.8.23.3.1" class="indexterm"></a>sexixa_ and _<a id="id-1.20.8.23.4.1" class="indexterm"></a>vexixa_ above. Exactly similar treatment can be given to the bu'a-series of selma'o GOhA and to the gismu pro-bridi _<a id="id-1.20.8.23.5.1" class="indexterm"></a>[_broda_](../go01#valsi-broda)_ , _<a id="id-1.20.8.23.6.1" class="indexterm"></a>[_brode_](../go01#valsi-brode)_ , _<a id="id-1.20.8.23.7.1" class="indexterm"></a>[_brodi_](../go01#valsi-brodi)_ , _<a id="id-1.20.8.23.8.1" class="indexterm"></a>[_brodo_](../go01#valsi-brodo)_ , and _<a id="id-1.20.8.23.9.1" class="indexterm"></a>[_brodu_](../go01#valsi-brodu)_.

<a id="id-1.20.8.24.1" class="indexterm"></a>Subscripts on lerfu words are used in the standard mathematical way to extend the number of variables:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wez6"></a>

**Example 19.32. <a id="c19e6d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>xy.boixipa</td><td>du</td><td>li</td><td>xy.boixire</td><td>su'i</td><td>xy.boixici</td></tr><tr class="gloss"><td>The-number</td><td>x-sub-1</td><td>equals</td><td>the-number</td><td>x-sub-2</td><td>plus</td><td>x-sub-3</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">x <sub>1</sub> = x <sub>2</sub> + x <sub>3</sub></span></div></td></tr></tbody></table>

</div>  

and can be used to extend the number of pro-sumti as well, since lerfu strings outside mathematical contexts are grammatically and semantically equivalent to pro-sumti of the ko'a-series. (In [Example 19.32](../section-subscripts-general#example-random-id-wez6) , note the required terminator _<a id="id-1.20.8.26.2.1" class="indexterm"></a>[_boi_](../go01#valsi-boi)_ after each _<a id="id-1.20.8.26.3.1" class="indexterm"></a>[_xy._](../go01#valsi-xy)_ cmavo; this terminator allows the subscript to be attached without ambiguity.)

<a id="id-1.20.8.27.1" class="indexterm"></a>Names, which are similar to pro-sumti, can also be subscripted to distinguish two individuals with the same name:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tW4J"></a>

**Example 19.33. <a id="c19e6d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>xipa</td><td>cusku</td><td>lu</td><td>mi'enai</td><td>do</td><td>li'u</td><td>la</td><td>.djan.</td><td>xire</td></tr><tr class="gloss"><td></td><td>John<sub>1</sub></td><td>expresses</td><td>[quote]</td><td>I-am-not</td><td>you</td><td>[unquote]</td><td>to</td><td></td><td>John<sub>2</sub></td><td>.</td></tr></tbody></table>

</div>  

<a id="id-1.20.8.29.1" class="indexterm"></a>Subscripts on tenses allow talking about more than one time or place that is described by the same general cmavo. For example, _<a id="id-1.20.8.29.2.1" class="indexterm"></a>puxipa_ could refer to one point in the past, and _<a id="id-1.20.8.29.3.1" class="indexterm"></a>puxire_ a second point (earlier or later).

<a id="id-1.20.8.30.1" class="indexterm"></a>You can place a subscript on the word _<a id="id-1.20.8.30.2.1" class="indexterm"></a>[_ja'a_](../go01#valsi-jaha)_ , the bridi affirmative of selma'o NA, to express so-called fuzzy truths. The usual machinery for fuzzy logic (statements whose truth value is not merely “true” or “false” , but is expressed by a number in the range 0 to 1) in Lojban is the abstractor _<a id="id-1.20.8.30.5.1" class="indexterm"></a>[_jei_](../go01#valsi-jei)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-NGGv"></a>

**Example 19.34. <a id="c19e6d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pimu</td><td>jei</td><td>mi</td><td>ganra</td></tr><tr class="gloss"><td>The-number</td><td>.5</td><td>is-the-truth-value-of</td><td>my</td><td>being-broad.</td></tr></tbody></table>

</div>  

However, by convention we can attach a subscript to _<a id="id-1.20.8.32.1.1" class="indexterm"></a>[_ja'a_](../go01#valsi-jaha)_ to indicate fuzzy truth (or to _<a id="id-1.20.8.32.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ if we change the amount):

<div class="interlinear-gloss-example example">
<a id="example-random-id-xpiI"></a>

**Example 19.35. <a id="c19e6d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ja'a</td><td>xipimu</td><td>ganra</td></tr><tr class="gloss"><td>I</td><td>truly</td><td>sub-.5</td><td>am-broad</td></tr></tbody></table>

</div>  

<a id="id-1.20.8.34.1" class="indexterm"></a>Finally, as mentioned in [Section 19.2](../section-i) , _<a id="id-1.20.8.34.3.1" class="indexterm"></a>[_ni'o_](../go01#valsi-niho)_ and _<a id="id-1.20.8.34.4.1" class="indexterm"></a>[_no'i_](../go01#valsi-nohi)_ cmavo with matching subscripts mark the start and the continuation of a given topic respectively. Different topics can be assigned to different subscripts.

Other uses of subscripts will doubtless be devised in future.