<a id="section-sub-bridi-tenses"></a>10.15. <a id="c10s15"></a>Tenses in subordinate bridi
------------------------------------------------------------------------------------------

<a id="id-1.11.17.2.1" class="indexterm"></a>English has a set of rules, formally known as “sequence of tense rules” , for determining what tense should be used in a subordinate clause, depending on the tense used in the main sentence. Here are some examples:

<div class="example">
<a id="example-random-id-qECX"></a>

**Example 10.100. <a id="c10e15d1"></a>** 

John says that George is going to the market.

</div>  
<div class="example">
<a id="example-random-id-qeds"></a>

**Example 10.101. <a id="c10e15d2"></a>** 

John says that George went to the market.

</div>  
<div class="example">
<a id="example-random-id-qEE5"></a>

**Example 10.102. <a id="c10e15d3"></a>** 

John said that George went to the market.

</div>  
<div class="example">
<a id="example-random-id-qeFQ"></a>

**Example 10.103. <a id="c10e15d4"></a>** 

John said that George had gone to the market.

</div>  

In [Example 10.100](../section-sub-bridi-tenses#example-random-id-qECX) and [Example 10.101](../section-sub-bridi-tenses#example-random-id-qeds) , the tense of the main sentence is the present: “says”. If George goes when John speaks, we get the present tense “is going” ( “goes” would be unidiomatic); if George goes before John speaks, we get the past tense “went”. But if the tense of the main sentence is the past, with “said” , then the tense required in the subordinate clause is different. If George goes when John speaks, we get the past tense “went” ; if George goes before John speaks, we get the past-perfect tense “had gone”.

The rule of English, therefore, is that both the tense of the main sentence and the tense of the subordinate clause are understood relative to the speaker of the main sentence (not John, but the person who speaks [Example 10.100](../section-sub-bridi-tenses#example-random-id-qECX) through [Example 10.103](../section-sub-bridi-tenses#example-random-id-qeFQ)).

<a id="id-1.11.17.9.1" class="indexterm"></a><a id="id-1.11.17.9.2" class="indexterm"></a><a id="id-1.11.17.9.3" class="indexterm"></a><a id="id-1.11.17.9.4" class="indexterm"></a><a id="id-1.11.17.9.5" class="indexterm"></a>Lojban, like Russian and Esperanto, uses a different convention. A tense in a subordinate bridi is understood to be relative to the tense already set in the main bridi. Thus [Example 10.100](../section-sub-bridi-tenses#example-random-id-qECX) through [Example 10.103](../section-sub-bridi-tenses#example-random-id-qeFQ) can be expressed in Lojban respectively thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qega"></a>

**Example 10.104. <a id="c10e15d5"></a><a id="id-1.11.17.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>ca</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td></td><td>John</td><td>[present]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>ca</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>George</td><td>[present]</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qeGL"></a>

**Example 10.105. <a id="c10e15d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>ca</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[present]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>George</td><td>[past]</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qEGL"></a>

**Example 10.106. <a id="c10e15d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>pu</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[past]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr><tr class="jbo"><td>la</td><td>.djordj.</td><td>ca</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>George</td><td>[present]</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qegV"></a>

**Example 10.107. <a id="c10e15d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>pu</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[past]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>George</td><td>[past]</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

Probably the most counterintuitive of the Lojban examples is [Example 10.106](../section-sub-bridi-tenses#example-random-id-qEGL). The _<a id="id-1.11.17.14.2.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_ looks quite odd, as if George were going to the market right now, rather than back when John spoke. But this _<a id="id-1.11.17.14.3.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_ is really a _<a id="id-1.11.17.14.4.1" class="indexterm"></a>[_ca_](../go01#valsi-ca)_ with respect to a reference point specified by the outer _<a id="id-1.11.17.14.5.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_. This behavior is the same as the additive behavior of multiple tenses in the same bridi, as explained in [Section 10.13](../section-sticky-tenses).

<a id="id-1.11.17.15.1" class="indexterm"></a><a id="id-1.11.17.15.2" class="indexterm"></a><a id="id-1.11.17.15.3" class="indexterm"></a>There is a special cmavo _<a id="id-1.11.17.15.4.1" class="indexterm"></a>[_nau_](../go01#valsi-nau)_ (of selma'o CUhE) which can be used to override these rules and get to the speaker's current reference point. (Yes, it sounds like English “now”.) It is not grammatical to combine _<a id="id-1.11.17.15.6.1" class="indexterm"></a>[_nau_](../go01#valsi-nau)_ with any other cmavo in a tense, except by way of a logical or non-logical connection (see [Section 10.20](../section-connected-tenses)). Here is a convoluted sentence with several nested bridi which uses _<a id="id-1.11.17.15.8.1" class="indexterm"></a>[_nau_](../go01#valsi-nau)_ at the lowest level:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Yjop"></a>

**Example 10.108. <a id="c10e15d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>pu</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[past]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis</td><td>pu</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>[past]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>pu</td><td>cusku</td><td>le</td><td>se</td><td>du'u</td></tr><tr class="gloss"><td>That-named</td><td>George</td><td>[past]</td><td>says</td><td>the</td><td></td><td>statement-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.maris.</td><td>nau</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>Mary</td><td>[now]</td><td>goes-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John said that Alice had said that George had earlier said that Mary is now going to the market.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.17.17.1" class="indexterm"></a><a id="id-1.11.17.17.2" class="indexterm"></a>The use of _<a id="id-1.11.17.17.3.1" class="indexterm"></a>[_nau_](../go01#valsi-nau)_ does not affect sticky tenses.