<a id="section-stress"></a>3.9. <a id="c3s9"></a>Syllabication and stress
-------------------------------------------------------------------------

<a id="id-1.4.11.2.1" class="indexterm"></a>A Lojban word has one syllable for each of its vowels, diphthongs, and syllabic consonants (referred to simply as “vowels” for the purposes of this section). Syllabication rules determine which of the consonants separating two vowels belong to the preceding vowel and which to the following vowel. These rules are conventional only; the phonetic facts of the matter about how utterances are syllabified in any language are always very complex.

<a id="id-1.4.11.3.1" class="indexterm"></a>A single consonant always belongs to the following vowel. A consonant pair is normally divided between the two vowels; however, if the pair constitute a valid initial consonant pair, they are normally both assigned to the following vowel. A consonant triple is divided between the first and second consonants. Apostrophes and commas, of course, also represent syllable breaks. Syllabic consonants usually appear alone in their syllables.

<a id="id-1.4.11.4.1" class="indexterm"></a>It is permissible to vary from these rules in Lojbanized names. For example, there are no definitive rules for the syllabication of Lojbanized names with consonant clusters longer than three consonants. The comma is used to indicate variant syllabication or to explicitly mark normal syllabication.

<a id="id-1.4.11.5.1" class="indexterm"></a>Here are some examples of Lojban syllabication:

<div class="pronunciation-example example">
<a id="example-random-id-C9tX"></a>

**Example 3.18. <a id="c3e9d1"></a>** 

*   pujenaicajeba

*   pu,je,nai,ca,je,ba

</div>  

This word has no consonant pairs and is therefore syllabified before each medial consonant.

<div class="pronunciation-example example">
<a id="example-random-id-WfXq"></a>

**Example 3.19. <a id="c3e9d2"></a>** 

*   ninmu

*   nin,mu

</div>  

This word is split at a consonant pair.

<div class="pronunciation-example example">
<a id="example-random-id-cwtY"></a>

**Example 3.20. <a id="c3e9d3"></a>** 

*   fitpri

*   fit,pri

</div>  

This word is split at a consonant triple, between the first two consonants of the triple.

<div class="pronunciation-example example">
<a id="example-random-id-WHAV"></a>

**Example 3.21. <a id="c3e9d4"></a>** 

*   sairgoi

*   sair,goi

*   sai,r,goi

</div>  

This word contains the consonant pair _rg_ ; the _r_ may be pronounced syllabically or not.

<div class="pronunciation-example example">
<a id="example-random-id-nK5r"></a>

**Example 3.22. <a id="c3e9d5"></a>** 

*   klezba

*   klez,ba

*   kle,zba

</div>  

This word contains the permissible initial pair _zb_ , and so may be syllabicated either between _z_ and _b_ or before _zb_.

<a id="id-1.4.11.16.1" class="indexterm"></a><a id="id-1.4.11.16.2" class="indexterm"></a><a id="id-1.4.11.16.3" class="indexterm"></a>Stress is a relatively louder pronunciation of one syllable in a word or group of words. Since every syllable has a vowel sound (or diphthong or syllabic consonant) as its nucleus, and the stress is on the vowel sound itself, the terms “stressed syllable” and “stressed vowel” are largely interchangeable concepts.

<a id="id-1.4.11.17.1" class="indexterm"></a>Most Lojban words are stressed on the next-to-the-last, or penultimate, syllable. In counting syllables, however, syllables whose vowel is _y_ or which contain a syllabic consonant ( _l_ , _m_ , _n_ , or _r_) are never counted. (The Lojban term for penultimate stress is _<a id="id-1.4.11.17.7.1" class="indexterm"></a>da'amoi terbasna_.) Similarly, syllables created solely by adding a buffer vowel, such as \[ɪ\] , are not counted.

<a id="id-1.4.11.18.1" class="indexterm"></a>There are actually three levels of stress – primary, secondary, and weak. Weak stress is the lowest level, so it really means no stress at all. Weak stress is required for syllables containing _y_ , a syllabic consonant, or a buffer vowel.

<a id="id-1.4.11.19.1" class="indexterm"></a><a id="id-1.4.11.19.2" class="indexterm"></a><a id="id-1.4.11.19.3" class="indexterm"></a><a id="id-1.4.11.19.4" class="indexterm"></a>Primary stress is required on the penultimate syllable of Lojban content words (called _<a id="id-1.4.11.19.5.1" class="indexterm"></a>[_brivla_](../go01#valsi-brivla)_). Lojbanized names (called _<a id="id-1.4.11.19.6.1" class="indexterm"></a>[_cmevla_](../go01#valsi-cmevla)_) may be stressed on any syllable, but if a syllable other than the penultimate is stressed, the syllable (or at least its vowel) must be capitalized in writing. Lojban structural words (called _<a id="id-1.4.11.19.7.1" class="indexterm"></a>[_cmavo_](../go01#valsi-cmavo)_) may be stressed on any syllable or none at all. However, primary stress may not be used in a syllable just preceding a brivla, unless a pause divides them; otherwise, the two words may run together.

<a id="id-1.4.11.20.1" class="indexterm"></a>Secondary stress is the optional and non-distinctive emphasis used for other syllables besides those required to have either weak or primary stress. There are few rules governing secondary stress, which typically will follow a speaker's native language habits or preferences. Secondary stress can be used for contrast, or for emphasis of a point. Secondary stress can be emphasized at any level up to primary stress, although the speaker must not allow a false primary stress in brivla, since errors in word resolution could result.

The following are Lojban words with stress explicitly shown:

<div class="pronunciation-example example">
<a id="example-random-id-cxzt"></a>

**Example 3.23. <a id="c3e9d6"></a>** 

*   dikyjvo

*   DI,ky,jvo

</div>  

(In a fully-buffered dialect, the pronunciation would be: \['di kə ʒɪ vo\].) Note that the syllable _<a id="id-1.4.11.23.2.1" class="indexterm"></a>[_ky._](../go01#valsi-ky)_ is not counted in determining stress. The vowel _y_ is never stressed in a normal Lojban context.

<div class="pronunciation-example example">
<a id="example-random-id-Sz52"></a>

**Example 3.24. <a id="id-1.4.11.24.1.1" class="indexterm"></a><a id="c3e9d7"></a>** 

*   .armstrong.

*   .ARM,strong.

</div>  

This is a Lojbanized version of the name “Armstrong”. The final _g_ must be explicitly pronounced. With full buffering, the name would be pronounced:

<div class="pronunciation-example example">
<a id="example-random-id-k2PA"></a>

**Example 3.25. <a id="c3e9d8"></a>** 

*   \[ˈʔa rɪ mɪ sɪ tɪ ro nɪ gɪʔ\]

</div>  

However, there is no need to insert a buffer in every possible place just because it is inserted in one place: partial buffering is also acceptable. In every case, however, the stress remains in the same place: on the first syllable.

<a id="id-1.4.11.28.1" class="indexterm"></a>The English pronunciation of “Armstrong” , as spelled in English, is not correct by Lojban standards; the letters “ng” in English represent a velar nasal (IPA \[ŋ\]) which is a single consonant. In Lojban, _ng_ represents two separate consonants that must both be pronounced; you may not use \[ŋ\] to pronounce Lojban _ng_ , although \[ŋg\] is acceptable. English speakers are likely to have to pronounce the ending with a buffer, as one of the following:

<div class="pronunciation-example example">
<a id="example-random-id-k2T5"></a>

**Example 3.26. <a id="c3e9d9"></a>** 

*   \[ˈʔarm stron gɪʔ\]

*   or

*   \[ˈʔarm stroŋ gɪʔ\]

*   or even

*   \[ˈʔarm stro nɪgʔ\]

</div>  

The normal English pronunciation of the name “Armstrong” could be Lojbanized as:

<div class="pronunciation-example example">
<a id="example-random-id-vY2y"></a>

**Example 3.27. <a id="c3e9d10"></a>** 

*   .ARMstron.

</div>  

since Lojban _n_ is allowed to be pronounced as the velar nasal \[ŋ\].

Here is another example showing the use of _y_ :

<div class="pronunciation-example example">
<a id="example-random-id-hNb7"></a>

**Example 3.28. <a id="c3e9d11"></a>** 

*   bisydja

*   BI,sy,dja

*   BI,syd,ja

</div>  

This word is a compound word, or lujvo, built from the two affixes _bis_ and _dja_. When they are joined, an impermissible consonant pair results: _sd_. In accordance with the algorithm for making lujvo, explained in [Section 4.11](../section-lujvo-making) , a _y_ is inserted to separate the impermissible consonant pair; the _y_ is not counted as a syllable for purposes of stress determination.

<div class="pronunciation-example example">
<a id="example-random-id-5g4j"></a>

**Example 3.29. <a id="c3e9d12"></a>** 

*   da'udja

*   da'UD,ja

*   da'U,dja

</div>  

These two syllabications sound the same to a Lojban listener – the association of unbuffered consonants in syllables is of no import in recognizing the word.

<div class="pronunciation-example example">
<a id="example-random-id-Ki4a"></a>

**Example 3.30. <a id="id-1.4.11.38.1.1" class="indexterm"></a><a id="c3e9d13"></a>** 

*   e'u bridi

*   e'u BRI,di

*   E'u BRI,di

*   e'U.BRI,di

</div>  

In [Example 3.30](../section-stress#example-random-id-Ki4a) , _<a id="id-1.4.11.39.2.1" class="indexterm"></a>[_.e'u_](../go01#valsi-ehu)_ is a cmavo and _<a id="id-1.4.11.39.3.1" class="indexterm"></a>[_bridi_](../go01#valsi-bridi)_ is a brivla. Either of the first two pronunciations is permitted: no primary stress on either syllable of _<a id="id-1.4.11.39.4.1" class="indexterm"></a>[_.e'u_](../go01#valsi-ehu)_ , or primary stress on the first syllable. The third pronunciation, which places primary stress on the second syllable of the cmavo, requires that – since the following word is a brivla – the two words must be separated by a pause. Consider the following two cases:

<div class="pronunciation-example example">
<a id="example-random-id-qIXo"></a>

**Example 3.31. <a id="c3e9d14"></a>** 

*   le re nobli prenu

*   le re NObli PREnu

</div>  
<div class="pronunciation-example example">
<a id="example-random-id-qiXR"></a>

**Example 3.32. <a id="c3e9d15"></a>** 

*   le re no bliprenu

*   le re no bliPREnu

</div>  

If the cmavo _<a id="id-1.4.11.42.1.1" class="indexterm"></a>[_no_](../go01#valsi-no)_ in [Example 3.32](../section-stress#example-random-id-qiXR) were to be stressed, the phrase would sound exactly like the given pronunciation of [Example 3.31](../section-stress#example-random-id-qIXo) , which is unacceptable in Lojban: a single pronunciation cannot represent both.