<a id="section-story-time"></a>10.14. <a id="c10s14"></a>Story time
-------------------------------------------------------------------

<a id="id-1.11.16.2.1" class="indexterm"></a><a id="id-1.11.16.2.2" class="indexterm"></a><a id="id-1.11.16.2.3" class="indexterm"></a>Making strict use of the conventions explained in [Section 10.13](../section-sticky-tenses) would be intolerably awkward when a story is being told. The time at which a story is told by the narrator is usually unimportant to the story. What matters is the flow of time within the story itself. The term “story” in this section refers to any series of statements related in more-or-less time-sequential order, not just a fictional one.

<a id="id-1.11.16.3.1" class="indexterm"></a><a id="id-1.11.16.3.2" class="indexterm"></a><a id="id-1.11.16.3.3" class="indexterm"></a>Lojban speakers use a different set of conventions, commonly called “story time” , for inferring tense within a story. It is presumed that the event described by each sentence takes place some time more or less after the previous ones. Therefore, tenseless sentences are implicitly tensed as “what happens next”. In particular, any sticky time setting is advanced by each sentence.

The following mini-story illustrates the important features of story time. A sentence-by-sentence explication follows:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qE94"></a>

**Example 10.93. <a id="c10e14d1"></a><a id="id-1.11.16.5.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pu</td><td>zu</td><td>ki</td><td>ku</td><td>ne'i</td><td>ki</td><td>le</td><td>kevna</td></tr><tr class="gloss"><td>[past]</td><td>[long]</td><td>[sticky]</td><td>[,]</td><td>[inside]</td><td>[sticky]</td><td>the</td><td>cave,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ninmu</td><td>goi</td><td>ko'a</td><td>zutse</td><td>le</td><td>rokci</td></tr><tr class="gloss"><td>the</td><td>woman</td><td>defined-as</td><td>she-1</td><td>sat-on</td><td>the</td><td>rock</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Long ago, in a cave, a woman sat on a rock.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qEa4"></a>

**Example 10.94. <a id="c10e14d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ko'a</td><td>citka</td><td>loi</td><td>kanba</td><td>rectu</td></tr><tr class="gloss"><td></td><td>She-1</td><td>eat-(tenseless)</td><td>some-of-the-mass-of</td><td>goat</td><td>flesh.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">She was eating goat's meat.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qEa7"></a>

**Example 10.95. <a id="c10e14d3"></a><a id="id-1.11.16.7.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ko'a</td><td>pu</td><td>jukpa</td><td>ri</td><td>le</td><td>mudyfagri</td></tr><tr class="gloss"><td></td><td>She</td><td>[past]</td><td>cook</td><td>the-last-mentioned</td><td>by-method-the</td><td>wood-fire.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">She had cooked the meat over a wood fire.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qEao"></a>

**Example 10.96. <a id="c10e14d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>lei</td><td>rectu</td><td>cu</td><td>zanglare</td></tr><tr class="gloss"><td></td><td>The-mass-of</td><td>flesh</td><td></td><td>is-(favorable)-warm.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The meat was pleasantly warm.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qebJ"></a>

**Example 10.97. <a id="c10e14d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>labno</td><td>goi</td><td>ko'e</td></tr><tr class="gloss"><td></td><td>The</td><td>wolf</td><td>defined-as</td><td>it-2</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ba</td><td>za</td><td>ki</td><td>nenri</td><td>klama</td><td>le</td><td>kevna</td></tr><tr class="gloss"><td>[future]</td><td>[medium]</td><td>[sticky]</td><td>within</td><td>came</td><td>to-the</td><td>cave.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A while later, a wolf came into the cave.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qebT"></a>

**Example 10.98. <a id="c10e14d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ko'e</td><td>lebna</td><td>lei</td><td>rectu</td><td>ko'a</td></tr><tr class="gloss"><td></td><td>It-2</td><td>takes-(tenseless)</td><td>the-mass-of</td><td>flesh</td><td>from-her-1.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It took the meat from her.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qeBW"></a>

**Example 10.99. <a id="c10e14d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ko'e</td><td>bartu</td><td>klama</td></tr><tr class="gloss"><td></td><td>It-2</td><td>out</td><td>ran</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It ran out.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.16.12.1" class="indexterm"></a>[Example 10.93](../section-story-time#example-random-id-qE94) sets both the time (long ago) and the place (in a cave) using _<a id="id-1.11.16.12.3.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_ , just like the sentence sequences in [Section 10.13](../section-sticky-tenses). No further space cmavo are used in the rest of the story, so the place is assumed to remain unchanged. The English translation of [Example 10.93](../section-story-time#example-random-id-qE94) is marked for past tense also, as the conventions of English storytelling require: consequently, all other English translation sentences are also in the past tense. (We don't notice how strange this is; even stories about the future are written in past tense!) This conventional use of past tense is not used in Lojban narratives.

[Example 10.94](../section-story-time#example-random-id-qEa4) is tenseless. Outside story time, it would be assumed that its event happens simultaneously with that of [Example 10.93](../section-story-time#example-random-id-qE94) , since a sticky tense is in effect; the rules of story time, however, imply that the event occurs afterwards, and that the story time has advanced (changing the sticky time set in [Example 10.93](../section-story-time#example-random-id-qE94)).

[Example 10.95](../section-story-time#example-random-id-qEa7) has an explicit tense. This is taken relative to the latest setting of the sticky time; therefore, the event of [Example 10.95](../section-story-time#example-random-id-qEa7) happens before that of [Example 10.94](../section-story-time#example-random-id-qEa4). It cannot be determined if [Example 10.95](../section-story-time#example-random-id-qEa7) happens before or after [Example 10.93](../section-story-time#example-random-id-qE94).

[Example 10.96](../section-story-time#example-random-id-qEao) is again tenseless. Story time was not changed by the flashback in [Example 10.95](../section-story-time#example-random-id-qEa7) , so [Example 10.96](../section-story-time#example-random-id-qEao) happens after [Example 10.94](../section-story-time#example-random-id-qEa4).

[Example 10.97](../section-story-time#example-random-id-qebJ) specifies the future (relative to [Example 10.96](../section-story-time#example-random-id-qEao)) and makes it sticky. So all further events happen after [Example 10.97](../section-story-time#example-random-id-qebJ).

[Example 10.98](../section-story-time#example-random-id-qebT) and [Example 10.99](../section-story-time#example-random-id-qeBW) are again tenseless, and so happen after [Example 10.97](../section-story-time#example-random-id-qebJ). (Story time is changed.)

So the overall order is [Example 10.93](../section-story-time#example-random-id-qE94) - [Example 10.95](../section-story-time#example-random-id-qEa7) - [Example 10.94](../section-story-time#example-random-id-qEa4) - [Example 10.96](../section-story-time#example-random-id-qEao) - (medium interval) - [Example 10.97](../section-story-time#example-random-id-qebJ) - [Example 10.98](../section-story-time#example-random-id-qebT) - [Example 10.99](../section-story-time#example-random-id-qeBW). It is also possible that [Example 10.95](../section-story-time#example-random-id-qEa7) happens before [Example 10.93](../section-story-time#example-random-id-qE94).

<a id="id-1.11.16.19.1" class="indexterm"></a>If no sticky time (or space) is set initially, the story is set at an unspecified time (or space): the effect is like that of choosing an arbitrary reference point and making it sticky. This style is common in stories that are jokes. The same convention may be used if the context specifies the sticky time sufficiently.