<a id="section-sticky-tenses"></a>10.13. <a id="c10s13"></a>Sticky and multiple tenses: KI
------------------------------------------------------------------------------------------

The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ki</p></td><td class="selmaho"><p class="selmaho">KI</p></td><td class="description"><p class="description">sticky tense set/reset</p></td></tr></tbody></table>

<a id="id-1.11.15.4.1" class="indexterm"></a><a id="id-1.11.15.4.2" class="indexterm"></a><a id="id-1.11.15.4.3" class="indexterm"></a><a id="id-1.11.15.4.4" class="indexterm"></a>So far we have only considered tenses in isolated bridi. Lojban provides several ways for a tense to continue in effect over more than a single bridi. This property is known as “stickiness” : the tense gets “stuck” and remains in effect until explicitly “unstuck”. In the metaphor of the imaginary journey, the place and time set by a sticky tense may be thought of as a campsite or way-station: it provides a permanent origin with respect to which other tenses are understood. Later imaginary journeys start from that point rather than from the speaker.

To make a tense sticky, suffix _<a id="id-1.11.15.5.1.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_ to it:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rIuI"></a>

**Example 10.82. <a id="c10e13d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>puki</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past-sticky]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td></td><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market. The man bit the dog.</p></td></tr></tbody></table>

</div>  

Here the use of _<a id="id-1.11.15.7.1.1" class="indexterm"></a>puki_ rather than just _<a id="id-1.11.15.7.2.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ ensures that the tense will affect the next sentence as well. Otherwise, since the second sentence is tenseless, there would be no way of determining its tense; the event of the second sentence might happen before, after, or simultaneously with that of the first sentence.

(The last statement does not apply when the two sentences form part of a narrative. See [Section 10.14](../section-story-time) for an explanation of “story time” , which employs a different set of conventions.)

What if the second sentence has a tense anyway?

<div class="interlinear-gloss-example example">
<a id="example-random-id-L9GA"></a>

**Example 10.83. <a id="c10e13d2"></a><a id="id-1.11.15.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>puki</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past-sticky]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>nanmu</td><td>pu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td></td><td>The</td><td>man</td><td>[past]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

</div>  

Here the second _<a id="id-1.11.15.11.1.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ does not replace the sticky tense, but adds to it, in the sense that the starting point of its imaginary journey is taken to be the previously set sticky time. So the translation of [Example 10.83](../section-sticky-tenses#example-random-id-L9GA) is:

<div class="example">
<a id="example-random-id-oJQz"></a>

**Example 10.84. <a id="c10e13d3"></a><a id="id-1.11.15.12.1.2" class="indexterm"></a>** 

I went to the market. The man had earlier bitten the dog.

</div>  

<a id="id-1.11.15.13.1" class="indexterm"></a><a id="id-1.11.15.13.2" class="indexterm"></a>and it is equivalent in meaning (when considered in isolation from any other sentences) to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-N5xa"></a>

**Example 10.85. <a id="c10e13d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>nanmu</td><td>pupu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td></td><td>The</td><td>man</td><td>[past-past]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

</div>  

<a id="id-1.11.15.15.1" class="indexterm"></a><a id="id-1.11.15.15.2" class="indexterm"></a><a id="id-1.11.15.15.3" class="indexterm"></a>The point has not been discussed so far, but it is perfectly grammatical to have more than one tense construct in a sentence:

<div class="interlinear-gloss-example example">
<a id="example-random-id-t7YR"></a>

**Example 10.86. <a id="c10e13d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>puku</td><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>[past]</td><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Earlier, I was going to go to the market.</p></td></tr></tbody></table>

</div>  

Here there are two tenses in the same bridi, the first floating free and specified by _<a id="id-1.11.15.17.1.1" class="indexterm"></a>puku_ , the second in the usual place and specified by _<a id="id-1.11.15.17.2.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_. They are considered cumulative in the same way as the two tenses in separate sentences of [Example 10.85](../section-sticky-tenses#example-random-id-N5xa). [Example 10.86](../section-sticky-tenses#example-random-id-t7YR) is therefore equivalent in meaning, except for emphasis, to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mRPV"></a>

**Example 10.87. <a id="c10e13d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>puba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past-future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I was going to go to the market.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.15.19.1" class="indexterm"></a>Compare [Example 10.88](../section-sticky-tenses#example-random-id-qE4G) and [Example 10.89](../section-sticky-tenses#example-random-id-qE4m) , which have a different meaning from [Example 10.86](../section-sticky-tenses#example-random-id-t7YR) and [Example 10.87](../section-sticky-tenses#example-random-id-mRPV) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qE4G"></a>

**Example 10.88. <a id="c10e13d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td><td>puku</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>market</td><td>[past].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will have gone to the market earlier.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qE4m"></a>

**Example 10.89. <a id="c10e13d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>bapu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[future-past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will have gone to the market.</p></td></tr></tbody></table>

</div>  

So when multiple tense constructs in a single bridi are involved, order counts – the tenses cannot be shifted around as freely as if there were only one tense to worry about.

<a id="id-1.11.15.23.1" class="indexterm"></a>But why bother to allow multiple tense constructs at all? They specify separate portions of the imaginary journey, and can be useful in order to make part of a tense sticky. Consider [Example 10.90](../section-sticky-tenses#example-random-id-gg9C) , which adds a second bridi and a _<a id="id-1.11.15.23.3.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_ to [Example 10.86](../section-sticky-tenses#example-random-id-t7YR) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-gg9C"></a>

**Example 10.90. <a id="c10e13d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pu</td><td>ki</td><td>ku</td><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>[past]</td><td>[sticky]</td><td></td><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td></td><td>The</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

</div>  

What is the implied tense of the second sentence? Not _<a id="id-1.11.15.25.1.1" class="indexterm"></a>[_puba_](../go01#valsi-puba)_ , but only _<a id="id-1.11.15.25.2.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ , since only _<a id="id-1.11.15.25.3.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ was made sticky with _<a id="id-1.11.15.25.4.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_. So the translation is:

> I was going to go to the market. The man bit the dog.

<a id="id-1.11.15.27.1" class="indexterm"></a><a id="id-1.11.15.27.2" class="indexterm"></a><a id="id-1.11.15.27.3" class="indexterm"></a><a id="id-1.11.15.27.4" class="indexterm"></a><a id="id-1.11.15.27.5" class="indexterm"></a>Lojban has several ways of embedding a bridi within another bridi: descriptions, abstractors, relative clauses. (Technically, descriptions contain selbri rather than bridi.) Any of the selbri of these subordinate bridi may have tenses attached. These tenses are interpreted relative to the tense of the main bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-yxFP"></a>

**Example 10.91. <a id="c10e13d10"></a><a id="id-1.11.15.28.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>ba'o</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>[retrospective]</td><td>market</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the former market.</p></td></tr></tbody></table>

</div>  

The significance of the _<a id="id-1.11.15.29.1.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ in [Example 10.91](../section-sticky-tenses#example-random-id-yxFP) is that the speaker's destination is described as being “in the aftermath of being a market” ; that is, it is a market no longer. In particular, the time at which it was no longer a market is in the speaker's past, because the _<a id="id-1.11.15.29.4.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ is interpreted relative to the _<a id="id-1.11.15.29.5.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ tense of the main bridi.

Here is an example involving an abstraction bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-NfS1"></a>

**Example 10.92. <a id="c10e13d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>jinvi</td><td>le</td><td>du'u</td><td>mi</td><td>ba</td><td>morsi</td></tr><tr class="gloss"><td>I</td><td>now</td><td>opine</td><td>the</td><td>fact-that</td><td>I</td><td>will-be</td><td>dead.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I now believe that I will be dead.</p></td></tr></tbody></table>

</div>  

Here the event of being dead is said to be in the future with respect to the opinion, which is in the present.

<a id="id-1.11.15.33.1" class="indexterm"></a><a id="id-1.11.15.33.2" class="indexterm"></a>_<a id="id-1.11.15.33.3.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_ may also be used as a tense by itself. This cancels all stickiness and returns the bridi and all following bridi to the speaker's location in both space and time.

<a id="id-1.11.15.34.1" class="indexterm"></a><a id="id-1.11.15.34.2" class="indexterm"></a><a id="id-1.11.15.34.3" class="indexterm"></a>In complex descriptions, multiple tenses may be saved and then used by adding a subscript to _<a id="id-1.11.15.34.4.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_. A time made sticky with _<a id="id-1.11.15.34.5.1" class="indexterm"></a>kixipa_ (ki-sub-1) can be returned to by specifying _<a id="id-1.11.15.34.6.1" class="indexterm"></a>kixipa_ as a tense by itself. In the case of written expression, the writer's here-and-now is often different from the reader's, and a pair of subscripted _<a id="id-1.11.15.34.7.1" class="indexterm"></a>[_ki_](../go01#valsi-ki)_ tenses could be used to distinguish the two.