<a id="section-spatial-tenses"></a>10.2. <a id="c10s2"></a>Spatial tenses: FAhA and VA
--------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vi</p></td><td class="selmaho"><p class="selmaho">VA</p></td><td class="description"><p class="description">short distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">va</p></td><td class="selmaho"><p class="selmaho">VA</p></td><td class="description"><p class="description">medium distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vu</p></td><td class="selmaho"><p class="selmaho">VA</p></td><td class="description"><p class="description">long distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zu'a</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">left</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ri'u</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">right</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ga'u</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">up</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ni'a</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">down</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ca'u</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">front</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ne'i</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">within</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">be'a</p></td><td class="selmaho"><p class="selmaho">FAhA</p></td><td class="description"><p class="description">north of</p></td></tr></tbody></table>

(The complete list of FAhA cmavo can be found in [Section 10.28](../section-direction-cmavo).)

Why is this section about spatial tenses rather than the more familiar time tenses of [Section 10.1](../chapter-tenses#section-tenses-introduction) , asks the reader? Because the model to be used in explaining both will be easier to grasp for space than for time. The explanation of time tenses will resume in [Section 10.4](../section-temporal-tenses).

<a id="id-1.11.4.6.1" class="indexterm"></a><a id="id-1.11.4.6.2" class="indexterm"></a><a id="id-1.11.4.6.3" class="indexterm"></a><a id="id-1.11.4.6.4" class="indexterm"></a>English doesn't have mandatory spatial tenses. Although there are plenty of ways in English of showing where an event happens, there is absolutely no need to do so. Considering this fact may give the reader a feel for what the optional Lojban time tenses are like. From the Lojban point of view, space and time are interchangeable, although they are not treated identically.

<a id="id-1.11.4.7.1" class="indexterm"></a><a id="id-1.11.4.7.2" class="indexterm"></a><a id="id-1.11.4.7.3" class="indexterm"></a><a id="id-1.11.4.7.4" class="indexterm"></a><a id="id-1.11.4.7.5" class="indexterm"></a><a id="id-1.11.4.7.6" class="indexterm"></a>Lojban specifies the spatial tense of a bridi (the place at which it occurs) by using words from selma'o FAhA and VA to describe an imaginary journey from the speaker to the place referred to. FAhA cmavo specify the direction taken in the journey, whereas VA cmavo specify the distance gone. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hNAJ"></a>

**Example 10.6. <a id="c10e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>va</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[medium-distance]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Over there the man is biting the dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.4.9.1" class="indexterm"></a><a id="id-1.11.4.9.2" class="indexterm"></a><a id="id-1.11.4.9.3" class="indexterm"></a><a id="id-1.11.4.9.4" class="indexterm"></a><a id="id-1.11.4.9.5" class="indexterm"></a>What is at a medium distance? The event referred to by the bridi: the man biting the dog. What is this event at a medium distance from? The speaker's location. We can understand the _<a id="id-1.11.4.9.6.1" class="indexterm"></a>[_va_](../go01#valsi-va)_ as saying: “If you want to get from the speaker's location to the location of the bridi, journey for a medium distance (in some direction unspecified).” This “imaginary journey” can be used to understand not only [Example 10.6](../section-spatial-tenses#example-random-id-hNAJ) , but also every other spatial tense construct.

<a id="id-1.11.4.10.1" class="indexterm"></a><a id="id-1.11.4.10.2" class="indexterm"></a><a id="id-1.11.4.10.3" class="indexterm"></a>Suppose you specify a direction with a FAhA cmavo, rather than a distance with a VA cmavo:

<div class="interlinear-gloss-example example">
<a id="example-random-id-5Qxr"></a>

**Example 10.7. <a id="c10e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>zu'a</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[left]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

</div>  

Here the imaginary journey is again from the speaker's location to the location of the bridi, but it is now performed by going to the left (in the speaker's reference frame) for an unspecified distance. So a reasonable translation is:

> To my left, the man bites the dog.

The “my” does not have an explicit equivalent in the Lojban, because the speaker's location is understood as the starting point.

<a id="id-1.11.4.15.1" class="indexterm"></a><a id="id-1.11.4.15.2" class="indexterm"></a>(Etymologically, by the way, _<a id="id-1.11.4.15.3.1" class="indexterm"></a>[_zu'a_](../go01#valsi-zuha)_ is derived from _<a id="id-1.11.4.15.4.1" class="indexterm"></a>[_zunle_](../go01#valsi-zunle)_ , the gismu for “left” , whereas _<a id="id-1.11.4.15.6.1" class="indexterm"></a>[_vi_](../go01#valsi-vi)_ , _<a id="id-1.11.4.15.7.1" class="indexterm"></a>[_va_](../go01#valsi-va)_ , and _<a id="id-1.11.4.15.8.1" class="indexterm"></a>[_vu_](../go01#valsi-vu)_ are intended to be reminiscent of _<a id="id-1.11.4.15.9.1" class="indexterm"></a>[_ti_](../go01#valsi-ti)_ , _<a id="id-1.11.4.15.10.1" class="indexterm"></a>[_ta_](../go01#valsi-ta)_ , and _<a id="id-1.11.4.15.11.1" class="indexterm"></a>[_tu_](../go01#valsi-tu)_ , the demonstrative pronouns “this-here” , “that-there” , and “that-yonder”.)

<a id="id-1.11.4.16.1" class="indexterm"></a><a id="id-1.11.4.16.2" class="indexterm"></a><a id="id-1.11.4.16.3" class="indexterm"></a><a id="id-1.11.4.16.4" class="indexterm"></a><a id="id-1.11.4.16.5" class="indexterm"></a>What about specifying both a direction and a distance? The rule here is that the direction must come before the distance:

<div class="interlinear-gloss-example example">
<a id="example-random-id-LEIm"></a>

**Example 10.8. <a id="c10e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>zu'avi</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[left-short-distance]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Slightly to my left, the man bites the dog.</p></td></tr></tbody></table>

</div>  

As explained in [Section 10.1](../chapter-tenses#section-tenses-introduction) , it would be perfectly correct to use _<a id="id-1.11.4.18.2.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ to move this tense to the beginning or the end of the sentence to emphasize it:

<div class="interlinear-gloss-example example">
<a id="example-random-id-uCGa"></a>

**Example 10.9. <a id="c10e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zu'aviku</td><td>le</td><td>nanmu</td><td>cu</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>[Left-short-distance]</td><td>the</td><td>man</td><td></td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Slightly to my left, the man bites the dog.</p></td></tr></tbody></table>

</div>