<a id="section-six-types"></a>14.3. <a id="c14s3"></a>The six types of logical connectives
------------------------------------------------------------------------------------------

<a id="id-1.15.5.2.1" class="indexterm"></a>In order to remain unambiguous, Lojban cannot have only a single logical connective for each truth function. There are many places in the grammar of the language where logical connection is permitted, and each must have its appropriate set of connectives. If the connective suitable for sumti were used to connect selbri, ambiguity would result.

Consider the English sentence:

<div class="example">
<a id="example-random-id-ptgf"></a>

**Example 14.2. <a id="c14e3d1"></a><a id="id-1.15.5.4.1.2" class="indexterm"></a>** 

Mary went to the window and ...

</div>  

where the last word could be followed by “the door” , a noun phrase, or by “saw the horses” , a sentence with subject omitted, or by “John went to the door” , a full sentence, or by one of a variety of other English grammatical constructions. Lojban cannot tolerate such grammatical looseness.

<a id="id-1.15.5.6.1" class="indexterm"></a><a id="id-1.15.5.6.2" class="indexterm"></a>Instead, there are a total of five different selma'o used for logical connection: A, GA, GIhA, GUhA, and JA. Each of these includes four cmavo, one based on each of the four vowels, which is always the last vowel in the cmavo. In selma'o A, the vowel is the entire cmavo.

<a id="id-1.15.5.7.1" class="indexterm"></a>Thus, in selma'o A, the cmavo for the function A is _<a id="id-1.15.5.7.3.1" class="indexterm"></a>[_.a_](../go01#valsi-a)_. (Do not confuse A, which is a selma'o, with A , which is a truth function, or _<a id="id-1.15.5.7.5.1" class="indexterm"></a>[_.a_](../go01#valsi-a)_, which is a cmavo.) Likewise, the cmavo for E in selma'o GIhA is _<a id="id-1.15.5.7.7.1" class="indexterm"></a>[_gi'e_](../go01#valsi-gihe)_ , and the cmavo for U in selma'o GA is _<a id="id-1.15.5.7.9.1" class="indexterm"></a>[_gu_](../go01#valsi-gu)_. This systematic regularity makes the cmavo easier to learn.

<a id="id-1.15.5.8.1" class="indexterm"></a>Obviously, four cmavo are not enough to express the 14 truth functions explained in [Section 14.1](../chapter-connectives#section-connectives-introduction). Therefore, compound cmavo must be used. These compound cmavo follow a systematic pattern: each has one cmavo from the five logical connection selma'o at its heart, and may also contain one or more of the auxiliary cmavo _<a id="id-1.15.5.8.3.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ , _<a id="id-1.15.5.8.4.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ , or _<a id="id-1.15.5.8.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_. Which auxiliaries are used with which logical connection cmavo, and with what grammar and meaning, will be explained in the following sections. The uses of each of these auxiliary cmavo relates to its other uses in other parts of Lojban grammar.

<a id="id-1.15.5.9.1" class="indexterm"></a><a id="id-1.15.5.9.2" class="indexterm"></a><a id="id-1.15.5.9.3" class="indexterm"></a><a id="id-1.15.5.9.4" class="indexterm"></a><a id="id-1.15.5.9.5" class="indexterm"></a>For convenience, each of the types of compound cmavo used for logical connection is designated by a Lojban name. The name is derived by changing the final “\-A” of the selma'o name to “\-ek” ; the reasons for using “\-ek” are buried deep in the history of the Loglan Project. Thus, compound cmavo based on selma'o A are known as eks, and those based on selma'o JA are known as jeks. (When writing in English, it is conventional to use “eks” as the plural of “ek”.) When the term “logical connective” is used in this chapter, it refers to one or more of these kinds of compound cmavo.

<a id="id-1.15.5.10.1" class="indexterm"></a><a id="id-1.15.5.10.2" class="indexterm"></a>Why does the title of this section refer to “six types” when there are only five selma'o? A jek may be preceded by _<a id="id-1.15.5.10.4.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ , the usual Lojban cmavo for connecting two sentences. The compound produced by _<a id="id-1.15.5.10.5.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ followed by a jek is known as an ijek. It is useful to think of ijeks as a sixth kind of logical connective, parallel to eks, jeks, geks, giheks, and guheks.

<a id="id-1.15.5.11.1" class="indexterm"></a><a id="id-1.15.5.11.2" class="indexterm"></a><a id="id-1.15.5.11.3" class="indexterm"></a><a id="id-1.15.5.11.4" class="indexterm"></a><a id="id-1.15.5.11.5" class="indexterm"></a><a id="id-1.15.5.11.6" class="indexterm"></a>There also exist giks, joiks, ijoiks, and joigiks, which are not logical connectives, but are other kinds of compound cmavo which will be introduced later.