<a id="section-simple-tanru"></a>5.2. <a id="c5s2"></a>Simple tanru
-------------------------------------------------------------------

<a id="id-1.6.4.2.1" class="indexterm"></a><a id="id-1.6.4.2.2" class="indexterm"></a>Beyond the single brivla, a selbri may consist of two brivla placed together. When a selbri is built in this way from more than one brivla, it is called a tanru, a word with no single English equivalent. The nearest analogue to tanru in English are combinations of two nouns such as “lemon tree”. There is no way to tell just by looking at the phrase “lemon tree” exactly what it refers to, even if you know the meanings of “lemon” and “tree” by themselves. As English-speakers, we must simply know that it refers to “a tree which bears lemons as fruits”. A person who didn't know English very well might think of it as analogous to “brown tree” and wonder, “What kind of tree is lemon-colored?”

<a id="id-1.6.4.3.1" class="indexterm"></a><a id="id-1.6.4.3.2" class="indexterm"></a>In Lojban, tanru are also used for the same purposes as English adjective-noun combinations like “big boy” and adverb-verb combinations like “quickly run”. This is a consequence of Lojban not having any such categories as “noun”, “verb”, “adjective”, or “adverb”. English words belonging to any of these categories are translated by simple brivla in Lojban. Here are some examples of tanru:

<div class="interlinear-gloss-example example">
<a id="example-lemon-tree"></a>

**Example 5.6. <a id="id-1.6.4.4.1.1" class="indexterm"></a><a id="c5e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tu</td><td>pelnimre</td><td>tricu</td></tr><tr class="gloss"><td>That-yonder</td><td>is-a-lemon</td><td>tree.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a lemon tree.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qHNA"></a>

**Example 5.7. <a id="c5e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>barda</td><td>nanla</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-big</td><td>boy.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a big boy.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-eD63"></a>

**Example 5.8. <a id="id-1.6.4.6.1.1" class="indexterm"></a><a id="c5e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>sutra</td><td>bajra</td></tr><tr class="gloss"><td>I</td><td>quick</td><td>run</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I quickly run./I run quickly.</p></td></tr></tbody></table>

</div>  

Note that _<a id="id-1.6.4.7.1.1" class="indexterm"></a>[_pelnimre_](../go01#valsi-pelnimre)_ is a lujvo for “lemon”; it is derived from the gismu _<a id="id-1.6.4.7.3.1" class="indexterm"></a>[_pelxu_](../go01#valsi-pelxu)_, yellow, and _<a id="id-1.6.4.7.4.1" class="indexterm"></a>[_nimre_](../go01#valsi-nimre)_, citrus. Note also that _<a id="id-1.6.4.7.5.1" class="indexterm"></a>[_sutra_](../go01#valsi-sutra)_ can mean “fast/quick” or “quickly” depending on its use:

<div class="interlinear-gloss-example example">
<a id="example-random-id-cjhN"></a>

**Example 5.9. <a id="c5e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>sutra</td></tr><tr class="gloss"><td>I</td><td>am-fast/quick</td></tr></tbody></table>

</div>  

shows _<a id="id-1.6.4.9.1.1" class="indexterm"></a>[_sutra_](../go01#valsi-sutra)_ used to translate an adjective, whereas in [Example 5.8](../section-simple-tanru#example-random-id-eD63) it is translating an adverb. (Another correct translation of [Example 5.8](../section-simple-tanru#example-random-id-eD63), however, would be “I am a quick runner”.)

<a id="id-1.6.4.10.1" class="indexterm"></a><a id="id-1.6.4.10.2" class="indexterm"></a>There are special Lojban terms for the two components of a tanru, derived from the place structure of the word _<a id="id-1.6.4.10.3.1" class="indexterm"></a>[_tanru_](../go01#valsi-tanru)_. The first component is called the _<a id="id-1.6.4.10.4.1" class="indexterm"></a>[_seltau_](../go01#valsi-seltau)_, and the second component is called the _<a id="id-1.6.4.10.5.1" class="indexterm"></a>[_tertau_](../go01#valsi-tertau)_.

<a id="id-1.6.4.11.1" class="indexterm"></a><a id="id-1.6.4.11.2" class="indexterm"></a>The most important rule for use in interpreting tanru is that the tertau carries the primary meaning. A _<a id="id-1.6.4.11.3.1" class="indexterm"></a>pelnimre tricu_ is primarily a tree, and only secondarily is it connected with lemons in some way. For this reason, an alternative translation of [Example 5.6](../section-simple-tanru#example-lemon-tree) would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hP9j"></a>

**Example 5.10. <a id="c5e2d5"></a>** 

That is a lemon type of tree.

</div>  

This “type of” relationship between the components of a tanru is fundamental to the tanru concept.

<a id="id-1.6.4.14.1" class="indexterm"></a><a id="id-1.6.4.14.2" class="indexterm"></a>We may also say that the seltau modifies the meaning of the tertau:

<div class="interlinear-gloss-example example">
<a id="example-random-id-4fvn"></a>

**Example 5.11. <a id="c5e2d6"></a>** 

That is a tree which is lemon-ish (in the way appropriate to trees)

</div>  

would be another possible translation of [Example 5.6](../section-simple-tanru#example-lemon-tree). In the same way, a more explicit translation of [Example 5.7](../section-simple-tanru#example-random-id-qHNA) might be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-asRA"></a>

**Example 5.12. <a id="c5e2d7"></a>** 

John is a boy who is big in the way that boys are big.

</div>  

This “way that boys are big” would be quite different from the way in which elephants are big; big-for-a-boy is small-for-an-elephant.

<a id="id-1.6.4.19.1" class="indexterm"></a><a id="id-1.6.4.19.2" class="indexterm"></a>All tanru are ambiguous semantically. Possible translations of:

<div class="interlinear-gloss-example example">
<a id="example-random-id-aIfM"></a>

**Example 5.13. <a id="id-1.6.4.20.1.1" class="indexterm"></a><a id="c5e2d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>klama</td><td>jubme</td></tr><tr class="gloss"><td>That</td><td>is-a-goer</td><td>type-of-table.</td></tr></tbody></table>

</div>  

include:

*   That is a table which goes (a wheeled table, perhaps).

*   That is a table owned by one who goes.

*   That is a table used by those who go (a sports doctor's table?).

*   That is a table when it goes (otherwise it is a chair?).

<a id="id-1.6.4.23.1" class="indexterm"></a>In each case the object referred to is a “goer type of table”, but the ambiguous “type of” relationship can mean one of many things. A speaker who uses tanru (and pragmatically all speakers must) takes the risk of being misunderstood. Using tanru is convenient because they are short and expressive; the circumlocution required to squeeze out all ambiguity can require too much effort.

<a id="id-1.6.4.24.1" class="indexterm"></a>No general theory covering the meaning of all possible tanru exists; probably no such theory can exist. However, some regularities obviously do exist:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Lczh"></a>

**Example 5.14. <a id="c5e2d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>barda</td><td>prenu</td></tr><tr class="gloss"><td>You</td><td>are-a-large</td><td>person.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-Ldb1"></a>

**Example 5.15. <a id="c5e2d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cmalu</td><td>prenu</td></tr><tr class="gloss"><td>You</td><td>are-a-small</td><td>person.</td></tr></tbody></table>

</div>  

are parallel tanru, in the sense that the relationship between _<a id="id-1.6.4.27.1.1" class="indexterm"></a>[_barda_](../go01#valsi-barda)_ and _<a id="id-1.6.4.27.2.1" class="indexterm"></a>[_prenu_](../go01#valsi-prenu)_ is the same as that between _<a id="id-1.6.4.27.3.1" class="indexterm"></a>[_cmalu_](../go01#valsi-cmalu)_ and _<a id="id-1.6.4.27.4.1" class="indexterm"></a>[_prenu_](../go01#valsi-prenu)_. [Section 5.14](../section-asymmetric-tanru) and [Section 5.15](../section-symmetric-tanru) contain a partial listing of some types of tanru, with examples.