<a id="section-simple-infix"></a>18.5. <a id="c18s5"></a>Simple infix expressions and equations
-----------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">du</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="description"><p class="description">equals</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su'i</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">plus</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vu'u</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">minus</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pi'i</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">times</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">te'a</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">raised to the power</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ny.</p></td><td class="selmaho"><p class="selmaho">BY</p></td><td class="description"><p class="description">letter <span class="quote">“<span class="quote">n</span>”</span></p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vei</p></td><td class="selmaho"><p class="selmaho">VEI</p></td><td class="description"><p class="description">left parenthesis</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ve'o</p></td><td class="selmaho"><p class="selmaho">VEhO</p></td><td class="description"><p class="description">right parenthesis</p></td></tr></tbody></table>

<a id="id-1.19.7.4.1" class="indexterm"></a>Let us begin at the beginning: one plus one equals two. In Lojban, that sentence translates to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-CUeK"></a>

**Example 18.22. <a id="c18e5d1"></a><a id="id-1.19.7.5.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pa</td><td>su'i</td><td>pa</td><td>du</td><td>li</td><td>re</td></tr><tr class="gloss"><td>The-number</td><td>one</td><td>plus</td><td>one</td><td>equals</td><td>the-number</td><td>two.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">1 + 1 = 2</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.7.6.1" class="indexterm"></a><a id="id-1.19.7.6.2" class="indexterm"></a>[Example 18.22](../section-simple-infix#example-random-id-CUeK) , a mekso sentence, is a regular Lojban bridi that exploits mekso features. _<a id="id-1.19.7.6.4.1" class="indexterm"></a>[_du_](../go01#valsi-du)_ is the predicate meaning “x1 is mathematically equal to x2”. It is a cmavo for conciseness, but it has the same grammatical uses as any brivla. Outside mathematical contexts, _<a id="id-1.19.7.6.6.1" class="indexterm"></a>[_du_](../go01#valsi-du)_ means “x1 is identical with x2” or “x1 is the same object as x2”.

<a id="id-1.19.7.7.1" class="indexterm"></a><a id="id-1.19.7.7.2" class="indexterm"></a><a id="id-1.19.7.7.3" class="indexterm"></a><a id="id-1.19.7.7.4" class="indexterm"></a><a id="id-1.19.7.7.5" class="indexterm"></a>The cmavo _<a id="id-1.19.7.7.6.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ is the number article. It is required whenever a sentence talks about numbers as numbers, as opposed to using numbers to quantify things. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nSU9"></a>

**Example 18.23. <a id="c18e5d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ci</td><td>prenu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the three persons</p></td></tr></tbody></table>

</div>  

requires no _<a id="id-1.19.7.9.1.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ article, because the _<a id="id-1.19.7.9.2.1" class="indexterm"></a>[_ci_](../go01#valsi-ci)_ is being used to specify the number of _<a id="id-1.19.7.9.3.1" class="indexterm"></a>[_prenu_](../go01#valsi-prenu)_. However, the sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-BNFi"></a>

**Example 18.24. <a id="c18e5d3"></a><a id="id-1.19.7.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>levi</td><td>sfani</td><td>cu</td><td>grake</td><td>li</td><td>ci</td></tr><tr class="gloss"><td>This</td><td>fly</td><td></td><td>masses-in-grams</td><td>the-number</td><td>three.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This fly has a mass of 3 grams.</p></td></tr></tbody></table>

</div>  

<a id="id-1.19.7.11.1" class="indexterm"></a><a id="id-1.19.7.11.2" class="indexterm"></a>requires _<a id="id-1.19.7.11.3.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ because _<a id="id-1.19.7.11.4.1" class="indexterm"></a>[_ci_](../go01#valsi-ci)_ is being used as a sumti. Note that this is the way in which measurements are stated in Lojban: all the predicates for units of length, mass, temperature, and so on have the measured object as the first place and a number as the second place. Using _<a id="id-1.19.7.11.5.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ for _<a id="id-1.19.7.11.6.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ in [Example 18.23](../section-simple-infix#example-random-id-nSU9) would produce

<div class="interlinear-gloss-example example">
<a id="example-random-id-gJe1"></a>

**Example 18.25. <a id="c18e5d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>prenu</td></tr><tr class="gloss"><td>The-number</td><td>3</td><td>is-a-person.</td></tr></tbody></table>

</div>  

which is grammatical but nonsensical: numbers are not persons.

<a id="id-1.19.7.14.1" class="indexterm"></a><a id="id-1.19.7.14.2" class="indexterm"></a><a id="id-1.19.7.14.3" class="indexterm"></a><a id="id-1.19.7.14.4" class="indexterm"></a>The cmavo _<a id="id-1.19.7.14.5.1" class="indexterm"></a>[_su'i_](../go01#valsi-suhi)_ belongs to selma'o VUhU, which is composed of mathematical operators, and means “addition”. As mentioned before, it is distinct from _<a id="id-1.19.7.14.7.1" class="indexterm"></a>[_ma'u_](../go01#valsi-mahu)_ which means the positive sign as an indication of a positive number:

<div class="interlinear-gloss-example example">
<a id="example-random-id-4gsp"></a>

**Example 18.26. <a id="c18e5d5"></a><a id="id-1.19.7.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ma'u</td><td>pa</td><td>su'i</td></tr><tr class="gloss"><td>The-number</td><td>positive-sign</td><td>one</td><td>plus</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ni'u</td><td>pa</td><td>du</td><td>li</td><td>no</td></tr><tr class="gloss"><td>negative-sign</td><td>one</td><td>equals</td><td>the-number</td><td>zero.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">+1 + -1 = 0</span></div></td></tr></tbody></table>

</div>  

Of course, it is legal to have complex mekso on both sides of _<a id="id-1.19.7.16.1.1" class="indexterm"></a>[_du_](../go01#valsi-du)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-d6bM"></a>

**Example 18.27. <a id="c18e5d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>mu</td><td>su'i</td><td>pa</td><td>du</td><td>li</td><td>ci</td><td>su'i</td><td>ci</td></tr><tr class="gloss"><td>The-number</td><td>five</td><td>plus</td><td>one</td><td>equals</td><td>the-number</td><td>three</td><td>plus</td><td>three.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">5 + 1 = 3 + 3</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.7.18.1" class="indexterm"></a><a id="id-1.19.7.18.2" class="indexterm"></a><a id="id-1.19.7.18.3" class="indexterm"></a><a id="id-1.19.7.18.4" class="indexterm"></a><a id="id-1.19.7.18.5" class="indexterm"></a><a id="id-1.19.7.18.6" class="indexterm"></a><a id="id-1.19.7.18.7" class="indexterm"></a><a id="id-1.19.7.18.8" class="indexterm"></a>Why don't we say _<a id="id-1.19.7.18.9.1" class="indexterm"></a>li mu su'i li pa_ rather than just _<a id="id-1.19.7.18.10.1" class="indexterm"></a>li mu su'i pa_ ? The answer is that VUhU operators connect mekso operands (numbers, in [Example 18.27](../section-simple-infix#example-random-id-d6bM)), not general sumti. _<a id="id-1.19.7.18.12.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ is used to make the entire mekso into a sumti, which then plays the roles applicable to other sumti: in [Example 18.27](../section-simple-infix#example-random-id-d6bM) , filling the places of a bridi

<a id="id-1.19.7.19.1" class="indexterm"></a><a id="id-1.19.7.19.2" class="indexterm"></a><a id="id-1.19.7.19.3" class="indexterm"></a><a id="id-1.19.7.19.4" class="indexterm"></a>By default, Lojban mathematics is like simple calculator mathematics: there is no notion of “operator precedence”. Consider the following example, where _<a id="id-1.19.7.19.6.1" class="indexterm"></a>[_pi'i_](../go01#valsi-pihi)_ means “times” , the multiplication operator:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7a2Q"></a>

**Example 18.28. <a id="c18e5d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>su'i</td><td>vo</td><td>pi'i</td><td>mu</td><td>du</td><td>li</td><td>reci</td></tr><tr class="gloss"><td>The-number</td><td>three</td><td>plus</td><td>four</td><td>times</td><td>five</td><td>equals</td><td>the-number</td><td>two-three.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3 + 4 × 5 = 23</span></div></td></tr></tbody></table>

</div>  

Is the Lojban version of [Example 18.28](../section-simple-infix#example-random-id-7a2Q) true? No! “3 + 4 × 5” is indeed 23, because the usual conventions of mathematics state that multiplication takes precedence over addition; that is, the multiplication “4 × 5” is done first, giving 20, and only then the addition “3 + 20”. But VUhU operators by default are done left to right, like other Lojban grouping, and so a truthful bridi would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-XUQh"></a>

**Example 18.29. <a id="c18e5d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>su'i</td><td>vo</td><td>pi'i</td><td>mu</td><td>du</td><td>li</td><td>cimu</td></tr><tr class="gloss"><td>The-number</td><td>three</td><td>plus</td><td>four</td><td>times</td><td>five</td><td>equals</td><td>the-number</td><td>three-five.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3 + 4 × 5 = 35</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.7.23.1" class="indexterm"></a>Here we calculate 3 + 4 first, giving 7, and then calculate 7 × 5 second, leading to the result 35. While possessing the advantage of simplicity, this result violates the design goal of matching the standards of mathematics. What can be done?

<a id="id-1.19.7.24.1" class="indexterm"></a><a id="id-1.19.7.24.2" class="indexterm"></a><a id="id-1.19.7.24.3" class="indexterm"></a>There are three solutions, all of which will probably be used to some degree. The first solution is to ignore the problem. People will say _<a id="id-1.19.7.24.4.1" class="indexterm"></a>li ci su'i vo pi'i mu_ and mean 23 by it, because the notion that multiplication takes precedence over addition is too deeply ingrained to be eradicated by Lojban parsing, which totally ignores semantics. This convention essentially allows semantics to dominate syntax in this one area.

<a id="id-1.19.7.25.1" class="indexterm"></a><a id="id-1.19.7.25.2" class="indexterm"></a>(Why not hard-wire the precedences into the grammar, as is done in computer programming languages? Essentially because there are too many operators, known and unknown, with levels of precedence that vary according to usage. The programming language 'C' has 13 levels of precedence, and its list of operators is not even extensible. For Lojban this approach is just not practical. In addition, hard-wired precedence could not be overridden in mathematical systems such as spreadsheets where the conventions are different.)

<a id="id-1.19.7.26.1" class="indexterm"></a>The second solution is to use explicit means to specify the precedence of operators. This approach is fully general, but clumsy, and will be explained in [Section 18.20](../section-explicit-operator-precedence).

<a id="id-1.19.7.27.1" class="indexterm"></a><a id="id-1.19.7.27.2" class="indexterm"></a>The third solution is simple but not very general. When an operator is prefixed with the cmavo _<a id="id-1.19.7.27.3.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ (of selma'o BIhE), it becomes automatically of higher precedence than other operators not so prefixed. Thus,

<div class="interlinear-gloss-example example">
<a id="example-random-id-LIUa"></a>

**Example 18.30. <a id="c18e5d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>su'i</td><td>vo</td><td>bi'e</td><td>pi'i</td><td>mu</td><td>du</td><td>li</td><td>reci</td></tr><tr class="gloss"><td>The-number</td><td>three</td><td>plus</td><td>four</td><td></td><td>times</td><td>five</td><td>equals</td><td>the-number</td><td>two-three.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3 + 4 × 5 = 23</span></div></td></tr></tbody></table>

</div>  

is a truthful Lojban bridi. If more than one operator has a _<a id="id-1.19.7.29.1.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ prefix, grouping is from the right; multiple _<a id="id-1.19.7.29.2.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ prefixes on a single operator are not allowed.

<a id="id-1.19.7.30.1" class="indexterm"></a><a id="id-1.19.7.30.2" class="indexterm"></a>In addition, of course, Lojban has the mathematical parentheses _<a id="id-1.19.7.30.3.1" class="indexterm"></a>[_vei_](../go01#valsi-vei)_ and _<a id="id-1.19.7.30.4.1" class="indexterm"></a>[_ve'o_](../go01#valsi-veho)_ , which can be used just like their written equivalents “(” and “)” to group expressions in any way desired:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wfFV"></a>

**Example 18.31. <a id="c18e5d10"></a><a id="id-1.19.7.31.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>ve'o</td><td>pi'i</td><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>[ve'o]</td></tr><tr class="gloss"><td>The-number</td><td>(</td><td><span class="mathphrase">n</span></td><td>plus</td><td>one</td><td>)</td><td>times</td><td>(</td><td><span class="mathphrase">n</span></td><td>plus</td><td>one</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>du</td><td>li</td><td>ny.</td><td>[bi'e]</td><td>te'a</td><td>re</td></tr><tr class="gloss"><td>equals</td><td>the-number</td><td>n</td><td></td><td>to-the-power</td><td>two</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'i</td><td>re</td><td>bi'e</td><td>pi'i</td><td>ny.</td><td>su'i</td><td>pa</td></tr><tr class="gloss"><td>plus</td><td>two</td><td></td><td>times</td><td><span class="mathphrase">n</span></td><td>plus</td><td>1.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">(n+1)(n+1) = n <sup>2</sup> + 2n + 1</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.7.32.1" class="indexterm"></a><a id="id-1.19.7.32.2" class="indexterm"></a>There are several new usages in [Example 18.31](../section-simple-infix#example-random-id-wfFV) : _<a id="id-1.19.7.32.4.1" class="indexterm"></a>[_te'a_](../go01#valsi-teha)_ means “raised to the power” , and we also see the use of the lerfu word _<a id="id-1.19.7.32.6.1" class="indexterm"></a>[_ny._](../go01#valsi-ny)_ , representing the letter “n”. In mekso, letters stand for just what they do in ordinary mathematics: variables. The parser will accept a string of lerfu words (called a “lerfu string”) as the equivalent of a single lerfu word, in agreement with computer-science conventions; “abc” is a single variable, not the equivalent of “a × b × c”. (Of course, a local convention could state that the value of a variable like “abc” , with a multi-lerfu name, was equal to the values of the variables “a” , “b” , and “c” multiplied together.)

The explicit operator _<a id="id-1.19.7.33.1.1" class="indexterm"></a>[_pi'i_](../go01#valsi-pihi)_ is required in the Lojban verbal form whereas multiplication is implicit in the symbolic form. Note that _<a id="id-1.19.7.33.2.1" class="indexterm"></a>[_ve'o_](../go01#valsi-veho)_ (the right parenthesis) is an elidable terminator: the first use of it in [Example 18.31](../section-simple-infix#example-random-id-wfFV) is required, but the second use (marked by square brackets) could be elided. Additionally, the first _<a id="id-1.19.7.33.4.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ (also marked by square brackets) is not necessary to get the proper grouping, but it is included here for symmetry with the other one.