<a id="section-signs-punctuation"></a>18.3. <a id="c18s3"></a>Signs and numerical punctuation
---------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ma'u</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">positive sign</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ni'u</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">negative sign</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pi</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">decimal point</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">fi'u</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">fraction slash</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ra'e</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">repeating decimal</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ce'i</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">percent sign</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ki'o</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">comma between digits</p></td></tr></tbody></table>

<a id="id-1.19.5.4.1" class="indexterm"></a><a id="id-1.19.5.4.2" class="indexterm"></a><a id="id-1.19.5.4.3" class="indexterm"></a>A number can be given an explicit sign by the use of _<a id="id-1.19.5.4.4.1" class="indexterm"></a>[_ma'u_](../go01#valsi-mahu)_ and _<a id="id-1.19.5.4.5.1" class="indexterm"></a>[_ni'u_](../go01#valsi-nihu)_ , which are the positive and negative signs as distinct from the addition, subtraction, and negation operators. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-6A5H"></a>

**Example 18.5. <a id="c18e3d1"></a><a id="id-1.19.5.5.1.2" class="indexterm"></a><a id="id-1.19.5.5.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ni'u</td><td>pa</td></tr><tr class="gloss"><td>negative-sign</td><td>1</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">-1</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.5.6.1" class="indexterm"></a>Grammatically, the signs are part of the number to which they are attached. It is also possible to use _<a id="id-1.19.5.6.2.1" class="indexterm"></a>[_ma'u_](../go01#valsi-mahu)_ and _<a id="id-1.19.5.6.3.1" class="indexterm"></a>[_ni'u_](../go01#valsi-nihu)_ by themselves as numbers; the meaning of these numbers is explained in [Section 18.8](../section-indefinite-numbers).

<a id="id-1.19.5.7.1" class="indexterm"></a><a id="id-1.19.5.7.2" class="indexterm"></a><a id="id-1.19.5.7.3" class="indexterm"></a>Various numerical punctuation marks are likewise expressed by cmavo, as illustrated in the following examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ust4"></a>

**Example 18.6. <a id="c18e3d2"></a><a id="id-1.19.5.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ci</td><td>pi</td><td>pa</td><td>vo</td><td>pa</td><td>mu</td></tr><tr class="gloss"><td>three</td><td>point</td><td>one</td><td>four</td><td>one</td><td>five</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3.1415</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.5.9.1" class="indexterm"></a>(In some cultures, a comma is used instead of a period in the symbolic version of [Example 18.6](../section-signs-punctuation#example-random-id-Ust4) ; _<a id="id-1.19.5.9.3.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ is still the Lojban representation for the decimal point.)

<div class="interlinear-gloss-example example">
<a id="example-random-id-AeRL"></a>

**Example 18.7. <a id="c18e3d3"></a><a id="id-1.19.5.10.1.2" class="indexterm"></a><a id="id-1.19.5.10.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>fi'u</td><td>ze</td></tr><tr class="gloss"><td>two</td><td>fraction</td><td>seven</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><math xmlns="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" display="block"><mfrac><mn>2</mn> <mn>7</mn></mfrac></math></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.5.11.1" class="indexterm"></a><a id="id-1.19.5.11.2" class="indexterm"></a><a id="id-1.19.5.11.3" class="indexterm"></a>[Example 18.7](../section-signs-punctuation#example-random-id-AeRL) is the name of the number two-sevenths; it is not the same as “the result of 2 divided by 7” in Lojban, although numerically these two are equal. If the denominator of the fraction is present but the numerator is not, the numerator is taken to be 1, thus expressing the reciprocal of the following number:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qhvj"></a>

**Example 18.8. <a id="c18e3d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fi'u</td><td>ze</td></tr><tr class="gloss"><td>fraction</td><td>seven</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><math xmlns="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" display="block"><mfrac><mn>1</mn> <mn>7</mn></mfrac></math></div></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhVs"></a>

**Example 18.9. <a id="c18e3d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pi</td><td>ci</td><td>mu</td><td>ra'e</td><td>pa</td><td>vo</td><td>re</td><td>bi</td><td>mu</td><td>ze</td></tr><tr class="gloss"><td>point</td><td>three</td><td>five</td><td>repeating</td><td>one</td><td>four</td><td>two</td><td>eight</td><td>five</td><td>seven</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">.35142857142857...</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.5.14.1" class="indexterm"></a><a id="id-1.19.5.14.2" class="indexterm"></a>Note that the _<a id="id-1.19.5.14.3.1" class="indexterm"></a>[_ra'e_](../go01#valsi-rahe)_ marks unambiguously where the repeating portion “142857” begins.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qhWd"></a>

**Example 18.10. <a id="c18e3d6"></a><a id="id-1.19.5.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ci</td><td>mu</td><td>ce'i</td></tr><tr class="gloss"><td>three</td><td>five</td><td>percent</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">35%</span></div></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhwM"></a>

**Example 18.11. <a id="c18e3d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pa</td><td>ki'o</td><td>re</td><td>ci</td><td>vo</td><td>ki'o</td><td>mu</td><td>xa</td><td>ze</td></tr><tr class="gloss"><td>one</td><td>comma</td><td>two</td><td>three</td><td>four</td><td>comma</td><td>five</td><td>six</td><td>seven</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">1,234,567</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.5.17.1" class="indexterm"></a><a id="id-1.19.5.17.2" class="indexterm"></a><a id="id-1.19.5.17.3" class="indexterm"></a>(In some cultures, spaces are used in the symbolic representation of [Example 18.11](../section-signs-punctuation#example-random-id-qhwM) ; _<a id="id-1.19.5.17.5.1" class="indexterm"></a>[_ki'o_](../go01#valsi-kiho)_ is still the Lojban representation.)

<a id="id-1.19.5.18.1" class="indexterm"></a>It is also possible to have less than three digits between successive _<a id="id-1.19.5.18.2.1" class="indexterm"></a>[_ki'o_](../go01#valsi-kiho)_ s, in which case zeros are assumed to have been elided:

<div class="interlinear-gloss-example example">
<a id="example-random-id-TTBx"></a>

**Example 18.12. <a id="c18e3d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pa</td><td>ki'o</td><td>re</td><td>ci</td><td>ki'o</td><td>vo</td></tr><tr class="gloss"><td>one</td><td>comma</td><td>two</td><td>three</td><td>comma</td><td>four</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">1,023,004</span></div></td></tr></tbody></table>

</div>  

In the same way, _<a id="id-1.19.5.20.1.1" class="indexterm"></a>[_ki'o_](../go01#valsi-kiho)_ can be used after _<a id="id-1.19.5.20.2.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ to divide fractions into groups of three:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qHwu"></a>

**Example 18.13. <a id="c18e3d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pi</td><td>ki'o</td><td>re</td><td>re</td></tr><tr class="gloss"><td>point</td><td>comma</td><td>two</td><td>two</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">.022</span></div></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhxp"></a>

**Example 18.14. <a id="c18e3d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pi</td><td>pa</td><td>ki'o</td><td>pa</td><td>re</td><td>ki'o</td><td>pa</td></tr><tr class="gloss"><td>point</td><td>one</td><td>comma</td><td>one</td><td>two</td><td>comma</td><td>one</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">.001012001</span></div></td></tr></tbody></table>

</div>