<a id="section-selecting-places"></a>12.4. <a id="c12s4"></a>Selecting places
-----------------------------------------------------------------------------

<a id="id-1.13.6.2.1" class="indexterm"></a>The set of places of an ordinary lujvo are selected from the places of its component gismu. More precisely, the places of such a lujvo are derived from the set of places of the component gismu by eliminating unnecessary places, until just enough places remain to give an appropriate meaning to the lujvo. In general, including a place makes the concept expressed by a lujvo more general; excluding a place makes the concept more specific, because omitting the place requires assuming a standard value or range of values for it.

<a id="id-1.13.6.3.1" class="indexterm"></a>It would be possible to design the place structure of a lujvo from scratch, treating it as if it were a gismu, and working out what arguments contribute to the notion to be expressed by the lujvo. There are two reasons arguing against doing so and in favor of the procedure detailed in this chapter.

The first is that it might be very difficult for a hearer or reader, who has no preconceived idea of what concept the lujvo is intended to convey, to work out what the place structure actually is. Instead, he or she would have to make use of a lujvo dictionary every time a lujvo is encountered in order to work out what a _<a id="id-1.13.6.4.1.1" class="indexterm"></a>se jbopli_ or a _<a id="id-1.13.6.4.2.1" class="indexterm"></a>te klagau_ is. But this would mean that, rather than having to learn just the 1300-odd gismu place structures, a Lojbanist would also have to learn myriads of lujvo place structures with little or no apparent pattern or regularity to them. The purpose of the guidelines documented in this chapter is to apply regularity and to make it conventional wherever possible.

The second reason is related to the first: if the veljvo of the lujvo has not been properly selected, and the places for the lujvo are formulated from scratch, then there is a risk that some of the places formulated may not correspond to any of the places of the gismu used in the veljvo of the lujvo. If that is the case – that is to say, if the lujvo places are not a subset of the veljvo gismu places – then it will be very difficult for the hearer or reader to understand what a particular place means, and what it is doing in that particular lujvo. This is a topic that will be further discussed in [Section 12.14](../section-anomalous-lujvo).

However, second-guessing the place structure of the lujvo is useful in guiding the process of subsequently eliminating places from the veljvo. If the Lojbanist has an idea of what the final place structure should look like, he or she should be able to pick an appropriate veljvo to begin with, in order to express the idea, and then to decide which places are relevant or not relevant to expressing that idea.