<a id="section-scope"></a>13.9. <a id="c13s9"></a>The uses of indicators
------------------------------------------------------------------------

<a id="id-1.14.11.2.1" class="indexterm"></a><a id="id-1.14.11.2.2" class="indexterm"></a>The behavior of indicators in the “outside grammar” is nearly as simple as their internal structure. Indicator groupings are identified immediately after the metalinguistic erasers _<a id="id-1.14.11.2.4.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ , _<a id="id-1.14.11.2.5.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ , and _<a id="id-1.14.11.2.6.1" class="indexterm"></a>[_su_](../go01#valsi-su)_ and some, though not all, kinds of quotations. The details of such interactions are discussed in [Section 19.16](../section-cmavo-interactions).

A group of indicators may appear anywhere that a single indicator may, except in those few situations (as in _<a id="id-1.14.11.3.1.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ quotation, explained in [Section 19.10](../section-more-quotations)) where compound cmavo may not be used.

<a id="id-1.14.11.4.1" class="indexterm"></a>At the beginning of a text, indicators modify everything following them indefinitely: such a usage is taken as a raw emotional expression, and we normally don't turn off our emotions when we start and stop sentences. In every other place in an utterance, the indicator (or group) attaches to the word immediately to its left, and indicates that the attitude is being expressed concerning the object or concept to which the word refers.

<a id="id-1.14.11.5.1" class="indexterm"></a>If the word that an indicator (or group) attaches to is itself a cmavo which governs a grammatical structure, then the indicator construct pertains to the referent of the entire structure. There is also a mechanism, discussed in [Section 19.8](../section-attitudinal-scope) , for explicitly marking the range of words to which an indicator applies.

<a id="id-1.14.11.6.1" class="indexterm"></a>More details about the uses of indicators, and the way they interact with other specialized cmavo, are given in [Chapter 19](../chapter-structure). It is worth mentioning that real-world interpretation is not necessarily consistent with the formal scope rules. People generally express emotions when they feel them, with only a minimum of grammatical constraint on that expression; complexities of emotional expression are seldom logically analyzable. Lojban attempts to provide a systematic reference that could possibly be ingrained to an instinctive level. However, it should always be assumed that the referent of an indicator has some uncertainty.

<a id="id-1.14.11.7.1" class="indexterm"></a>For example, in cases of multiple indicators expressed together, the combined form has some ambiguity of interpretation. It is possible to interpret the second indicator as expressing an attitude about the first, or to interpret both as expressing attitudes about the common referent. For example, in

<div class="interlinear-gloss-example example">
<a id="example-random-id-Rs6P"></a>

**Example 13.63. <a id="c13e9d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>tavla</td><td>do</td><td>.o'onai</td><td>.oi</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>talk-to</td><td>you</td><td>[Grrr!]</td><td>[Oy!]</td></tr></tbody></table>

</div>  

can be interpreted as expressing complaint about the anger, in which case it means “Damn, I snapped at you” ; or as expressing both anger and complaint about the listener, in which case it means “I told you, you pest!”

Similarly, an indicator after the final brivla of a tanru may be taken to express an attitude about the particular brivla placed there – as the rules have it – or about the entire bridi which hinges on that brivla. Remembering that indicators are supposedly direct expressions of emotion, this ambiguity is acceptable.

<a id="id-1.14.11.11.1" class="indexterm"></a>Even if the scope rules given for indicators turn out to be impractical or unintuitive for use in conversation, they are still useful in written expression. There, where you can go back and put in markers or move words around, the scope rules can be used in lieu of elaborate nuances of body language and intonation to convey the writer's intent.