<a id="section-scales-negation"></a>15.5. <a id="c15s5"></a>Expressing scales in selbri negation
------------------------------------------------------------------------------------------------

In expressing a scalar negation, we can provide some indication of the scale, range, frame-of-reference, or universe of discourse that is being dealt with in an assertion. As stated in [Section 15.4](../section-nahe) , the default is the set of plausible alternatives. Thus if we say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mw3B"></a>

**Example 15.62. <a id="c15e5d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-a-non-</td><td>(red-thing).</td></tr></tbody></table>

</div>  

the pragmatic interpretation is that we mean a different color and not

<div class="interlinear-gloss-example example">
<a id="example-random-id-7iMz"></a>

**Example 15.63. <a id="c15e5d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>dzukla</td><td>be</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>walkingly-goes</td><td>to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

However, if we have reason to be more explicit (an obtuse or contrary listener, or simply an overt logical analysis), we can clarify that we are referring to a color by saying:

<div class="interlinear-gloss-example example">
<a id="example-random-id-yWSC"></a>

**Example 15.64. <a id="c15e5d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td><td>skari</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>(is-of-a-non</td><td>red)</td><td>color.</td></tr></tbody></table>

</div>  

We might also have reduced the pragmatic ambiguity by making the two trailing sumti values explicit (the “as perceived by” and “under conditions” places have been added to the place structure of _<a id="id-1.16.7.8.3.1" class="indexterm"></a>[_xunre_](../go01#valsi-xunre)_). But assume we have a really stubborn listener (an artificially semi-intelligent computer?) who will find a way to misinterpret [Example 15.64](../section-scales-negation#example-random-id-yWSC) even with three specific sumti provided.

In this case, we use a sumti tagged with the sumtcita _<a id="id-1.16.7.9.1.1" class="indexterm"></a>[_ci'u_](../go01#valsi-cihu)_ , which translates roughly as “on a scale of X” , where X is the sumti. For maximal clarity, the tagged sumti can be bound into the negated selbri with _<a id="id-1.16.7.9.4.1" class="indexterm"></a>[_be_](../go01#valsi-be)_. To clarify [Example 15.64](../section-scales-negation#example-random-id-yWSC) , we might say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-a8S1"></a>

**Example 15.65. <a id="c15e5d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td><td>be</td><td>ci'u</td><td>loka</td><td>skari</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-non</td><td>(red</td><td>on</td><td>a-scale-of</td><td>a-property</td><td>color-ness).</td></tr></tbody></table>

</div>  

We can alternately use the sumtcita _<a id="id-1.16.7.11.1.1" class="indexterm"></a>[_teci'e_](../go01#valsi-tecihe)_ , based on _<a id="id-1.16.7.11.2.1" class="indexterm"></a>[_ciste_](../go01#valsi-ciste)_ , which translates roughly as “of a system of components X” , for universes of discourse; in this case, we would express [Example 15.64](../section-scales-negation#example-random-id-yWSC) as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-I0eV"></a>

**Example 15.66. <a id="c15e5d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-a-non</td><td>(red</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>teci'e</td><td>le</td><td>skari</td></tr><tr class="gloss"><td>of</td><td>a-system</td><td>with-components-the</td><td>colors)-thing.</td></tr></tbody></table>

</div>  

Other places of _<a id="id-1.16.7.13.1.1" class="indexterm"></a>[_ciste_](../go01#valsi-ciste)_ can be brought out using the grammar of selma'o BAI modals, allowing slightly different forms of expression, thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Rj71"></a>

**Example 15.67. <a id="c15e5d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-a-non</td><td>(red</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>ci'e</td><td>lo'i</td><td>skari</td></tr><tr class="gloss"><td>of</td><td>a-system</td><td>which-is-the-set-of</td><td>colors)-thing.</td></tr></tbody></table>

</div>  

The cmavo _<a id="id-1.16.7.15.1.1" class="indexterm"></a>[_le'a_](../go01#valsi-leha)_ , also in selma'o BAI, can be used to specify a category:

<div class="interlinear-gloss-example example">
<a id="example-random-id-5ibb"></a>

**Example 15.68. <a id="c15e5d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>na'e</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-a-non</td><td>(red</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>le'a</td><td>lo'i</td><td>skari</td></tr><tr class="gloss"><td>of</td><td>a-category</td><td>which-is-the-set-of</td><td>colors)-thing.</td></tr></tbody></table>

</div>  

which is minimally different in meaning from [Example 15.67](../section-scales-negation#example-random-id-Rj71).

The cmavo _<a id="id-1.16.7.18.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ is not the only member of selma'o NAhE. If we want to express a scalar negation which is a polar opposite, we use the cmavo _<a id="id-1.16.7.18.2.1" class="indexterm"></a>[_to'e_](../go01#valsi-tohe)_ , which is grammatically equivalent to _<a id="id-1.16.7.18.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-RuvP"></a>

**Example 15.69. <a id="c15e5d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>cu</td><td>to'e</td><td>xunre</td><td>be</td><td>ci'u</td><td>loka</td><td>skari</td></tr><tr class="gloss"><td>The</td><td>chair</td><td></td><td>is-a-(opposite-of</td><td>red)</td><td>on</td><td>scale</td><td>a-property-of</td><td>color-ness.</td></tr></tbody></table>

</div>  

Likewise, the midpoint of a scale can be expressed with the cmavo _<a id="id-1.16.7.20.1.1" class="indexterm"></a>[_no'e_](../go01#valsi-nohe)_ , also grammatically equivalent to _<a id="id-1.16.7.20.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_. Here are some parallel examples of _<a id="id-1.16.7.20.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ , _<a id="id-1.16.7.20.4.1" class="indexterm"></a>[_no'e_](../go01#valsi-nohe)_ , and _<a id="id-1.16.7.20.5.1" class="indexterm"></a>[_to'e_](../go01#valsi-tohe)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qH9T"></a>

**Example 15.70. <a id="c15e5d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>melbi</td></tr><tr class="gloss"><td>That</td><td>is-beautiful.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qh9U"></a>

**Example 15.71. <a id="c15e5d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>na'e</td><td>melbi</td></tr><tr class="gloss"><td>That</td><td>is-other-than</td><td>beautiful.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is ugly [in one sense].</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhAI"></a>

**Example 15.72. <a id="c15e5d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>no'e</td><td>melbi</td></tr><tr class="gloss"><td>That</td><td>is-neutrally</td><td>beautiful.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is plain/ordinary-looking (neither ugly nor beautiful).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qHAV"></a>

**Example 15.73. <a id="c15e5d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>to'e</td><td>melbi</td></tr><tr class="gloss"><td>That</td><td>is-opposite-of</td><td>beautiful.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is ugly/very ugly/repulsive.</p></td></tr></tbody></table>

</div>  

The cmavo _<a id="id-1.16.7.25.1.1" class="indexterm"></a>[_to'e_](../go01#valsi-tohe)_ has the assigned rafsi _\-tol-_ and _<a id="id-1.16.7.25.3.1" class="indexterm"></a>\-to'e-_ ; the cmavo _<a id="id-1.16.7.25.4.1" class="indexterm"></a>[_no'e_](../go01#valsi-nohe)_ has the assigned rafsi _\-nor-_ and _\-no'e-_. The selbri in [Example 15.71](../section-scales-negation#example-random-id-qh9U) through [Example 15.73](../section-scales-negation#example-random-id-qHAV) could be replaced by the lujvo _nalmle_ , _normle_ , and _<a id="id-1.16.7.25.11.1" class="indexterm"></a>[_tolmle_](../go01#valsi-tolmle)_ respectively.

This large variety of scalar negations is provided because different scales have different properties. Some scales are open-ended in both directions: there is no “ultimately ugly” or “ultimately beautiful”. Other scales, like temperature, are open at one end and closed at the other: there is a minimum temperature (so-called “absolute zero”) but no maximum temperature. Still other scales are closed at both ends.

Correspondingly, some selbri have no obvious _<a id="id-1.16.7.27.1.1" class="indexterm"></a>[_to'e_](../go01#valsi-tohe)_ - what is the opposite of a dog? – while others have more than one, and need _<a id="id-1.16.7.27.2.1" class="indexterm"></a>[_ci'u_](../go01#valsi-cihu)_ to specify which opposite is meant.