<a id="section-scalar-negation"></a>15.3. <a id="c15s3"></a>Scalar negation
---------------------------------------------------------------------------

Let us now consider some other types of negation. For example, when we say:

<div class="example">
<a id="example-random-id-GJga"></a>

**Example 15.29. <a id="c15e3d1"></a>** 

The chair is not brown.

</div>  

we make a positive inference – that the chair is some other color. Thus, it is legitimate to respond:

<div class="example">
<a id="example-random-id-DDN8"></a>

**Example 15.30. <a id="c15e3d2"></a>** 

It is green.

</div>  

Whether we agree that the chair is brown or not, the fact that the statement refers to color has significant effect on how we interpret some responses. If we hear the following exchange:

<div class="example">
<a id="example-random-id-muQB"></a>

**Example 15.31. <a id="c15e3d3"></a>** 

The chair is not brown.

Correct. The chair is wooden.

</div>  

we immediately start to wonder about the unusual wood that isn't brown. If we hear the exchange:

<div class="example">
<a id="example-random-id-MxWM"></a>

**Example 15.32. <a id="c15e3d4"></a>** 

Is the chair green?

No, it is in the kitchen.

</div>  

we are unsettled because the response seems to be a non-sequitur. But since it might be true and it is a statement about the chair, one can't say it is entirely irrelevant!

What is going on in these statements is something called “scalar negation”. As the name suggests, scalar negation presumes an implied scale. A negation of this type not only states that one scalar value is false, but implies that another value on the scale must be true. This can easily lead to complications. The following exchange seems reasonably natural (a little suspension of disbelief in such inane conversation will help):

<div class="example">
<a id="example-random-id-s5DJ"></a>

**Example 15.33. <a id="c15e3d5"></a>** 

That isn't a blue house.

Right! That is a green house.

</div>  

We have acknowledged a scalar negation by providing a correct value which is another color in the set of colors permissible for houses. While a little less likely, the following exchange is also natural:

<div class="example">
<a id="example-random-id-M472"></a>

**Example 15.34. <a id="c15e3d6"></a>** 

That isn't a blue house.

Right! That is a blue car.

</div>  

Again, we have acknowledged a scalar negation, and substituted a different object in the universe of discourse of things that can be blue.

Now, if the following exchange occurs:

<div class="example">
<a id="example-random-id-sq36"></a>

**Example 15.35. <a id="c15e3d7"></a>** 

That isn't a blue house.

Right! That is a green car.

</div>  

we find the result unsettling. This is because it seems that two corrections have been applied when there is only one negation. Yet out of context, “blue house” and “green car” seem to be reasonably equivalent units that should be mutually replaceable in a sentence. It's just that we don't have a clear way in English to say:

<div class="example">
<a id="example-random-id-hd0I"></a>

**Example 15.36. <a id="c15e3d8"></a>** 

That isn't a “blue-house”.

</div>  

aloud so as to clearly imply that the scalar negation is affecting the pair of words as a single unit.

Another even more confusing example of scalar negation is to the sentence:

<div class="example">
<a id="example-random-id-JTrd"></a>

**Example 15.37. <a id="c15e3d9"></a>** 

John didn't go to Paris from Rome.

</div>  

Might [Example 15.37](../section-scalar-negation#example-random-id-JTrd) imply that John went to Paris from somewhere else? Or did he go somewhere else from Rome? Or perhaps he didn't go anywhere at all: maybe someone else did, or maybe there was no event of going whatsoever. One can devise circumstances where any one, two or all three of these statements might be inferred by a listener.

In English, we have a clear way of distinguishing scalar negation from predicate negation that can be used in many situations. We can use the partial word “non-” as a prefix. But this is not always considered good usage, even though it would render many statements much clearer. For example, we can clearly distinguish

<div class="example">
<a id="example-random-id-gN3C"></a>

**Example 15.38. <a id="c15e3d10"></a>** 

That is a non-blue house.

</div>  

from the related sentence

<div class="example">
<a id="example-random-id-GtQC"></a>

**Example 15.39. <a id="c15e3d11"></a>** 

That is a blue non-house.

</div>  

[Example 15.38](../section-scalar-negation#example-random-id-gN3C) and [Example 15.39](../section-scalar-negation#example-random-id-GtQC) have the advantage that, while they contain a negative indication, they are in fact positive assertions. They say what is true by excluding the false; they do not say what is false.

We can't always use “non-” though, because of the peculiarities of English's grammar. It would sound strange to say:

<div class="example">
<a id="example-random-id-A3yR"></a>

**Example 15.40. <a id="c15e3d12"></a>** 

John went to non-Paris from Rome.

</div>  

or

<div class="example">
<a id="example-random-id-sn2I"></a>

**Example 15.41. <a id="c15e3d13"></a>** 

John went to Paris from non-Rome.

</div>  

although these would clarify the vague negation. Another circumlocution for English scalar negation is “other than” , which works where “non-” does not, but is wordier.

Finally, we have natural language negations that are called polar negations, or opposites:

<div class="example">
<a id="example-random-id-qh2s"></a>

**Example 15.42. <a id="c15e3d14"></a>** 

John is moral

</div>  
<div class="example">
<a id="example-random-id-qh3s"></a>

**Example 15.43. <a id="c15e3d15"></a>** 

John is immoral

</div>  

To be immoral is much more than to just be not moral: it implies the opposite condition. Statements like [Example 15.43](../section-scalar-negation#example-random-id-qh3s) are strong negations which not only deny the truth of a statement, but assert its opposite. Since, “opposite” implies a scale, polar negations are a special variety of scalar negations.

To examine this concept more closely, let us draw a linear scale, showing two examples of how the scale is used:

      Affirmations (positive)      Negations (negative)  
      |-----------|-----------|-----------|-----------|  
      All       Most        Some         Few       None  
      Excellent Good        Fair         Poor     Awful  
    

Some scales are more binary than the examples we diagrammed. Thus we have “not necessary” or “unnecessary” being the polar opposite of necessary. Another scale, especially relevant to Lojban, is interpreted based on situations modified by one's philosophy: “not true” may be equated with “false” in a bi-valued truth-functional logic, while in tri-valued logic an intermediate between “true” and “false” is permitted, and in fuzzy logic a continuous scale exists from true to false. The meaning of “not true” requires a knowledge of which variety of truth scale is being considered.

We will define the most general form of scalar negation as indicating only that the particular point or value in the scale or range is not valid and that some other (unspecified) point on the scale is correct. This is the intent expressed in most contexts by “not mild” , for example.

Using this paradigm, contradictory negation is less restrictive than scalar negation – it says that the point or value stated is incorrect (false), and makes no statement about the truth of any other point or value, whether or not on the scale.

In English, scalar negation semantically includes phrases such as “other than” , “reverse of” , or “opposite from” expressions and their equivalents. More commonly, scalar negation is expressed in English by the prefixes “non-” , “un-” , “il-” , and “im-”. Just which form and permissible values are implied by a scalar negation is dependent on the semantics of the word or concept which is being negated, and on the context. Much confusion in English results from the uncontrolled variations in meaning of these phrases and prefixes.

In the examples of [Section 15.4](../section-nahe) , we will translate the general case of scalar negation using the general formula “other than” when a phrase is scalar-negated, and “non-” when a single word is scalar-negated.