<a id="section-ri-gohi-series"></a>7.6. <a id="c7s6"></a>Anaphoric pro-sumti and pro-bridi: the ri-series and the go'i-series
-----------------------------------------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ri</p></td><td class="selmaho"><p class="selmaho">KOhA</p></td><td class="cmavo-series"><p class="cmavo-series">ri-series</p></td><td class="description"><p class="description">(repeats last sumti)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ra</p></td><td class="selmaho"><p class="selmaho">KOhA</p></td><td class="cmavo-series"><p class="cmavo-series">ri-series</p></td><td class="description"><p class="description">(repeats previous sumti)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ru</p></td><td class="selmaho"><p class="selmaho">KOhA</p></td><td class="cmavo-series"><p class="cmavo-series">ri-series</p></td><td class="description"><p class="description">(repeats long-ago sumti)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">go'i</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats last bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">go'a</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats previous bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">go'u</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats long-ago bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">go'e</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats last-but-one bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">go'o</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats future bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">nei</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats current bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">no'a</p></td><td class="selmaho"><p class="selmaho">GOhA</p></td><td class="cmavo-series"><p class="cmavo-series">go'i-series</p></td><td class="description"><p class="description">(repeats outer bridi)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ra'o</p></td><td class="selmaho"><p class="selmaho">RAhO</p></td><td class="cmavo-series"><p class="cmavo-series"></p></td><td class="description"><p class="description">pro-cmavo update</p></td></tr></tbody></table>

The term “anaphora” literally means “repetition”, but is used in linguistics to refer to pronouns whose significance is the repetition of earlier words, namely their antecedents. Lojban provides three pro-sumti anaphora, _<a id="id-1.8.8.4.3.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_, _<a id="id-1.8.8.4.4.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_, and _<a id="id-1.8.8.4.5.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_; and three corresponding pro-bridi anaphora, _<a id="id-1.8.8.4.6.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_, _<a id="id-1.8.8.4.7.1" class="indexterm"></a>[_go'a_](../go01#valsi-goha)_, and _<a id="id-1.8.8.4.8.1" class="indexterm"></a>[_go'u_](../go01#valsi-gohu)_. These cmavo reveal the same vowel pattern as the ti-series, but the “distances” referred to are not physical distances, but distances from the anaphoric cmavo to its antecedent.

The cmavo _<a id="id-1.8.8.5.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ is the simplest of these; it has the same referent as the last complete sumti appearing before the _<a id="id-1.8.8.5.2.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3som"></a>

**Example 7.30. <a id="c7e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>sipna</td><td>ne'i</td><td>le</td><td></td><td>ri</td><td>kumfa</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>sleeps</td><td>in</td><td>the</td><td>of-</td><td>[repeat-last-sumti]</td><td>room.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice sleeps in her room.</p></td></tr></tbody></table>

</div>  

The _<a id="id-1.8.8.7.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ in [Example 7.30](../section-ri-gohi-series#example-random-id-3som) is equivalent to repeating the last sumti, which is _<a id="id-1.8.8.7.3.1" class="indexterm"></a>la .alis._, so [Example 7.30](../section-ri-gohi-series#example-random-id-3som) is equivalent to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-bs5R"></a>

**Example 7.31. <a id="c7e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>sipna</td><td>ne'i</td><td>le</td><td></td><td>la</td><td>.alis.</td><td>kumfa</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>sleeps</td><td>in</td><td>the</td><td>of-</td><td>that-named</td><td>Alice</td><td>room.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Alice sleeps in Alice's room.</p></td></tr></tbody></table>

</div>  

Note that _<a id="id-1.8.8.9.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ does not repeat _<a id="id-1.8.8.9.2.1" class="indexterm"></a>le ri kumfa_, because that sumti is not yet complete when _<a id="id-1.8.8.9.3.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ appears. This prevents _<a id="id-1.8.8.9.4.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ from getting entangled in paradoxes of self-reference. (There are plenty of other ways to do that!) Note also that sumti within other sumti, as in quotations, abstractions, and the like, are counted in the order of their beginnings; thus a lower level sumti like _<a id="id-1.8.8.9.5.1" class="indexterm"></a>la .alis._ in [Example 7.31](../section-ri-gohi-series#example-random-id-bs5R) is considered to be more recent than a higher level sumti that contains it.

Certain sumti are ignored by _<a id="id-1.8.8.10.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_; specifically, most of the other cmavo of KOhA, and the almost-grammatically-equivalent lerfu words of selma'o BY. It is simpler just to repeat these directly:

<div class="interlinear-gloss-example example">
<a id="example-random-id-CVmN"></a>

**Example 7.32. <a id="c7e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>prami</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>love</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I love myself.</p></td></tr></tbody></table>

</div>  

However, the cmavo of the ti-series can be picked up by _<a id="id-1.8.8.12.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_, because you might have changed what you are pointing at, so repeating _<a id="id-1.8.8.12.2.1" class="indexterm"></a>[_ti_](../go01#valsi-ti)_ may not be effective. Likewise, _<a id="id-1.8.8.12.3.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ itself (or rather its antecedent) can be repeated by a later _<a id="id-1.8.8.12.4.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_; in fact, a string of _<a id="id-1.8.8.12.5.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ cmavo with no other intervening sumti always all repeat the same sumti:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eXsN"></a>

**Example 7.33. <a id="c7e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>viska</td><td>le</td><td>tricu</td><td>.i</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>sees</td><td>the</td><td>tree.</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ri</td><td>se&nbsp;jadni</td><td>le</td><td></td><td>ri</td><td>jimca</td></tr><tr class="gloss"><td>[repeat-last]</td><td>is-adorned-by</td><td>the</td><td>of-</td><td>[repeat-last]</td><td>branch.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John sees the tree. It is adorned by its branches.</p></td></tr></tbody></table>

</div>  

Here the second _<a id="id-1.8.8.14.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ has as antecedent the first _<a id="id-1.8.8.14.2.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_, which has as antecedent _<a id="id-1.8.8.14.3.1" class="indexterm"></a>le tricu_. All three refer to the same thing: a tree.

To refer to the next-to-last sumti, the third-from-last sumti, and so on, _<a id="id-1.8.8.15.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ may be subscripted (subscripts are explained in [Section 19.6](../section-subscripts-general)):

<div class="interlinear-gloss-example example">
<a id="example-random-id-Lc2y"></a>

**Example 7.34. <a id="c7e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>smuci</td><td>.i</td><td>lo</td><td>forca</td><td>.i</td><td>la</td><td>.rik.</td><td>pilno</td><td>rixire</td></tr><tr class="gloss"><td>A</td><td>spoon.</td><td></td><td>A</td><td>fork.</td><td></td><td>That-named</td><td>Rick</td><td>uses</td><td>[repeat-next-to-last].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>la</td><td>.alis.</td><td>pilno</td><td>riximu</td></tr><tr class="gloss"><td></td><td>That-named</td><td>Alice</td><td>uses</td><td>[repeat-fifth-from-last].</td></tr></tbody></table>

</div>  

Here _<a id="id-1.8.8.17.1.1" class="indexterm"></a>rixire_, or “ri-sub-2”, skips _<a id="id-1.8.8.17.3.1" class="indexterm"></a>la .rik._ to reach _<a id="id-1.8.8.17.4.1" class="indexterm"></a>lo forca_. In the same way, _<a id="id-1.8.8.17.5.1" class="indexterm"></a>riximu_, or “ri-sub-5”, skips _<a id="id-1.8.8.17.7.1" class="indexterm"></a>la .alis._, _<a id="id-1.8.8.17.8.1" class="indexterm"></a>rixire_, _<a id="id-1.8.8.17.9.1" class="indexterm"></a>la .rik._, and _<a id="id-1.8.8.17.10.1" class="indexterm"></a>lo forca_ to reach _<a id="id-1.8.8.17.11.1" class="indexterm"></a>lo smuci_. As can clearly be seen, this procedure is barely practicable in writing, and would break down totally in speech.

Therefore, the vaguer _<a id="id-1.8.8.18.1.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ and _<a id="id-1.8.8.18.2.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ are also provided. The cmavo _<a id="id-1.8.8.18.3.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ repeats a recently used sumti, and _<a id="id-1.8.8.18.4.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ one that was further back in the speech or text. The use of _<a id="id-1.8.8.18.5.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ and _<a id="id-1.8.8.18.6.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ forces the listener to guess at the referent, but makes life easier for the speaker. Can _<a id="id-1.8.8.18.7.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ refer to the last sumti, like _<a id="id-1.8.8.18.8.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ ? The answer is no if _<a id="id-1.8.8.18.9.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ has also been used. If _<a id="id-1.8.8.18.10.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ has not been used, then _<a id="id-1.8.8.18.11.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ might be the last sumti. Likewise, if _<a id="id-1.8.8.18.12.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ has been used, then any use of _<a id="id-1.8.8.18.13.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ would repeat a sumti earlier than the one _<a id="id-1.8.8.18.14.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ is repeating. A more reasonable version of [Example 7.34](../section-ri-gohi-series#example-random-id-Lc2y), but one that depends more on context, is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-N89g"></a>

**Example 7.35. <a id="c7e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>smuci</td><td>.i</td><td>lo</td><td>forca</td><td>.i</td><td>la</td><td>.rik.</td><td>pilno</td><td>ra</td></tr><tr class="gloss"><td>A</td><td>spoon.</td><td></td><td>A</td><td>fork.</td><td></td><td>That-named</td><td>Rick</td><td>uses</td><td>[some-previous-thing].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>la</td><td>.alis.</td><td>pilno</td><td>ru</td></tr><tr class="gloss"><td></td><td>That-named</td><td>Alice</td><td>uses</td><td>[some-more-remote-thing].</td></tr></tbody></table>

</div>  

In [Example 7.35](../section-ri-gohi-series#example-random-id-N89g), the use of _<a id="id-1.8.8.20.2.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ tells us that something other than _<a id="id-1.8.8.20.3.1" class="indexterm"></a>la .rik._ is the antecedent; _<a id="id-1.8.8.20.4.1" class="indexterm"></a>lo forca_ is the nearest sumti, so it is probably the antecedent. Similarly, the antecedent of _<a id="id-1.8.8.20.5.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ must be something even further back in the utterance than _<a id="id-1.8.8.20.6.1" class="indexterm"></a>lo forca_, and _<a id="id-1.8.8.20.7.1" class="indexterm"></a>lo smuci_ is the obvious candidate.

The meaning of _<a id="id-1.8.8.21.1.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ must be determined every time it is used. Since _<a id="id-1.8.8.21.2.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_ and _<a id="id-1.8.8.21.3.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_ are more vaguely defined, they may well retain the same meaning for a while, but the listener cannot count on this behavior. To make a permanent reference to something repeated by _<a id="id-1.8.8.21.4.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_, _<a id="id-1.8.8.21.5.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_, or _<a id="id-1.8.8.21.6.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_, use _<a id="id-1.8.8.21.7.1" class="indexterm"></a>[_goi_](../go01#valsi-goi)_ and a ko'a-series cmavo:

<div class="interlinear-gloss-example example">
<a id="example-random-id-xIRG"></a>

**Example 7.36. <a id="c7e6d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.alis.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>That-named</td><td>Alice</td><td>goes-to</td><td>the</td><td>store</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ri</td><td>goi</td><td>ko'a</td><td>blanu</td></tr><tr class="gloss"><td>.</td><td>It-last-mentioned</td><td>also-known-as</td><td>it-1</td><td>is-blue.</td></tr></tbody></table>

</div>  

allows the store to be referred to henceforth as _<a id="id-1.8.8.23.1.1" class="indexterm"></a>[_ko'a_](../go01#valsi-koha)_ without ambiguity. [Example 7.36](../section-ri-gohi-series#example-random-id-xIRG) is equivalent to [Example 7.21](../section-koha-broda-series#example-random-id-qdCR) and eliminates any possibility of _<a id="id-1.8.8.23.4.1" class="indexterm"></a>[_ko'a_](../go01#valsi-koha)_ being interpreted by the listener as referring to Alice.

<a id="id-1.8.8.24.1" class="indexterm"></a><a id="id-1.8.8.24.2" class="indexterm"></a><a id="id-1.8.8.24.3" class="indexterm"></a><a id="id-1.8.8.24.4" class="indexterm"></a><a id="id-1.8.8.24.5" class="indexterm"></a><a id="id-1.8.8.24.6" class="indexterm"></a><a id="id-1.8.8.24.7" class="indexterm"></a><a id="id-1.8.8.24.8" class="indexterm"></a><a id="id-1.8.8.24.9" class="indexterm"></a><a id="id-1.8.8.24.10" class="indexterm"></a><a id="id-1.8.8.24.11" class="indexterm"></a><a id="id-1.8.8.24.12" class="indexterm"></a><a id="id-1.8.8.24.13" class="indexterm"></a>The cmavo _<a id="id-1.8.8.24.14.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_, _<a id="id-1.8.8.24.15.1" class="indexterm"></a>[_go'a_](../go01#valsi-goha)_, and _<a id="id-1.8.8.24.16.1" class="indexterm"></a>[_go'u_](../go01#valsi-gohu)_ follow exactly the same rules as _<a id="id-1.8.8.24.17.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_, _<a id="id-1.8.8.24.18.1" class="indexterm"></a>[_ra_](../go01#valsi-ra)_, and _<a id="id-1.8.8.24.19.1" class="indexterm"></a>[_ru_](../go01#valsi-ru)_, except that they are pro-bridi, and therefore repeat bridi, not sumti – specifically, main sentence bridi. Any bridi that are embedded within other bridi, such as relative clauses or abstractions, are not counted. Like the cmavo of the broda-series, the cmavo of the go'i-series copy all sumti with them. This makes _<a id="id-1.8.8.24.20.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ by itself convenient for answering a question affirmatively, or for repeating the last bridi, possibly with new sumti:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLN4"></a>

**Example 7.37. <a id="c7e6d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>zo</td><td>.djan.</td><td>cmene</td><td>do</td><td>.i</td><td>go'i</td></tr><tr class="gloss"><td>[True-false?]</td><td>The-word</td><td><span class="quote">“<span class="quote">John</span>”</span></td><td>is-the-name-of</td><td>you?</td><td>&nbsp;</td><td>[repeat&nbsp;last&nbsp;bridi].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Is John your name? Yes.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLn5"></a>

**Example 7.38. <a id="c7e6d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>.i</td><td>do</td><td>go'i</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>store</td><td>.</td><td>You</td><td>[repeat&nbsp;last&nbsp;bridi].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I go to the store . You, too.</p></td></tr></tbody></table>

</div>  

<a id="id-1.8.8.27.1" class="indexterm"></a><a id="id-1.8.8.27.2" class="indexterm"></a>Note that [Example 7.38](../section-ri-gohi-series#example-random-id-qLn5) means the same as [Example 7.26](../section-koha-broda-series#example-random-id-UFJf), but without the bother of assigning an actual broda-series word to the first bridi. For long-term reference, use _<a id="id-1.8.8.27.5.1" class="indexterm"></a>go'i cei broda_ or the like, analogously to _<a id="id-1.8.8.27.6.1" class="indexterm"></a>ri goi ko'a_ in [Example 7.36](../section-ri-gohi-series#example-random-id-xIRG).

The remaining four cmavo of the go'i-series are provided for convenience or for achieving special effects. The cmavo _<a id="id-1.8.8.28.1.1" class="indexterm"></a>[_go'e_](../go01#valsi-gohe)_ means the same as _<a id="id-1.8.8.28.2.1" class="indexterm"></a>go'ixire_: it repeats the last bridi but one. This is useful in conversation:

<div class="interlinear-gloss-example example">
<a id="example-random-id-9hf5"></a>

**Example 7.39. <a id="c7e6d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>A:</td><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>A:</td><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A: I am going to the store.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>B:</td><td>mi</td><td>nelci</td><td>le</td><td>si'o</td><td>mi</td><td>go'i</td></tr><tr class="gloss"><td>B:</td><td>I</td><td>like</td><td>the</td><td>concept-of</td><td>I</td><td>[repeat-last-bridi].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">B: I like the idea of my going.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>A:</td><td>do</td><td>go'e</td></tr><tr class="gloss"><td>A:</td><td>You</td><td>[repeat-last-bridi-but-one].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A: You'll go, too.</p></td></tr></tbody></table>

</div>  

Here B's sentence repeats A's within an abstraction (explained in [Chapter 11](../chapter-abstractions)): _<a id="id-1.8.8.30.2.1" class="indexterm"></a>le si'o mi go'i_ means _<a id="id-1.8.8.30.3.1" class="indexterm"></a>le si'o mi klama le zarci_. Why must B use the word _<a id="id-1.8.8.30.4.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ explicitly to replace the x1 of _<a id="id-1.8.8.30.6.1" class="indexterm"></a>mi klama le zarci_, even though it looks like _<a id="id-1.8.8.30.7.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ is replacing _<a id="id-1.8.8.30.8.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ ? Because B's _<a id="id-1.8.8.30.9.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ refers to B, whereas A's _<a id="id-1.8.8.30.10.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ refers to A. If B said:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2uS7"></a>

**Example 7.40. <a id="c7e6d11"></a>** 

<a id="id-1.8.8.31.2.1" class="indexterm"></a>mi nelci le si'o go'i

</div>  

that would mean:

> I like the idea of your going to the store.

The repetition signalled by _<a id="id-1.8.8.34.1.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ is not literally of words, but of concepts. Finally, A repeats her own sentence, but with the x1 changed to _<a id="id-1.8.8.34.3.1" class="indexterm"></a>[_do_](../go01#valsi-do)_, meaning B. Note that in [Example 7.39](../section-ri-gohi-series#example-random-id-9hf5), the tense _<a id="id-1.8.8.34.5.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ (future time) is carried along by both _<a id="id-1.8.8.34.6.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ and _<a id="id-1.8.8.34.7.1" class="indexterm"></a>[_go'e_](../go01#valsi-gohe)_.

Descriptions based on go'i-series cmavo can be very useful for repeating specific sumti of previous bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hwau"></a>

**Example 7.41. <a id="c7e6d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>xekri</td><td>mlatu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td><td>.i</td><td>le</td></tr><tr class="gloss"><td>The</td><td>black</td><td>cat</td><td></td><td>goes-to</td><td>the</td><td>store.</td><td></td><td>That-described-as-the-x<sub>1</sub>-place-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go'i</td><td>cu</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>[repeat-last-bridi]</td><td></td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The black cat goes to the store. It walks on the ice.</p></td></tr></tbody></table>

</div>  

Here the _<a id="id-1.8.8.37.1.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ repeats _<a id="id-1.8.8.37.2.1" class="indexterm"></a>le xekri mlatu cu klama le zarci_, and since _<a id="id-1.8.8.37.3.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ makes the x1 place into a description, and the x1 place of this bridi is _<a id="id-1.8.8.37.6.1" class="indexterm"></a>le xekri mlatu_, _<a id="id-1.8.8.37.7.1" class="indexterm"></a>le go'i_ means _<a id="id-1.8.8.37.8.1" class="indexterm"></a>le xekri mlatu_.

The cmavo _<a id="id-1.8.8.38.1.1" class="indexterm"></a>[_go'o_](../go01#valsi-goho)_, _<a id="id-1.8.8.38.2.1" class="indexterm"></a>[_nei_](../go01#valsi-nei)_, and _<a id="id-1.8.8.38.3.1" class="indexterm"></a>[_no'a_](../go01#valsi-noha)_ have been little used so far. They repeat respectively some future bridi, the current bridi, and the bridi that encloses the current bridi (_<a id="id-1.8.8.38.4.1" class="indexterm"></a>[_no'a_](../go01#valsi-noha)_, unlike the other members of the go'i- series, can repeat non-sentence bridi). Here are a few examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-EUmV"></a>

**Example 7.42. <a id="c7e6d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nupre</td><td>le</td><td>nu</td><td>mi</td><td>go'o</td></tr><tr class="gloss"><td>I</td><td>promise</td><td>the</td><td>event-of</td><td>I</td><td>[repeat-future-bridi].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ba</td><td>dunda</td><td>le</td><td>jdini</td><td></td><td>le</td><td>bersa</td></tr><tr class="gloss"><td></td><td>[Future]</td><td>give</td><td>the</td><td>money</td><td>to</td><td>the</td><td>son</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ba</td><td>dunda</td><td>le</td><td>zdani</td><td></td><td>le</td><td>tixnu</td></tr><tr class="gloss"><td></td><td>[Future]</td><td>give</td><td>the</td><td>house</td><td>to</td><td>the</td><td>daughter</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I promise to do the following: Give the money to my son. Give the house to my daughter.</p></td></tr></tbody></table>

</div>  

(Note: The Lojban does not contain an equivalent of the “my” in the colloquial English; it leaves the fact that it is the speaker's son and daughter that are referred to implicit. To make the fact explicit, use _<a id="id-1.8.8.40.2.1" class="indexterm"></a>le bersa_ / _<a id="id-1.8.8.40.3.1" class="indexterm"></a>tixnu be mi_.)

For good examples of _<a id="id-1.8.8.41.1.1" class="indexterm"></a>[_nei_](../go01#valsi-nei)_ and _<a id="id-1.8.8.41.2.1" class="indexterm"></a>[_no'a_](../go01#valsi-noha)_, we need nested bridi contexts:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLo1"></a>

**Example 7.43. <a id="c7e6d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>se</td><td>pluka</td><td>le</td><td>nu</td><td>do</td><td>pensi</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>I</td><td></td><td>am-pleased-by</td><td>the</td><td>event-of</td><td>(you</td><td>think-about</td><td>the</td><td>(event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nei</td><td>kei</td><td>pu</td><td>le</td><td>nu</td><td>do</td><td>zukte</td></tr><tr class="gloss"><td>[main-bridi]</td><td>)</td><td>before</td><td>the</td><td>(event-of</td><td>your</td><td>acting).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am pleased that you thought about whether I would be pleased (about ...) before you acted.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLop"></a>

**Example 7.44. <a id="c7e6d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>klama</td><td>ca</td><td>le</td><td>nu</td><td>do</td><td>no'a</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>go</td><td>[present]</td><td>the</td><td>event-of</td><td>you</td><td>[repeats&nbsp;outer&nbsp;bridi]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will go when you do.</p></td></tr></tbody></table>

</div>  

<a id="id-1.8.8.44.1" class="indexterm"></a>Finally, _<a id="id-1.8.8.44.2.1" class="indexterm"></a>[_ra'o_](../go01#valsi-raho)_ is a cmavo that can be appended to any go'i-series cmavo, or indeed any cmavo of selma'o GOhA, to signal that pro-sumti or pro-bridi cmavo in the antecedent are to be repeated literally and reinterpreted in their new context. Normally, any pro-sumti used within the antecedent of the pro-bridi keep their meanings intact. In the presence of _<a id="id-1.8.8.44.3.1" class="indexterm"></a>[_ra'o_](../go01#valsi-raho)_, however, their meanings must be reinterpreted with reference to the new environment. If someone says to you:

<div class="interlinear-gloss-example example">
<a id="example-random-id-9Uq6"></a>

**Example 7.45. <a id="c7e6d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi ba lumci le mi karce</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will wash my car.</p></td></tr></tbody></table>

</div>  

you might reply either:

<div class="interlinear-gloss-example example">
<a id="example-random-id-1fK3"></a>

**Example 7.46. <a id="c7e6d17"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi go'i</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will wash your car.</p></td></tr></tbody></table>

</div>  

or:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qW1B"></a>

**Example 7.47. <a id="c7e6d18"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi go'i ra'o</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will wash my car.</p></td></tr></tbody></table>

</div>  

The _<a id="id-1.8.8.50.1.1" class="indexterm"></a>[_ra'o_](../go01#valsi-raho)_ forces the second _<a id="id-1.8.8.50.2.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ from the original bridi to mean the new speaker rather than the former speaker. This means that _<a id="id-1.8.8.50.3.1" class="indexterm"></a>mi nelci le si'o go'i ra'o_ would be an acceptable alternative to _<a id="id-1.8.8.50.4.1" class="indexterm"></a>mi nelci le si'o mi go'i_ in B's statement in [Example 7.39](../section-ri-gohi-series#example-random-id-9hf5).

<a id="id-1.8.8.51.1" class="indexterm"></a><a id="id-1.8.8.51.2" class="indexterm"></a>The anaphoric pro-sumti of this section can be used in quotations, but never refer to any of the supporting text outside the quotation, since speakers presumably do not know that they may be quoted by someone else.

<a id="id-1.8.8.52.1" class="indexterm"></a><a id="id-1.8.8.52.2" class="indexterm"></a>However, a _<a id="id-1.8.8.52.3.1" class="indexterm"></a>ri-_ series or _<a id="id-1.8.8.52.4.1" class="indexterm"></a>go'a-_ series reference within a quotation can refer to something mentioned in an earlier quotation if the two quotations are closely related in time and context. This allows a quotation to be broken up by narrative material without interfering with the pro-sumti within it. Here's an example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-LWyE"></a>

**Example 7.48. <a id="c7e6d19"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cusku</td><td>lu</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>li'u</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>says</td><td>[quote]</td><td>I</td><td>go-to</td><td>the</td><td>store</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>la</td><td>.alis.</td><td>cusku</td><td>lu</td><td>mi</td><td>go'i</td><td>li'u</td></tr><tr class="gloss"><td></td><td>That-named</td><td>Alice</td><td>says</td><td>[quote]</td><td>I</td><td>[repeat]</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John says, <span class="quote">“<span class="quote">I am going to the store.</span>”</span> Alice says, <span class="quote">“<span class="quote">Me too.</span>”</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.8.8.54.1" class="indexterm"></a><a id="id-1.8.8.54.2" class="indexterm"></a>Of course, there is no problem with narrative material referring to something within a quotation: people who quote, unlike people who are quoted, are aware of what they are doing.