<a id="section-restricted-claims"></a>16.4. <a id="c16s4"></a>Restricted claims: _da poi_
-----------------------------------------------------------------------------------------

<a id="id-1.17.6.2.1" class="indexterm"></a><a id="id-1.17.6.2.2" class="indexterm"></a>The universal claims of [Section 16.3](../section-universal-claims) are not only false but absurd: there is really very little to be said that is both true and non-trivial about every object whatsoever. Furthermore, we have been glossing over the distinction between “everything” and “everybody” and the other pairs ending in “\-thing” and “\-body”. It is time to bring up the most useful feature of Lojban variables: the ability to restrict their ranges.

<a id="id-1.17.6.3.1" class="indexterm"></a><a id="id-1.17.6.3.2" class="indexterm"></a>In Lojban, a variable _<a id="id-1.17.6.3.3.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ , _<a id="id-1.17.6.3.4.1" class="indexterm"></a>[_de_](../go01#valsi-de)_ , or _<a id="id-1.17.6.3.5.1" class="indexterm"></a>[_di_](../go01#valsi-di)_ may be followed by a _<a id="id-1.17.6.3.6.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ relative clause in order to restrict the range of things that the variable describes. Relative clauses are described in detail in [Chapter 8](../chapter-relative-clauses) , but the kind we will need at present consist of _<a id="id-1.17.6.3.8.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ followed by a bridi (often just a selbri) terminated with _<a id="id-1.17.6.3.9.1" class="indexterm"></a>[_ku'o_](../go01#valsi-kuho)_ or _<a id="id-1.17.6.3.10.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ (which can usually be elided). Consider the difference between

<div class="interlinear-gloss-example example">
<a id="example-random-id-NPX7"></a>

**Example 16.20. <a id="c16e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>zo'u</td><td>da</td><td>viska</td><td>la</td><td>.djim.</td></tr><tr class="gloss"><td>There-is-an-X</td><td>:</td><td>X</td><td>sees</td><td>that-named</td><td>Jim.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Something sees Jim.</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-I8AF"></a>

**Example 16.21. <a id="c16e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>poi</td><td>prenu</td><td>zo'u</td><td>da</td><td>viska</td><td>la</td><td>.djim.</td></tr><tr class="gloss"><td>There-is-an-X</td><td>which</td><td>is-a-person</td><td>:</td><td>X</td><td>sees</td><td>that-named</td><td>Jim.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Someone sees Jim.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.6.7.1" class="indexterm"></a>In [Example 16.20](../section-restricted-claims#example-random-id-NPX7) , the variable _<a id="id-1.17.6.7.3.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ can refer to any object whatever; there are no restrictions on it. In [Example 16.21](../section-restricted-claims#example-random-id-I8AF) , _<a id="id-1.17.6.7.5.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ is restricted by the _<a id="id-1.17.6.7.6.1" class="indexterm"></a>poi prenu_ relative clause to persons only, and so _<a id="id-1.17.6.7.7.1" class="indexterm"></a>da poi prenu_ translates as “someone.” (The difference between “someone” and “somebody” is a matter of English style, with no real counterpart in Lojban.) If [Example 16.21](../section-restricted-claims#example-random-id-I8AF) is true, then [Example 16.20](../section-restricted-claims#example-random-id-NPX7) must be true, but not necessarily vice versa.

<a id="id-1.17.6.8.1" class="indexterm"></a><a id="id-1.17.6.8.2" class="indexterm"></a>Universal claims benefit even more from the existence of relative clauses. Consider

<div class="interlinear-gloss-example example">
<a id="example-random-id-DFen"></a>

**Example 16.22. <a id="c16e4d3"></a><a id="id-1.17.6.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>zo'u</td><td>da</td><td>vasxu</td></tr><tr class="gloss"><td>For-every</td><td>X</td><td>:</td><td>X</td><td>breathes</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Everything breathes</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-njh0"></a>

**Example 16.23. <a id="c16e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>poi</td><td>gerku</td><td>zo'u</td><td>da</td><td>vasxu</td></tr><tr class="gloss"><td>For-every</td><td>X</td><td>which</td><td>is-a-dog</td><td>:</td><td>X</td><td>breathes.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Every dog breathes.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Each dog breathes.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">All dogs breathe.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.6.12.1" class="indexterm"></a>[Example 16.22](../section-restricted-claims#example-random-id-DFen) is a silly falsehood, but [Example 16.23](../section-restricted-claims#example-random-id-njh0) is an important truth (at least if applied in a timeless or potential sense: see [Section 10.19](../section-caha)). Note the various colloquial translations “every dog” , “each dog” , and “all dogs”. They all come to the same thing in Lojban, since what is true of every dog is true of all dogs. “All dogs” is treated as an English plural and the others as singular, but Lojban makes no distinction.

If we make an existential claim about dogs rather than a universal one, we get:

<div class="interlinear-gloss-example example">
<a id="example-random-id-4BTd"></a>

**Example 16.24. <a id="c16e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>poi</td><td>gerku</td><td>zo'u</td><td>da</td><td>vasxu</td></tr><tr class="gloss"><td>There-is-an-X</td><td>which</td><td>is-a-dog</td><td>:</td><td>X</td><td>breathes.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some dog breathes.</p></td></tr></tbody></table>

</div>