<a id="section-relative-phrases"></a>8.3. <a id="c8s3"></a>Relative phrases
---------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pe</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">restrictive association</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">po</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">restrictive possession</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">po'e</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">restrictive intrinsic possession</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">po'u</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">restrictive identification</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ne</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">incidental association</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">no'u</p></td><td class="selmaho"><p class="selmaho">GOI</p></td><td class="description"><p class="description">incidental identification</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ge'u</p></td><td class="selmaho"><p class="selmaho">GEhU</p></td><td class="description"><p class="description">relative phrase terminator</p></td></tr></tbody></table>

<a id="id-1.9.5.4.1" class="indexterm"></a><a id="id-1.9.5.4.2" class="indexterm"></a><a id="id-1.9.5.4.3" class="indexterm"></a>There are types of relative clauses (those which have a certain selbri) which are frequently wanted in Lojban, and can be expressed using a shortcut called a relative phrase. Relative phrases are introduced by cmavo of selma'o GOI, and consist of a GOI cmavo followed by a single sumti.

<a id="id-1.9.5.5.1" class="indexterm"></a><a id="id-1.9.5.5.2" class="indexterm"></a><a id="id-1.9.5.5.3" class="indexterm"></a>Here is an example of _<a id="id-1.9.5.5.4.1" class="indexterm"></a>[_pe_](../go01#valsi-pe)_ , plus an equivalent sentence using a relative clause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qM04"></a>

**Example 8.18. <a id="c8e3d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>pe</td><td>mi</td><td>cu</td><td>blanu</td></tr><tr class="gloss"><td>The</td><td>chair</td><td>associated-with</td><td>me</td><td>&nbsp;</td><td>is-blue.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My chair is blue.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qM1W"></a>

**Example 8.19. <a id="c8e3d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>poi</td><td>ke'a</td><td>srana</td><td>mi</td><td>cu</td><td>blanu</td></tr><tr class="gloss"><td>The</td><td>chair</td><td>such-that-(</td><td>IT</td><td>is-associated-with</td><td>me</td><td>)</td><td>is-blue.</td></tr></tbody></table>

</div>  

In [Example 8.18](../section-relative-phrases#example-random-id-qM04) and [Example 8.19](../section-relative-phrases#example-random-id-qM1W) , the link between the chair and the speaker is of the loosest kind.

<a id="id-1.9.5.9.1" class="indexterm"></a><a id="id-1.9.5.9.2" class="indexterm"></a><a id="id-1.9.5.9.3" class="indexterm"></a><a id="id-1.9.5.9.4" class="indexterm"></a>Here is an example of _<a id="id-1.9.5.9.5.1" class="indexterm"></a>[_po_](../go01#valsi-po)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qM3D"></a>

**Example 8.20. <a id="c8e3d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>po</td><td>mi</td><td>cu</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td>specific-to</td><td>me</td><td>&nbsp;</td><td>is-red.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qm3I"></a>

**Example 8.21. <a id="c8e3d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>stizu</td><td>poi</td><td>ke'a</td><td>se&nbsp;steci</td><td>srana</td><td>mi</td><td>cu</td><td>xunre</td></tr><tr class="gloss"><td>The</td><td>chair</td><td>such-that-(</td><td>IT</td><td>is-specifically</td><td>associated-with</td><td>me</td><td>)</td><td>is-red.</td></tr></tbody></table>

</div>  

<a id="id-1.9.5.12.1" class="indexterm"></a><a id="id-1.9.5.12.2" class="indexterm"></a>[Example 8.20](../section-relative-phrases#example-random-id-qM3D) and [Example 8.21](../section-relative-phrases#example-random-id-qm3I) contrast with [Example 8.18](../section-relative-phrases#example-random-id-qM04) and [Example 8.19](../section-relative-phrases#example-random-id-qM1W) : the chair is more permanently connected with the speaker. A plausible (though not the only possible) contrast between [Example 8.18](../section-relative-phrases#example-random-id-qM04) and [Example 8.20](../section-relative-phrases#example-random-id-qM3D) is that _<a id="id-1.9.5.12.9.1" class="indexterm"></a>pe mi_ would be appropriate for a chair the speaker is currently sitting on (whether or not the speaker owned that chair), and _<a id="id-1.9.5.12.10.1" class="indexterm"></a>po mi_ for a chair owned by the speaker (whether or not he or she was currently occupying it).

<a id="id-1.9.5.13.1" class="indexterm"></a>As a result, the relationship expressed between two sumti by _<a id="id-1.9.5.13.2.1" class="indexterm"></a>[_po_](../go01#valsi-po)_ is usually called “possession” , although it does not necessarily imply ownership, legal or otherwise. The central concept is that of specificity ( _<a id="id-1.9.5.13.4.1" class="indexterm"></a>[_steci_](../go01#valsi-steci)_ in Lojban).

<a id="id-1.9.5.14.1" class="indexterm"></a><a id="id-1.9.5.14.2" class="indexterm"></a><a id="id-1.9.5.14.3" class="indexterm"></a><a id="id-1.9.5.14.4" class="indexterm"></a><a id="id-1.9.5.14.5" class="indexterm"></a>Here is an example of _<a id="id-1.9.5.14.6.1" class="indexterm"></a>[_po'e_](../go01#valsi-pohe)_ , as well as another example of _<a id="id-1.9.5.14.7.1" class="indexterm"></a>[_po_](../go01#valsi-po)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qM3Q"></a>

**Example 8.22. <a id="c8e3d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>birka</td><td>po'e</td><td>mi</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>The</td><td>arm</td><td>intrinsically-possessed-by</td><td>me</td><td>&nbsp;</td><td>is-broken</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qm5E"></a>

**Example 8.23. <a id="id-1.9.5.16.1.1" class="indexterm"></a><a id="c8e3d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>birka</td><td>poi</td><td>jinzi</td><td>ke</td><td>se&nbsp;steci</td></tr><tr class="gloss"><td>The</td><td>arm</td><td>which</td><td>is-intrinsically</td><td>(</td><td>specifically</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>srana</td><td>mi</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>associated-with)</td><td>me</td><td>&nbsp;</td><td>is-broken.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qm7W"></a>

**Example 8.24. <a id="c8e3d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>botpi</td><td>po</td><td>mi</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>The</td><td>bottle</td><td>specific-to</td><td>me</td><td>&nbsp;</td><td>is-broken</td></tr></tbody></table>

</div>  

<a id="id-1.9.5.18.1" class="indexterm"></a><a id="id-1.9.5.18.2" class="indexterm"></a><a id="id-1.9.5.18.3" class="indexterm"></a><a id="id-1.9.5.18.4" class="indexterm"></a><a id="id-1.9.5.18.5" class="indexterm"></a><a id="id-1.9.5.18.6" class="indexterm"></a>[Example 8.22](../section-relative-phrases#example-random-id-qM3Q) and [Example 8.23](../section-relative-phrases#example-random-id-qm5E) on the one hand, and [Example 8.24](../section-relative-phrases#example-random-id-qm7W) on the other, illustrate the contrast between two types of possession called “intrinsic” and “extrinsic” , or sometimes “inalienable” and “alienable” , respectively. Something is intrinsically (or inalienably) possessed by someone if the possession is part of the possessor, and cannot be changed without changing the possessor. In the case of [Example 8.22](../section-relative-phrases#example-random-id-qM3Q) , people are usually taken to intrinsically possess their arms: even if an arm is cut off, it remains the arm of that person. (If the arm is transplanted to another person, however, it becomes intrinsically possessed by the new user, though, so intrinsic possession is a matter of degree.)

<a id="id-1.9.5.19.1" class="indexterm"></a>By contrast, the bottle of [Example 8.24](../section-relative-phrases#example-random-id-qm7W) can be given away, or thrown away, or lost, or stolen, so it is possessed extrinsically (alienably). The exact line between intrinsic and extrinsic possession is culturally dependent. The U.S. Declaration of Independence speaks of the “inalienable rights” of men, but just what those rights are, and even whether the concept makes sense at all, varies from culture to culture.

Note that [Example 8.22](../section-relative-phrases#example-random-id-qM3Q) can also be expressed without a relative clause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-bF0U"></a>

**Example 8.25. <a id="c8e3d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>birka</td><td>be</td><td>mi</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>The</td><td>arm</td><td>of-body</td><td>me</td><td>&nbsp;</td><td>is-broken</td></tr></tbody></table>

</div>  

<a id="id-1.9.5.22.1" class="indexterm"></a>reflecting the fact that the gismu _<a id="id-1.9.5.22.2.1" class="indexterm"></a>[_birka_](../go01#valsi-birka)_ has an x2 place representing the body to which the arm belongs. Many, but not all, cases of intrinsic possession can be thus covered without using _<a id="id-1.9.5.22.4.1" class="indexterm"></a>[_po'e_](../go01#valsi-pohe)_ by placing the possessor into the appropriate place of the description selbri.

Here is an example of _<a id="id-1.9.5.23.1.1" class="indexterm"></a>[_po'u_](../go01#valsi-pohu)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qM8u"></a>

**Example 8.26. <a id="c8e3d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>po'u</td><td>le</td><td>mi</td><td>pendo</td><td>cu</td><td>cinba</td><td>mi</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>which-is</td><td>&nbsp;</td><td>my</td><td>friend</td><td>&nbsp;</td><td>kisses</td><td>me.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qm90"></a>

**Example 8.27. <a id="c8e3d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>poi</td><td>du</td><td>le</td><td>mi</td><td>pendo</td><td>cu</td><td>cinba</td><td>mi</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>which</td><td>=</td><td>&nbsp;</td><td>my</td><td>friend</td><td>&nbsp;</td><td>kisses</td><td>me.</td></tr></tbody></table>

</div>  

<a id="id-1.9.5.26.1" class="indexterm"></a><a id="id-1.9.5.26.2" class="indexterm"></a><a id="id-1.9.5.26.3" class="indexterm"></a>The cmavo _<a id="id-1.9.5.26.4.1" class="indexterm"></a>[_po'u_](../go01#valsi-pohu)_ does not represent possession at all, but rather identity. (Note that it means _<a id="id-1.9.5.26.5.1" class="indexterm"></a>poi du_ and its form was chosen to suggest the relationship.)

In [Example 8.26](../section-relative-phrases#example-random-id-qM8u) , the use of _<a id="id-1.9.5.27.2.1" class="indexterm"></a>[_po'u_](../go01#valsi-pohu)_ tells us that _<a id="id-1.9.5.27.3.1" class="indexterm"></a>le gerku_ and _<a id="id-1.9.5.27.4.1" class="indexterm"></a>le mi pendo_ represent the same thing. Consider the contrast between [Example 8.26](../section-relative-phrases#example-random-id-qM8u) and:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wARJ"></a>

**Example 8.28. <a id="c8e3d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>mi</td><td>pendo</td><td>po'u</td><td>le</td><td>gerku</td><td>cu</td><td>cinba</td><td>mi</td></tr><tr class="gloss"><td>&nbsp;</td><td>My</td><td>friend</td><td>which-is</td><td>the</td><td>dog</td><td>&nbsp;</td><td>kisses</td><td>me.</td></tr></tbody></table>

</div>  

<a id="id-1.9.5.29.1" class="indexterm"></a>The facts of the case are the same, but the listener's knowledge about the situation may not be. In [Example 8.26](../section-relative-phrases#example-random-id-qM8u) , the listener is presumed not to understand which dog is meant by _<a id="id-1.9.5.29.3.1" class="indexterm"></a>le gerku_ , so the speaker adds a relative phrase clarifying that it is the particular dog which is the speaker's friend.

[Example 8.28](../section-relative-phrases#example-random-id-wARJ) , however, assumes that the listener does not know which of the speaker's friends is referred to, and specifies that it is the friend that is the dog (which dog is taken to be obvious). Here is another example of the same contrast:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMAd"></a>

**Example 8.29. <a id="id-1.9.5.31.1.1" class="indexterm"></a><a id="c8e3d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>tcadu</td><td>po'u</td><td>la&nbsp;nu,iork</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The city of New--York [not another city]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmaY"></a>

**Example 8.30. <a id="id-1.9.5.32.1.1" class="indexterm"></a><a id="id-1.9.5.32.1.2" class="indexterm"></a><a id="c8e3d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;nu,iork</td><td>po'u</td><td>le</td><td>tcadu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">New--York -- the city (not the state or some other New York)</p></td></tr></tbody></table>

</div>  

<a id="id-1.9.5.33.1" class="indexterm"></a><a id="id-1.9.5.33.2" class="indexterm"></a>The principle that the possessor and the possessed may change places applies to all the GOI cmavo, and allows for the possibility of odd effects:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMb2"></a>

**Example 8.31. <a id="c8e3d14"></a><a id="id-1.9.5.34.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>kabri</td><td>pe</td><td>le</td><td>mi</td><td>pendo</td><td>cu</td><td>cmalu</td></tr><tr class="gloss"><td>The</td><td>cup</td><td>associated-with</td><td>&nbsp;</td><td>my</td><td>friend</td><td>&nbsp;</td><td>is-small.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My friend's cup is small</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmbn"></a>

**Example 8.32. <a id="c8e3d15"></a><a id="id-1.9.5.35.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>mi</td><td>pendo</td><td>pe</td><td>le</td><td>kabri</td><td>cu</td><td>cmalu</td></tr><tr class="gloss"><td>&nbsp;</td><td>My</td><td>friend</td><td>associated-with</td><td>the</td><td>cup</td><td>&nbsp;</td><td>is-small.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My friend, the one with the cup, is small.</p></td></tr></tbody></table>

</div>  

[Example 8.31](../section-relative-phrases#example-random-id-qMb2) is useful in a context which is about my friend, and states that his or her cup is small, whereas [Example 8.32](../section-relative-phrases#example-random-id-qmbn) is useful in a context that is primarily about a certain cup, and makes a claim about “my friend of the cup” , as opposed to some other friend of mine. Here the cup appears to “possess” the person! English can't even express this relationship with a possessive – “the cup's friend of mine” looks like nonsense – but Lojban has no trouble doing so.

<a id="id-1.9.5.37.1" class="indexterm"></a><a id="id-1.9.5.37.2" class="indexterm"></a><a id="id-1.9.5.37.3" class="indexterm"></a><a id="id-1.9.5.37.4" class="indexterm"></a><a id="id-1.9.5.37.5" class="indexterm"></a><a id="id-1.9.5.37.6" class="indexterm"></a>Finally, the cmavo _<a id="id-1.9.5.37.7.1" class="indexterm"></a>[_ne_](../go01#valsi-ne)_ and _<a id="id-1.9.5.37.8.1" class="indexterm"></a>[_no'u_](../go01#valsi-nohu)_ stand to _<a id="id-1.9.5.37.9.1" class="indexterm"></a>[_pe_](../go01#valsi-pe)_ and _<a id="id-1.9.5.37.10.1" class="indexterm"></a>[_po'u_](../go01#valsi-pohu)_ , respectively, as _<a id="id-1.9.5.37.11.1" class="indexterm"></a>[_noi_](../go01#valsi-noi)_ does to _<a id="id-1.9.5.37.12.1" class="indexterm"></a>poi-_ they provide incidental information:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Arj8"></a>

**Example 8.33. <a id="c8e3d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>blabi</td><td>gerku</td><td>ne</td><td>mi</td><td>cu</td><td>batci</td><td>do</td></tr><tr class="gloss"><td>The</td><td>white</td><td>dog,</td><td>incidentally-associated-with</td><td>me</td><td>,</td><td>bites</td><td>you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The white dog, which is mine, bites you.</p></td></tr></tbody></table>

</div>  

In [Example 8.33](../section-relative-phrases#example-random-id-Arj8) , the white dog is already fully identified (after all, presumably the listener knows which dog bit him or her!). The fact that it is yours is merely incidental to the main bridi claim.

<a id="id-1.9.5.40.1" class="indexterm"></a><a id="id-1.9.5.40.2" class="indexterm"></a>Distinguishing between _<a id="id-1.9.5.40.3.1" class="indexterm"></a>[_po'u_](../go01#valsi-pohu)_ and _<a id="id-1.9.5.40.4.1" class="indexterm"></a>[_no'u_](../go01#valsi-nohu)_ can be a little tricky. Consider a room with several men in it, one of whom is named Jim. If you don't know their names, I might say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-DSf4"></a>

**Example 8.34. <a id="c8e3d17"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>no'u</td><td>la</td><td>.djim.</td><td>cu</td><td>terpemci</td></tr><tr class="gloss"><td>The</td><td>man,</td><td>incidentally-who-is</td><td>that-named</td><td>Jim</td><td>,</td><td>is-a-poet.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man, Jim, is a poet.</p></td></tr></tbody></table>

</div>  

Here I am saying that one of the men is a poet, and incidentally telling you that he is Jim. But if you do know the names, then

<div class="interlinear-gloss-example example">
<a id="example-random-id-y8nH"></a>

**Example 8.35. <a id="c8e3d18"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>po'u</td><td>la</td><td>.djim.</td><td>cu</td><td>terpemci</td></tr><tr class="gloss"><td>The</td><td>man</td><td>who-is</td><td>that-named</td><td>Jim</td><td>&nbsp;</td><td>is-a-poet.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man Jim is a poet.</p></td></tr></tbody></table>

</div>  

is appropriate. Now I am using the fact that the man I am speaking of is Jim in order to pick out which man I mean.

<a id="id-1.9.5.45.1" class="indexterm"></a><a id="id-1.9.5.45.2" class="indexterm"></a>It is worth mentioning that English sometimes over-specifies possession from the Lojban point of view (and the point of view of many other languages, including ones closely related to English). The idiomatic English sentence

<div class="example">
<a id="example-random-id-GXyS"></a>

**Example 8.36. <a id="c8e3d19"></a>** 

The man put his hands in his pockets.

</div>  

seems strange to a French- or German-speaking person: whose pockets would he put his hands into? and even odder, whose hands would he put into his pockets? In Lojban, the sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-V4R1"></a>

**Example 8.37. <a id="id-1.9.5.48.1.1" class="indexterm"></a><a id="c8e3d20"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>punji</td><td>le</td><td>xance</td><td></td><td>le</td><td>daski</td></tr><tr class="gloss"><td>The</td><td>man</td><td>&nbsp;</td><td>puts</td><td>the</td><td>hand</td><td>at-locus</td><td>the</td><td>pocket.</td></tr></tbody></table>

</div>  

is very natural. Of course, if the man is in fact putting his hands into another's pockets, or another's hands into his pockets, the fact can be specified.

<a id="id-1.9.5.50.1" class="indexterm"></a><a id="id-1.9.5.50.2" class="indexterm"></a><a id="id-1.9.5.50.3" class="indexterm"></a><a id="id-1.9.5.50.4" class="indexterm"></a>Finally, the elidable terminator for GOI cmavo is _<a id="id-1.9.5.50.5.1" class="indexterm"></a>[_ge'u_](../go01#valsi-gehu)_ of selma'o GEhU; it is almost never required. However, if a logical connective immediately follows a sumti modified by a relative phrase, then an explicit _<a id="id-1.9.5.50.6.1" class="indexterm"></a>[_ge'u_](../go01#valsi-gehu)_ is needed to allow the connective to affect the relativized sumti rather than the sumti of the relative phrase. (What about the cmavo after which selma'o GOI is named? It is discussed in [Section 7.5](../section-koha-broda-series) , as it is not semantically akin to the other kinds of relative phrases, although the syntax is the same.)