<a id="section-relative-clauses-and-vocatives"></a>8.9. <a id="c8s9"></a>Relative clauses in vocative phrases
-------------------------------------------------------------------------------------------------------------

<a id="id-1.9.11.2.1" class="indexterm"></a><a id="id-1.9.11.2.2" class="indexterm"></a>Vocative phrases are explained in more detail in [Section 6.11](../section-vocative-syntax). Briefly, they are a method of indicating who a sentence or discourse is addressed to: of identifying the intended listener. They take three general forms, all beginning with cmavo from selma'o COI or DOI (called “vocative words” ; there can be one or many), followed by either a cmevla, a selbri, or a sumti. Here are three examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMG8"></a>

**Example 8.74. <a id="c8e9d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">coi .frank.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hello, Frank.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMGj"></a>

**Example 8.75. <a id="c8e9d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">co'o xirma</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Goodbye, horse.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmgM"></a>

**Example 8.76. <a id="c8e9d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">fi'i la .frank. .e la .djordj.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Welcome, Frank and George!</p></td></tr></tbody></table>

</div>  

Note that [Example 8.75](../section-relative-clauses-and-vocatives#example-random-id-qMGj) says farewell to something which doesn't really have to be a horse, something that the speaker simply thinks of as being a horse, or even might be something (a person, for example) who is named “Horse”. In a sense, [Example 8.75](../section-relative-clauses-and-vocatives#example-random-id-qMGj) is ambiguous between _<a id="id-1.9.11.6.4.1" class="indexterm"></a>co'o le xirma_ and _<a id="id-1.9.11.6.5.1" class="indexterm"></a>co'o la xirma_ , a relatively safe semantic ambiguity, since names are ambiguous in general: saying “George” doesn't distinguish between the possible Georges.

Similarly, [Example 8.74](../section-relative-clauses-and-vocatives#example-random-id-qMG8) can be thought of as an abbreviation of:

<div class="interlinear-gloss-example example">
<a id="example-random-id-oWPU"></a>

**Example 8.77. <a id="c8e9d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>la</td><td>.frank.</td></tr><tr class="gloss"><td>Hello,</td><td>the-one-named</td><td><span class="quote">“<span class="quote">Frank</span>”</span></td><td>.</td></tr></tbody></table>

</div>  

Syntactically, vocative phrases are a kind of free modifier, and can appear in many places in Lojban text, generally at the beginning or end of some complete construct; or, as in [Example 8.74](../section-relative-clauses-and-vocatives#example-random-id-qMG8) to [Example 8.76](../section-relative-clauses-and-vocatives#example-random-id-qmgM) , as sentences by themselves.

<a id="id-1.9.11.10.1" class="indexterm"></a><a id="id-1.9.11.10.2" class="indexterm"></a><a id="id-1.9.11.10.3" class="indexterm"></a><a id="id-1.9.11.10.4" class="indexterm"></a>As can be seen, the form of vocative phrases is similar to that of sumti, and as you might expect, vocative phrases allow relative clauses in various places. In vocative phrases which are simple names (after the vocative words), any relative clauses must come just after the names:

<div class="interlinear-gloss-example example">
<a id="example-random-id-xECX"></a>

**Example 8.78. <a id="c8e9d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>.frank.</td><td>poi</td><td>xunre</td><td>se&nbsp;bende</td></tr><tr class="gloss"><td>Hello,</td><td>Frank</td><td>who</td><td>is-a-red</td><td>team-member</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hello, Frank from the Red Team!</p></td></tr></tbody></table>

</div>  

The restrictive relative clause in [Example 8.78](../section-relative-clauses-and-vocatives#example-random-id-xECX) suggests that there is some other Frank (perhaps on the Green Team) from whom this Frank, the one the speaker is greeting, must be distinguished.

<a id="id-1.9.11.13.1" class="indexterm"></a>A vocative phrase containing a selbri can have relative clauses either before or after the selbri; both forms have the same meaning. Here are some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmgV"></a>

**Example 8.79. <a id="c8e9d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>co'o</td><td>poi</td><td>mi</td><td>zvati</td><td>ke'a</td><td>ku'o</td><td>xirma</td></tr><tr class="gloss"><td>Goodbye,</td><td>such-that-(</td><td>I</td><td>am-at</td><td>IT</td><td>)</td><td>horse</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Goodbye, horse where I am!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMHc"></a>

**Example 8.80. <a id="c8e9d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>co'o</td><td>xirma</td><td>poi</td><td>mi</td><td>zvati</td></tr><tr class="gloss"><td>Goodbye,</td><td>horse</td><td>such-that-(</td><td>I</td><td>am-at-it).</td></tr></tbody></table>

</div>  

[Example 8.79](../section-relative-clauses-and-vocatives#example-random-id-qmgV) and [Example 8.80](../section-relative-clauses-and-vocatives#example-random-id-qMHc) mean the same thing. In fact, relative clauses can appear in both places.