<a id="section-rafsi"></a>4.6. <a id="c4s6"></a>rafsi
-----------------------------------------------------

<a id="id-1.5.8.2.1" class="indexterm"></a><a id="id-1.5.8.2.2" class="indexterm"></a><a id="id-1.5.8.2.3" class="indexterm"></a><a id="id-1.5.8.2.4" class="indexterm"></a><a id="id-1.5.8.2.5" class="indexterm"></a><a id="id-1.5.8.2.6" class="indexterm"></a>Every gismu has from two to five rafsi, each of a different form, but each such rafsi represents only one gismu. It is valid to use any of the rafsi forms in building lujvo – whichever the reader or listener will most easily understand, or whichever is most pleasing – subject to the rules of lujvo making. There is a scoring algorithm which is intended to determine which of the possible and legal lujvo forms will be the standard dictionary form (see [Section 4.12](../section-lujvo-scoring)).

<a id="id-1.5.8.3.1" class="indexterm"></a><a id="id-1.5.8.3.2" class="indexterm"></a><a id="id-1.5.8.3.3" class="indexterm"></a><a id="id-1.5.8.3.4" class="indexterm"></a><a id="id-1.5.8.3.5" class="indexterm"></a><a id="id-1.5.8.3.6" class="indexterm"></a><a id="id-1.5.8.3.7" class="indexterm"></a><a id="id-1.5.8.3.8" class="indexterm"></a>Each gismu always has at least two rafsi forms; one is the gismu itself (used only at the end of a lujvo), and one is the gismu without its final vowel (used only at the beginning or middle of a lujvo). These forms are represented as CVC/CV or CCVCV (called “the 5-letter rafsi”), and CVC/C or CCVC (called “the 4-letter rafsi”) respectively. The dashes in these rafsi form representations show where other rafsi may be attached to form a valid lujvo. When lujvo are formed only from 4-letter and 5-letter rafsi, known collectively as “long rafsi” , they are called “unreduced lujvo”.

Some examples of unreduced lujvo forms are:

<div class="lujvo-example example">
<a id="example-random-id-qj84"></a>

**Example 4.27. <a id="c4e6d1"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">mamtypatfu</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.5.2.3.1.1.1.1" class="indexterm"></a>mamta patfu</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">mother father</span>”</span> or <span class="quote">“<span class="quote">maternal grandfather</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qj99"></a>

**Example 4.28. <a id="c4e6d2"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">lerfyliste</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.6.2.3.1.1.1.1" class="indexterm"></a>lerfu liste</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">letter list</span>”</span> or a <span class="quote">“<span class="quote">list of letters</span>”</span></p></td></tr><tr><td><p class="natlang">(letters of the alphabet)</p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qj9G"></a>

**Example 4.29. <a id="c4e6d3"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">nancyprali</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.7.2.3.1.1.1.1" class="indexterm"></a>nanca prali</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">year profit</span>”</span> or <span class="quote">“<span class="quote">annual profit</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJbi"></a>

**Example 4.30. <a id="c4e6d4"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">prunyplipe</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.8.2.3.1.1.1.1" class="indexterm"></a>pruni plipe</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">elastic (springy) leap</span>”</span> or <span class="quote">“<span class="quote">spring</span>”</span> (the verb)</p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qjbP"></a>

**Example 4.31. <a id="id-1.5.8.9.1.1" class="indexterm"></a><a id="c4e6d5"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">vancysanmi</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.9.2.3.1.1.1.1" class="indexterm"></a>vanci sanmi</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">evening meal</span>”</span> or <span class="quote">“<span class="quote">supper</span>”</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.5.8.10.1" class="indexterm"></a><a id="id-1.5.8.10.2" class="indexterm"></a>In addition to these two forms, each gismu may have up to three additional short rafsi, three letters long. All short rafsi have one of the forms CVC, CCV, or CVV. The total number of rafsi forms that are assigned to a gismu depends on how useful the gismu is, or is presumed to be, in making lujvo, when compared to other gismu that could be assigned the rafsi.

<a id="id-1.5.8.11.1" class="indexterm"></a><a id="id-1.5.8.11.2" class="indexterm"></a>For example, _<a id="id-1.5.8.11.3.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ ( “more than”) has the two short rafsi _zma_ and _mau_ (in addition to its unreduced rafsi _zmad_ and _<a id="id-1.5.8.11.8.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_), because a vast number of lujvo have been created based on _<a id="id-1.5.8.11.9.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ , corresponding in general to English comparative adjectives ending in “\-er” such as “whiter” (Lojban _labmau_). On the other hand, _<a id="id-1.5.8.11.13.1" class="indexterm"></a>[_bakri_](../go01#valsi-bakri)_ ( “chalk”) has no short rafsi and few lujvo.

There are at most one CVC-form, one CCV-form, and one CVV-form rafsi per gismu. In fact, only a tiny handful of gismu have both a CCV-form and a CVV-form rafsi assigned, and still fewer have all three forms of short rafsi. However, gismu with both a CVC-form and another short rafsi are fairly common, partly because more possible CVC-form rafsi exist. Yet CVC-form rafsi, even though they are fairly easy to remember, cannot be used at the end of a lujvo (because lujvo must end in vowels), so justifying the assignment of an additional short rafsi to many gismu.

<a id="id-1.5.8.13.1" class="indexterm"></a><a id="id-1.5.8.13.2" class="indexterm"></a>The intention was to use the available “rafsi space” - the set of all possible short rafsi forms – in the most efficient way possible; the goal is to make the most-used lujvo as short as possible (thus maximizing the use of short rafsi), while keeping the rafsi very recognizable to anyone who knows the source gismu. For this reason, the letters in a rafsi have always been chosen from among the five letters of the corresponding gismu. As a result, there are a limited set of short rafsi available for assignment to each gismu. At most seven possible short rafsi are available for consideration (of which at most three can be used, as explained above).

<a id="id-1.5.8.14.1" class="indexterm"></a>Here are the only short rafsi forms that can possibly exist for gismu of the form CVC/CV, like _<a id="id-1.5.8.14.2.1" class="indexterm"></a>[_sakli_](../go01#valsi-sakli)_. The digits in the second column represent the gismu letters used to form the rafsi.

<table><tbody><tr><td>CVC</td><td>123</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-sak-</em></span></td></tr><tr><td>CVC</td><td>124</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-sal-</em></span></td></tr><tr><td>CVV</td><td>12'5</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-sa'i-</em></span></td></tr><tr><td>CVV</td><td>125</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-sai-</em></span></td></tr><tr><td>CCV</td><td>345</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kli-</em></span></td></tr><tr><td>CCV</td><td>132</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ska-</em></span></td></tr></tbody></table>

(The only actual short rafsi for _<a id="id-1.5.8.16.1.1" class="indexterm"></a>[_sakli_](../go01#valsi-sakli)_ is _\-sal-_.)

For gismu of the form CCVCV, like _<a id="id-1.5.8.17.1.1" class="indexterm"></a>[_blaci_](../go01#valsi-blaci)_ , the only short rafsi forms that can exist are:

<table><tbody><tr><td>CVC</td><td>134</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bac-</em></span></td></tr><tr><td>CVC</td><td>234</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-lac-</em></span></td></tr><tr><td>CVV</td><td>13'5</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ba'i-</em></span></td></tr><tr><td>CVV</td><td>135</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bai-</em></span></td></tr><tr><td>CVV</td><td>23'5</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-la'i-</em></span></td></tr><tr><td>CVV</td><td>235</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-lai-</em></span></td></tr><tr><td>CCV</td><td>123</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bla-</em></span></td></tr></tbody></table>

<a id="id-1.5.8.19.1" class="indexterm"></a>(In fact, _<a id="id-1.5.8.19.2.1" class="indexterm"></a>[_blaci_](../go01#valsi-blaci)_ has none of these short rafsi; they are all assigned to other gismu. Lojban speakers are not free to reassign any of the rafsi; the tables shown here are to help understand how the rafsi were chosen in the first place.)

<a id="id-1.5.8.20.1" class="indexterm"></a>There are a few restrictions: a CVV-form rafsi without an apostrophe cannot exist unless the vowels make up one of the four diphthongs _ai_ , _ei_ , _oi_ , or _au_ ; and a CCV-form rafsi is possible only if the two consonants form a permissible initial consonant pair (see [Section 4.1](../chapter-morphology#section-morphology-introduction)). Thus _<a id="id-1.5.8.20.7.1" class="indexterm"></a>[_mamta_](../go01#valsi-mamta)_ , which has the same form as _<a id="id-1.5.8.20.8.1" class="indexterm"></a>[_salci_](../go01#valsi-salci)_ , can only have _mam_ , _mat_ , and _ma'a_ as possible rafsi: in fact, only _mam_ is assigned to it.

<a id="id-1.5.8.21.1" class="indexterm"></a><a id="id-1.5.8.21.2" class="indexterm"></a>Some cmavo also have associated rafsi, usually CVC-form. For example, the ten common numerical digits, which are all CV form cmavo, each have a CVC-form rafsi formed by adding a consonant to the cmavo. Most cmavo that have rafsi are ones used in composing tanru.

<a id="id-1.5.8.22.1" class="indexterm"></a><a id="id-1.5.8.22.2" class="indexterm"></a>The term for a lujvo made up solely of short rafsi is “fully reduced lujvo”. Here are some examples of fully reduced lujvo:

<div class="lujvo-example example">
<a id="example-random-id-qJc2"></a>

**Example 4.32. <a id="c4e6d6"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">cumfri</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.23.2.3.1.1.1.1" class="indexterm"></a>cumki lifri</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">possible experience</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qjcA"></a>

**Example 4.33. <a id="c4e6d7"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">klezba</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.24.2.3.1.1.1.1" class="indexterm"></a>klesi zbasu</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">category make</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qjD7"></a>

**Example 4.34. <a id="c4e6d8"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">kixta'a</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.25.2.3.1.1.1.1" class="indexterm"></a>krixa tavla</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">cry-out talk</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJDa"></a>

**Example 4.35. <a id="c4e6d9"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">sniju'o</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.26.2.3.1.1.1.1" class="indexterm"></a>sinxa djuno</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">sign know</span>”</span></p></td></tr></tbody></table>

</div>  

In addition, the unreduced forms in [Example 4.27](../section-rafsi#example-random-id-qj84) and [Example 4.28](../section-rafsi#example-random-id-qj99) may be fully reduced to:

<div class="lujvo-example example">
<a id="example-random-id-qjdE"></a>

**Example 4.36. <a id="c4e6d10"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">mampa'u</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.28.2.3.1.1.1.1" class="indexterm"></a>mamta patfu</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">mother father</span>”</span> or <span class="quote">“<span class="quote">maternal grandfather</span>”</span></p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJDg"></a>

**Example 4.37. <a id="c4e6d11"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">lerste</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.8.29.2.3.1.1.1.1" class="indexterm"></a>lerfu liste</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">letter list</span>”</span> or a <span class="quote">“<span class="quote">list of letters</span>”</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.5.8.30.1" class="indexterm"></a><a id="id-1.5.8.30.2" class="indexterm"></a><a id="id-1.5.8.30.3" class="indexterm"></a><a id="id-1.5.8.30.4" class="indexterm"></a><a id="id-1.5.8.30.5" class="indexterm"></a>As noted above, CVC-form rafsi cannot appear as the final rafsi in a lujvo, because all lujvo must end with one or two vowels. As a brivla, a lujvo must also contain a consonant cluster within the first five letters – this ensures that they cannot be mistaken for compound cmavo. Of course, all lujvo have at least six letters since they have two or more rafsi, each at least three letters long; hence they cannot be confused with gismu.

<a id="id-1.5.8.31.1" class="indexterm"></a><a id="id-1.5.8.31.2" class="indexterm"></a><a id="id-1.5.8.31.3" class="indexterm"></a>When attaching two rafsi together, it may be necessary to insert a hyphen letter. In Lojban, the term “hyphen” always refers to a letter, either the vowel _y_ or one of the consonants _r_ and _n_. (The letter _l_ can also be a hyphen, but is not used as one in lujvo.)

<a id="id-1.5.8.32.1" class="indexterm"></a>The y-hyphen is used after a CVC-form rafsi when joining it with the following rafsi could result in an impermissible consonant pair, or when the resulting lujvo could fall apart into two or more words (either cmavo or gismu).

<a id="id-1.5.8.33.1" class="indexterm"></a>Thus, the tanru _<a id="id-1.5.8.33.2.1" class="indexterm"></a>pante tavla_ ( “protest talk”) cannot produce the lujvo _patta'a_ , because _tt_ is not a permissible consonant pair; the lujvo must be _<a id="id-1.5.8.33.6.1" class="indexterm"></a>[_patyta'a_](../go01#valsi-patytaha)_. Similarly, the tanru _<a id="id-1.5.8.33.7.1" class="indexterm"></a>mudri siclu_ ( “wooden whistle”) cannot form the lujvo _mudsiclu_ ; instead, _mudysiclu_ must be used. (Remember that _y_ is not counted in determining whether the first five letters of a brivla contain a consonant cluster: this is why.)

<a id="id-1.5.8.34.1" class="indexterm"></a>The y-hyphen is also used to attach a 4-letter rafsi, formed by dropping the final vowel of a gismu, to the following rafsi. (This procedure was shown, but not explained, in [Example 4.27](../section-rafsi#example-random-id-qj84) to [Example 4.31](../section-rafsi#example-random-id-qjbP).)

The lujvo forms _zunlyjamfu_ , _zunlyjma_ , _zuljamfu_ , and _<a id="id-1.5.8.35.4.1" class="indexterm"></a>[_zuljma_](../go01#valsi-zuljma)_ are all legitimate and equivalent forms made from the tanru _<a id="id-1.5.8.35.5.1" class="indexterm"></a>zunle jamfu_ ( “left foot”). Of these, _<a id="id-1.5.8.35.7.1" class="indexterm"></a>[_zuljma_](../go01#valsi-zuljma)_ is the preferred one since it is the shortest; it thus is likely to be the form listed in a Lojban dictionary.

<a id="id-1.5.8.36.1" class="indexterm"></a><a id="id-1.5.8.36.2" class="indexterm"></a><a id="id-1.5.8.36.3" class="indexterm"></a>The r-hyphen and its close relative, the n-hyphen, are used in lujvo only after CVV-form rafsi. A hyphen is always required in a two-part lujvo of the form CVV-CVV, since otherwise there would be no consonant cluster.

An r-hyphen or n-hyphen is also required after the CVV-form rafsi of any lujvo of the form CVV-CVC/CV or CVV-CCVCV since it would otherwise fall apart into a CVV-form cmavo and a gismu. In any lujvo with more than two parts, a CVV-form rafsi in the initial position must always be followed by a hyphen. If the hyphen were to be omitted, the supposed lujvo could be broken into smaller words without the hyphen: because the CVV-form rafsi would be interpreted as a cmavo, and the remainder of the word as a valid lujvo that is one rafsi shorter.

<a id="id-1.5.8.38.1" class="indexterm"></a><a id="id-1.5.8.38.2" class="indexterm"></a><a id="id-1.5.8.38.3" class="indexterm"></a>An n-hyphen is only used in place of an r-hyphen when the following rafsi begins with _r_. For example, the tanru _<a id="id-1.5.8.38.5.1" class="indexterm"></a>rokci renro_ ( “rock throw”) cannot be expressed as _<a id="id-1.5.8.38.7.1" class="indexterm"></a>ro'ire'o_ (which breaks up into two cmavo), nor can it be _<a id="id-1.5.8.38.8.1" class="indexterm"></a>ro'irre'o_ (which has an impermissible double consonant); the n-hyphen is required, and the correct form of the hyphenated lujvo is _ro'inre'o_. The same lujvo could also be expressed without hyphenation as _rokre'o_.

<a id="id-1.5.8.39.1" class="indexterm"></a>There is also a different way of building lujvo, or rather phrases which are grammatically and semantically equivalent to lujvo. You can make a phrase containing any desired words, joining each pair of them with the special cmavo _<a id="id-1.5.8.39.2.1" class="indexterm"></a>[_zei_](../go01#valsi-zei)_. Thus,

<div class="lujvo-example example">
<a id="example-random-id-VeGL"></a>

**Example 4.38. <a id="c4e6d12"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">bridi zei valsi</p></td></tr></tbody></table>

</div>  

<a id="id-1.5.8.41.1" class="indexterm"></a><a id="id-1.5.8.41.2" class="indexterm"></a><a id="id-1.5.8.41.3" class="indexterm"></a><a id="id-1.5.8.41.4" class="indexterm"></a><a id="id-1.5.8.41.5" class="indexterm"></a>is the exact equivalent of _<a id="id-1.5.8.41.6.1" class="indexterm"></a>[_brivla_](../go01#valsi-brivla)_ (but not necessarily the same as the underlying tanru _<a id="id-1.5.8.41.7.1" class="indexterm"></a>bridi valsi_ , which could have other meanings). Using _<a id="id-1.5.8.41.8.1" class="indexterm"></a>[_zei_](../go01#valsi-zei)_ is the only way to get a cmavo lacking a rafsi, a cmevla, or a fu'ivla into a lujvo:

<div class="lujvo-example example">
<a id="example-random-id-qJe1"></a>

**Example 4.39. <a id="id-1.5.8.42.1.1" class="indexterm"></a><a id="c4e6d13"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">xy. zei kantu</p></td></tr><tr><td><p class="natlang">X ray</p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJeE"></a>

**Example 4.40. <a id="id-1.5.8.43.1.1" class="indexterm"></a><a id="id-1.5.8.43.1.2" class="indexterm"></a><a id="c4e6d14"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">kulnr,farsi zei lolgai</p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">Farsi floor-cover</span>”</span></p></td></tr><tr><td><p class="natlang">Persian rug</p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJef"></a>

**Example 4.41. <a id="id-1.5.8.44.1.1" class="indexterm"></a><a id="c4e6d15"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">na'e zei .a zei na'e zei by. livgyterbilma</p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">non-A, non-B liver-disease</span>”</span></p></td></tr><tr><td><p class="natlang">non-A, non-B hepatitis</p></td></tr></tbody></table>

</div>  
<div class="lujvo-example example">
<a id="example-random-id-qJEh"></a>

**Example 4.42. <a id="id-1.5.8.45.1.1" class="indexterm"></a><a id="id-1.5.8.45.1.2" class="indexterm"></a><a id="c4e6d16"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">.cerman. zei jamkarce</p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">Sherman war-car</span>”</span></p></td></tr><tr><td><p class="natlang">Sherman tank</p></td></tr></tbody></table>

</div>  

[Example 4.41](../section-rafsi#example-random-id-qJef) is particularly noteworthy because the phrase that would be produced by removing the _<a id="id-1.5.8.46.2.1" class="indexterm"></a>[_zei_](../go01#valsi-zei)_ s from it doesn't end with a brivla, and in fact is not even grammatical. As written, the example is a tanru with two components, but by adding a _<a id="id-1.5.8.46.3.1" class="indexterm"></a>[_zei_](../go01#valsi-zei)_ between _<a id="id-1.5.8.46.4.1" class="indexterm"></a>[_by._](../go01#valsi-by)_ and _livgyterbilma_ to produce

<div class="lujvo-example example">
<a id="example-random-id-Wnaz"></a>

**Example 4.43. <a id="id-1.5.8.47.1.1" class="indexterm"></a><a id="c4e6d17"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">na'e zei .a zei na'e zei by. zei livgyterbilma</p></td></tr><tr><td><p class="natlang">non-A-non-B-hepatitis</p></td></tr></tbody></table>

</div>  

the whole phrase would become a single lujvo. The longer lujvo of [Example 4.43](../section-rafsi#example-random-id-Wnaz) may be preferable, because its place structure can be built from that of _<a id="id-1.5.8.48.2.1" class="indexterm"></a>[_bilma_](../go01#valsi-bilma)_ , whereas the place structure of a lujvo without a brivla must be constructed ad hoc.

<a id="id-1.5.8.49.1" class="indexterm"></a><a id="id-1.5.8.49.2" class="indexterm"></a><a id="id-1.5.8.49.3" class="indexterm"></a>Note that rafsi may not be used in _<a id="id-1.5.8.49.4.1" class="indexterm"></a>[_zei_](../go01#valsi-zei)_ phrases, because they are not words. CVV rafsi look like words (specifically cmavo) but there can be no confusion between the two uses of the same letters, because cmavo appear only as separate words or in compound cmavo (which are really just a notation for writing separate but closely related words as if they were one); rafsi appear only as parts of lujvo and fu'ivla.