<a id="section-radixen"></a>18.10. <a id="c18s10"></a>Non-decimal and compound bases
------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ju'u</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">to the base</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">dau</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit A = 10</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">fei</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit B = 11</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">gai</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit C = 12</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">jau</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit D = 13</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">rei</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit E = 14</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">vai</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">hex digit F = 15</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pi'e</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">compound base point</p></td></tr></tbody></table>

<a id="id-1.19.12.4.1" class="indexterm"></a>In normal contexts, Lojban assumes that all numbers are expressed in the decimal (base 10) system. However, other bases are possible, and may be appropriate in particular circumstances.

<a id="id-1.19.12.5.1" class="indexterm"></a><a id="id-1.19.12.5.2" class="indexterm"></a><a id="id-1.19.12.5.3" class="indexterm"></a>To specify a number in a particular base, the VUhU operator _<a id="id-1.19.12.5.4.1" class="indexterm"></a>[_ju'u_](../go01#valsi-juhu)_ is suitable:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Iw8u"></a>

**Example 18.70. <a id="c18e10d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>panopano</td><td>ju'u</td><td>re</td><td>du</td><td>li</td><td>pano</td></tr><tr class="gloss"><td>The-number</td><td>1010</td><td>base</td><td>2</td><td>equals</td><td>the-number</td><td>1</td><td>0.</td></tr></tbody></table>

</div>  

<a id="id-1.19.12.7.1" class="indexterm"></a><a id="id-1.19.12.7.2" class="indexterm"></a>Here, the final _<a id="id-1.19.12.7.3.1" class="indexterm"></a>pa no_ is assumed to be base 10, as usual; so is the base specification. (The base may also be changed permanently by a metalinguistic specification; no standard way of doing so has as yet been worked out.)

<a id="id-1.19.12.8.1" class="indexterm"></a><a id="id-1.19.12.8.2" class="indexterm"></a>Lojban has digits for representing bases up to 16, because 16 is a base often used in computer applications. In English, it is customary to use the letters A-F as the base 16 digits equivalent to the numbers ten through fifteen. In Lojban, this ambiguity is avoided:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qIgb"></a>

**Example 18.71. <a id="c18e10d2"></a><a id="id-1.19.12.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>daufeigai</td><td>ju'u</td><td>paxa</td><td>du</td><td>li</td><td>rezevobi</td></tr><tr class="gloss"><td>The-number</td><td>ABC</td><td>base</td><td>16</td><td>equals</td><td>the-number</td><td>2748.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qIha"></a>

**Example 18.72. <a id="c18e10d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>jaureivai</td><td>ju'u</td><td>paxa</td><td>du</td><td>li</td><td>cimuxaze</td></tr><tr class="gloss"><td>The-number</td><td>DEF</td><td>base</td><td>16</td><td>equals</td><td>the-number</td><td>3567.</td></tr></tbody></table>

</div>  

<a id="id-1.19.12.11.1" class="indexterm"></a>Note the pattern in the cmavo: the diphthongs _<a id="id-1.19.12.11.2.1" class="indexterm"></a>[_.au_](../go01#valsi-au)_ , _<a id="id-1.19.12.11.3.1" class="indexterm"></a>[_.ei_](../go01#valsi-ei)_ , _<a id="id-1.19.12.11.4.1" class="indexterm"></a>[_.ai_](../go01#valsi-ai)_ are used twice in the same order. The digits for A to D use consonants different from those used in the decimal digit cmavo; E and F unfortunately overlap 2 and 4 – there was simply not enough available cmavo space to make a full differentiation possible. The cmavo are also in alphabetical order.

<a id="id-1.19.12.12.1" class="indexterm"></a><a id="id-1.19.12.12.2" class="indexterm"></a>The base point _<a id="id-1.19.12.12.3.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ is used in non-decimal bases just as in base 10:

<div class="interlinear-gloss-example example">
<a id="example-random-id-gCo4"></a>

**Example 18.73. <a id="c18e10d4"></a><a id="id-1.19.12.13.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vai</td><td>pi</td><td>bi</td><td>ju'u</td><td>paxa</td><td>du</td><td>li</td><td>pamu</td><td>pi</td><td>mu</td></tr><tr class="gloss"><td>The-number</td><td>F</td><td>.</td><td>8</td><td>base</td><td>16</td><td>equals</td><td>the-number</td><td>15</td><td>.</td><td>5.</td></tr></tbody></table>

</div>  

<a id="id-1.19.12.14.1" class="indexterm"></a><a id="id-1.19.12.14.2" class="indexterm"></a>Since _<a id="id-1.19.12.14.3.1" class="indexterm"></a>[_ju'u_](../go01#valsi-juhu)_ is an operator of selma'o VUhU, it is grammatical to use any operand as the left argument. Semantically, however, it is undefined to use anything but a numeral string on the left. The reason for making _<a id="id-1.19.12.14.4.1" class="indexterm"></a>[_ju'u_](../go01#valsi-juhu)_ an operator is to allow reference to a base which is not a constant.

<a id="id-1.19.12.15.1" class="indexterm"></a><a id="id-1.19.12.15.2" class="indexterm"></a><a id="id-1.19.12.15.3" class="indexterm"></a>There are some numerical values that require a “base” that varies from digit to digit. For example, times represented in hours, minutes, and seconds have, in effect, three “digits” : the first is base 24, the second and third are base 60. To express such numbers, the compound base separator _<a id="id-1.19.12.15.6.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ is used:

<div class="interlinear-gloss-example example">
<a id="example-random-id-17HR"></a>

**Example 18.74. <a id="c18e10d5"></a><a id="id-1.19.12.16.1.2" class="indexterm"></a><a id="id-1.19.12.16.1.3" class="indexterm"></a><a id="id-1.19.12.16.1.4" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ci</td><td>pi'e</td><td>rere</td><td>pi'e</td><td>vono</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3:22:40</span></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.12.17.1" class="indexterm"></a>Each digit sequence separated by instances of _<a id="id-1.19.12.17.2.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ is expressed in decimal notation, but the number as a whole is not decimal and can only be added and subtracted by special rules:

<div class="interlinear-gloss-example example">
<a id="example-random-id-iUYu"></a>

**Example 18.75. <a id="c18e10d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>pi'e</td><td>rere</td><td>pi'e</td><td>vono</td><td>su'i</td><td>pi'e</td><td>ci</td><td>pi'e</td><td>cici</td></tr><tr class="gloss"><td>The-number</td><td>3</td><td>:</td><td>22</td><td>:</td><td>40</td><td>plus</td><td>:</td><td>3</td><td>:</td><td>33</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>du</td><td>li</td><td>ci</td><td>pi'e</td><td>rexa</td><td>pi'e</td><td>paci</td></tr><tr class="gloss"><td>equals</td><td>the-number</td><td>3</td><td>:</td><td>26</td><td>:</td><td>13.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">3:22:40 + 0:3:33 = 3:26:13</span></div></td></tr></tbody></table>

</div>  

Of course, only context tells you that the first part of the numbers in [Example 18.74](../section-radixen#example-random-id-17HR) and [Example 18.75](../section-radixen#example-random-id-iUYu) is hours, the second minutes, and the third seconds.

<a id="id-1.19.12.20.1" class="indexterm"></a><a id="id-1.19.12.20.2" class="indexterm"></a>The same mechanism using _<a id="id-1.19.12.20.3.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ can be used to express numbers which have a base larger than 16. For example, base-20 Mayan mathematics might use digits from _<a id="id-1.19.12.20.4.1" class="indexterm"></a>[_no_](../go01#valsi-no)_ to _<a id="id-1.19.12.20.5.1" class="indexterm"></a>[_paso_](../go01#valsi-paso)_ , each separated by _<a id="id-1.19.12.20.6.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-Nx5T"></a>

**Example 18.76. <a id="c18e10d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pa</td><td>pi'e</td><td>re</td><td>pi'e</td><td>ci</td><td>ju'u</td><td>reno</td><td>du</td><td>li</td><td>vovoci</td></tr><tr class="gloss"><td>the-number</td><td>1</td><td>;</td><td>2</td><td>;</td><td>3</td><td>base</td><td>20</td><td>equals</td><td>the-number</td><td>443</td></tr></tbody></table>

</div>  

<a id="id-1.19.12.22.1" class="indexterm"></a><a id="id-1.19.12.22.2" class="indexterm"></a>Carefully note the difference between:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ydwP"></a>

**Example 18.77. <a id="c18e10d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pano</td><td>ju'u</td><td>reno</td></tr><tr class="gloss"><td>the-digit-10</td><td>base</td><td>20</td></tr></tbody></table>

</div>  

which is equal to ten, and:

<div class="interlinear-gloss-example example">
<a id="example-random-id-QBQx"></a>

**Example 18.78. <a id="c18e10d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pa</td><td>pi'e</td><td>no</td><td>ju'u</td><td>reno</td></tr><tr class="gloss"><td>1;0</td><td>base</td><td>20</td></tr></tbody></table>

</div>  

which is equal to twenty.

<a id="id-1.19.12.27.1" class="indexterm"></a>Both _<a id="id-1.19.12.27.2.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ and _<a id="id-1.19.12.27.3.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ can be used to express large-base fractions:

<div class="interlinear-gloss-example example">
<a id="example-random-id-26Li"></a>

**Example 18.79. <a id="c18e10d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pa</td><td>pi'e</td><td>vo</td><td>pi</td><td>ze</td><td>ju'u</td><td>reno</td></tr><tr class="gloss"><td>The-number</td><td>1</td><td>;</td><td>4</td><td>.</td><td>7</td><td>base</td><td>20</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>du</td><td>li</td><td>revo</td><td>pi</td><td>cimu</td></tr><tr class="gloss"><td>equals</td><td>the-number</td><td>24</td><td>.</td><td>35</td></tr></tbody></table>

</div>  

<a id="id-1.19.12.29.1" class="indexterm"></a>_<a id="id-1.19.12.29.2.1" class="indexterm"></a>[_pi'e_](../go01#valsi-pihe)_ is also used where the base of each digit is vague, as in the numbering of the examples in this chapter:

<div class="interlinear-gloss-example example">
<a id="example-random-id-U161"></a>

**Example 18.80. <a id="c18e10d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>dei</td><td>jufra</td><td>pabipi'ebinomoi</td></tr><tr class="gloss"><td>This-utterance</td><td>is-a-sentence-type-of</td><td>18;80th-thing.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This is Sentence 18.80.</p></td></tr></tbody></table>

</div>