<a id="section-quotations"></a>19.9. <a id="c19s9"></a>Quotations: LU, LIhU, LOhU, LEhU
---------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lu</p></td><td class="selmaho"><p class="selmaho">LU</p></td><td class="description"><p class="description">begin quotation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">li'u</p></td><td class="selmaho"><p class="selmaho">LIhU</p></td><td class="description"><p class="description">end quotation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lo'u</p></td><td class="selmaho"><p class="selmaho">LOhU</p></td><td class="description"><p class="description">begin error quotation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">le'u</p></td><td class="selmaho"><p class="selmaho">LEhU</p></td><td class="description"><p class="description">end error quotation</p></td></tr></tbody></table>

Grammatically, quotations are very simple in Lojban: all of them are sumti, and they all mean something like “the piece of text here quoted” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-6SBj"></a>

**Example 19.43. <a id="c19e9d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>cusku</td><td>lu</td><td>mi'e</td><td>.djan.</td><td>[li'u]</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>express</td><td>[quote]</td><td>I-am</td><td>John</td><td>[unquote]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I said, <span class="quote">“<span class="quote">I'm John</span>”</span>.</p></td></tr></tbody></table>

</div>  

But in fact there are four different flavors of quotation in the language, involving six cmavo of six different selma'o. This being the case, quotation deserves some elaboration.

The simplest kind of quotation, exhibited in [Example 19.43](../section-quotations#example-random-id-6SBj) , uses the cmavo _<a id="id-1.20.11.7.2.1" class="indexterm"></a>[_lu_](../go01#valsi-lu)_ (of selma'o LU) as the opening quotation mark, and the cmavo _<a id="id-1.20.11.7.3.1" class="indexterm"></a>[_li'u_](../go01#valsi-lihu)_ (of selma'o LIhU) as the closing quotation mark. The text between _<a id="id-1.20.11.7.4.1" class="indexterm"></a>[_lu_](../go01#valsi-lu)_ and _<a id="id-1.20.11.7.5.1" class="indexterm"></a>[_li'u_](../go01#valsi-lihu)_ must be a valid, parseable Lojban text. If the quotation is ungrammatical, so is the surrounding expression. The cmavo _<a id="id-1.20.11.7.6.1" class="indexterm"></a>[_li'u_](../go01#valsi-lihu)_ is technically an elidable terminator, but it's almost never possible to elide it except at the end of text.

The cmavo _<a id="id-1.20.11.8.1.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ (of selma'o LOhU) and _<a id="id-1.20.11.8.2.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ (of selma'o LEhU) are used to surround a quotation that is not necessarily grammatical Lojban. However, the text must consist of morphologically correct Lojban words (as defined in [Chapter 4](../chapter-morphology)), so that the _<a id="id-1.20.11.8.4.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ can be picked out reliably. The words need not be meaningful, but they must be recognizable as cmavo, brivla, or cmevla. Quotation with _<a id="id-1.20.11.8.5.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ is essential to quoting ungrammatical Lojban for teaching in the language, the equivalent of the \* that is used in English to mark such errors:

<div class="interlinear-gloss-example example">
<a id="example-random-id-IUz8"></a>

**Example 19.44. <a id="c19e9d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'u</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;la&nbsp;.djan.</td><td>le'u</td></tr><tr class="gloss"><td>[quote]</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;la&nbsp;djan.</td><td>[unquote]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>na</td><td>tergerna</td><td>la</td><td>.lojban.</td></tr><tr class="gloss"><td>is-not</td><td>a-grammatical-structure</td><td>in</td><td>Lojban.</td></tr></tbody></table>

</div>  

[Example 19.44](../section-quotations#example-random-id-IUz8) is grammatical even though the embedded quotation is not. Similarly, _<a id="id-1.20.11.10.2.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation can quote fragments of a text which themselves do not constitute grammatical utterances:

<div class="interlinear-gloss-example example">
<a id="example-random-id-EXeq"></a>

**Example 19.45. <a id="c19e9d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lu</td><td>le&nbsp;mlatu&nbsp;cu&nbsp;viska&nbsp;le&nbsp;finpe</td><td>li'u</td><td>zo'u</td></tr><tr class="gloss"><td>[quote]</td><td>le&nbsp;mlatu&nbsp;cu&nbsp;viska&nbsp;le&nbsp;finpe</td><td>[unquote]</td><td>:</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'u</td><td>viska&nbsp;le</td><td>le'u</td><td>cu</td><td>selbasti</td></tr><tr class="gloss"><td>[quote]</td><td>viska&nbsp;le</td><td>[unquote]</td><td></td><td>is-replaced-by</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ei</td><td>lo'u</td><td>viska&nbsp;lo</td><td>le'u</td></tr><tr class="gloss"><td>[obligation!]</td><td>[quote]</td><td>viska&nbsp;lo</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">In the sentence <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.11.11.5.1.1.1.1.1" class="indexterm"></a>le mlatu cu viska le finpe</em></span> , <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.11.11.5.1.1.1.2.1" class="indexterm"></a>viska le</em></span> should be replaced by <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.11.11.5.1.1.1.3.1" class="indexterm"></a>viska lo</em></span>.</p></td></tr></tbody></table>

</div>  

Note the topic-comment formulation ( [Section 19.4](../section-topic-comments)) and the indicator applying to the selbri only ( [Section 19.8](../section-attitudinal-scope)). Neither _<a id="id-1.20.11.12.3.1" class="indexterm"></a>viska le_ nor _<a id="id-1.20.11.12.4.1" class="indexterm"></a>viska lo_ is a valid Lojban utterance, and both require _<a id="id-1.20.11.12.5.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation.

Additionally, pro-sumti or pro-bridi in the quoting sentence can refer to words appearing in the quoted sentence when _<a id="id-1.20.11.13.1.1" class="indexterm"></a>[_lu_](../go01#valsi-lu)_ … _<a id="id-1.20.11.13.2.1" class="indexterm"></a>[_li'u_](../go01#valsi-lihu)_ is used, but not when _<a id="id-1.20.11.13.3.1" class="indexterm"></a>lo'u ... le'u_ is used:

<div class="interlinear-gloss-example example">
<a id="example-random-id-x8XL"></a>

**Example 19.46. <a id="c19e9d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.tcarlis.</td><td>cusku</td><td>lu</td><td>le</td><td>ninmu</td><td>cu</td><td>morsi</td><td>li'u</td></tr><tr class="gloss"><td></td><td>Charlie</td><td>says</td><td>[quote]</td><td>the</td><td>woman</td><td></td><td>is-dead</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.iku'i</td><td>ri</td><td>jmive</td></tr><tr class="gloss"><td>However,</td><td>the-last-mentioned</td><td>is-alive.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Charlie says <span class="quote">“<span class="quote">The woman is dead</span>”</span> , but she is alive.</p></td></tr></tbody></table>

</div>  

In [Example 19.46](../section-quotations#example-random-id-x8XL) , _<a id="id-1.20.11.15.2.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ is a pro-sumti which refers to the most recent previous sumti, namely _<a id="id-1.20.11.15.3.1" class="indexterm"></a>le ninmu_. Compare:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hvhb"></a>

**Example 19.47. <a id="c19e9d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.tcarlis.</td><td>cusku</td><td>lo'u</td><td>le</td><td>ninmu</td><td>cu</td><td>morsi</td><td>le'u</td></tr><tr class="gloss"><td></td><td>Charlie</td><td>says</td><td>[quote]</td><td>le</td><td>ninmu</td><td>cu</td><td>morsi</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.iku'i</td><td>ri</td><td>jmive</td></tr><tr class="gloss"><td>However,</td><td>the-last-mentioned</td><td>is-alive.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Charlie says <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.11.16.4.1.1.1.1.1" class="indexterm"></a>le ninmu cu morsi</em></span> , but he is alive.</p></td></tr></tbody></table>

</div>  

In [Example 19.47](../section-quotations#example-random-id-hvhb) , _<a id="id-1.20.11.17.2.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ cannot refer to the referent of the alleged sumti _<a id="id-1.20.11.17.3.1" class="indexterm"></a>le ninmu_ , because _<a id="id-1.20.11.17.4.1" class="indexterm"></a>le ninmu cu morsi_ is a mere uninterpreted sequence of Lojban words. Instead, _<a id="id-1.20.11.17.5.1" class="indexterm"></a>[_ri_](../go01#valsi-ri)_ ends up referring to the referent of the sumti _<a id="id-1.20.11.17.6.1" class="indexterm"></a>la .tcarlis._ , and so it is Charlie who is alive.

The metalinguistic erasers _<a id="id-1.20.11.18.1.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ , _<a id="id-1.20.11.18.2.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ , and _<a id="id-1.20.11.18.3.1" class="indexterm"></a>[_su_](../go01#valsi-su)_ , discussed in [Section 19.13](../section-erasure) , do not operate in text between _<a id="id-1.20.11.18.5.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ and _<a id="id-1.20.11.18.6.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_. Since the first _<a id="id-1.20.11.18.7.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ terminates a _<a id="id-1.20.11.18.8.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation, it is not directly possible to have a _<a id="id-1.20.11.18.9.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation within another _<a id="id-1.20.11.18.10.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation. However, it is possible for a _<a id="id-1.20.11.18.11.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ to occur within a _<a id="id-1.20.11.18.12.1" class="indexterm"></a>lo'u ... le'u_ quotation by preceding it with the cmavo _<a id="id-1.20.11.18.13.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ , discussed in [Section 19.10](../section-more-quotations). Note that _<a id="id-1.20.11.18.15.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ is not an elidable terminator; it is required.