<a id="section-quantified-sumti"></a>6.6. <a id="c6s6"></a>Quantified sumti
---------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">all of/each of</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su'o</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">at least (one of)</p></td></tr></tbody></table>

Quantifiers tell us how many: in the case of quantifiers with sumti, how many things we are talking about. In Lojban, quantifiers are expressed by numbers and mathematical expressions: a large topic discussed in some detail in [Chapter 18](../chapter-mekso). For the purposes of this chapter, a simplified treatment will suffice. Our examples will employ either the simple Lojban numbers _<a id="id-1.7.8.4.2.1" class="indexterm"></a>[_pa_](../go01#valsi-pa)_ , _<a id="id-1.7.8.4.3.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ , _<a id="id-1.7.8.4.4.1" class="indexterm"></a>[_ci_](../go01#valsi-ci)_ , _<a id="id-1.7.8.4.5.1" class="indexterm"></a>[_vo_](../go01#valsi-vo)_ , and _<a id="id-1.7.8.4.6.1" class="indexterm"></a>[_mu_](../go01#valsi-mu)_ , meaning “one” , “two” , “three” , “four” , “five” respectively, or else one of four special quantifiers, two of which are discussed in this section and listed above. These four quantifiers are important because every Lojban sumti has either one or two of them implicitly present in it – which one or two depends on the particular kind of sumti. There is more explanation of implicit quantifiers later in this section. (The other two quantifiers, _<a id="id-1.7.8.4.12.1" class="indexterm"></a>[_piro_](../go01#valsi-piro)_ and _<a id="id-1.7.8.4.13.1" class="indexterm"></a>[_pisu'o_](../go01#valsi-pisuho)_ , are explained in [Section 6.7](../section-quantified-descriptions).)

Every Lojban sumti may optionally be preceded by an explicit quantifier. The purpose of this quantifier is to specify how many of the things referred to by the sumti are being talked about. Here are some simple examples contrasting sumti with and without explicit quantifiers:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qL61"></a>

**Example 6.30. <a id="c6e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>You</td><td>walk-on</td><td>the</td><td>ice.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLAH"></a>

**Example 6.31. <a id="c6e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>Two-of</td><td>you</td><td>walk-on</td><td>the</td><td>ice.</td></tr></tbody></table>

</div>  

The difference between [Example 6.30](../section-quantified-sumti#example-random-id-qL61) and [Example 6.31](../section-quantified-sumti#example-random-id-qLAH) is the presence of the explicit quantifier _<a id="id-1.7.8.8.3.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ in the latter example. Although _<a id="id-1.7.8.8.4.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ by itself means “two” , when used as a quantifier it means “two-of”. Out of the group of listeners (the number of which isn't stated), two (we are not told which ones) are asserted to be “walkers on the ice”. Implicitly, the others (if any) are not walkers on the ice. In Lojban, you cannot say “I own three shoes” if in fact you own four shoes. Numbers need never be specified, but if they are specified they must be correct.

(This rule does not mean that there is no way to specify a number which is vague. The sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-gLpy"></a>

**Example 6.32. <a id="c6e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ponse</td><td>su'o</td><td>ci</td><td>cutci</td></tr><tr class="gloss"><td>I</td><td>possess</td><td>at-least</td><td>three</td><td>shoes.</td></tr></tbody></table>

</div>  

is true if you own three shoes, or four, or indeed any larger number. More details on vague numbers appear in the discussion of mathematical expressions in [Chapter 18](../chapter-mekso).)

Now consider [Example 6.30](../section-quantified-sumti#example-random-id-qL61) again. How many of the listeners are claimed to walk on the ice? The answer turns out to be: all of them, however many that is. So [Example 6.30](../section-quantified-sumti#example-random-id-qL61) and [Example 6.33](../section-quantified-sumti#example-random-id-0qr0) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-0qr0"></a>

**Example 6.33. <a id="c6e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>All-of</td><td>you</td><td>walk-on</td><td>the</td><td>ice.</td></tr></tbody></table>

</div>  

<a id="id-1.7.8.14.1" class="indexterm"></a><a id="id-1.7.8.14.2" class="indexterm"></a>turn out to mean exactly the same thing. This is a safe strategy, because if one of my listeners doesn't turn out to be walking on the ice, I can safely claim that I didn't intend that person to be a listener! And in fact, all of the personal pro-sumti such as _<a id="id-1.7.8.14.3.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ and _<a id="id-1.7.8.14.4.1" class="indexterm"></a>[_mi'o_](../go01#valsi-miho)_ and _<a id="id-1.7.8.14.5.1" class="indexterm"></a>[_ko_](../go01#valsi-ko)_ obey the same rule. We say that personal pro-sumti have a so-called “implicit quantifier” of _<a id="id-1.7.8.14.7.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ (all). This just means that if no quantifier is given explicitly, the meaning is the same as if the implicit quantifier had been used.

<a id="id-1.7.8.15.1" class="indexterm"></a>Not all sumti have _<a id="id-1.7.8.15.2.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ as the implicit quantifier, however. Consider the quotation in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3eMo"></a>

**Example 6.34. <a id="c6e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>lu</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>[quote]</td><td>you</td><td>walk-on</td><td>the</td><td>ice</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I say, <span class="quote">“<span class="quote">You walk on the ice.</span>”</span></p></td></tr></tbody></table>

</div>  

What is the implicit quantifier of the quotation _<a id="id-1.7.8.17.1.1" class="indexterm"></a>lu do cadzu le bisli li'u_ ? Surely not _<a id="id-1.7.8.17.2.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_. If _<a id="id-1.7.8.17.3.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ were supplied explicitly, thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-h4SJ"></a>

**Example 6.35. <a id="c6e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>ro</td><td>lu</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>all-of</td><td>[quote]</td><td>you</td><td>walk-on</td><td>the</td><td>ice</td><td>[unquote].</td></tr></tbody></table>

</div>  

the meaning would be something like “I say every occurrence of the sentence 'You walk on the ice'”. Of course I don't say every occurrence of it, only some occurrences. One might suppose that [Example 6.34](../section-quantified-sumti#example-random-id-3eMo) means that I express exactly one occurrence, but it is more Lojbanic to leave the number unspecified, as with other sumti. We can say definitely, however, that I say it at least once.

The Lojban cmavo meaning “at least” is _<a id="id-1.7.8.20.2.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ , and if no ordinary number follows, _<a id="id-1.7.8.20.3.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ means “at least once”. (See [Example 6.32](../section-quantified-sumti#example-random-id-gLpy) for the use of _<a id="id-1.7.8.20.6.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ with an ordinary number). Therefore, the explicitly quantified version of [Example 6.34](../section-quantified-sumti#example-random-id-3eMo) is<a id="id-1.7.8.20.8" class="indexterm"></a><a id="id-1.7.8.20.9" class="indexterm"></a><a id="id-1.7.8.20.10" class="indexterm"></a>

<div class="interlinear-gloss-example example">
<a id="example-random-id-P558"></a>

**Example 6.36. <a id="c6e6d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>su'o</td><td>lu</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>at-least-one-of</td><td>[quote]</td><td>you</td><td>walk-on</td><td>the</td><td>ice</td><td>[unquote].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I say one or more instances of <span class="quote">“<span class="quote">You walk on the ice</span>”</span>.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">I say <span class="quote">“<span class="quote">You walk on the ice</span>”</span>.</p></td></tr></tbody></table>

</div>  

If an explicit ordinary number such as _<a id="id-1.7.8.22.1.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ were to appear, it would have to convey an exact expression, so

<div class="interlinear-gloss-example example">
<a id="example-random-id-59dF"></a>

**Example 6.37. <a id="c6e6d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>re</td><td>lu</td><td>do</td><td>cadzu</td><td>le</td><td>bisli</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>two-of</td><td>[quote]</td><td>you</td><td>walk-on</td><td>the</td><td>ice</td><td>[unquote].</td></tr></tbody></table>

</div>  

means that I say the sentence exactly twice, neither more nor less.