<a id="section-quantified-descriptions"></a>6.7. <a id="c6s7"></a>Quantified descriptions
-----------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">piro</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">the whole of</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pisu'o</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">a part of</p></td></tr></tbody></table>

<a id="id-1.7.9.4.1" class="indexterm"></a>Like other sumti, descriptions can be quantified. When a quantifier appears before a description, it has the same meaning as one appearing before a non-description sumti: it specifies how many things, of all those referred to by the description, are being talked about in this particular bridi. Suppose that context tells us that _<a id="id-1.7.9.4.2.1" class="indexterm"></a>le gerku_ refers to three dogs. Then we can say that exactly two of them are white as follows:

<div class="interlinear-gloss-example example">
<a id="example-random-id-WtUh"></a>

**Example 6.38. <a id="id-1.7.9.5.1.1" class="indexterm"></a><a id="c6e7d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>le</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>Two-of</td><td>the</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two of the dogs are white.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.9.6.1" class="indexterm"></a><a id="id-1.7.9.6.2" class="indexterm"></a><a id="id-1.7.9.6.3" class="indexterm"></a><a id="id-1.7.9.6.4" class="indexterm"></a><a id="id-1.7.9.6.5" class="indexterm"></a><a id="id-1.7.9.6.6" class="indexterm"></a>When discussing descriptions, this ordinary quantifier is called an “outer quantifier” , since it appears outside the description. But there is another possible location for a quantifier: between the descriptor and the selbri. This quantifier is called an “inner quantifier” , and its meaning is quite different: it tells the listener how many objects the description selbri characterizes.

For example, the context of [Example 6.38](../section-quantified-descriptions#example-random-id-WtUh) supposedly told us that _<a id="id-1.7.9.7.2.1" class="indexterm"></a>le gerku_ referred to some three specific dogs. This assumption can be made certain with the use of an explicit inner quantifier:

<div class="interlinear-gloss-example example">
<a id="example-random-id-X3iY"></a>

**Example 6.39. <a id="c6e7d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>le</td><td>ci</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>Two-of</td><td>the</td><td>three</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two of the three dogs are white.</p></td></tr></tbody></table>

</div>  

(As explained in the discussion of [Example 6.32](../section-quantified-sumti#example-random-id-gLpy) , simple numbers like those in [Example 6.39](../section-quantified-descriptions#example-random-id-X3iY) must be exact: it therefore follows that the third dog cannot be white.)

<a id="id-1.7.9.10.1" class="indexterm"></a>You may also specify an explicit inner quantifier and leave the outer quantifier implicit:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JxzV"></a>

**Example 6.40. <a id="c6e7d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ci</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>The</td><td>three</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The three dogs are white.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.9.12.1" class="indexterm"></a><a id="id-1.7.9.12.2" class="indexterm"></a><a id="id-1.7.9.12.3" class="indexterm"></a>There are rules for each of the 11 descriptors specifying what the implicit values for the inner and outer quantifiers are. They are meant to provide sensible default values when context is absent, not necessarily to prescribe hard and fast rules. The following table lists the implicit values:

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-le"><em class="glossterm">le</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.1.2.1.1" class="indexterm"></a>ro le su'o</em></span></td><td>all of the at-least-one described as</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lo"><em class="glossterm">lo</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.2.2.1.1" class="indexterm"></a>su'o lo ro</em></span></td><td>at least one of all of those which really are</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-la"><em class="glossterm">la</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.3.2.1.1" class="indexterm"></a>ro la su'o</em></span></td><td>all of the at least one named</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lei"><em class="glossterm">lei</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.4.2.1.1" class="indexterm"></a>pisu'o lei su'o</em></span></td><td>some part of the mass of the at-least-one described as</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-loi"><em class="glossterm">loi</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.5.2.1.1" class="indexterm"></a>pisu'o loi ro</em></span></td><td>some part of the mass of all those that really are</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lai"><em class="glossterm">lai</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.6.2.1.1" class="indexterm"></a>pisu'o lai su'o</em></span></td><td>some part of the mass of the at-least-one named</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lehi"><em class="glossterm">le'i</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.7.2.1.1" class="indexterm"></a>piro le'i su'o</em></span></td><td>the whole of the set of the at-least-one described as</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lohi"><em class="glossterm">lo'i</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.8.2.1.1" class="indexterm"></a>piro lo'i ro</em></span></td><td>the whole of the set of all those that really are</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lahi"><em class="glossterm">la'i</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.9.2.1.1" class="indexterm"></a>piro la'i su'o</em></span></td><td>the whole of the set of the at-least-one named</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lehe"><em class="glossterm">le'e</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.10.2.1.1" class="indexterm"></a>ro le'e su'o</em></span></td><td>all the stereotypes of the at-least-one described as</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.11.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lohe"><em class="glossterm">lo'e</em></a></em></span> :</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.7.9.13.11.2.1.1" class="indexterm"></a>su'o lo'e ro</em></span></td><td>at least one of the types of all those that really are</td></tr></tbody></table>

<a id="id-1.7.9.14.1" class="indexterm"></a><a id="id-1.7.9.14.2" class="indexterm"></a><a id="id-1.7.9.14.3" class="indexterm"></a><a id="id-1.7.9.14.4" class="indexterm"></a>When examined for the first time, this table looks dreadfully arbitrary. In fact, there are quite a few regularities in it. First of all, the la-series (that is, the descriptors _<a id="id-1.7.9.14.5.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , _<a id="id-1.7.9.14.6.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ , and _<a id="id-1.7.9.14.7.1" class="indexterm"></a>[_la'i_](../go01#valsi-lahi)_) and the le-series (that is, the descriptors _<a id="id-1.7.9.14.8.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , _<a id="id-1.7.9.14.9.1" class="indexterm"></a>[_lei_](../go01#valsi-lei)_ , _<a id="id-1.7.9.14.10.1" class="indexterm"></a>[_le'i_](../go01#valsi-lehi)_ , and _<a id="id-1.7.9.14.11.1" class="indexterm"></a>[_le'e_](../go01#valsi-lehe)_) always have corresponding implicit quantifiers, so we may subsume the la-series under the le-series for the rest of this discussion: “le-series cmavo” will refer to both the le-series proper and to the la-series.

<a id="id-1.7.9.15.1" class="indexterm"></a><a id="id-1.7.9.15.2" class="indexterm"></a>The rule for the inner quantifier is very simple: the lo-series cmavo (namely, _<a id="id-1.7.9.15.3.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , _<a id="id-1.7.9.15.4.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_ , _<a id="id-1.7.9.15.5.1" class="indexterm"></a>[_lo'i_](../go01#valsi-lohi)_ , and _<a id="id-1.7.9.15.6.1" class="indexterm"></a>[_lo'e_](../go01#valsi-lohe)_) all have an implicit inner quantifier of _<a id="id-1.7.9.15.7.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ , whereas the le-series cmavo all have an implicit inner quantifier of _<a id="id-1.7.9.15.8.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_.

<a id="id-1.7.9.16.1" class="indexterm"></a><a id="id-1.7.9.16.2" class="indexterm"></a>Why? Because lo-series descriptors always refer to all of the things which really fit into the x1 place of the selbri. They are not restricted by the speaker's intention. Descriptors of the le-series, however, are so restricted, and therefore talk about some number, definite or indefinite, of objects the speaker has in mind – but never less than one.

<a id="id-1.7.9.17.1" class="indexterm"></a><a id="id-1.7.9.17.2" class="indexterm"></a>Understanding the implicit outer quantifier requires rules of greater subtlety. In the case of mass and set descriptors, a single rule suffices for each: reference to a mass is implicitly a reference to some part of the mass; reference to a set is implicitly a reference to the whole set. Masses and sets are inherently singular objects: it makes no sense to talk about two distinct masses with the same components, or two distinct sets with the same members. Therefore, the largest possible outer quantifier for either a set description or a mass description is _<a id="id-1.7.9.17.3.1" class="indexterm"></a>[_piro_](../go01#valsi-piro)_ , the whole of it.

<a id="id-1.7.9.18.1" class="indexterm"></a>(Pedantically, it is possible that the mass of water molecules composing an ice cube might be thought of as different from the same mass of water molecules in liquid form, in which case we might talk about _<a id="id-1.7.9.18.2.1" class="indexterm"></a>re lei djacu_ , two masses of the water-bits I have in mind.)

<a id="id-1.7.9.19.1" class="indexterm"></a><a id="id-1.7.9.19.2" class="indexterm"></a>Why “_<a id="id-1.7.9.19.3.1.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ - ” ? It is the Lojban cmavo for the decimal point. Just as _<a id="id-1.7.9.19.4.1" class="indexterm"></a>pimu_ means “.5” , and when used as a quantifier specifies a portion consisting of five tenths of a thing, _<a id="id-1.7.9.19.6.1" class="indexterm"></a>[_piro_](../go01#valsi-piro)_ means a portion consisting of the all-ness – the entirety – of a thing. Similarly, _<a id="id-1.7.9.19.7.1" class="indexterm"></a>[_pisu'o_](../go01#valsi-pisuho)_ specifies a portion consisting of at least one part of a thing, i.e. some of it.

<a id="id-1.7.9.20.1" class="indexterm"></a><a id="id-1.7.9.20.2" class="indexterm"></a><a id="id-1.7.9.20.3" class="indexterm"></a>Smaller quantifiers are possible for sets, and refer to subsets. Thus _<a id="id-1.7.9.20.4.1" class="indexterm"></a>pimu le'i nanmu_ is a subset of the set of men I have in mind; we don't know precisely which elements make up this subset, but it must have half the size of the full set. This is the best way to say “half of the men” ; saying _<a id="id-1.7.9.20.6.1" class="indexterm"></a>pimu le nanmu_ would give us a half-portion of one of them instead! Of course, the result of _<a id="id-1.7.9.20.7.1" class="indexterm"></a>pimu le'i nanmu_ is still a set; if you need to refer to the individuals of the subset, you must say so (see _<a id="id-1.7.9.20.8.1" class="indexterm"></a>[_lu'a_](../go01#valsi-luha)_ in [Section 6.10](../section-sumti-qualifiers)).

<a id="id-1.7.9.21.1" class="indexterm"></a><a id="id-1.7.9.21.2" class="indexterm"></a><a id="id-1.7.9.21.3" class="indexterm"></a><a id="id-1.7.9.21.4" class="indexterm"></a>The case of outer quantifiers for individual descriptors (including _<a id="id-1.7.9.21.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , _<a id="id-1.7.9.21.6.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , _<a id="id-1.7.9.21.7.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , and the typical descriptors _<a id="id-1.7.9.21.8.1" class="indexterm"></a>[_le'e_](../go01#valsi-lehe)_ and _<a id="id-1.7.9.21.9.1" class="indexterm"></a>[_lo'e_](../go01#valsi-lohe)_) is special. When we refer to specific individuals with _<a id="id-1.7.9.21.10.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , we mean to refer to all of those we have in mind, so _<a id="id-1.7.9.21.11.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ is appropriate as the implicit quantifier, just as it is appropriate for _<a id="id-1.7.9.21.12.1" class="indexterm"></a>[_do_](../go01#valsi-do)_. Reference to non-specific individuals with _<a id="id-1.7.9.21.13.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , however, is typically to only some of the objects which can be correctly described, and so _<a id="id-1.7.9.21.14.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ is the appropriate implicit quantifier, just as for quotations.

<a id="id-1.7.9.22.1" class="indexterm"></a><a id="id-1.7.9.22.2" class="indexterm"></a>From the English-speaking point of view, the difference in structure between the following example using _<a id="id-1.7.9.22.3.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-f643"></a>

**Example 6.41. <a id="c6e7d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>[ro]</td><td>le</td><td>ci</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>[All-of]</td><td>those-described-as</td><td>three</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The three dogs are white.</p></td></tr></tbody></table>

</div>  

and the corresponding form with _<a id="id-1.7.9.24.1.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-gr7Y"></a>

**Example 6.42. <a id="c6e7d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ci</td><td>lo</td><td>[ro]</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>Three-of</td><td>those-which-are</td><td>[all]</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Three dogs are white.</p></td></tr></tbody></table>

</div>  

looks very peculiar. Why is the number _<a id="id-1.7.9.26.1.1" class="indexterm"></a>[_ci_](../go01#valsi-ci)_ found as an inner quantifier in [Example 6.41](../section-quantified-descriptions#example-random-id-f643) and as an outer quantifier in [Example 6.42](../section-quantified-descriptions#example-random-id-gr7Y) ? The number of dogs is the same in either case. The answer is that the _<a id="id-1.7.9.26.4.1" class="indexterm"></a>[_ci_](../go01#valsi-ci)_ in [Example 6.41](../section-quantified-descriptions#example-random-id-f643) is part of the specification: it tells us the actual number of dogs in the group that the speaker has in mind. In [Example 6.42](../section-quantified-descriptions#example-random-id-gr7Y) , however, the dogs referred to by _<a id="id-1.7.9.26.7.1" class="indexterm"></a>... lo gerku_ are all the dogs that exist: the outer quantifier then restricts the number to three; which three, we cannot tell. The implicit quantifiers are chosen to avoid claiming too much or too little: in the case of _<a id="id-1.7.9.26.8.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , the implicit outer quantifier _<a id="id-1.7.9.26.9.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ says that each of the dogs in the restricted group is white; in the case of _<a id="id-1.7.9.26.10.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , the implicit inner quantifier simply says that three dogs, chosen from the group of all the dogs there are, are white.

<a id="id-1.7.9.27.1" class="indexterm"></a>Using exact numbers as inner quantifiers in lo-series descriptions is dangerous, because you are stating that exactly that many things exist which really fit the description. So examples like

<div class="interlinear-gloss-example example">
<a id="example-random-id-uYH4"></a>

**Example 6.43. <a id="c6e7d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>[so'o]</td><td>lo</td><td>ci</td><td>gerku</td><td>cu</td><td>blabi</td></tr><tr class="gloss"><td>[some-of]</td><td>those-which-really-are</td><td>three</td><td>dogs</td><td></td><td>are-white.</td></tr></tbody></table>

</div>  

are semantically anomalous; [Example 6.43](../section-quantified-descriptions#example-random-id-uYH4) claims that some dog (or dogs) is white, but also that there are just three dogs in the universe!

Nevertheless, inner quantifiers are permitted on _<a id="id-1.7.9.30.1.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ descriptors for consistency's sake, and may occasionally be useful.

Note that the inner quantifier of _<a id="id-1.7.9.31.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , even when exact, need not be truthful: _<a id="id-1.7.9.31.2.1" class="indexterm"></a>le ci nanmu_ means “what I describe as three men” , not “three of what I describe as men”. This follows from the rule that what is described by a _<a id="id-1.7.9.31.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ description represents the speaker's viewpoint rather than the objective way things are.