<a id="section-pure-emotions"></a>13.2. <a id="c13s2"></a>Pure emotion indicators
---------------------------------------------------------------------------------

Attitudinals make no claim: they are expressions of attitude, not of facts or alleged facts. As a result, attitudinals themselves have no truth value, nor do they directly affect the truth value of a bridi that they modify. However, since emotional attitudes are carried in your mind, they reflect reactions to that version of the world that the mind is thinking about; this is seldom identical with the real world. At times, we are thinking about our idealized version of the real world; at other times we are thinking about a potential world that might or might not ever exist.

Therefore, there are two groups of attitudinals in Lojban. The “pure emotion indicators” express the way the speaker is feeling, without direct reference to what else is said. These indicators comprise the attitudinals which begin with _u_ or _o_ and many of those beginning with _i_.

The cmavo beginning with _u_ are simple emotions, which represent the speaker's reaction to the world as it is, or as it is perceived to be.

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ua</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">discovery</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">confusion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.u'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">gain</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">loss</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ue</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">surprise</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">no surprise</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">expectation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.u'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">wonder</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">commonplace</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ui</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">happiness</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">unhappiness</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.u'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">amusement</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">weariness</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.uo</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">completion</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">incompleteness</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.u'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">courage</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">timidity</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">cowardice</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.uu</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">pity</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">cruelty</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.u'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">repentance</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">lack of regret</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">innocence</p></td></tr></tbody></table>

Here are some typical uses of the _u_ attitudinals:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFgi"></a>

**Example 13.7. <a id="c13e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ua</td><td>mi</td><td>facki</td><td>fi</td><td>le</td><td>mi</td><td>mapku</td></tr><tr class="gloss"><td>[Eureka!]</td><td>I</td><td>found-out</td><td>about</td><td>the</td><td>of-me</td><td>hat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[Eureka!] I found my hat! [emphasizes the discovery of the hat]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFgv"></a>

**Example 13.8. <a id="c13e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.u'a</td><td>mi</td><td>facki</td><td>fi</td><td>le</td><td>mi</td><td>mapku</td></tr><tr class="gloss"><td>[Gain!]</td><td>I</td><td>found-out</td><td>about</td><td>the</td><td>of-me</td><td>hat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[Gain!] I found my hat! [emphasizes the obtaining of the hat]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFh5"></a>

**Example 13.9. <a id="c13e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ui</td><td>mi</td><td>facki</td><td>fi</td><td>le</td><td>mi</td><td>mapku</td></tr><tr class="gloss"><td>[Yay!]</td><td>I</td><td>found-out</td><td>about</td><td>the</td><td>of-me</td><td>hat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[Yay!] I found my hat! [emphasizes the feeling of happiness]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfHA"></a>

**Example 13.10. <a id="c13e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.uo</td><td>mi</td><td>facki</td><td>fi</td><td>le</td><td>mi</td><td>mapku</td></tr><tr class="gloss"><td>[At-last!]</td><td>I</td><td>found-out</td><td>about</td><td>the</td><td>of-me</td><td>hat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[At last!] I found my hat! [emphasizes that the finding is complete]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfHC"></a>

**Example 13.11. <a id="c13e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.uu</td><td>do</td><td>cortu</td></tr><tr class="gloss"><td>[Pity!]</td><td>you</td><td>feel-pain.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[Pity!] you feel pain. [expresses speaker's sympathy]</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfhT"></a>

**Example 13.12. <a id="c13e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.u'u</td><td>do</td><td>cortu</td></tr><tr class="gloss"><td>[Repentance!]</td><td>you</td><td>feel-pain.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">[Repentance!] you feel pain. [expresses that speaker feels guilty]</p></td></tr></tbody></table>

</div>  

In [Example 13.10](../section-pure-emotions#example-random-id-qfHA) , note that the attitudinal _<a id="id-1.14.4.13.2.1" class="indexterm"></a>[_.uo_](../go01#valsi-uo)_ is translated by an English non-attitudinal phrase: “At last!” It is common for the English equivalents of Lojban attitudinals to be short phrases of this sort, with more or less normal grammar, but actually expressions of emotion.

In particular, both _<a id="id-1.14.4.14.1.1" class="indexterm"></a>[_.uu_](../go01#valsi-uu)_ and _<a id="id-1.14.4.14.2.1" class="indexterm"></a>[_.u'u_](../go01#valsi-uhu)_ can be translated into English as “I'm sorry” ; the difference between these two attitudes frequently causes confusion among English-speakers who use this phrase, leading to responses like “Why are you sorry? It's not your fault!”

It is important to realize that _<a id="id-1.14.4.15.1.1" class="indexterm"></a>[_.uu_](../go01#valsi-uu)_ , and indeed all attitudinals, are meant to be used sincerely, not ironically. In English, the exclamation “Pity!” is just as likely to be ironically intended, but this usage does not extend to Lojban. Lying with attitudinals is (normally) as inappropriate to Lojban discourse as any other kind of lying: perhaps worse, because misunderstood emotions can cause even greater problems than misunderstood statements.

The following examples display the effects of _<a id="id-1.14.4.16.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ and _<a id="id-1.14.4.16.2.1" class="indexterm"></a>[_cu'i_](../go01#valsi-cuhi)_ when suffixed to an attitudinal:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFiE"></a>

**Example 13.13. <a id="c13e2d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ue</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Surprise!]</td><td>that-named</td><td>John</td><td>comes.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfiI"></a>

**Example 13.14. <a id="c13e2d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.uecu'i</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Ho-hum.]</td><td>that-named</td><td>John</td><td>comes.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfin"></a>

**Example 13.15. <a id="c13e2d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.uenai</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Expected!]</td><td>that-named</td><td>John</td><td>comes.</td></tr></tbody></table>

</div>  

In [Example 13.15](../section-pure-emotions#example-random-id-qfin) , John's coming has been anticipated by the speaker. In [Example 13.13](../section-pure-emotions#example-random-id-qFiE) and [Example 13.14](../section-pure-emotions#example-random-id-qfiI) , no such anticipation has been made, but in [Example 13.14](../section-pure-emotions#example-random-id-qfiI) the lack-of-anticipation goes no further – in [Example 13.13](../section-pure-emotions#example-random-id-qFiE) , it amounts to actual surprise.

It is not possible to firmly distinguish the pure emotion words beginning with _o_ or _i_ from those beginning with _u_ , but in general they represent more complex, more ambivalent, or more difficult emotions.

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.o'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">pride</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">modesty</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">shame</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.o'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">closeness</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">detachment</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">distance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.oi</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">complaint/pain</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">doing OK</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">pleasure</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.o'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">caution</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">boldness</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">rashness</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.o'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">patience</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">mere tolerance</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">anger</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.o'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">relaxation</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">composure</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">stress</p></td></tr></tbody></table>

Here are some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ch2s"></a>

**Example 13.16. <a id="c13e2d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.oi</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Complaint!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  

Here the speaker is distressed or discomfited over John's coming. The word _<a id="id-1.14.4.25.1.1" class="indexterm"></a>[_.oi_](../go01#valsi-oi)_ is derived from the Yiddish word “oy” of similar meaning. It is the only cmavo with a Yiddish origin.

<div class="interlinear-gloss-example example">
<a id="example-random-id-V8eD"></a>

**Example 13.17. <a id="c13e2d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.o'onai</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Anger!]</td><td>that-named</td><td>John</td><td>is-coming!</td></tr></tbody></table>

</div>  

Here the speaker feels anger over John's coming.

<div class="interlinear-gloss-example example">
<a id="example-random-id-QCTs"></a>

**Example 13.18. <a id="c13e2d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.o'i</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Beware!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  

Here there is a sense of danger in John's arrival.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfIR"></a>

**Example 13.19. <a id="c13e2d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.o'ecu'i</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Detachment!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFJf"></a>

**Example 13.20. <a id="c13e2d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.o'u</td><td>la</td><td>.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Phew!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  

In [Example 13.19](../section-pure-emotions#example-random-id-qfIR) and [Example 13.20](../section-pure-emotions#example-random-id-qFJf) , John's arrival is no problem: in the former example, the speaker feels emotional distance from the situation; in the latter example, John's coming is actually a relief of some kind.

The pure emotion indicators beginning with _i_ are those which could not be fitted into the _u_ or _o_ groups because there was a lack of room, so they are a mixed lot. _<a id="id-1.14.4.33.4.1" class="indexterm"></a>[_.ia_](../go01#valsi-ia)_ , _<a id="id-1.14.4.33.5.1" class="indexterm"></a>[_.i'a_](../go01#valsi-iha)_ , _<a id="id-1.14.4.33.6.1" class="indexterm"></a>[_.ie_](../go01#valsi-ie)_ , and _<a id="id-1.14.4.33.7.1" class="indexterm"></a>[_.i'e_](../go01#valsi-ihe)_ do not appear here, as they belong in [Section 13.3](../section-propositional-emotions) instead.

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ii</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">fear</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">nervousness</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">security</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.i'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">togetherness</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">privacy</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.io</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">respect</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">disrespect</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.i'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">appreciation</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">envy</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.iu</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">love</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">no love lost</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">hatred</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.i'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">familiarity</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">mystery</p></td></tr></tbody></table>

Here are some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFJV"></a>

**Example 13.21. <a id="c13e2d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ii</td><td>smacu</td></tr><tr class="gloss"><td>[Fear!]</td><td>[Observative:]-a-mouse!</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Eek! A mouse!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfK3"></a>

**Example 13.22. <a id="c13e2d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>.iu</td><td>klama</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[love!]</td><td>is-coming.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfKX"></a>

**Example 13.23. <a id="c13e2d17"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>.ionai</td><td>klama</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[disrespect!]</td><td>is-coming.</td></tr></tbody></table>

</div>  

[Example 13.21](../section-pure-emotions#example-random-id-qFJV) shows an attitude-colored observative; the attitudinal modifies the situation described by the observative, namely the mouse that is causing the emotion. Lojban-speaking toddlers, if there ever are any, will probably use sentences like [Example 13.21](../section-pure-emotions#example-random-id-qFJV) a lot.

[Example 13.22](../section-pure-emotions#example-random-id-qfK3) and [Example 13.23](../section-pure-emotions#example-random-id-qfKX) use attitudinals that follow _<a id="id-1.14.4.40.3.1" class="indexterm"></a>la .djan._ rather than being at the beginning of the sentence. This form means that the attitude is attached to John rather than the event of his coming; the speaker loves or disrespects John specifically. Compare:

<div class="interlinear-gloss-example example">
<a id="example-random-id-09oC"></a>

**Example 13.24. <a id="c13e2d18"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>klama</td><td>.iu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-coming</td><td>[love!]</td></tr></tbody></table>

</div>  

where it is specifically the coming of John that inspires the feeling.

[Example 13.23](../section-pure-emotions#example-random-id-qfKX) is a compact way of swearing at John: you could translate it as “That good-for-nothing John is coming.”