<a id="section-propositional-emotions"></a>13.3. <a id="c13s3"></a>Propositional attitude indicators
----------------------------------------------------------------------------------------------------

<a id="id-1.14.5.2.1" class="indexterm"></a><a id="id-1.14.5.2.2" class="indexterm"></a><a id="id-1.14.5.2.3" class="indexterm"></a><a id="id-1.14.5.2.4" class="indexterm"></a>As mentioned at the beginning of [Section 13.2](../section-pure-emotions) , attitudinals may be divided into two groups, the pure emotion indicators explained in that section, and a contrasting group which may be called the “propositional attitude indicators”. These indicators establish an internal, hypothetical world which the speaker is reacting to, distinct from the world as it really is. Thus we may be expressing our attitude towards “what the world would be like if ...” , or more directly stating our attitude towards making the potential world a reality.

<a id="id-1.14.5.3.1" class="indexterm"></a><a id="id-1.14.5.3.2" class="indexterm"></a><a id="id-1.14.5.3.3" class="indexterm"></a>In general, the bridi paraphrases of pure emotions look (in English) something like “I'm going to the market, and I'm happy about it”. The emotion is present with the subject of the primary claim, but is logically independent of it. Propositional attitudes, though, look more like “I intend to go to the market” , where the main claim is logically subordinate to the intention: I am not claiming that I am actually going to the market, but merely that I intend to.

<a id="id-1.14.5.4.1" class="indexterm"></a><a id="id-1.14.5.4.2" class="indexterm"></a><a id="id-1.14.5.4.3" class="indexterm"></a>There is no sharp distinction between attitudinals beginning with _a_ and those beginning with _e_ ; however, the original intent (not entirely realized due to the need to cram too many attitudes into too little space) was to make the members of the _a_ -series the purer, more attitudinal realizers of a potential world, while the members of the _e_ -series were more ambivalent or complex about the speaker's intention with regard to the predication. The relationship between the _a_ -series and the _e_ -series is similar to that between the _u_ -series and the _o_ -series, respectively. A few propositional attitude indicators overflowed into the _i_ -series as well.

<a id="id-1.14.5.5.1" class="indexterm"></a><a id="id-1.14.5.5.2" class="indexterm"></a><a id="id-1.14.5.5.3" class="indexterm"></a>In fact, the entire distinction between pure emotions and propositional attitudes is itself a bit shaky: _<a id="id-1.14.5.5.4.1" class="indexterm"></a>[_.u'u_](../go01#valsi-uhu)_ can be seen as a propositional attitude indicator meaning “I regret that ...” , and _<a id="id-1.14.5.5.6.1" class="indexterm"></a>[_.a'e_](../go01#valsi-ahe)_ (discussed below) can be seen as a pure emotion meaning “I'm awake/aware”. The division of the attitudinals into pure-emotion and propositional-attitude classes in this chapter is mostly by way of explanation; it is not intended to permit firm rulings on specific points. Attitudinals are the part of Lojban most distant from the “logical language” aspect.

Here is the list of propositional attitude indicators grouped by initial letter, starting with those beginning with _a_ :

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.a'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">attentive</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">inattentive</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">avoiding</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.a'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">alertness</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">exhaustion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ai</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">intent</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">indecision</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">refusal</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.a'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">effort</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">no real effort</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">repose</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.a'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">hope</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">despair</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.au</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">desire</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">indifference</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">reluctance</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.a'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">interest</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">no interest</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">repulsion</p></td></tr></tbody></table>

Some examples (of a parental kind):

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfLc"></a>

**Example 13.25. <a id="c13e3d1"></a><a id="id-1.14.5.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'a</td><td>do</td><td>zgana</td><td>le</td><td>veltivni</td></tr><tr class="gloss"><td>[attentive]</td><td>you</td><td>observe</td><td>the</td><td>television-receiver.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I'm noticing that you are watching the TV.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfMa"></a>

**Example 13.26. <a id="c13e3d2"></a><a id="id-1.14.5.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'enai</td><td>do</td><td>ranji</td><td>bacru</td></tr><tr class="gloss"><td>[exhaustion]</td><td>you</td><td>continuously</td><td>utter.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I'm worn out by your continuous talking.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFmF"></a>

**Example 13.27. <a id="c13e3d3"></a><a id="id-1.14.5.11.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ai</td><td>mi</td><td>muvgau</td><td>do</td><td>le</td><td>ckana</td></tr><tr class="gloss"><td>[intent]</td><td>I</td><td>transfer</td><td>you</td><td>to-the</td><td>bed.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I'm putting you to bed.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfnb"></a>

**Example 13.28. <a id="c13e3d4"></a><a id="id-1.14.5.12.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'i</td><td>mi</td><td>ba</td><td>gasnu</td><td>le</td><td>nu</td><td>do</td><td>cikna</td><td>binxo</td></tr><tr class="gloss"><td>[effort]</td><td>I</td><td>[future]</td><td>am-the-actor-in</td><td>the</td><td>event-of</td><td>you</td><td>awake-ly</td><td>become.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It'll be hard for me to wake you up.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFPm"></a>

**Example 13.29. <a id="c13e3d5"></a><a id="id-1.14.5.13.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'o</td><td>mi</td><td>kanryze'a</td><td>ca</td><td>le</td><td>bavlamdei</td></tr><tr class="gloss"><td>[hope]</td><td>I</td><td>am-health-increased</td><td>at-time</td><td>the</td><td>future-adjacent-day.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I hope I feel better tomorrow!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfPV"></a>

**Example 13.30. <a id="c13e3d6"></a><a id="id-1.14.5.14.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.au</td><td>mi</td><td>sipna</td></tr><tr class="gloss"><td>[desire]</td><td>I</td><td>sleep.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I want to sleep.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFpy"></a>

**Example 13.31. <a id="c13e3d7"></a><a id="id-1.14.5.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'ucu'i</td><td>do</td><td>pante</td></tr><tr class="gloss"><td>[no-interest]</td><td>you</td><td>complain.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I have no interest in your complaints.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.5.16.1" class="indexterm"></a><a id="id-1.14.5.16.2" class="indexterm"></a>(In a real-life situation, [Example 13.25](../section-propositional-emotions#example-random-id-qfLc) through [Example 13.31](../section-propositional-emotions#example-random-id-qFpy) would also be decorated by various pure emotion indicators, certainly including _<a id="id-1.14.5.16.5.1" class="indexterm"></a>.oicai_ , but probably also _<a id="id-1.14.5.16.6.1" class="indexterm"></a>.iucai_.)

<a id="id-1.14.5.17.1" class="indexterm"></a><a id="id-1.14.5.17.2" class="indexterm"></a>Splitting off the attitude into an indicator allows the regular bridi grammar to do what it does best: express the relationships between concepts that are intended, desired, hoped for, or whatever. Rephrasing these examples to express the attitude as the main selbri would make for unacceptably heavyweight grammar.

Here are the propositional attitude indicators beginning with _e_ , which stand roughly in the relation to those beginning with _a_ as the pure-emotion indicators beginning with _o_ do to those beginning with _u_ - they are more complex or difficult:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.e'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">permission</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">prohibition</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.e'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">competence</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">incompetence</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ei</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">obligation</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">freedom</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.e'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">constraint</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">independence</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">resistance to constraint</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.e'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">request</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">negative request</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.e'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">suggestion</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">no suggestion</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">warning</p></td></tr></tbody></table>

More examples (after a good night's sleep):

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFQ7"></a>

**Example 13.32. <a id="c13e3d8"></a><a id="id-1.14.5.21.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.e'a</td><td>do</td><td>sazri</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>[permission]</td><td>you</td><td>drive</td><td>the</td><td>car.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Sure, you can drive the car.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFR1"></a>

**Example 13.33. <a id="c13e3d9"></a><a id="id-1.14.5.22.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.e'e</td><td>mi</td><td>lifri</td><td>tu'a</td><td>do</td></tr><tr class="gloss"><td>[competence]</td><td>I</td><td>experience</td><td>something-related-to</td><td>you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I feel up to dealing with you.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfS1"></a>

**Example 13.34. <a id="c13e3d10"></a><a id="id-1.14.5.23.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ei</td><td>mi</td><td>tisygau</td><td>le</td><td>karce</td><td>ctilyvau</td></tr><tr class="gloss"><td>[obligation]</td><td>I</td><td>fill</td><td>the</td><td>car-type-of</td><td>petroleum-container.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I should fill the car's gas tank.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfS7"></a>

**Example 13.35. <a id="c13e3d11"></a><a id="id-1.14.5.24.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.e'o</td><td>ko</td><td>ko</td><td>kurji</td></tr><tr class="gloss"><td>[request]</td><td>you-imperative</td><td>of-you-imperative</td><td>take-care.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Please take care of yourself!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFSC"></a>

**Example 13.36. <a id="c13e3d12"></a><a id="id-1.14.5.25.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.e'u</td><td>do</td><td>klama</td><td>le</td><td>panka</td></tr><tr class="gloss"><td>[suggestion]</td><td>you</td><td>go</td><td>to-the</td><td>park.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I suggest going to the park.</p></td></tr></tbody></table>

</div>  

Finally, the propositional attitude indicators beginning with _i_ , which are the overflow from the other sets:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ia</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">belief</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">skepticism</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">disbelief</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.i'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">acceptance</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">blame</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.ie</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">agreement</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">disagreement</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.i'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">approval</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">non-approval</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">disapproval</p></td></tr></tbody></table>

Still more examples (much, much later):

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfSU"></a>

**Example 13.37. <a id="c13e3d13"></a><a id="id-1.14.5.29.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ianai</td><td>do</td><td>pu</td><td>pensi</td><td>le</td><td>nu</td><td>tcica</td><td>mi</td></tr><tr class="gloss"><td>[disbelief]</td><td>you</td><td>[past]</td><td>think</td><td>the</td><td>event-of</td><td>deceiving</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I can't believe you thought you could fool me.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfT6"></a>

**Example 13.38. <a id="c13e3d14"></a><a id="id-1.14.5.30.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>.i'anai</td><td>na</td><td>xruti</td><td>do</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>You</td><td>[blame]</td><td>did-not</td><td>return</td><td>you</td><td>to-the</td><td>house.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I blame you for not coming home.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qftC"></a>

**Example 13.39. <a id="c13e3d15"></a><a id="id-1.14.5.31.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ie</td><td>mi</td><td>na</td><td>cusku</td><td>lu'e</td></tr><tr class="gloss"><td>[agreement]</td><td>I</td><td>did-not</td><td>express</td><td>a-symbol-for</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>tcika</td><td>be</td><td>le</td><td>nu</td><td>xruti</td></tr><tr class="gloss"><td>the</td><td>time-of-day</td><td>of</td><td>the</td><td>event-of</td><td>return.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It's true I didn't tell you when to come back.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFU7"></a>

**Example 13.40. <a id="c13e3d16"></a><a id="id-1.14.5.32.1.2" class="indexterm"></a><a id="id-1.14.5.32.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i'enai</td><td>do</td><td>.i'e</td><td>zukte</td></tr><tr class="gloss"><td>[disapproval]</td><td>you</td><td>[approval]</td><td>act.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I don't approve of what you did, but I approve of you.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.5.33.1" class="indexterm"></a><a id="id-1.14.5.33.2" class="indexterm"></a><a id="id-1.14.5.33.3" class="indexterm"></a>[Example 13.40](../section-propositional-emotions#example-random-id-qFU7) illustrates the use of a propositional attitude indicator, _<a id="id-1.14.5.33.5.1" class="indexterm"></a>[_.i'e_](../go01#valsi-ihe)_ , in both the usual sense (at the beginning of the bridi) and as a pure emotion (attached to _<a id="id-1.14.5.33.6.1" class="indexterm"></a>[_do_](../go01#valsi-do)_). The event expressed by the main bridi is disapproved of by the speaker, but the referent of the sumti in the x1 place (namely the listener) is approved of.

<a id="id-1.14.5.34.1" class="indexterm"></a>To indicate that an attitudinal discussed in this section is not meant to indicate a propositional attitude, the simplest expedient is to split the attitudinal off into a separate sentence. Thus, a version of [Example 13.32](../section-propositional-emotions#example-random-id-qFQ7) which actually claimed that the listener was or would be driving the car might be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-96qq"></a>

**Example 13.41. <a id="c13e3d17"></a><a id="id-1.14.5.35.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>sazri</td><td>le</td><td>karce</td><td>.i</td><td>.e'a</td></tr><tr class="gloss"><td>You</td><td>drive</td><td>the</td><td>car.</td><td></td><td>[Permission].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You're driving (or will drive) the car, and that's fine.</p></td></tr></tbody></table>

</div>