<a id="section-properties"></a>11.4. <a id="c11s4"></a>Property abstractions
----------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ka</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">property abstractor</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ce'u</p></td><td class="selmaho"><p class="selmaho">KOhA</p></td><td class="description"><p class="description">abstraction focus</p></td></tr></tbody></table>

The things described by _<a id="id-1.12.6.4.1.1" class="indexterm"></a>le nu_ descriptions (or, to put it another way, the things of which _<a id="id-1.12.6.4.2.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ selbri may correctly be predicated) are only moderately “abstract”. They are still closely tied to happenings in space and time. Properties, however, are much more ethereal. What is “the property of being blue” , or “the property of being a go-er” ? They are what logicians call “intensions”. If John has a heart, then “the property of having a heart” is an abstract object which, when applied to John, is true. In fact,

<div class="interlinear-gloss-example example">
<a id="example-random-id-YSUx"></a>

**Example 11.21. <a id="c11e4d1"></a><a id="id-1.12.6.5.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>se&nbsp;risna</td><td>zo'e</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>has-as-heart</td><td>something-unspecified.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John has a heart.</p></td></tr></tbody></table>

</div>  

has the same truth conditions as

<div class="interlinear-gloss-example example">
<a id="example-random-id-1PPS"></a>

**Example 11.22. <a id="c11e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>ckaji</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>has-the-property</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>se&nbsp;risna</td><td>[zo'e]</td><td>[kei]</td></tr><tr class="gloss"><td>the</td><td>property-of</td><td>having-as-heart</td><td>something.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John has the property of having a heart.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.6.8.1" class="indexterm"></a>(The English word “have” frequently appears in any discussion of Lojban properties: things are said to “have” properties, but this is not the same sense of “have” as in “I have money” , which is possession.)

Property descriptions, like event descriptions, are often wanted to fill places in brivla place structures:

<div class="interlinear-gloss-example example">
<a id="example-random-id-v3Ba"></a>

**Example 11.23. <a id="c11e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cnino</td><td>mi</td><td>le</td><td>ka</td><td>xunre</td><td>[kei]</td></tr><tr class="gloss"><td>You</td><td>are-new</td><td>to-me</td><td>in-the-quality-of-the</td><td>property-of</td><td>being-red.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You are new to me in redness.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.6.11.1" class="indexterm"></a><a id="id-1.12.6.11.2" class="indexterm"></a>(The English suffix “\-ness” often signals a property abstraction, as does the suffix “\-ity”.)

<a id="id-1.12.6.12.1" class="indexterm"></a><a id="id-1.12.6.12.2" class="indexterm"></a>It would be suitable to use [Example 11.23](../section-properties#example-random-id-v3Ba) to someone who has returned from the beach with a sunburn.

<a id="id-1.12.6.13.1" class="indexterm"></a><a id="id-1.12.6.13.2" class="indexterm"></a>There are several different properties that can be extracted from a bridi, depending on which place of the bridi is “understood” as being specified externally. Thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-H71J"></a>

**Example 11.24. <a id="c11e4d5"></a><a id="id-1.12.6.14.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ka</td><td>mi</td><td>prami</td><td>[zo'e]</td><td>[kei]</td></tr><tr class="gloss"><td>a-property-of</td><td>me</td><td>loving</td><td>something-unspecified</td></tr></tbody></table>

</div>  

is quite different from

<div class="interlinear-gloss-example example">
<a id="example-random-id-wcxY"></a>

**Example 11.25. <a id="c11e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ka</td><td>[zo'e]</td><td>prami</td><td>mi</td><td>[kei]</td></tr><tr class="gloss"><td>a-property-of</td><td>something-unspecified</td><td>loving</td><td>me</td></tr></tbody></table>

</div>  

In particular, sentences like [Example 11.26](../section-properties#example-random-id-qfAM) and [Example 11.27](../section-properties#example-random-id-qfav) are quite different in meaning:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfAM"></a>

**Example 11.26. <a id="c11e4d7"></a><a id="id-1.12.6.18.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>zmadu</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>exceeds</td><td>that-named</td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>mi</td><td>prami</td></tr><tr class="gloss"><td>in-the</td><td>property-of</td><td>(I</td><td>love</td><td>X)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I love John more than I love George.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfav"></a>

**Example 11.27. <a id="c11e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>zmadu</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>exceeds</td><td>that-named</td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td></td><td>prami</td><td>mi</td></tr><tr class="gloss"><td>in-the</td><td>property&nbsp;of</td><td>(X</td><td>loves</td><td>me).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John loves me more than George loves me.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.6.20.1" class="indexterm"></a>The “X” used in the glosses of [Example 11.26](../section-properties#example-random-id-qfAM) through [Example 11.27](../section-properties#example-random-id-qfav) as a place-holder cannot be represented only by ellipsis in Lojban, because ellipsis means that there must be a specific value that can fill the ellipsis, as mentioned in [Section 11.2](../section-events). Instead, the cmavo _<a id="id-1.12.6.20.6.1" class="indexterm"></a>[_ce'u_](../go01#valsi-cehu)_ of selma'o KOhA is employed when an explicit sumti is wanted. (The form “X” will be used in literal translations.)

Therefore, an explicit equivalent of [Example 11.26](../section-properties#example-random-id-qfAM) , with no ellipsis, is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-8DD8"></a>

**Example 11.28. <a id="c11e4d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>zmadu</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>exceeds</td><td>that-named</td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>mi</td><td>prami</td><td>ce'u</td></tr><tr class="gloss"><td>in-the</td><td>property-of</td><td>(I</td><td>love</td><td>X).</td></tr></tbody></table>

</div>  

and of [Example 11.27](../section-properties#example-random-id-qfav) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JKBQ"></a>

**Example 11.29. <a id="c11e4d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cu</td><td>zmadu</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>&nbsp;</td><td>exceeds</td><td>that-named</td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>ce'u</td><td>prami</td><td>mi</td></tr><tr class="gloss"><td>in-the</td><td>property-of</td><td>(X</td><td>loves</td><td>me).</td></tr></tbody></table>

</div>  

This convention allows disambiguation of cases like:

<div class="interlinear-gloss-example example">
<a id="example-random-id-GiJp"></a>

**Example 11.30. <a id="c11e4d11"></a><a id="id-1.12.6.26.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>[zo'e]</td><td>dunda</td><td>le</td><td>xirma</td><td>[zo'e]</td><td>[kei]</td></tr><tr class="gloss"><td>the</td><td>property-of</td><td>&nbsp;</td><td>giving</td><td>the</td><td>horse</td></tr></tbody></table>

</div>  

into

<div class="interlinear-gloss-example example">
<a id="example-random-id-1vc4"></a>

**Example 11.31. <a id="c11e4d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>ce'u</td><td>dunda</td><td>le</td><td>xirma</td><td></td><td>[zo'e]</td><td>[kei]</td></tr><tr class="gloss"><td>the</td><td>property-of</td><td>(X</td><td>is-a-giver-of</td><td>the</td><td>horse</td><td>to</td><td>someone-unspecified</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the property of being a giver of the horse</p></td></tr></tbody></table>

</div>  

which is the most natural interpretation of [Example 11.30](../section-properties#example-random-id-GiJp) , versus

<div class="interlinear-gloss-example example">
<a id="example-random-id-rDtg"></a>

**Example 11.32. <a id="c11e4d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ka</td><td>[zo'e]</td><td>dunda</td><td>le</td><td>xirma</td><td></td><td>ce'u</td><td>[kei]</td></tr><tr class="gloss"><td>the</td><td>property-of</td><td>(someone-unspecified</td><td>is-a-giver-of</td><td>the</td><td>horse</td><td>to</td><td>X</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the property of being one to whom the horse is given</p></td></tr></tbody></table>

</div>  

which is also a possible interpretation.

<a id="id-1.12.6.32.1" class="indexterm"></a><a id="id-1.12.6.32.2" class="indexterm"></a>It is also possible to have more than one _<a id="id-1.12.6.32.3.1" class="indexterm"></a>[_ce'u_](../go01#valsi-cehu)_ in a _<a id="id-1.12.6.32.4.1" class="indexterm"></a>[_ka_](../go01#valsi-ka)_ abstraction, which transforms it from a property abstraction into a relationship abstraction. Relationship abstractions “package up” a complex relationship for future use; such an abstraction can be translated back into a selbri by placing it in the x2 place of the selbri _<a id="id-1.12.6.32.7.1" class="indexterm"></a>[_bridi_](../go01#valsi-bridi)_ , whose place structure is:

> _<a id="id-1.12.6.33.1.1.1" class="indexterm"></a>[_bridi_](../go01#valsi-bridi)_ x1 is a predicate relationship with relation x2 (abstraction) among arguments (sequence/set) x3

<a id="id-1.12.6.34.1" class="indexterm"></a>The place structure of _<a id="id-1.12.6.34.2.1" class="indexterm"></a>[_ka_](../go01#valsi-ka)_ abstraction selbri is simply:

> _<a id="id-1.12.6.35.1.1.1" class="indexterm"></a>[_ka_](../go01#valsi-ka)_ x1 is a property of (the bridi)