<a id="section-parentheses"></a>19.12. <a id="c19s12"></a>Parenthesis and metalinguistic commentary: TO, TOI, SEI
-----------------------------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">to</p></td><td class="selmaho"><p class="selmaho">TO</p></td><td class="description"><p class="description">open parenthesis</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">to'i</p></td><td class="selmaho"><p class="selmaho">TO</p></td><td class="description"><p class="description">open editorial parenthesis</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">toi</p></td><td class="selmaho"><p class="selmaho">TOI</p></td><td class="description"><p class="description">close parenthesis</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">sei</p></td><td class="selmaho"><p class="selmaho">SEI</p></td><td class="description"><p class="description">metalinguistic bridi marker</p></td></tr></tbody></table>

The cmavo _<a id="id-1.20.14.4.1.1" class="indexterm"></a>[_to_](../go01#valsi-to)_ and _<a id="id-1.20.14.4.2.1" class="indexterm"></a>[_toi_](../go01#valsi-toi)_ are discursive (non-mathematical) parentheses, for inserting parenthetical remarks. Any text whatsoever can go within the parentheses, and it is completely invisible to its context. It can, however, refer to the context by the use of pro-sumti and pro-bridi: any that have been assigned in the context are still assigned in the parenthetical remarks, but the reverse is not true.

<div class="interlinear-gloss-example example">
<a id="example-random-id-FHJi"></a>

**Example 19.66. <a id="c19e12d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.lisas.</td><td>mi</td><td>djica</td><td>le</td><td>nu</td><td>to</td><td>doi</td><td>.frank.</td></tr><tr class="gloss"><td>O</td><td>Lisa,</td><td>I</td><td>desire</td><td>the</td><td>event-of</td><td>(</td><td>O</td><td>Frank,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ko</td><td>sisti</td><td>toi</td><td>do</td><td>viska</td><td>le</td><td>mlatu</td></tr><tr class="gloss"><td>[imperative]</td><td>stop!</td><td>)</td><td>you</td><td>see</td><td>the</td><td>cat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lisa, I want you to (Frank! Stop!) see the cat.</p></td></tr></tbody></table>

</div>  

[Example 19.66](../section-parentheses#example-random-id-FHJi) implicitly redefines _<a id="id-1.20.14.6.2.1" class="indexterm"></a>[_do_](../go01#valsi-do)_ within the parentheses: the listener is changed by _<a id="id-1.20.14.6.3.1" class="indexterm"></a>doi .frank._ When the context sentence resumes, however, the old listener, Lisa, is automatically restored.

<a id="id-1.20.14.7.1" class="indexterm"></a>There is another cmavo of selma'o TO: _<a id="id-1.20.14.7.2.1" class="indexterm"></a>[_to'i_](../go01#valsi-tohi)_. The difference between _<a id="id-1.20.14.7.3.1" class="indexterm"></a>[_to_](../go01#valsi-to)_ and _<a id="id-1.20.14.7.4.1" class="indexterm"></a>[_to'i_](../go01#valsi-tohi)_ is the difference between parentheses and square brackets in English prose. Remarks within _<a id="id-1.20.14.7.5.1" class="indexterm"></a>to ... toi_ cmavo are implicitly by the same speaker, whereas remarks within _<a id="id-1.20.14.7.6.1" class="indexterm"></a>to'i ... toi_ are implicitly by someone else, perhaps an editor:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hXIi"></a>

**Example 19.67. <a id="c19e12d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .frank. cusku lu mi prami do to'isa'a do du la .djein. toi li'u</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank expresses <span class="quote">“<span class="quote">I love you [you = Jane]</span>”</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.20.14.9.1" class="indexterm"></a><a id="id-1.20.14.9.2" class="indexterm"></a>The _<a id="id-1.20.14.9.3.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ suffix is a discursive cmavo (of selma'o UI) meaning “editorial insertion” , and indicating that the marked word or construct (in this case, the entire bracketed remark) is not part of the quotation. It is required whenever the _<a id="id-1.20.14.9.5.1" class="indexterm"></a>to'i ... toi_ remark is physically within quotation marks, at least when speaking to literal-minded listeners; the convention may be relaxed if no actual confusion results.

Note: The parser believes that parentheses are attached to the previous word or construct, because it treats them as syntactic equivalents of subscripts and other such so-called “free modifiers”. Semantically, however, parenthetical remarks are not necessarily attached either to what precedes them or what follows them.

<a id="id-1.20.14.11.1" class="indexterm"></a><a id="id-1.20.14.11.2" class="indexterm"></a><a id="id-1.20.14.11.3" class="indexterm"></a>The cmavo _<a id="id-1.20.14.11.4.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ (of selma'o SEI) begins an embedded discursive bridi. Comments added with _<a id="id-1.20.14.11.5.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ are called “metalinguistic” , because they are comments about the discourse itself rather than about the subject matter of the discourse. This sense of the term “metalinguistic” is used throughout this chapter, and is not to be confused with the sense “language for expressing other languages”.

When marked with _<a id="id-1.20.14.12.1.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ , a metalinguistic utterance can be embedded in another utterance as a discursive. In this way, discursives which do not have cmavo assigned in selma'o UI can be expressed:

<div class="interlinear-gloss-example example">
<a id="example-random-id-jA1T"></a>

**Example 19.68. <a id="c19e12d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .frank. prami sei la .frank. gleki la .djein.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank loves (Frank is happy) Jane.</p></td></tr></tbody></table>

</div>  

Using the happiness attitudinal, _<a id="id-1.20.14.14.1.1" class="indexterm"></a>[_.ui_](../go01#valsi-ui)_ , would imply that the speaker was happy. Instead, the speaker attributes happiness to Frank. It would probably be safe to elide the one who is happy, and say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-vago"></a>

**Example 19.69. <a id="c19e12d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .frank. prami sei gleki la .djein.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank loves (he is happy) Jane.</p></td></tr></tbody></table>

</div>  

The grammar of the bridi following _<a id="id-1.20.14.16.1.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ has an unusual limitation: the sumti must either precede the selbri, or must be glued into the selbri with _<a id="id-1.20.14.16.2.1" class="indexterm"></a>[_be_](../go01#valsi-be)_ and _<a id="id-1.20.14.16.3.1" class="indexterm"></a>[_bei_](../go01#valsi-bei)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-sz7v"></a>

**Example 19.70. <a id="c19e12d5"></a><a id="id-1.20.14.17.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .frank. prami sei gleki be fa la .suzn. la .djein.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank loves (Susan is happy) Jane.</p></td></tr></tbody></table>

</div>  

This restriction allows the terminator cmavo _<a id="id-1.20.14.18.1.1" class="indexterm"></a>[_se'u_](../go01#valsi-sehu)_ to almost always be elided.

<a id="id-1.20.14.19.1" class="indexterm"></a><a id="id-1.20.14.19.2" class="indexterm"></a><a id="id-1.20.14.19.3" class="indexterm"></a><a id="id-1.20.14.19.4" class="indexterm"></a>Since a discursive utterance is working at a “higher” level of abstraction than a non-discursive utterance, a non-discursive utterance cannot refer to a discursive utterance. Specifically, the various back-counting, reciprocal, and reflexive constructs in selma'o KOhA ignore the utterances at “higher” metalinguistic levels in determining their referent. It is possible, and sometimes necessary, to refer to lower metalinguistic levels. For example, the English “he said” in a conversation is metalinguistic. For this purpose, quotations are considered to be at a lower metalinguistic level than the surrounding context (a quoted text cannot refer to the statements of the one who quotes it), whereas parenthetical remarks are considered to be at a higher level than the context.

Lojban works differently from English in that the “he said” can be marked instead of the quotation. In Lojban, you can say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-DY0u"></a>

**Example 19.71. <a id="c19e12d6"></a><a id="id-1.20.14.21.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cusku</td><td>lu</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>li'u</td></tr><tr class="gloss"><td></td><td>John</td><td>expresses</td><td>[quote]</td><td>I</td><td>go-to</td><td>the</td><td>store</td><td>[unquote].</td></tr></tbody></table>

</div>  

which literally claims that John uttered the quoted text. If the central claim is that John made the utterance, as is likely in conversation, this style is the most sensible. However, in written text which quotes a conversation, you don't want the “he said” or “she said” to be considered part of the conversation. If unmarked, it could mess up the anaphora counting. Instead, you can use:

<div class="interlinear-gloss-example example">
<a id="example-random-id-b7Fi"></a>

**Example 19.72. <a id="c19e12d7"></a><a id="id-1.20.14.23.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lu</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>seisa'a</td></tr><tr class="gloss"><td>[quote]</td><td>I</td><td>go-to</td><td>the</td><td>store</td><td>(</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cusku</td><td>be</td><td>dei</td><td>li'u</td></tr><tr class="gloss"><td></td><td>John</td><td>expresses</td><td></td><td>this-sentence</td><td>)[unquote]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span class="quote">“<span class="quote">I go to the store</span>”</span> , said John.</p></td></tr></tbody></table>

</div>  

And of course other orders are possible:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qIUa"></a>

**Example 19.73. <a id="c19e12d8"></a><a id="id-1.20.14.25.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">lu seisa'a la .djan. cusku be dei mi klama le zarci</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John said, <span class="quote">“<span class="quote">I go to the store</span>”</span>.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qIuI"></a>

**Example 19.74. <a id="c19e12d9"></a><a id="id-1.20.14.26.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">lu mi klama seisa'a la djan cusku le zarci</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span class="quote">“<span class="quote">I go</span>”</span> , John said, <span class="quote">“<span class="quote">to the store</span>”</span>.</p></td></tr></tbody></table>

</div>  

Note the _<a id="id-1.20.14.27.1.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ following each _<a id="id-1.20.14.27.2.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ , marking the _<a id="id-1.20.14.27.3.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ and its attached bridi as an editorial insert, not part of the quotation. In a more relaxed style, these _<a id="id-1.20.14.27.4.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ cmavo would probably be dropped.

The elidable terminator for _<a id="id-1.20.14.28.1.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ is _<a id="id-1.20.14.28.2.1" class="indexterm"></a>[_se'u_](../go01#valsi-sehu)_ (of selma'o SEhU); it is rarely needed, except to separate a selbri within the _<a id="id-1.20.14.28.3.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ comment from an immediately following selbri (or component) outside the comment.