<a id="section-other-negation"></a>15.7. <a id="c15s7"></a>Negation of minor grammatical constructs
---------------------------------------------------------------------------------------------------

We have a few other constructs that can be negated, all of them based on negating individual words. For such negation, we use the suffix-combining negator, which is _<a id="id-1.16.9.2.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_. _<a id="id-1.16.9.2.2.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ , by the way, is almost always written as a compound into the previous word that it is negating, although it is a regular separate-word cmavo and the sole member of selma'o NAI.

Most of these negation forms are straightforward, and should be discussed and interpreted in connection with an analysis of the particular construct being negated. Thus, we will not go into much detail here.

The following are places where _<a id="id-1.16.9.4.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ is used:

When attached to tenses and modals (see [Section 9.13](../section-modal-negation) , [Section 10.9](../section-interval-properties) , [Section 10.18](../section-tense-negation) and [Section 10.20](../section-connected-tenses)), the _<a id="id-1.16.9.5.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ suffix usually indicates a contradictory negation of the tagged bridi. Thus _<a id="id-1.16.9.5.6.1" class="indexterm"></a>punai_ as a tense inflection means “not-in-the-past” , or “not-previously” , without making any implication about any other time period unless explicitly stated. As a result,

<div class="interlinear-gloss-example example">
<a id="example-random-id-PprX"></a>

**Example 15.77. <a id="c15e7d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[false]</td><td>[past]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I didn't go to the store.</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-0hv2"></a>

**Example 15.78. <a id="c15e7d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>punai</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past-not]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I didn't go to the store.</p></td></tr></tbody></table>

</div>  

mean exactly the same thing, although there may be a difference of emphasis.

Tenses and modals can be logically connected, with the logical connectives containing contradictory negations; this allows negated tenses and modals to be expressed positively using logical connectives. Thus _<a id="id-1.16.9.10.1.1" class="indexterm"></a>punai je ca_ means the same thing as _<a id="id-1.16.9.10.2.1" class="indexterm"></a>pu naje ca_.

As a special case, a _<a id="id-1.16.9.11.1.1" class="indexterm"></a>\-nai_ attached to the interval modifiers of selma'o TAhE, ROI, or ZAhO (explained in [Chapter 10](../chapter-tenses)) signals a scalar negation:

<div class="interlinear-gloss-example example">
<a id="example-random-id-4YYQ"></a>

**Example 15.79. <a id="c15e7d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>paroinai</td><td>dansu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>I</td><td>[once]-[not]</td><td>dance-on</td><td>the</td><td>ice</td></tr></tbody></table>

</div>  

means that I dance on the ice either zero or else two or more times within the relevant time interval described by the bridi. [Example 15.79](../section-other-negation#example-random-id-4YYQ) is very different from the English use of “not once” , which is an emphatic way of saying “never” – that is, exactly zero times.

In indicators and attitudinals of selma'o UI or CAI, _<a id="id-1.16.9.14.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ denotes a polar negation. As discussed in [Section 13.4](../section-intensity-scale) , most indicators have an implicit scale, and _<a id="id-1.16.9.14.3.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ changes the indicator to refer to the opposite end of the scale. Thus _<a id="id-1.16.9.14.4.1" class="indexterm"></a>[_.uinai_](../go01#valsi-uinai)_ expresses unhappiness, and _<a id="id-1.16.9.14.5.1" class="indexterm"></a>[_.ienai_](../go01#valsi-ienai)_ expresses disagreement (not ambivalence, which is expressed with the neutral or undecided intensity as _<a id="id-1.16.9.14.6.1" class="indexterm"></a>.iecu'i_).

Vocative cmavo of selma'o COI are considered a kind of indicator, but one which identifies the listener. Semantically, we could dispense with about half of the COI selma'o words based on the scalar paradigm. For example, _<a id="id-1.16.9.15.1.1" class="indexterm"></a>[_co'o_](../go01#valsi-coho)_ could be expressed as _<a id="id-1.16.9.15.2.1" class="indexterm"></a>coinai_. However, this is not generally done.

Most of the COI cmavo are used in what are commonly called protocol situations. These protocols are used, for example, in radio conversations, which often take place in a noisy environment. The negatives of protocol words tend to convey diametrically opposite communications situations (as might be expected). Therefore, only one protocol vocative is dependent on _<a id="id-1.16.9.16.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ : negative acknowledgement, which is _<a id="id-1.16.9.16.2.1" class="indexterm"></a>[_je'enai_](../go01#valsi-jehenai)_ ( “I didn't get that”).

Unlike the attitudinal indicators, which tend to be unimportant in noisy situations, the protocol vocatives become more important. So if, in a noisy environment, a protocol listener makes out only _<a id="id-1.16.9.17.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ , he or she can presume it is a negative acknowledgement and repeat transmission or otherwise respond accordingly. [Section 13.14](../section-vocative-scales) provides more detail on this topic.

The abstractors of selma'o NU follow the pattern of the tenses and modals. NU allows negative abstractions, especially in compound abstractions connected by logical connectives: _<a id="id-1.16.9.18.1.1" class="indexterm"></a>pu'ujeza'inai_ , which corresponds to _<a id="id-1.16.9.18.2.1" class="indexterm"></a>pu'u jenai za'i_ just as _<a id="id-1.16.9.18.3.1" class="indexterm"></a>punai je ca_ corresponds to _<a id="id-1.16.9.18.4.1" class="indexterm"></a>pu naje ca_. It is not clear how much use logically connected abstractors will be: see [Section 11.12](../section-abstractor-connection).

A _<a id="id-1.16.9.19.1.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ attached to a non-logical connective (of selma'o JOI or BIhI) is a scalar negation, and says that the bridi is false under the specified mixture, but that another connective is applicable. Non-logical connectives are discussed in [Section 14.14](../section-non-logical-connectives).