<a id="section-order-of-places"></a>12.7. <a id="c12s7"></a>Ordering lujvo places.
----------------------------------------------------------------------------------

<a id="id-1.13.9.2.1" class="indexterm"></a>So far, we have concentrated on selecting the places to go into the place structure of a lujvo. However, this is only half the story. In using selbri in Lojban, it is important to remember the right order of the sumti. With lujvo, the need to attend to the order of sumti becomes critical: the set of places selected should be ordered in such a way that a reader unfamiliar with the lujvo should be able to tell which place is which.

<a id="id-1.13.9.3.1" class="indexterm"></a>If we aim to make understandable lujvo, then, we should make the order of places in the place structure follow some conventions. If this does not occur, very real ambiguities can turn up. Take for example the lujvo _<a id="id-1.13.9.3.2.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ , meaning “prayer”. In the sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-FfWn"></a>

**Example 12.29. <a id="c12e7d1"></a><a id="id-1.13.9.4.1.2" class="indexterm"></a><a id="id-1.13.9.4.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>di'e</td><td>jdaselsku</td><td></td><td>la</td><td>.dong.</td></tr><tr class="gloss"><td>This-utterance</td><td>is-a-prayer</td><td>somehow-related-to</td><td>that-named</td><td>Dong.</td></tr></tbody></table>

</div>  

we must be able to know if Dong is the person making the prayer, giving the meaning

<div class="example">
<a id="example-random-id-b38f"></a>

**Example 12.30. <a id="c12e7d2"></a><a id="id-1.13.9.6.1.2" class="indexterm"></a><a id="id-1.13.9.6.1.3" class="indexterm"></a>** 

This is a prayer by Dong

</div>  

or is the entity being prayed to, resulting in

<div class="example">
<a id="example-random-id-uL3V"></a>

**Example 12.31. <a id="c12e7d3"></a><a id="id-1.13.9.8.1.2" class="indexterm"></a><a id="id-1.13.9.8.1.3" class="indexterm"></a>** 

This is a prayer to Dong

</div>  

We could resolve such problems on a case-by-case basis for each lujvo ( [Section 12.14](../section-anomalous-lujvo) discusses when this is actually necessary), but case-by-case resolution for run-of-the-mill lujvo makes the task of learning lujvo place structures unmanageable. People need consistent patterns to make sense of what they learn. Such patterns can be found across gismu place structures (see [Section 12.16](../section-gismu-place-structures)), and are even more necessary in lujvo place structures. Case-by-case consideration is still necessary; lujvo creation is a subtle art, after all. But it is helpful to take advantage of any available regularities.

<a id="id-1.13.9.10.1" class="indexterm"></a><a id="id-1.13.9.10.2" class="indexterm"></a>We use two different ordering rules: one for symmetrical lujvo and one for asymmetrical ones. A symmetrical lujvo like _<a id="id-1.13.9.10.3.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ (from [Section 12.5](../section-symmetrical-asymmetrical)) has the places of its tertau followed by whatever places of the seltau survive the elimination process. For _<a id="id-1.13.9.10.5.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ , the surviving places of _<a id="id-1.13.9.10.6.1" class="indexterm"></a>[_banli_](../go01#valsi-banli)_ are b2 and b3, leading to the place structure:

<div class="example">
<a id="example-random-id-rv1m"></a>

**Example 12.32. <a id="c12e7d4"></a><a id="id-1.13.9.11.1.2" class="indexterm"></a>** 

> b1=s1 is a great soldier of army s2 in property b2 by standard b3

</div>  

just what appears in [Example 12.11](../section-symmetrical-asymmetrical#example-random-id-7AFc). In fact, all place structures shown until now have been in the correct order by the conventions of this section, though the fact has been left tacit until now.

The motivation for this rule is the parallelism between the lujvo bridi-schema

<div class="interlinear-gloss-example example">
<a id="example-random-id-7juc"></a>

**Example 12.33. <a id="c12e7d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>b1</td><td>balsoi</td><td>s2</td><td>b2</td><td>b3</td></tr><tr class="gloss"><td>b1</td><td>is-a-great-soldier</td><td>of-army-s2</td><td>in-property-b2</td><td>by-standard-b3</td></tr></tbody></table>

</div>  

and the more or less equivalent bridi-schema

<div class="interlinear-gloss-example example">
<a id="example-random-id-LzCP"></a>

**Example 12.34. <a id="c12e7d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>b1</td><td>sonci</td><td>s2</td><td>gi'e</td><td>banli</td><td>b2</td><td>b3</td></tr><tr class="gloss"><td>b1</td><td>is-a-soldier</td><td>of-army-s2</td><td>and</td><td>is-great</td><td>in-property-b2</td><td>by-standard-b3</td></tr></tbody></table>

</div>  

where _<a id="id-1.13.9.17.1.1" class="indexterm"></a>[_gi'e_](../go01#valsi-gihe)_ is the Lojban word for “and” when placed between two partial bridi, as explained in [Section 14.9](../section-compound-bridi).

<a id="id-1.13.9.18.1" class="indexterm"></a><a id="id-1.13.9.18.2" class="indexterm"></a>Asymmetrical lujvo like _<a id="id-1.13.9.18.3.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ , on the other hand, employ a different rule. The seltau places are inserted not at the end of the place structure, but rather immediately after the tertau place which is equivalent to the first place of the seltau. Consider _<a id="id-1.13.9.18.4.1" class="indexterm"></a>[_dalmikce_](../go01#valsi-dalmikce)_ , meaning “veterinarian” : its veljvo is _<a id="id-1.13.9.18.6.1" class="indexterm"></a>danlu mikce_ , or “animal doctor”. The place structures for those gismu are:

<div class="example">
<a id="example-random-id-BqPj"></a>

**Example 12.35. <a id="c12e7d7"></a>** 

_<a id="id-1.13.9.19.2.1.1" class="indexterm"></a>[_danlu_](../go01#valsi-danlu)_ : d1 is an animal of species d2

_<a id="id-1.13.9.19.3.1.1" class="indexterm"></a>[_mikce_](../go01#valsi-mikce)_ : m1 is a doctor to patient m2 for ailment m3 using treatment m4

</div>  

<a id="id-1.13.9.20.1" class="indexterm"></a>and the lujvo place structure is:

<div class="example">
<a id="example-random-id-WeBW"></a>

**Example 12.36. <a id="c12e7d8"></a><a id="id-1.13.9.21.1.2" class="indexterm"></a>** 

> m1 is a doctor for animal m2=d1 of species d2 for ailment m3 using treatment m4

</div>  

<a id="id-1.13.9.22.1" class="indexterm"></a>Since the shared place is m2=d1, the animal patient, the remaining seltau place d2 is inserted immediately after the shared place; then the remaining tertau places form the last two places of the lujvo.