<a id="section-oddball-orthographies"></a>3.12. <a id="c3s12"></a>Oddball orthographies
---------------------------------------------------------------------------------------

<a id="id-1.4.14.2.1" class="indexterm"></a>The following notes describe ways in which Lojban has been written or could be written that differ from the standard orthography explained in the rest of this chapter. Nobody needs to read this section except people with an interest in the obscure. Technicalities are used without explanation or further apology.

There exists an alternative orthography for Lojban, which is designed to be as compatible as possible (but no more so) with the orthography used in pre-Lojban versions of Loglan. The consonants undergo no change, except that _x_ is replaced by _h_. The individual vowels likewise remain unchanged. However, the vowel pairs and diphthongs are changed as follows:

*   _ai_ , _ei_ , _oi_ , _au_ become _ai_ , _ei_ , _oi_ , _ao_.

*   _ia_ through _iu_ and _ua_ through _uu_ remain unchanged.

*   _a'i_ , _e'i_ , _o'i_ and _a'o_ become _a,i_ , _e,i_ , _o,i_ and _a,o_.

*   _i'a_ through _i'u_ and _u'a_ through _u'u_ are changed to _ia_ through _iu_ and _ua_ through _uu_ in lujvo and cmavo other than attitudinals, but become _i,a_ through _i,u_ and _u,a_ through _u,u_ in cmevla, fu'ivla, and attitudinal cmavo.

*   All other vowel pairs simply drop the apostrophe.

The result of these rules is to eliminate the apostrophe altogether, replacing it with comma where necessary, and otherwise with nothing. In addition, names and the cmavo _<a id="id-1.4.14.5.1.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ are capitalized, and irregular stress is marked with an apostrophe (now no longer used for a sound) following the stressed syllable.

Three points must be emphasized about this alternative orthography:

*   <a id="id-1.4.14.7.1.1.1" class="indexterm"></a>It is not standard, and has not been used.

*   It does not represent any changes to the standard Lojban phonology; it is simply a representation of the same phonology using a different written form.

*   It was designed to aid in a planned rapprochement between the Logical Language Group and The Loglan Institute, a group headed by James Cooke Brown. The rapprochement never took place.

<a id="id-1.4.14.8.1" class="indexterm"></a>There also exists a Cyrillic orthography for Lojban which was designed when the introductory Lojban brochure was translated into Russian.

<table><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">а</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">б</span></td></tr><tr><td>b</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">ш</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">c</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">д</span></td></tr><tr><td>d</td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">е</span></td></tr><tr><td>e</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">ф</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">f</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">г</span></td></tr><tr><td>g</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">и</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">ж</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">j</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">к</span></td></tr><tr><td>k</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">л</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">l</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">м</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">m</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">н</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">о</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">п</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">p</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">р</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">с</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">s</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">т</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">t</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">у</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">в</span></td></tr><tr><td>v</td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">х</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">x</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">ъ</span></td></tr><tr><td>y</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="rus" class="phrase" lang="rus">з</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">z</em></span></td></tr></tbody></table></td><td></td></tr></tbody></table>

The Lojban letter “y” is mapped onto the hard sign “ъ” , as in Bulgarian. The apostrophe, comma, and period are unchanged. Diphthongs are written as vowel pairs, as in the Roman representation. Capital Lojban letters are written using corresponding capital Cyrillic letters.

<a id="id-1.4.14.11.1" class="indexterm"></a><a id="id-1.4.14.11.2" class="indexterm"></a>An orthography using the Tengwar of Féanor, a fictional orthography invented by J. R. R. Tolkien and described in the Appendixes to _The Lord Of The Rings_ , has been devised for Lojban. The following mapping, which closely resembles that used for Westron, will be meaningful only to those who have read those appendixes. In brief, the tincotéma and parmatéma are used in the conventional ways; the calmatéma represents palatal consonants, and the quessetéma represents velar consonants.

<table><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">tinco</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">t</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">calma</span></td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">ando</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">d</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">anga</span></td></tr><tr><td>-</td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">thule</span></td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">harma</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">c</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">anto</span></td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">anca</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">j</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">numen</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">noldo</span></td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">ore</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">anna</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">parma</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">p</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">quesse</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">k</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">umbar</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">b</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">ungwe</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">g</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">formen</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">f</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">hwesta</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">x</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">ampa</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">v</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">unque</span></td></tr><tr><td>-</td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">malta</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">m</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">nwalme</span></td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">vala</span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="qya" class="phrase" lang="qya">vilya</span></td></tr><tr><td>-</td></tr></tbody></table></td></tr></tbody></table>

The letters “vala” and “anna” are used for _u_ and _i_ only when those letters are used to represent glides. Of the additional letters, _r_ , _l_ , _s_ , and _z_ are written with “rómen” , “lambe” , “silme” , and “áre” / “esse” respectively; the inverted forms are used as free variants.

<a id="id-1.4.14.14.1" class="indexterm"></a><a id="id-1.4.14.14.2" class="indexterm"></a>Finally, the zbalermorna orthography exists, which is completely unofficial.

In this orthography each symbol is made of a base “radical element”, which represents a consonant, which is then modified, if necessary, by another smaller symbol called a “diacritic element”, which represents a vowel.

If the consonant is not followed by a vowel then no diacritic element is used.

The set of radical elements in zbalermorna:

<table><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">p</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">t</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">k</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">f</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">b</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">d</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">g</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">v</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">l</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">s</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">c</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">m</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">z</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">j</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span></td></tr></tbody></table></td></tr><tr><td colspan="4"><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">x</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">'</em></span></td></tr></tbody></table></td><td colspan="2"><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">combining .y'y.bu</em></span></td></tr></tbody></table></td></tr><tr><td colspan="2"><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span> (only before vowels)</td></tr></tbody></table></td><td colspan="2"><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span> (only before vowels)</td></tr></tbody></table></td></tr></tbody></table>

The set of diacritic elements:

<table><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">y</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">au</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ai</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ei</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">oi</em></span></td></tr></tbody></table></td></tr></tbody></table>

Diacritic elements are written above radical elements, e.g. “__” (“drani”), “__” (“roda”), “__” (“rode”), “__” (“rodi”).

Words in zbalermorna are separated with spaces.

The radical element for the Lojban letter “i” (“__”) is only used in front of vowels; it is not interchangeable with “ __ ”. Similarly, the element for “u” (“__”) is only used in front of vowels and is not interchangeable with “ __ ”).

When a fu'ivla or a cmavo starts with “i” or “u” and a vowel follows it then in zbalermorna the radical for the initial period is not used.

An example would be “_  _” (“do .io .ui” with no initial periods).

The symbol for the period after the word can also be optionally omitted for the word of any class in cases when this word is the last word of the text and in cases when the current and the next word are separated with space. Periods in front of and after cmevla are not required, and are discouraged from being used when they are at text borders or separated by space from other words.

In zbalermorna there is an alternate form of the apostrophe called the “combining .y'y.bu” or “attitudinal shorthand”; it exists to make it more natural to write a period and an apostrophe in two consecutive syllables (a sequence, which represents the majority of the set of attitudinals). The “combining .y'y.bu” spans over both syllables and replaces the radical elements in them.

Examples would be “__” (“.i'i”), “__” (“.a'e”), “__” (“.y'y.bu”).

There is an additional set of elements for vowels, called “full vowel elements”:

<table><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span></td></tr></tbody></table></td></tr><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">y</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">au</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ai</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ei</em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="zlm" class="foreignphrase" lang="zlm"><em xml:lang="zlm" class="foreignphrase" lang="zlm"></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">oi</em></span></td></tr></tbody></table></td></tr></tbody></table>

These full vowels elements are to be used in cmevla and fu'ivla instead of diacritic elements. Symbols “__” (for _i_ before vowels) and “__” (for _u_ before vowels) are used as previously explained. Examples of cmevla would be “__” (“.katrinas.” with no periods), “__” (“.djein.” with no periods).

There are two reasons for using full vowel elements.

Firstly, to give a distinct visual style and flavour to cmevla and fu'ivla.

Secondly, to implement some functionality of the comma. In standard orthography the comma can be used to separate consecutive vowels into different syllables. In the zbalermorna orthography, full vowel elements can be used to represent a comma and a following vowel. An example would be “__” (“.uein.”) as opposed to “__” (“.ue,in.”).