<a id="section-non-logical-continued"></a>14.15. <a id="c14s15"></a>More about non-logical connectives
------------------------------------------------------------------------------------------------------

<a id="id-1.15.17.2.1" class="indexterm"></a><a id="id-1.15.17.2.2" class="indexterm"></a><a id="id-1.15.17.2.3" class="indexterm"></a><a id="id-1.15.17.2.4" class="indexterm"></a>The final three JOI cmavo, _<a id="id-1.15.17.2.5.1" class="indexterm"></a>[_jo'e_](../go01#valsi-johe)_ , _<a id="id-1.15.17.2.6.1" class="indexterm"></a>[_ku'a_](../go01#valsi-kuha)_ , and _<a id="id-1.15.17.2.7.1" class="indexterm"></a>[_pi'u_](../go01#valsi-pihu)_ , are probably only useful when talking explicitly about sets. They represent three standard set operators usually called “union” , “intersection” , and “cross product” (also known as “Cartesian product”). The union of two sets is a set containing all the members that are in either set; the intersection of two sets is a set containing all the members that are in both sets. The cross product of two sets is the set of all possible ordered pairs, where each ordered pair contains a single element from the first set followed by a single element from the second. This may seem very abstract; hopefully, the following examples will help:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGSA"></a>

**Example 14.125. <a id="c14e15d1"></a><a id="id-1.15.17.3.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'i</td><td>ricfu</td><td>ku</td><td>jo'e</td><td>lo'i</td><td>dotco</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>The-set-of</td><td>rich-things</td><td></td><td>union</td><td>the-set-of</td><td>German-things</td><td></td><td>is-large.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgSe"></a>

**Example 14.126. <a id="c14e15d2"></a><a id="id-1.15.17.4.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'i</td><td>ricfu</td><td>ku</td><td>ku'a</td><td>lo'i</td><td>dotco</td><td>cu</td><td>cmalu</td></tr><tr class="gloss"><td>The-set-of</td><td>rich-things</td><td></td><td>intersection</td><td>the-set-of</td><td>German-things</td><td></td><td>is-small.</td></tr></tbody></table>

</div>  

<a id="id-1.15.17.5.1" class="indexterm"></a><a id="id-1.15.17.5.2" class="indexterm"></a>There is a parallelism between logic and set theory that makes [Example 14.125](../section-non-logical-continued#example-random-id-qGSA) and [Example 14.126](../section-non-logical-continued#example-random-id-qgSe) equivalent respectively to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-azCQ"></a>

**Example 14.127. <a id="c14e15d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'i</td><td>ricfu</td><td>ja</td><td>dotco</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>The-set-of</td><td>(rich-things</td><td>or</td><td>German-things)</td><td></td><td>is-large.</td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-QjD7"></a>

**Example 14.128. <a id="c14e15d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'i</td><td>ricfu</td><td>je</td><td>dotco</td><td>cu</td><td>cmalu</td></tr><tr class="gloss"><td>The-set-of</td><td>(rich-things</td><td>and</td><td>German-things)</td><td></td><td>is-small.</td></tr></tbody></table>

</div>  

The following example uses _<a id="id-1.15.17.9.1.1" class="indexterm"></a>se remei_ , which is a set (not a mass) of two elements:

<div class="interlinear-gloss-example example">
<a id="example-random-id-D9gz"></a>

**Example 14.129. <a id="c14e15d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>ce[bo]</td><td>la</td><td>.djordj.</td><td>pi'u</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>and-set</td><td>that-named</td><td>George</td><td>cross-product</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.meris.</td><td>cebo</td><td>la</td><td>.martas.</td><td>cu</td><td>prami</td><td>se</td><td>remei</td></tr><tr class="gloss"><td>that-named</td><td>Mary</td><td>and-set</td><td>that-named</td><td>Martha</td><td></td><td>are-lover</td><td></td><td>type-of-pairs.</td></tr></tbody></table>

</div>  

<a id="id-1.15.17.11.1" class="indexterm"></a><a id="id-1.15.17.11.2" class="indexterm"></a><a id="id-1.15.17.11.3" class="indexterm"></a><a id="id-1.15.17.11.4" class="indexterm"></a>means that each of the pairs James/Mary, George/Mary, James/Martha, and George/Martha love each other. Therefore it is similar in meaning to [Example 14.121](../section-non-logical-connectives#example-random-id-7bv3) ; however, that example speaks only of the men loving the women, not vice versa.

<a id="id-1.15.17.12.1" class="indexterm"></a><a id="id-1.15.17.12.2" class="indexterm"></a><a id="id-1.15.17.12.3" class="indexterm"></a>Joiks may be combined with _<a id="id-1.15.17.12.4.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ or with _<a id="id-1.15.17.12.5.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ in the same way as eks and jeks; this allows grouping of non-logical connections between sumti and tanru units, in complete parallelism with logical connections:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mwpo"></a>

**Example 14.130. <a id="c14e15d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>joibo</td><td>do</td><td>ce</td><td>la</td><td>.djan.</td><td>joibo</td><td>la</td><td>.djein.</td></tr><tr class="gloss"><td>(I</td><td>massed-with</td><td>you)</td><td>and</td><td>(that-named</td><td>John</td><td>massed-with</td><td>that-named</td><td>Jane)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>cu</td><td>gunma</td><td>se</td><td>remei</td></tr><tr class="gloss"><td></td><td>are-a-mass</td><td></td><td>type-of-two-set</td></tr></tbody></table>

</div>  

asserts that there is a set of two items each of which is a mass.

<a id="id-1.15.17.15.1" class="indexterm"></a><a id="id-1.15.17.15.2" class="indexterm"></a>Non-logical connection is permitted at the joint of a termset; this is useful for associating more than one sumti or tagged sumti with each side of the non-logical connection. The place structure of _<a id="id-1.15.17.15.3.1" class="indexterm"></a>[_casnu_](../go01#valsi-casnu)_ is:

> _<a id="id-1.15.17.16.1.1.1" class="indexterm"></a>[_casnu_](../go01#valsi-casnu)_ the mass x1 discusses/talks about x2

so the x1 place must be occupied by a mass (for reasons not explained here); however, different components of the mass may discuss in different languages. To associate each participant with his or her language, we can say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-sdba"></a>

**Example 14.131. <a id="c14e15d7"></a><a id="id-1.15.17.18.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ce'e</td><td>bau</td><td>la</td><td>.lojban.</td><td>pe'e</td><td>joi</td></tr><tr class="gloss"><td>(I</td><td>[plus]</td><td>in-language</td><td>that-named</td><td>Lojban</td><td>[joint]</td><td>massed-with</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>ce'e</td><td>bau</td><td>la</td><td>.gliban.</td><td>casnu</td></tr><tr class="gloss"><td>you</td><td>[plus]</td><td>in-language</td><td>that-named</td><td>English</td><td>discuss.</td></tr></tbody></table>

</div>  

Like all non-logical connectives, the usage shown in [Example 14.131](../section-non-logical-continued#example-random-id-sdba) cannot be mechanically converted into a non-logical connective placed at another location in the bridi. The forethought equivalent of [Example 14.131](../section-non-logical-continued#example-random-id-sdba) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-DgXI"></a>

**Example 14.132. <a id="c14e15d8"></a>** 

<a id="id-1.15.17.20.2.1" class="indexterm"></a>nu'i joigi mi bau la .lojban. gi do bau la .gliban. nu'u casnu

</div>  

<a id="id-1.15.17.21.1" class="indexterm"></a><a id="id-1.15.17.21.2" class="indexterm"></a><a id="id-1.15.17.21.3" class="indexterm"></a>Non-logical forethought termsets are also useful when the things to be non-logically connected are sumti preceded with tense or modal (BAI) tags:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wVSG"></a>

**Example 14.133. <a id="c14e15d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>fa'u</td><td>la</td><td>.frank.</td><td>cusku</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>respectively-with</td><td>that-named</td><td>Frank</td><td>express</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nu'i</td><td>fa'ugi</td><td>bau</td><td>la</td><td>.lojban.</td></tr><tr class="gloss"><td>[start-termset]</td><td>[respectively-with]</td><td>in-language</td><td>that-named</td><td>Lojban</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nu'u</td><td>gi</td><td>bai</td></tr><tr class="gloss"><td>[joint]</td><td>and</td><td>under-compulsion-by</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tu'a</td><td>la</td><td>.djordj.</td><td>[nu'u]</td></tr><tr class="gloss"><td>something-about</td><td>that-named</td><td>George.</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John and Frank speak in Lojban and under George's compulsion, respectively.</p></td></tr></tbody></table>

</div>  

[Example 14.133](../section-non-logical-continued#example-random-id-wVSG) associates speaking in Lojban with John, and speaking under George's compulsion with Frank. We do not know what language Frank uses, or whether John speaks under anyone's compulsion.

<a id="id-1.15.17.24.1" class="indexterm"></a><a id="id-1.15.17.24.2" class="indexterm"></a><a id="id-1.15.17.24.3" class="indexterm"></a><a id="id-1.15.17.24.4" class="indexterm"></a><a id="id-1.15.17.24.5" class="indexterm"></a><a id="id-1.15.17.24.6" class="indexterm"></a><a id="id-1.15.17.24.7" class="indexterm"></a>Joiks may be prefixed with _<a id="id-1.15.17.24.8.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ to produce ijoiks, which serve to non-logically connect sentences. The ijoik _<a id="id-1.15.17.24.9.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.17.24.10.1" class="indexterm"></a>[_ce'o_](../go01#valsi-ceho)_ indicates that the event of the second bridi follows that of the first bridi in some way other than a time relationship (which is handled with a tense):

<div class="interlinear-gloss-example example">
<a id="example-random-id-27xU"></a>

**Example 14.134. <a id="c14e15d10"></a><a id="id-1.15.17.25.1.2" class="indexterm"></a><a id="id-1.15.17.25.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>gasnu</td><td>la'e</td><td>di'e</td><td>.i</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>do</td><td>the-referent-of</td><td>the-following:</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tu'e</td><td>kanji</td><td>lo</td><td>ni</td><td>cteki</td><td>.ice'o</td><td>lumci</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>(</td><td>Compute</td><td>the</td><td>quantity-of</td><td>taxes.</td><td>And-then</td><td>wash</td><td>the</td><td>car.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ice'o</td><td>dzukansa</td><td>le</td><td>gerku</td><td>tu'u</td></tr><tr class="gloss"><td>And-then</td><td>walkingly-accompany</td><td>the</td><td>dog.</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">List of things to do: Figure taxes. Wash car. Walk dog.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.17.26.1" class="indexterm"></a><a id="id-1.15.17.26.2" class="indexterm"></a><a id="id-1.15.17.26.3" class="indexterm"></a><a id="id-1.15.17.26.4" class="indexterm"></a>[Example 14.134](../section-non-logical-continued#example-random-id-27xU) represents a list of things to be done in priority order. The order is important, hence the need for a sequence connective, but does not necessarily represent a time order (the dog may end up getting walked first). Note the use of _<a id="id-1.15.17.26.6.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ and _<a id="id-1.15.17.26.7.1" class="indexterm"></a>[_tu'u_](../go01#valsi-tuhu)_ as general brackets around the whole list. This is related to, but distinct from, their use in [Section 14.8](../section-afterthought-connectives-grouping) , because there is no logical connective between the introductory phrase _<a id="id-1.15.17.26.9.1" class="indexterm"></a>mi ba gasnu la'edi'e_ and the rest. The brackets effectively show how large an utterance the word _<a id="id-1.15.17.26.10.1" class="indexterm"></a>[_di'e_](../go01#valsi-dihe)_ , which means “the following utterance” , refers to.

Similarly, _<a id="id-1.15.17.27.1.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.17.27.2.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ is used to connect sentences that represent the components of a joint event such as a joint cause: the Lojban equivalent of “Fran hit her head and fell out of the boat, so that she drowned” would join the events “Fran hit her head” and “Fran fell out of the boat” with _<a id="id-1.15.17.27.6.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.17.27.7.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_.

<a id="id-1.15.17.28.1" class="indexterm"></a><a id="id-1.15.17.28.2" class="indexterm"></a><a id="id-1.15.17.28.3" class="indexterm"></a><a id="id-1.15.17.28.4" class="indexterm"></a>The following _<a id="id-1.15.17.28.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ , if present, does not negate either of the things to be connected, but instead specifies that some other connection (logical or non-logical) is applicable: it is a scalar negation:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mMdb"></a>

**Example 14.135. <a id="c14e15d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jo'u</td><td>nai</td><td>do</td><td>cu</td><td>remei</td></tr><tr class="gloss"><td>I</td><td>in-common-with</td><td>[not!]</td><td>you</td><td></td><td>are-a-twosome</td></tr></tbody></table>

</div>  

The result of _<a id="id-1.15.17.30.1.1" class="indexterm"></a>mi jo'u do_ would be two individuals, not a mass, therefore _<a id="id-1.15.17.30.2.1" class="indexterm"></a>[_jo'u_](../go01#valsi-johu)_ is not applicable; _<a id="id-1.15.17.30.3.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ would be the correct connective.

<a id="id-1.15.17.31.1" class="indexterm"></a><a id="id-1.15.17.31.2" class="indexterm"></a>There is no joik question cmavo as such; however, joiks and ijoiks may be uttered in isolation in response to a logical connective question, as in the following exchange:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGSm"></a>

**Example 14.136. <a id="c14e15d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djica</td><td>tu'a</td><td>loi</td><td>ckafi</td></tr><tr class="gloss"><td>You</td><td>desire</td><td>something-about</td><td>a-mass-of</td><td>coffee</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ji</td><td>loi</td><td>tcati</td></tr><tr class="gloss"><td>[what-connective?]</td><td>a-mass-of</td><td>tea?</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Do you want coffee or tea?</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgsp"></a>

**Example 14.137. <a id="c14e15d13"></a><a id="id-1.15.17.33.1.2" class="indexterm"></a><a id="id-1.15.17.33.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>joi</td></tr><tr class="gloss"><td>Mixed-mass-and.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Both as a mass (i.e, mixed together).</p></td></tr></tbody></table>

</div>  

Ugh. (Or in Lojban: _<a id="id-1.15.17.34.1.1" class="indexterm"></a>[_.a'u_](../go01#valsi-ahu)_ _<a id="id-1.15.17.34.2.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ _<a id="id-1.15.17.34.3.1" class="indexterm"></a>[_sai_](../go01#valsi-sai)_ _<a id="id-1.15.17.34.4.1" class="indexterm"></a>[_ro'o_](../go01#valsi-roho)_.)