<a id="section-non-logical-continued-continued"></a>14.16. <a id="c14s16"></a>Interval connectives and forethought non-logical connection
-----------------------------------------------------------------------------------------------------------------------------------------

<a id="id-1.15.18.2.1" class="indexterm"></a><a id="id-1.15.18.2.2" class="indexterm"></a>In addition to the non-logical connectives of selma'o JOI explained in [Section 14.14](../section-non-logical-connectives) and [Section 14.15](../section-non-logical-continued) , there are three other connectives which can appear in joiks: _<a id="id-1.15.18.2.5.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ , _<a id="id-1.15.18.2.6.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ , and _<a id="id-1.15.18.2.7.1" class="indexterm"></a>[_mi'i_](../go01#valsi-mihi)_ , all of selma'o BIhI. The first two cmavo are used to specify intervals: abstract objects defined by two endpoints. The cmavo _<a id="id-1.15.18.2.8.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ is correct if the endpoints are independent of order, whereas _<a id="id-1.15.18.2.9.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ or _<a id="id-1.15.18.2.10.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ _<a id="id-1.15.18.2.11.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ are used when order matters.

An example of _<a id="id-1.15.18.3.1.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ in sumti connection:

<div class="interlinear-gloss-example example">
<a id="example-random-id-sHhA"></a>

**Example 14.138. <a id="c14e16d1"></a><a id="id-1.15.18.4.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand-on-surface</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.drezdn.</td><td>bi'i</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>that-named</td><td>Dresden</td><td>[interval]</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden and Frankfurt.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.18.5.1" class="indexterm"></a>In [Example 14.138](../section-non-logical-continued-continued#example-random-id-sHhA) , it is all the same whether I am standing between Dresden and Frankfurt or between Frankfurt and Dresden, so _<a id="id-1.15.18.5.3.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ is the appropriate interval connective. The sumti _<a id="id-1.15.18.5.4.1" class="indexterm"></a>la .drezdn. bi'i la .frankfurt._ falls into the x2 place of _<a id="id-1.15.18.5.6.1" class="indexterm"></a>[_sanli_](../go01#valsi-sanli)_ , which is the surface I stand on; the interval specifies that surface by its limits. (Obviously, I am not standing on the whole of the interval; the x2 place of _<a id="id-1.15.18.5.8.1" class="indexterm"></a>[_sanli_](../go01#valsi-sanli)_ specifies a surface which is typically larger in extent than just the size of the stander's feet.)

<div class="interlinear-gloss-example example">
<a id="example-random-id-rYv4"></a>

**Example 14.139. <a id="c14e16d2"></a><a id="id-1.15.18.6.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cadzu</td><td>ca</td><td>la</td><td>.pacac.</td></tr><tr class="gloss"><td>I</td><td>walk</td><td>simultaneous-with</td><td></td><td>First-hour</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'o</td><td>la</td><td>.recac.</td></tr><tr class="gloss"><td>[ordered-interval]</td><td></td><td>Second-hour.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I walk from one o'clock to two o'clock.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.18.7.1" class="indexterm"></a>In [Example 14.139](../section-non-logical-continued-continued#example-random-id-rYv4) , on the other hand, it is essential that _<a id="id-1.15.18.7.3.1" class="indexterm"></a>la .pacac._ comes before _<a id="id-1.15.18.7.4.1" class="indexterm"></a>la .recac._ ; otherwise we have an 11-hour (or 23-hour) interval rather than a one-hour interval. In this use of an interval, the whole interval is probably intended, or at least most of it.

[Example 14.139](../section-non-logical-continued-continued#example-random-id-rYv4) is equivalent to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qqIr"></a>

**Example 14.140. <a id="c14e16d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cadzu</td><td>ca</td><td>la</td><td>.recac.</td></tr><tr class="gloss"><td>I</td><td>walk</td><td>simultaneous-with</td><td></td><td>Second-hour</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>se</td><td>bi'o</td><td>la</td><td>.pacac.</td></tr><tr class="gloss"><td>[reverse]</td><td>[ordered]</td><td></td><td>First-hour.</td></tr></tbody></table>

</div>  

English cannot readily express _<a id="id-1.15.18.10.1.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ _<a id="id-1.15.18.10.2.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ , but its meaning can be understood by reversing the two sumti.

<a id="id-1.15.18.11.1" class="indexterm"></a>The third cmavo of selma'o BIhI, namely _<a id="id-1.15.18.11.2.1" class="indexterm"></a>[_mi'i_](../go01#valsi-mihi)_ , expresses an interval seen from a different viewpoint: not a pair of endpoints, but a center point and a distance. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wm5E"></a>

**Example 14.141. <a id="c14e16d4"></a><a id="id-1.15.18.12.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>jbama</td><td>pu</td><td>daspo</td><td>la</td><td>.uacintyn.</td></tr><tr class="gloss"><td>The</td><td>bomb</td><td>[past]</td><td>destroys</td><td></td><td>Washington</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi'i</td><td>lo</td><td>minli</td><td>be</td><td>li</td><td>muno</td></tr><tr class="gloss"><td>[center]</td><td>what-is</td><td>measured-in-miles</td><td></td><td>by</td><td>50.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The bomb destroyed Washington and fifty miles around.</p></td></tr></tbody></table>

</div>  

Here we have an interval whose center is Washington and whose distance, or radius, is fifty miles.

<a id="id-1.15.18.14.1" class="indexterm"></a><a id="id-1.15.18.14.2" class="indexterm"></a><a id="id-1.15.18.14.3" class="indexterm"></a><a id="id-1.15.18.14.4" class="indexterm"></a><a id="id-1.15.18.14.5" class="indexterm"></a><a id="id-1.15.18.14.6" class="indexterm"></a>In [Example 14.138](../section-non-logical-continued-continued#example-random-id-sHhA) , is it possible that I am standing in Dresden (or Frankfurt) itself? Yes. The connectives of selma'o BIhI are ambiguous about whether the endpoints themselves are included in or excluded from the interval. Two auxiliary cmavo _<a id="id-1.15.18.14.8.1" class="indexterm"></a>[_ga'o_](../go01#valsi-gaho)_ and _<a id="id-1.15.18.14.9.1" class="indexterm"></a>[_ke'i_](../go01#valsi-kehi)_ (of cmavo GAhO) are used to indicate the status of the endpoints: _<a id="id-1.15.18.14.10.1" class="indexterm"></a>[_ga'o_](../go01#valsi-gaho)_ means that the endpoint is included, _<a id="id-1.15.18.14.11.1" class="indexterm"></a>[_ke'i_](../go01#valsi-kehi)_ that it is excluded:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGTc"></a>

**Example 14.142. <a id="c14e16d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la</td><td>.drezdn.</td><td>ga'o</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>that-named</td><td>Dresden</td><td>[inclusive]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'i</td><td>ga'o</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>[interval]</td><td>[inclusive]</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden and Frankfurt, inclusive of both.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qGtv"></a>

**Example 14.143. <a id="c14e16d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la</td><td>.drezdn.</td><td>ga'o</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>that-named</td><td>Dresden</td><td>[inclusive]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'i</td><td>ke'i</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>[interval]</td><td>[exclusive]</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden (inclusive) and Frankfurt (exclusive).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgUo"></a>

**Example 14.144. <a id="c14e16d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la</td><td>.drezdn.</td><td>ke'i</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>that-named</td><td>Dresden</td><td>[exclusive]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'i</td><td>ga'o</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>[interval]</td><td>[inclusive]</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden (exclusive) and Frankfurt (inclusive).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qGvB"></a>

**Example 14.145. <a id="c14e16d8"></a><a id="id-1.15.18.18.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la</td><td>.drezdn.</td><td>ke'i</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>that-named</td><td>Dresden</td><td>[exclusive]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'i</td><td>ke'i</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>[interval]</td><td>[exclusive]</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden and Frankfurt, exclusive of both.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.18.19.1" class="indexterm"></a>As these examples should make clear, the GAhO cmavo that applies to a given endpoint is the one that stands physically adjacent to it: the left-hand endpoint is referred to by the first GAhO, and the right-hand endpoint by the second GAhO. It is ungrammatical to have just one GAhO.

<a id="id-1.15.18.20.1" class="indexterm"></a><a id="id-1.15.18.20.2" class="indexterm"></a>(Etymologically, _<a id="id-1.15.18.20.3.1" class="indexterm"></a>[_ga'o_](../go01#valsi-gaho)_ is derived from _<a id="id-1.15.18.20.4.1" class="indexterm"></a>[_ganlo_](../go01#valsi-ganlo)_ , which means “closed” , and _<a id="id-1.15.18.20.6.1" class="indexterm"></a>[_ke'i_](../go01#valsi-kehi)_ from _<a id="id-1.15.18.20.7.1" class="indexterm"></a>[_kalri_](../go01#valsi-kalri)_ , which means “open”. In mathematics, inclusive intervals are referred to as closed intervals, and exclusive intervals as open ones.)

<a id="id-1.15.18.21.1" class="indexterm"></a>BIhI joiks are grammatical anywhere that other joiks are, including in tanru connection and (as ijoiks) between sentences. No meanings have been found for these uses.

<a id="id-1.15.18.22.1" class="indexterm"></a><a id="id-1.15.18.22.2" class="indexterm"></a><a id="id-1.15.18.22.3" class="indexterm"></a>Negated intervals, marked with a _<a id="id-1.15.18.22.4.1" class="indexterm"></a>\-nai_ following the BIhI cmavo, indicate an interval that includes everything but what is between the endpoints (with respect to some understood scale):

<div class="interlinear-gloss-example example">
<a id="example-random-id-39EI"></a>

**Example 14.146. <a id="c14e16d9"></a><a id="id-1.15.18.23.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>dicra</td><td>.e'a</td><td>mi</td><td>ca</td><td>la</td><td>.daucac.</td></tr><tr class="gloss"><td>You</td><td>disturb</td><td>(allowed)</td><td>me</td><td>at</td><td>that-named</td><td>10</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bi'onai</td><td>la</td><td>.gaicac.</td></tr><tr class="gloss"><td>not-from-...-to</td><td>that-named</td><td>12</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You can contact me except from 10 to 12.</p></td></tr></tbody></table>

</div>  

The complete syntax of joiks is:<a id="id-1.15.18.24.1" class="indexterm"></a><a id="id-1.15.18.24.2" class="indexterm"></a><a id="id-1.15.18.24.3" class="indexterm"></a><a id="id-1.15.18.24.4" class="indexterm"></a><a id="id-1.15.18.24.5" class="indexterm"></a>

> *   \[se\] JOI \[nai\]
>     
> *   \[se\] BIhI \[nai\]
>     
> *   GAhO \[se\] BIhI \[nai\] GAhO
>     

<a id="id-1.15.18.26.1" class="indexterm"></a><a id="id-1.15.18.26.2" class="indexterm"></a><a id="id-1.15.18.26.3" class="indexterm"></a>Notice that the colloquial English translations of _<a id="id-1.15.18.26.4.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ and _<a id="id-1.15.18.26.5.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ have forethought form: “between ... and” for _<a id="id-1.15.18.26.7.1" class="indexterm"></a>[_bi'i_](../go01#valsi-bihi)_ , and “from ... to” for _<a id="id-1.15.18.26.9.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_. In Lojban too, non-logical connectives can be expressed in forethought. Rather than using a separate selma'o, the forethought logical connectives are constructed from the afterthought ones by suffixing _<a id="id-1.15.18.26.10.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_. Such a compound cmavo is not unnaturally called a “joigik” ; the syntax of joigiks is any of:<a id="id-1.15.18.26.12" class="indexterm"></a><a id="id-1.15.18.26.13" class="indexterm"></a><a id="id-1.15.18.26.14" class="indexterm"></a><a id="id-1.15.18.26.15" class="indexterm"></a><a id="id-1.15.18.26.16" class="indexterm"></a><a id="id-1.15.18.26.17" class="indexterm"></a>

> *   \[se\] JOI \[nai\] GI
>     
> *   \[se\] BIhI \[nai\] GI
>     
> *   GAhO \[se\] BIhI \[nai\] GAhO GI
>     

<a id="id-1.15.18.28.1" class="indexterm"></a>Joigiks may be used to non-logically connect bridi, sumti, and bridi-tails; and also in termsets.

[Example 14.111](../section-non-logical-connectives#example-random-id-pC5x) in forethought becomes:

<div class="interlinear-gloss-example example">
<a id="example-random-id-iBpP"></a>

**Example 14.147. <a id="c14e16d10"></a><a id="id-1.15.18.30.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>joigi</td><td>la</td><td>.djan.</td><td>gi</td><td>la</td><td>.alis.</td><td>bevri</td><td>le</td><td>pipno</td></tr><tr class="gloss"><td>[Together]</td><td>that-named</td><td>John</td><td>and</td><td>that-named</td><td>Alice</td><td>carry</td><td>the</td><td>piano.</td></tr></tbody></table>

</div>  

The first _<a id="id-1.15.18.31.1.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ is part of the joigik; the second _<a id="id-1.15.18.31.2.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ is the regular gik that separates the two things being connected in all forethought forms.

[Example 14.143](../section-non-logical-continued-continued#example-random-id-qGtv) can be expressed in forethought as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-u51K"></a>

**Example 14.148. <a id="c14e16d11"></a><a id="id-1.15.18.33.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>ke'i</td><td>bi'i</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>[exclusive]</td><td>between</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ga'o</td><td>gi</td><td>la</td><td>.drezdn.</td><td>gi</td><td>la</td><td>.frankfurt.</td></tr><tr class="gloss"><td>[inclusive]</td><td>and</td><td>that-named</td><td>Dresden</td><td>and</td><td>that-named</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden (exclusive) and Frankfurt (inclusive).</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.18.34.1" class="indexterm"></a><a id="id-1.15.18.34.2" class="indexterm"></a>In forethought, unfortunately, the GAhOs become physically separated from the endpoints, but the same rule applies: the first GAhO refers to the first endpoint.