<a id="section-non-logical-connectives"></a>14.14. <a id="c14s14"></a>Non-logical connectives
---------------------------------------------------------------------------------------------

<a id="id-1.15.16.2.1" class="indexterm"></a>Way back in [Section 14.1](../chapter-connectives#section-connectives-introduction) , the point was made that not every use of English “and” , “if ... then” , and so on represents a Lojban logical connective. In particular, consider the “and” of:

<div class="example">
<a id="example-random-id-x6JW"></a>

**Example 14.109. <a id="c14e14d1"></a><a id="id-1.15.16.3.1.2" class="indexterm"></a>** 

John and Alice carried the piano.

</div>  

<a id="id-1.15.16.4.1" class="indexterm"></a>Given the nature of pianos, this probably means that John carried one end and Alice the other. So it is not true that:

<div class="example">
<a id="example-random-id-58yv"></a>

**Example 14.110. <a id="c14e14d2"></a>** 

John carried the piano, and Alice carried the piano.

</div>  

which would mean that each of them carried the piano by himself/herself. Lojban deals with this particular linguistic phenomenon as a “mass”. John and Alice are joined together into a mass, John-and-Alice, and it is this mass which carried the piano, not either of them separately. The cmavo _<a id="id-1.15.16.6.2.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ (of selma'o JOI) is used to join two or more components into a mass:

<div class="interlinear-gloss-example example">
<a id="example-random-id-pC5x"></a>

**Example 14.111. <a id="c14e14d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>joi</td><td>la</td><td>.alis.</td><td>cu</td><td>bevri</td><td>le</td><td>pipno</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>massed-with</td><td>that-named</td><td>Alice</td><td></td><td>carry</td><td>the</td><td>piano.</td></tr></tbody></table>

</div>  

<a id="id-1.15.16.8.1" class="indexterm"></a><a id="id-1.15.16.8.2" class="indexterm"></a><a id="id-1.15.16.8.3" class="indexterm"></a>[Example 14.111](../section-non-logical-connectives#example-random-id-pC5x) covers the case mentioned, where John and Alice divide the labor; it also could mean that John did all the hauling and Alice did the supervising. This possibility arises because the properties of a mass are the properties of its components, which can lead to apparent contradictions: if John is small and Alice is large, then John-and-Alice is both small and large. Masses are also discussed in [Section 6.3](../section-masses).

<a id="id-1.15.16.9.1" class="indexterm"></a><a id="id-1.15.16.9.2" class="indexterm"></a><a id="id-1.15.16.9.3" class="indexterm"></a><a id="id-1.15.16.9.4" class="indexterm"></a><a id="id-1.15.16.9.5" class="indexterm"></a><a id="id-1.15.16.9.6" class="indexterm"></a><a id="id-1.15.16.9.7" class="indexterm"></a>Grammatically, _<a id="id-1.15.16.9.8.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ can appear between two sumti (like an ek) or between two tanru components (like a jek). This flexibility must be paid for in the form of occasional terminators that cannot be elided:

<div class="interlinear-gloss-example example">
<a id="example-random-id-NN93"></a>

**Example 14.112. <a id="c14e14d4"></a><a id="id-1.15.16.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>ku</td><td>joi</td><td>le</td><td>ninmu</td><td>[ku]</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>The</td><td>man</td><td></td><td>massed-with</td><td>the</td><td>woman</td><td></td><td></td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

The cmavo _<a id="id-1.15.16.11.1.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ is the elidable terminator for _<a id="id-1.15.16.11.2.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , which can almost always be elided, but not in this case. If the first _<a id="id-1.15.16.11.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ were elided here, Lojban's parsing rules would see _<a id="id-1.15.16.11.4.1" class="indexterm"></a>le nanmu joi_ and assume that another tanru component is to follow; since the second _<a id="id-1.15.16.11.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ cannot be part of a tanru, a parsing error results. No such problem can occur with logical connectives, because an ek signals a following sumti and a jek a following tanru component unambiguously.

<a id="id-1.15.16.12.1" class="indexterm"></a>Single or compound cmavo involving members of selma'o JOI are called joiks, by analogy with the names for logical connectives. It is not grammatical to use joiks to connect bridi-tails.

<a id="id-1.15.16.13.1" class="indexterm"></a>In tanru, _<a id="id-1.15.16.13.2.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ has the connotation “mixed with” , as in the following example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Xxp2"></a>

**Example 14.113. <a id="c14e14d5"></a><a id="id-1.15.16.14.1.2" class="indexterm"></a><a id="id-1.15.16.14.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>blanu</td><td>joi</td><td>xunre</td><td>bolci</td></tr><tr class="gloss"><td>This</td><td>is-a-(blue</td><td>mixed-with</td><td>red)</td><td>ball.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This is a blue and red ball.</p></td></tr></tbody></table>

</div>  

Here the ball is neither wholly blue nor wholly red, but partly blue and partly red. Its blue/redness is a mass property. (Just how blue something has to be to count as “wholly blue” is an unsettled question, though. A _<a id="id-1.15.16.15.2.1" class="indexterm"></a>blanu zdani_ may be so even though not every part of it is blue.)

There are several other cmavo in selma'o JOI which can be used in the same grammatical constructions. Not all of them are well-defined as yet in all contexts. All have clear definitions as sumti connectives; those definitions are shown in the following table:

<table><tbody><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-joi"><em class="glossterm">joi</em></a></em></span> B</td><td>the mass with components A and B</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ce"><em class="glossterm">ce</em></a></em></span> B</td><td>the set with elements A and B</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ceho"><em class="glossterm">ce'o</em></a></em></span> B</td><td>the sequence with elements A and B in order</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-se"><em class="glossterm">se</em></a></em></span> <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.4.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ceho"><em class="glossterm">ce'o</em></a></em></span> B</td><td>the sequence with elements B and A in order</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-johu"><em class="glossterm">jo'u</em></a></em></span> B</td><td>A and B considered jointly</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fahu"><em class="glossterm">fa'u</em></a></em></span> B</td><td>A and B respectively</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-se"><em class="glossterm">se</em></a></em></span> <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.7.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fahu"><em class="glossterm">fa'u</em></a></em></span> B</td><td>B and A respectively</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-johe"><em class="glossterm">jo'e</em></a></em></span> B</td><td>the union of sets A and B</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kuha"><em class="glossterm">ku'a</em></a></em></span> B</td><td>the intersection of sets A and B</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-pihu"><em class="glossterm">pi'u</em></a></em></span> B</td><td>the cross product of sets A and B</td></tr><tr><td>A <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.11.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-se"><em class="glossterm">se</em></a></em></span> <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.15.16.17.11.1.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-pihu"><em class="glossterm">pi'u</em></a></em></span> B</td><td>the cross product of sets B and A</td></tr></tbody></table>

<a id="id-1.15.16.18.1" class="indexterm"></a><a id="id-1.15.16.18.2" class="indexterm"></a>The cmavo _<a id="id-1.15.16.18.3.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ is grammatical before any JOI cmavo, but only useful with those that have inherent order. Here are some examples of joiks:

<div class="interlinear-gloss-example example">
<a id="example-random-id-cwG8"></a>

**Example 14.114. <a id="c14e14d6"></a><a id="id-1.15.16.19.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cuxna</td><td>la</td><td>.alis.</td><td>la</td><td>.frank.</td></tr><tr class="gloss"><td>I</td><td>choose</td><td>that-named</td><td>Alice</td><td>from-that-named</td><td>Frank</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ce</td><td>la</td><td>.alis.</td><td>ce</td><td>la</td><td>.djeimyz.</td></tr><tr class="gloss"><td>and-member</td><td>that-named</td><td>Alice</td><td>and-member</td><td>that-named</td><td>James.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I choose Alice from among Frank, Alice, and James.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.16.20.1" class="indexterm"></a><a id="id-1.15.16.20.2" class="indexterm"></a><a id="id-1.15.16.20.3" class="indexterm"></a>The x3 place of _<a id="id-1.15.16.20.5.1" class="indexterm"></a>[_cuxna_](../go01#valsi-cuxna)_ is a set from which the choice is being made. A set is an abstract object which is determined by specifying its members. Unlike those of a mass, the properties of a set are unrelated to its members' properties: the set of all rats is large (since many rats exist), but the rats themselves are small. This chapter does not attempt to explain set theory (the mathematical study of sets) in detail: explaining propositional logic is quite enough for one chapter!

<a id="id-1.15.16.21.1" class="indexterm"></a>In [Example 14.114](../section-non-logical-connectives#example-random-id-cwG8) we specify that set by listing the members with _<a id="id-1.15.16.21.3.1" class="indexterm"></a>[_ce_](../go01#valsi-ce)_ joining them.

<div class="interlinear-gloss-example example">
<a id="example-random-id-Emw0"></a>

**Example 14.115. <a id="c14e14d7"></a><a id="id-1.15.16.22.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>liste</td><td>mi</td><td>ce'o</td><td>do</td><td>ce'o</td><td>la</td><td>.djan.</td></tr><tr class="gloss"><td>This</td><td>is-a-list-of</td><td>me</td><td>and-sequence</td><td>you</td><td>and-sequence</td><td>that-named</td><td>John.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This is a list of you, me, and John.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.16.23.1" class="indexterm"></a><a id="id-1.15.16.23.2" class="indexterm"></a><a id="id-1.15.16.23.3" class="indexterm"></a><a id="id-1.15.16.23.4" class="indexterm"></a><a id="id-1.15.16.23.5" class="indexterm"></a><a id="id-1.15.16.23.6" class="indexterm"></a><a id="id-1.15.16.23.7" class="indexterm"></a><a id="id-1.15.16.23.8" class="indexterm"></a><a id="id-1.15.16.23.9" class="indexterm"></a>The x2 place of _<a id="id-1.15.16.23.11.1" class="indexterm"></a>[_liste_](../go01#valsi-liste)_ is a sequence of the things which are mentioned in the list. (It is worth pointing out that _<a id="id-1.15.16.23.12.1" class="indexterm"></a>lo liste_ means a physical object such as a grocery list: a purely abstract list is _<a id="id-1.15.16.23.13.1" class="indexterm"></a>lo porsi_ , a sequence.) Here the three sumti connected by _<a id="id-1.15.16.23.14.1" class="indexterm"></a>[_ce'o_](../go01#valsi-ceho)_ are in a definite order, not just lumped together in a set or a mass.

<a id="id-1.15.16.24.1" class="indexterm"></a><a id="id-1.15.16.24.2" class="indexterm"></a><a id="id-1.15.16.24.3" class="indexterm"></a><a id="id-1.15.16.24.4" class="indexterm"></a><a id="id-1.15.16.24.5" class="indexterm"></a><a id="id-1.15.16.24.6" class="indexterm"></a><a id="id-1.15.16.24.7" class="indexterm"></a><a id="id-1.15.16.24.8" class="indexterm"></a>So _<a id="id-1.15.16.24.9.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ , _<a id="id-1.15.16.24.10.1" class="indexterm"></a>[_ce_](../go01#valsi-ce)_ , and _<a id="id-1.15.16.24.11.1" class="indexterm"></a>[_ce'o_](../go01#valsi-ceho)_ are parallel, in that the sumti connected are taken to be individuals, and the result is something else: a mass, a set, or a sequence respectively. The cmavo _<a id="id-1.15.16.24.12.1" class="indexterm"></a>[_jo'u_](../go01#valsi-johu)_ serves as a fourth element in this pattern: the sumti connected are individuals, and the result is still individuals – but inseparably so. The normal Lojban way of saying that James and George are brothers is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-sy2V"></a>

**Example 14.116. <a id="c14e14d8"></a><a id="id-1.15.16.25.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>bruna</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>is-the-brother-of</td><td>that-named</td><td>George.</td></tr></tbody></table>

</div>  

possibly adding a discursive element meaning “and vice versa”. However, “James and George are brothers” cannot be correctly translated as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-1PHN"></a>

**Example 14.117. <a id="c14e14d9"></a><a id="id-1.15.16.27.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>.e</td><td>la</td><td>.djordj.</td><td>bruna</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>and</td><td>that-named</td><td>George</td><td>is-a-brother.</td></tr></tbody></table>

</div>  

since that expands to two bridi and means that James is a brother and so is George, but not necessarily of each other. If the _<a id="id-1.15.16.28.1.1" class="indexterm"></a>[_.e_](../go01#valsi-e)_ is changed to _<a id="id-1.15.16.28.2.1" class="indexterm"></a>[_jo'u_](../go01#valsi-johu)_ , however, the meaning of [Example 14.116](../section-non-logical-connectives#example-random-id-sy2V) is preserved:

<div class="interlinear-gloss-example example">
<a id="example-random-id-gnwy"></a>

**Example 14.118. <a id="c14e14d10"></a><a id="id-1.15.16.29.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>jo'u</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>in-common-with</td><td>that-named</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>cu</td><td>remei</td><td>bruna</td></tr><tr class="gloss"><td>George</td><td></td><td>are-a-twosome</td><td>type-of-brothers.</td></tr></tbody></table>

</div>  

The tanru _<a id="id-1.15.16.30.1.1" class="indexterm"></a>remei bruna_ is not strictly necessary in this sentence, but is used to make clear that we are not saying that James and George are both brothers of some third person not specified. Alternatively, we could turn the tanru around: the x1 place of _<a id="id-1.15.16.30.3.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ _<a id="id-1.15.16.30.4.1" class="indexterm"></a>[_mei_](../go01#valsi-mei)_ is a mass with two components, leading to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-t0FJ"></a>

**Example 14.119. <a id="c14e14d11"></a><a id="id-1.15.16.31.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>joi</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>massed-with</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djordj.</td><td>cu</td><td>bruna</td><td>remei</td></tr><tr class="gloss"><td>that-named</td><td>George</td><td></td><td>are-a-brother</td><td>type-of-twosome.</td></tr></tbody></table>

</div>  

where _<a id="id-1.15.16.32.1.1" class="indexterm"></a>[_joi_](../go01#valsi-joi)_ is used to create the necessary mass.

<a id="id-1.15.16.33.1" class="indexterm"></a><a id="id-1.15.16.33.2" class="indexterm"></a>Likewise, _<a id="id-1.15.16.33.3.1" class="indexterm"></a>[_fa'u_](../go01#valsi-fahu)_ can be used to put two individuals together where order matters. Typically, there will be another _<a id="id-1.15.16.33.4.1" class="indexterm"></a>[_fa'u_](../go01#valsi-fahu)_ somewhere else in the same bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-MBsp"></a>

**Example 14.120. <a id="c14e14d12"></a><a id="id-1.15.16.34.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>fa'u</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>jointly-in-order-with</td><td>that-named</td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>prami</td><td>la</td><td>.meris.</td><td>fa'u</td><td>la</td><td>.martas.</td></tr><tr class="gloss"><td>loves</td><td>that-named</td><td>Mary</td><td>jointly-in-order-with</td><td>that-named</td><td>Martha.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">James and George love Mary and Martha, respectively.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.16.35.1" class="indexterm"></a><a id="id-1.15.16.35.2" class="indexterm"></a>Here the information carried by the English adverb “respectively” , namely that James loves Mary and George loves Martha, is divided between the two occurrences of _<a id="id-1.15.16.35.4.1" class="indexterm"></a>[_fa'u_](../go01#valsi-fahu)_. If both uses of _<a id="id-1.15.16.35.5.1" class="indexterm"></a>[_fa'u_](../go01#valsi-fahu)_ were to be changed to _<a id="id-1.15.16.35.6.1" class="indexterm"></a>[_.e_](../go01#valsi-e)_ , we would get:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7bv3"></a>

**Example 14.121. <a id="c14e14d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>.e</td><td>la</td><td>.djordj.</td><td>prami</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>and</td><td>that-named</td><td>George</td><td>love</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.meris.</td><td>.e</td><td>la</td><td>.martas.</td></tr><tr class="gloss"><td>that-named</td><td>Mary</td><td>and</td><td>that-named</td><td>Martha.</td></tr></tbody></table>

</div>  

which can be transformed to four bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-I3gH"></a>

**Example 14.122. <a id="c14e14d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>prami</td><td>la</td><td>.meris.</td><td>.ije</td><td>la</td><td>.djordj.</td><td>prami</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>loves</td><td>that-named</td><td>Mary,</td><td>and</td><td>that-named</td><td>George</td><td>loves</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.meris.</td><td>.ije</td><td>la</td><td>.djeimyz.</td><td>prami</td><td>la</td><td>.martas.</td></tr><tr class="gloss"><td>that-named</td><td>Mary,</td><td>and</td><td>that-named</td><td>James</td><td>loves</td><td>that-named</td><td>Martha,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>la</td><td>.djordj.</td><td>prami</td><td>la</td><td>.martas.</td></tr><tr class="gloss"><td>and</td><td>that-named</td><td>George</td><td>loves</td><td>that-named</td><td>Martha.</td></tr></tbody></table>

</div>  

which represents quite a different state of affairs from [Example 14.120](../section-non-logical-connectives#example-random-id-MBsp). The meaning of [Example 14.120](../section-non-logical-connectives#example-random-id-MBsp) can also be conveyed by a termset:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nER7"></a>

**Example 14.123. <a id="c14e14d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>ce'e</td><td>la</td><td>.meris.</td><td>pe'e</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>[plus]</td><td>that-named</td><td>Mary</td><td>[joint]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>je</td><td>la</td><td>.djordj.</td><td>ce'e</td><td>la</td><td>.martas.</td><td>prami</td></tr><tr class="gloss"><td>and</td><td>that-named</td><td>George</td><td>[plus]</td><td>that-named</td><td>Martha</td><td>loves.</td></tr></tbody></table>

</div>  

<a id="id-1.15.16.41.1" class="indexterm"></a><a id="id-1.15.16.41.2" class="indexterm"></a>at the expense of re-ordering the list of names so as to make the pairs explicit. This option is not available when one of the lists is only described rather than enumerated:

<div class="interlinear-gloss-example example">
<a id="example-random-id-1r61"></a>

**Example 14.124. <a id="c14e14d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djeimyz.</td><td>fa'u</td><td>la</td><td>.djordj.</td><td>prami</td><td>re</td><td>mensi</td></tr><tr class="gloss"><td>That-named</td><td>James</td><td>and-respectively</td><td>that-named</td><td>George</td><td>love</td><td>two</td><td>sisters.</td></tr></tbody></table>

</div>  

which conveys that James loves one sister and George the other, though we are not able to tell which of the sisters is which.