<a id="section-noi"></a>8.2. <a id="c8s2"></a>Incidental relative clauses
-------------------------------------------------------------------------

The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">noi</p></td><td class="selmaho"><p class="selmaho">NOI</p></td><td class="description"><p class="description">incidental relative clause introducer</p></td></tr></tbody></table>

<a id="id-1.9.4.4.1" class="indexterm"></a><a id="id-1.9.4.4.2" class="indexterm"></a><a id="id-1.9.4.4.3" class="indexterm"></a><a id="id-1.9.4.4.4" class="indexterm"></a><a id="id-1.9.4.4.5" class="indexterm"></a><a id="id-1.9.4.4.6" class="indexterm"></a>There are two basic kinds of relative clauses: restrictive relative clauses introduced by _<a id="id-1.9.4.4.7.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ , and incidental (sometimes called simply “non-restrictive”) relative clauses introduced by _<a id="id-1.9.4.4.9.1" class="indexterm"></a>[_noi_](../go01#valsi-noi)_. The difference between restrictive and incidental relative clauses is that restrictive clauses provide information that is essential to identifying the referent of the sumti to which they are attached, whereas incidental relative clauses provide additional information which is helpful to the listener but is not essential for identifying the referent of the sumti. All of the examples in [Section 8.1](../chapter-relative-clauses#section-poi) are restrictive relative clauses: the information in the relative clause is essential to identification. (The title of this chapter, though, uses an incidental relative clause.)

Consider the following examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLXK"></a>

**Example 8.12. <a id="c8e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>poi</td><td>blanu</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>which</td><td>is-blue</td><td>&nbsp;</td><td>is-large.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The dog which is blue is large.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLys"></a>

**Example 8.13. <a id="c8e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>noi</td><td>blanu</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>incidentally-which</td><td>is-blue</td><td>&nbsp;</td><td>is-large.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The dog, which is blue, is large.</p></td></tr></tbody></table>

</div>  

In [Example 8.12](../section-noi#example-random-id-qLXK) , the information conveyed by _<a id="id-1.9.4.8.2.1" class="indexterm"></a>poi blanu_ is essential to identifying the dog in question: it restricts the possible referents from dogs in general to dogs that are blue. This is why _<a id="id-1.9.4.8.3.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ relative clauses are called restrictive. In [Example 8.13](../section-noi#example-random-id-qLys) , on the other hand, the dog which is referred to has presumably already been identified clearly, and the relative clause _<a id="id-1.9.4.8.5.1" class="indexterm"></a>noi blanu_ just provides additional information about it. (If in fact the dog hasn't been identified clearly, then the relative clause does not help identify it further.)

<a id="id-1.9.4.9.1" class="indexterm"></a><a id="id-1.9.4.9.2" class="indexterm"></a><a id="id-1.9.4.9.3" class="indexterm"></a><a id="id-1.9.4.9.4" class="indexterm"></a>In English, the distinction between restrictive and incidental relative clauses is expressed in writing by surrounding incidental, but not restrictive, clauses with commas. These commas are functioning as parentheses, because incidental relative clauses are essentially parenthetical. This distinction in punctuation is represented in speech by a difference in tone of voice. In addition, English restrictive relative clauses can be introduced by “that” as well as “which” and “who” , whereas incidental relative clauses cannot begin with “that”. Lojban, however, always uses the cmavo _<a id="id-1.9.4.9.9.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ and _<a id="id-1.9.4.9.10.1" class="indexterm"></a>[_noi_](../go01#valsi-noi)_ rather than punctuation or intonation to make the distinction.

Here are more examples of incidental relative clauses:

<div class="interlinear-gloss-example example">
<a id="example-random-id-WxJo"></a>

**Example 8.14. <a id="c8e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>noi</td><td>pajni</td><td>cu</td><td>zvati</td></tr><tr class="gloss"><td>I</td><td>who-incidentally</td><td>am-a-judge</td><td>&nbsp;</td><td>am-at</td><td>[some-place].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I, a judge, am present.</p></td></tr></tbody></table>

</div>  

In this example, _<a id="id-1.9.4.12.1.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ is already sufficiently restricted, and the additional information that I am a judge is being provided solely for the listener's edification.

<div class="interlinear-gloss-example example">
<a id="example-random-id-pR53"></a>

**Example 8.15. <a id="c8e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>do</td><td>viska</td><td>le</td><td>mi</td><td>karce</td><td>noi</td><td>blabi</td></tr><tr class="gloss"><td>[True?]</td><td>You</td><td>see</td><td>&nbsp;</td><td>my</td><td>car</td><td>incidentally-which</td><td>is-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Do you see my car, which is white?</p></td></tr></tbody></table>

</div>  

In [Example 8.15](../section-noi#example-random-id-pR53) , the speaker is presumed to have only one car, and is providing incidental information that it is white. (Alternatively, he or she might have more than one car, since _<a id="id-1.9.4.14.2.1" class="indexterm"></a>le karce_ can be plural, in which case the incidental information is that each of them is white.) Contrast [Example 8.16](../section-noi#example-random-id-0qU1) with a restrictive relative clause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-0qU1"></a>

**Example 8.16. <a id="c8e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>do</td><td>viska</td><td>le</td><td>mi</td><td>karce</td><td>poi</td><td>blabi</td></tr><tr class="gloss"><td>[True?]</td><td>You</td><td>see</td><td>&nbsp;</td><td>my</td><td>car</td><td>which</td><td>is-white.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Do you see my car that is white?</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Do you see my white car?</p></td></tr></tbody></table>

</div>  

<a id="id-1.9.4.16.1" class="indexterm"></a>Here the speaker probably has several cars, and is restricting the referent of the sumti _<a id="id-1.9.4.16.2.1" class="indexterm"></a>le mi karce_ (and thereby the listener's attention) to the white one only. [Example 8.16](../section-noi#example-random-id-0qU1) means much the same as [Example 8.17](../section-noi#example-random-id-zsQ6) , which does not use a relative clause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-zsQ6"></a>

**Example 8.17. <a id="c8e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>do</td><td>viska</td><td>le</td><td>mi</td><td>blabi</td><td>karce</td></tr><tr class="gloss"><td>[True?]</td><td>You</td><td>see</td><td>&nbsp;</td><td>my</td><td>white</td><td>car.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Do you see my car, the white one?</p></td></tr></tbody></table>

</div>  

<a id="id-1.9.4.18.1" class="indexterm"></a>So a restrictive relative clause attached to a description can often mean the same as a description involving a tanru. However, _<a id="id-1.9.4.18.2.1" class="indexterm"></a>blabi karce_ , like all tanru, is somewhat vague: in principle, it might refer to a car which carries white things, or even express some more complicated concept involving whiteness and car-ness; the restrictive relative clause of [Example 8.16](../section-noi#example-random-id-0qU1) can only refer to a car which is white, not to any more complex or extended concept.