<a id="section-names"></a>6.12. <a id="c6s12"></a>Lojban names
--------------------------------------------------------------

Names have been used freely as sumti throughout this chapter without too much explanation. The time for the explanation has now come.

<a id="id-1.7.14.3.1" class="indexterm"></a><a id="id-1.7.14.3.2" class="indexterm"></a>First of all, there are two different kinds of things usually called “names” when talking about Lojban. The naming predicates of [Section 6.2](../section-basic-descriptors) are just ordinary predicates which are being used in a special sense. In addition, though, there is a class of Lojban words which are used only to name things: these can be recognized by the fact that they end in a consonant and are surrounded by pauses. Some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-u0zY"></a>

**Example 6.72. <a id="c6e12d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.djan.</td><td>.meris.</td><td>.djein.</td><td>.alis.</td></tr><tr class="gloss"><td>John.</td><td>Mary.</td><td>Jane.</td><td>Alice.</td></tr></tbody></table>

</div>  

<a id="id-1.7.14.5.1" class="indexterm"></a><a id="id-1.7.14.5.2" class="indexterm"></a><a id="id-1.7.14.5.3" class="indexterm"></a>Names of this kind have two basic uses in Lojban: when used in a vocative phrase (see [Section 6.11](../section-vocative-syntax)) they indicate who the listener is or should be. When used with a descriptor of selma'o LA, namely _<a id="id-1.7.14.5.5.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , _<a id="id-1.7.14.5.6.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ , or _<a id="id-1.7.14.5.7.1" class="indexterm"></a>[_la'i_](../go01#valsi-lahi)_ , they form sumti which refer to the persons or things known by the name.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qLgw"></a>

**Example 6.73. <a id="c6e12d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djonz.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>Those-named</td><td>Jones</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The Joneses go to-the store.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qLHn"></a>

**Example 6.74. <a id="c6e12d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lai</td><td>.djonz.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>The-mass-of-those-named</td><td>Jones</td><td>goes-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The Joneses go to the store.</p></td></tr></tbody></table>

</div>  

In [Example 6.73](../section-names#example-random-id-qLgw) , the significance is that all the persons (perhaps only one) I mean to refer to by the name _.djonz._ are going to the store. In [Example 6.74](../section-names#example-random-id-qLHn) , the Joneses are massified, and only some part of them needs to be going. Of course, by _.djonz._ I can mean whomever I want: that person need not use the name _.djonz._ at all.

<a id="id-1.7.14.9.1" class="indexterm"></a><a id="id-1.7.14.9.2" class="indexterm"></a>The sumti in [Example 6.73](../section-names#example-random-id-qLgw) and [Example 6.74](../section-names#example-random-id-qLHn) operate exactly like the similar uses of _<a id="id-1.7.14.9.5.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ and _<a id="id-1.7.14.9.6.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ in [Example 6.10](../section-basic-descriptors#example-random-id-PrGp) and [Example 6.21](../section-masses#example-random-id-H8z5) respectively. The only difference is that these descriptors are followed by Lojban name-words (i.e. cmevla). And in fact, the only difference between descriptors of selma'o LA (these three) and of selma'o LE (all the other descriptors) is that the former can be followed by name-words, whereas the latter cannot.

<a id="id-1.7.14.10.1" class="indexterm"></a>Unless some other rule prevents it (such as the rule that _<a id="id-1.7.14.10.2.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ is always followed by a single word, which is quoted), multiple name-words may appear wherever one name-word is permitted, each with its terminating pause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-cw3p"></a>

**Example 6.75. <a id="id-1.7.14.11.1.1" class="indexterm"></a><a id="id-1.7.14.11.1.2" class="indexterm"></a><a id="c6e12d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.djan.&nbsp;.pol.&nbsp;.djonz.</td><td>le</td><td>bloti</td><td>cu</td><td>klama</td><td>fi&nbsp;la</td><td>.niuport.&nbsp;.niuz.</td></tr><tr class="gloss"><td>O</td><td>John&nbsp;Paul&nbsp;Jones</td><td>the</td><td>boat</td><td></td><td>goes</td><td>from-that-named</td><td>Newport&nbsp;News.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John Paul Jones, the boat comes (to somewhere) from Newport News.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.14.12.1" class="indexterm"></a>A name-word may not contain any consonant combination that is illegal in Lojban words generally: the “impermissible consonant clusters” of Lojban morphology (explained in [Section 3.6](../section-clusters)). Thus _.djeimz._ is not a valid version of “James” (because _mz_ is invalid): _djeimyz_ will suffice.

<a id="id-1.7.14.13.1" class="indexterm"></a>Names may be borrowed from other languages or created arbitrarily. Another common practice is to use one or more rafsi, arranged to end with a consonant, to form a name: thus the rafsi _loj-_ for _<a id="id-1.7.14.13.3.1" class="indexterm"></a>[_logji_](../go01#valsi-logji)_ (logical) and _ban-_ for _<a id="id-1.7.14.13.5.1" class="indexterm"></a>[_bangu_](../go01#valsi-bangu)_ (language) unite to form the name of this language:

<div class="interlinear-gloss-example example">
<a id="example-random-id-uXAY"></a>

**Example 6.76. <a id="c6e12d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.lojban.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lojban</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.14.15.1" class="indexterm"></a><a id="id-1.7.14.15.2" class="indexterm"></a>When borrowing names from another language which end in a vowel, or when turning a Lojban brivla (all of which end in vowels) into a cmevla, the vowel may be removed or an arbitrary consonant added. It is common (but not required) to use the consonants _s_ or _n_ when borrowing vowel-final names from English; speakers of other languages may wish to use other consonant endings.

<a id="id-1.7.14.16.1" class="indexterm"></a>The implicit quantifier for name sumti of the form _<a id="id-1.7.14.16.2.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ followed by a cmevla (name-word) is _<a id="id-1.7.14.16.3.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ , just as for _<a id="id-1.7.14.16.4.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ followed by a selbri.