<a id="section-nahe"></a>15.4. <a id="c15s4"></a>selbri and tanru negation
--------------------------------------------------------------------------

All the scalar negations illustrated in [Section 15.3](../section-scalar-negation) are expressed in Lojban using the cmavo _<a id="id-1.16.6.2.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ (of selma'o NAhE). The most common use of _<a id="id-1.16.6.2.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ is as a prefix to the selbri:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qh42"></a>

**Example 15.44. <a id="c15e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qH4n"></a>

**Example 15.45. <a id="c15e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>(other-than</td><td>go-to)</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

Comparing these two, we see that the negation operator being used in [Example 15.45](../section-nahe#example-random-id-qH4n) is _<a id="id-1.16.6.5.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_. But what exactly does _<a id="id-1.16.6.5.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ negate? Does the negation include only the gismu _<a id="id-1.16.6.5.4.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ , which is the entire selbri in this case, or does it include the _<a id="id-1.16.6.5.5.1" class="indexterm"></a>le zarci_ as well? In Lojban, the answer is unambiguously “only the gismu”. The cmavo _<a id="id-1.16.6.5.7.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ always applies only to what follows it.

[Example 15.45](../section-nahe#example-random-id-qH4n) looks as if it were parallel to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tqX1"></a>

**Example 15.46. <a id="c15e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[false]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

but in fact there is no real parallelism at all. A negation using _<a id="id-1.16.6.8.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ denies the truth of a relationship, but a selbri negation with _<a id="id-1.16.6.8.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ asserts that a relationship exists other than that stated, one which specifically involves the sumti identified in the statement. The grammar allotted to _<a id="id-1.16.6.8.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ allows us to unambiguously express scalar negations in terms of scope, scale, and range within the scale. Before we explain the scalar aspects, let us show how the scope of _<a id="id-1.16.6.8.4.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ is determined.

In tanru, we may wish to negate an individual element before combining it with another to form the tanru. We in effect need a shorter-than-selbri-scope negation, for which we can use _<a id="id-1.16.6.9.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ as well. The positive sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-ETuV"></a>

**Example 15.47. <a id="c15e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cadzu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>walking-ly</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

can be subjected to selbri negation in several ways. Two are:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qh4w"></a>

**Example 15.48. <a id="c15e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>cadzu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>(other-than</td><td>walkingly)</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qH6w"></a>

**Example 15.49. <a id="c15e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cadzu</td><td>na'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>walkingly</td><td>(other-than</td><td>go-to)</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

These negations show the default scope of _<a id="id-1.16.6.14.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ is close-binding on an individual brivla in a tanru. [Example 15.48](../section-nahe#example-random-id-qh4w) says that I am going to the market, but in some kind of a non-walking manner. (As with most tanru, there are a few other possible interpretations, but we'll assume this one – see [Chapter 5](../chapter-selbri) for a discussion of tanru meaning).

In neither [Example 15.48](../section-nahe#example-random-id-qh4w) nor [Example 15.49](../section-nahe#example-random-id-qH6w) does the _<a id="id-1.16.6.15.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ negate the entire selbri. While both sentences contain negations that deny a particular relationship between the sumti, they also have a component which makes a positive claim about such a relationship. This is clearer in [Example 15.48](../section-nahe#example-random-id-qh4w) , which says that I am going, but in a non-walking manner. In [Example 15.49](../section-nahe#example-random-id-qH6w) , we have claimed that the relationship between me and the market in some way involves walking, but is not one of “going to” (perhaps we are walking around the market, or walking-in-place while at the market).

The “scale” , or actually the “set” , implied in Lojban tanru negations is anything which plausibly can be substituted into the tanru. (Plausibility here is interpreted in the same way that answers to a _<a id="id-1.16.6.16.3.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ question must be plausible – the result must not only have the right number of places and have sumti values appropriate to the place structure, it must also be appropriate or relevant to the context.) This minimal condition allows a speaker to be intentionally vague, while still communicating meaningful information. The speaker who uses selbri negation is denying one relationship, while minimally asserting a different relationship.

We also need a scalar negation form that has a scope longer than a single brivla. There exists such a longer-scope selbri negation form, as exemplified by (each Lojban sentence in the next several examples is given twice, with parentheses in the second copy showing the scope of the _<a id="id-1.16.6.17.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_):

<div class="interlinear-gloss-example example">
<a id="example-random-id-t20b"></a>

**Example 15.50. <a id="c15e4d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>ke</td><td>cadzu</td><td>klama</td><td>[ke'e]</td><td>le</td><td>zarci</td></tr><tr class="jbo"><td>mi</td><td>na'e</td><td>(ke</td><td>cadzu</td><td>klama</td><td>[ke'e])</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(</td><td>walkingly</td><td>go-to</td><td>)</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

This negation uses the same _<a id="id-1.16.6.19.1.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ and _<a id="id-1.16.6.19.2.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ delimiters (the _<a id="id-1.16.6.19.3.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ is always elidable at the end of a selbri) that are used in tanru. The sentence clearly negates the entire selbri. The _<a id="id-1.16.6.19.4.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ , whether elided or not, reminds us that the negation does not include the trailing sumti. While the trailing-sumti place-structure is defined as that of the final brivla, the trailing sumti themselves are not part of the selbri and are thus not negated by _<a id="id-1.16.6.19.5.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_.

Negations of just part of the selbri are also permitted:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PVct"></a>

**Example 15.51. <a id="c15e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>ke</td><td>sutra</td><td>cadzu</td><td>ke'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="jbo"><td>mi</td><td>na'e</td><td>(ke</td><td>sutra</td><td>cadzu</td><td>ke'e)</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(</td><td>quickly</td><td>walkingly</td><td>)</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

In [Example 15.51](../section-nahe#example-random-id-PVct) , only the _<a id="id-1.16.6.22.2.1" class="indexterm"></a>sutra cadzu_ tanru is negated, so the speaker is indeed going to the market, but not by walking quickly.

Negations made with _<a id="id-1.16.6.23.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ or _<a id="id-1.16.6.23.2.1" class="indexterm"></a>na'eke_ also include within their scope any sumti attached to the brivla or tanru with _<a id="id-1.16.6.23.3.1" class="indexterm"></a>[_be_](../go01#valsi-be)_ or _<a id="id-1.16.6.23.4.1" class="indexterm"></a>[_bei_](../go01#valsi-bei)_. Such attached sumti are considered part of the brivla or tanru:

<div class="interlinear-gloss-example example">
<a id="example-random-id-MYYa"></a>

**Example 15.52. <a id="c15e4d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>ke</td><td>sutra</td><td>cadzu</td><td>be</td><td>le</td><td>mi</td><td>birka</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(</td><td>quickly</td><td>walking</td><td>on</td><td>the</td><td>of-me</td><td>arms-ly</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ke'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>)</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

Note that [Example 15.53](../section-nahe#example-random-id-qh7T) and [Example 15.54](../section-nahe#example-random-id-qH8J) do not express the same thing:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qh7T"></a>

**Example 15.53. <a id="c15e4d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>ke</td><td>sutra</td><td>cadzu</td><td>[ke'e]</td><td>lemi</td><td>birka</td></tr><tr class="jbo"><td>mi</td><td>na'e</td><td>(ke</td><td>sutra</td><td>cadzu</td><td>[ke'e])</td><td>lemi</td><td>birka</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(</td><td>quickly</td><td>walk-on</td><td>)</td><td>my</td><td>arms.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qH8J"></a>

**Example 15.54. <a id="c15e4d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>ke</td><td>sutra</td><td>cadzu</td><td>be</td><td>lemi</td><td>birka</td><td>[ke'e]</td></tr><tr class="jbo"><td>mi</td><td>na'e</td><td>(ke</td><td>sutra</td><td>cadzu</td><td>be</td><td>lemi</td><td>birka</td><td>[ke'e])</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(</td><td>quickly</td><td>walk</td><td>on</td><td>my</td><td>arms</td><td>).</td></tr></tbody></table>

</div>  

The translations show that the negation in [Example 15.53](../section-nahe#example-random-id-qh7T) is more restricted in scope; i.e. less of the sentence is negated with respect to x1 ( _<a id="id-1.16.6.28.3.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_).

Logical scope being an important factor in Lojban's claims to be unambiguous, let us indicate the relative precedence of _<a id="id-1.16.6.29.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ as an operator. Grouping with _<a id="id-1.16.6.29.2.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ and _<a id="id-1.16.6.29.3.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ , of course, has an overt scope, which is its advantage. _<a id="id-1.16.6.29.4.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ is very close binding to its brivla. Internal binding of tanru, with _<a id="id-1.16.6.29.5.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , is not as tightly bound as _<a id="id-1.16.6.29.6.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_. _<a id="id-1.16.6.29.7.1" class="indexterm"></a>[_co_](../go01#valsi-co)_ , the tanru inversion operator has a scope that is longer than all other tanru constructs.

In short, _<a id="id-1.16.6.30.1.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ and _<a id="id-1.16.6.30.2.1" class="indexterm"></a>na'eke_ define a type of negation, which is shorter in scope than bridi negation, and which affects all or part of a selbri. The result of _<a id="id-1.16.6.30.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ negation remains an assertion of some specific truth and not merely a denial of another claim.

The similarity becomes striking when it is noticed that the rafsi _\-nal-_ , representing _<a id="id-1.16.6.31.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ when a tanru is condensed into a lujvo, forms an exact parallel to the English usage of _<a id="id-1.16.6.31.3.1" class="indexterm"></a>non-_. Turning a series of related negations into lujvo gives:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2buq"></a>

**Example 15.55. <a id="c15e4d12"></a>** 

*   na'e klama becomes nalkla

*   na'e cadzu klama becomes naldzukla

*   na'e sutra cadzu klama becomes nalsu'adzukla

*   na'e ke sutra cadzu ke'e klama becomes nalsu'adzuke'ekla

</div>  

Note: _\-kem-_ is the rafsi for _<a id="id-1.16.6.33.2.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , but it is omitted in the final lujvo as superfluous – _<a id="id-1.16.6.33.3.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ is its own rafsi, and its inclusion in the lujvo implies a _<a id="id-1.16.6.33.4.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ after the _\-nal-_ , since it needs to close something; only a _<a id="id-1.16.6.33.6.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ immediately after the negation would make the _<a id="id-1.16.6.33.7.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ meaningful in the tanru expressed in this lujvo.

In a lujvo, it is probably clearest to translate _\-nal-_ as “non-” , to match the English combining forms, except when the _<a id="id-1.16.6.34.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ has single word scope and English uses “un-” or “im-” to negate that single word. Translation style should determine the use of “other than” , “non-” , or another negator for _<a id="id-1.16.6.34.8.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ in tanru; the translator must render the Lojban into English so it is clear in context. Let's go back to our simplest example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qh9c"></a>

**Example 15.56. <a id="c15e4d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>other-than</td><td>(go-to)</td><td>the</td><td>market.</td></tr><tr class="gloss"><td>I</td><td>not</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qH9e"></a>

**Example 15.57. <a id="c15e4d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nalkla</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>am-a-non-go-er-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

Note that to compare with the English translation form using “non-” , we've translated the Lojban as if the selbri were a noun. Since Lojban _<a id="id-1.16.6.37.2.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ is indifferently a noun, verb, or adjective, the difference is purely a translation change, not a true change in meaning. The English difference seems significant, though, due to the strongly different English grammatical forms and the ambiguity of English negation.

Consider the following highly problematic sentence:

<div class="interlinear-gloss-example example">
<a id="example-random-id-GFFo"></a>

**Example 15.58. <a id="c15e4d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>ca</td><td>nolraitru</td></tr><tr class="gloss"><td>An-actual</td><td>currently</td><td>noblest-governor</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>le</td><td>fasygu'e</td><td>cu</td><td>krecau</td></tr><tr class="gloss"><td>of</td><td>the</td><td>French-country</td><td></td><td>is-hair-without.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The current King of France is bald.</p></td></tr></tbody></table>

</div>  

The selbri _<a id="id-1.16.6.40.1.1" class="indexterm"></a>[_krecau_](../go01#valsi-krecau)_ negates with _<a id="id-1.16.6.40.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2maY"></a>

**Example 15.59. <a id="c15e4d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>ca</td><td>nolraitru</td></tr><tr class="gloss"><td>An-actual</td><td>currently</td><td>noblest-governor</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>le</td><td>fasygu'e</td><td>cu</td><td>na'e</td><td>krecau</td></tr><tr class="gloss"><td>of</td><td>the</td><td>French-country</td><td></td><td>is-other-than</td><td>hair-without.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The current King of France is other-than-bald.</p></td></tr></tbody></table>

</div>  

or, as a lujvo:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wGXL"></a>

**Example 15.60. <a id="c15e4d17"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>ca</td><td>nolraitru</td></tr><tr class="gloss"><td>An-actual</td><td>currently</td><td>noblest-governor</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>le</td><td>fasygu'e</td><td>cu</td><td>nalkrecau</td></tr><tr class="gloss"><td>of</td><td>the</td><td>French-country</td><td></td><td>is-non-hair-without.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The current King of France is a non-bald-one.</p></td></tr></tbody></table>

</div>  

[Example 15.59](../section-nahe#example-random-id-2maY) and [Example 15.60](../section-nahe#example-random-id-wGXL) express the predicate negation forms using a negation word ( _<a id="id-1.16.6.44.3.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_) or rafsi ( _\-nal-_); yet they make positive assertions about the current King of France; ie., that he is other-than-bald or non-bald. This follows from the close binding of _<a id="id-1.16.6.44.5.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ to the brivla. The lujvo form makes this overt by absorbing the negative marker into the word.

Since there is no current King of France, it is false to say that he is bald, or non-bald, or to make any other affirmative claim about him. Any sentence about the current King of France containing only a selbri negation is as false as the sentence without the negation. No amount of selbri negations have any effect on the truth value of the sentence, which is invariably “false” , since no affirmative statement about the current King of France can be true. On the other hand, bridi negation does produce a truth:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Bwdy"></a>

**Example 15.61. <a id="c15e4d18"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>ca</td><td>nolraitru</td></tr><tr class="gloss"><td>An-actual</td><td>current</td><td>noblest-governor</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>be</td><td>le</td><td>fasygu'e</td><td>cu</td><td>na</td><td>krecau</td></tr><tr class="gloss"><td>of</td><td>the</td><td>French-country</td><td></td><td>[false]</td><td>is-hair-without.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is false that the current King of France is bald.</p></td></tr></tbody></table>

</div>  

Note: _<a id="id-1.16.6.47.1.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ is used in these sentences because negation relates to truth conditions. To meaningfully talk about truth conditions in sentences carrying a description, it must be clear that the description actually applies to the referent. A sentence using _<a id="id-1.16.6.47.2.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ instead of _<a id="id-1.16.6.47.3.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ can be true even if there is no current king of France, as long as the speaker and the listener agree to describe something as the current king of France. (See the explanations of _<a id="id-1.16.6.47.4.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ in [Section 6.2](../section-basic-descriptors).)