<a id="section-na-outside-prenex"></a>16.11. <a id="c16s11"></a>Using _naku_ outside a prenex
---------------------------------------------------------------------------------------------

Let us consider the English sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-hp0j"></a>

**Example 16.79. <a id="c16e11d1"></a><a id="id-1.17.13.3.1.2" class="indexterm"></a>** 

<a id="id-1.17.13.3.2.1" class="indexterm"></a>Some children do not go to school.

</div>  

We cannot express this directly with _<a id="id-1.17.13.4.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ ; the apparently obvious translation

<div class="interlinear-gloss-example example">
<a id="example-random-id-6mHh"></a>

**Example 16.80. <a id="c16e11d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'oda</td><td>poi</td><td>verba</td></tr><tr class="gloss"><td>At-least-one-X</td><td>which-are</td><td>child(ren)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>na</td><td>klama</td><td>su'ode</td><td>poi</td><td>ckule</td></tr><tr class="gloss"><td>[false]</td><td>go-to</td><td>at-least-one-Y</td><td>which-are</td><td>school(s).</td></tr></tbody></table>

</div>  

when converted to the external negation form produces:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nGTc"></a>

**Example 16.81. <a id="c16e11d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>naku</td><td>zo'u</td><td>su'oda</td><td>poi</td><td>verba</td><td>cu</td></tr><tr class="gloss"><td>It-is-false</td><td>that</td><td>some-which</td><td>are</td><td>children</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>klama</td><td>su'ode</td><td>poi</td><td>ckule</td></tr><tr class="gloss"><td>go-to</td><td>some-which</td><td>are</td><td>schools.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">All children don't go to some school (not just some children).</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.13.8.1" class="indexterm"></a><a id="id-1.17.13.8.2" class="indexterm"></a><a id="id-1.17.13.8.3" class="indexterm"></a>Lojban provides a negation form which more closely emulates natural language negation. This involves putting _<a id="id-1.17.13.8.4.1" class="indexterm"></a>naku_ before the selbri, instead of a _<a id="id-1.17.13.8.5.1" class="indexterm"></a>[_na_](../go01#valsi-na)_. _<a id="id-1.17.13.8.6.1" class="indexterm"></a>naku_ is clearly a contradictory negation, given its parallel with prenex bridi negation. Using _<a id="id-1.17.13.8.7.1" class="indexterm"></a>naku_ , [Example 16.79](../section-na-outside-prenex#example-random-id-hp0j) can be expressed as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nvtf"></a>

**Example 16.82. <a id="c16e11d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'oda</td><td>poi</td><td>verba</td><td>ku'o</td><td>naku</td><td>klama</td><td>su'ode</td><td>poi</td><td>ckule</td></tr><tr class="gloss"><td>Some</td><td>that</td><td>are-children</td><td></td><td>don't</td><td>go-to</td><td>some</td><td>that-are</td><td>schools.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some children don't go to a school.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.13.10.1" class="indexterm"></a>Although it is not technically a sumti, _<a id="id-1.17.13.10.2.1" class="indexterm"></a>naku_ can be used in most of the places where a sumti may appear. We'll see what this means in a moment.

<a id="id-1.17.13.11.1" class="indexterm"></a><a id="id-1.17.13.11.2" class="indexterm"></a><a id="id-1.17.13.11.3" class="indexterm"></a><a id="id-1.17.13.11.4" class="indexterm"></a>When you use _<a id="id-1.17.13.11.5.1" class="indexterm"></a>naku_ within a bridi, you are explicitly creating a negation boundary. As explained in [Section 16.9](../section-negation-boundaries) , when a prenex negation boundary expressed by _<a id="id-1.17.13.11.7.1" class="indexterm"></a>naku_ moves past a quantifier, the quantifier has to be inverted. The same is true for _<a id="id-1.17.13.11.8.1" class="indexterm"></a>naku_ in the bridi proper. We can move _<a id="id-1.17.13.11.9.1" class="indexterm"></a>naku_ to any place in the sentence where a sumti can go, inverting any quantifiers that the negation boundary crosses. Thus, the following are equivalent to [Example 16.82](../section-na-outside-prenex#example-random-id-nvtf) (no good English translations exist):

<div class="interlinear-gloss-example example">
<a id="example-random-id-qhLG"></a>

**Example 16.83. <a id="c16e11d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'oda</td><td>poi</td><td>verba</td><td>cu</td><td>klama</td><td>rode</td><td>poi</td><td>ckule</td><td>ku'o</td><td>naku</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">For some children, for every school, they don't go to it.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhnP"></a>

**Example 16.84. <a id="c16e11d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'oda</td><td>poi</td><td>verba</td><td>cu</td><td>klama</td><td>naku</td><td>su'ode</td><td>poi</td><td>ckule</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some children don't go to (some) school(s).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhoH"></a>

**Example 16.85. <a id="c16e11d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>naku</td><td>roda</td><td>poi</td><td>verba</td><td>cu</td><td>klama</td><td>su'ode</td><td>poi</td><td>ckule</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is false that all children go to some school(s).</p></td></tr></tbody></table>

</div>  

In [Example 16.83](../section-na-outside-prenex#example-random-id-qhLG) , we moved the negation boundary rightward across the quantifier of _<a id="id-1.17.13.15.2.1" class="indexterm"></a>[_de_](../go01#valsi-de)_ , forcing us to invert it. In [Example 16.85](../section-na-outside-prenex#example-random-id-qhoH) we moved the negation boundary across the quantifier of _<a id="id-1.17.13.15.4.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ , forcing us to invert it instead. [Example 16.84](../section-na-outside-prenex#example-random-id-qhnP) merely switched the selbri and the negation boundary, with no effect on the quantifiers.

<a id="id-1.17.13.16.1" class="indexterm"></a>The same rules apply if you rearrange the sentence so that the quantifier crosses an otherwise fixed negation. You can't just convert the selbri of [Example 16.82](../section-na-outside-prenex#example-random-id-nvtf) and rearrange the sumti to produce

<div class="interlinear-gloss-example example">
<a id="example-random-id-rHwu"></a>

**Example 16.86. <a id="c16e11d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'ode</td><td>poi</td><td>ckule</td><td>ku'o</td><td>naku</td><td>se</td><td>klama</td><td>roda</td><td>poi</td><td>verba</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some schools aren't gone-to-by every child.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.13.18.1" class="indexterm"></a><a id="id-1.17.13.18.2" class="indexterm"></a><a id="id-1.17.13.18.3" class="indexterm"></a>or rather, [Example 16.86](../section-na-outside-prenex#example-random-id-rHwu) means something completely different from [Example 16.82](../section-na-outside-prenex#example-random-id-nvtf). Conversion with _<a id="id-1.17.13.18.6.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ under _<a id="id-1.17.13.18.7.1" class="indexterm"></a>naku_ negation is not symmetric; not all sumti are treated identically, and some sumti are not invariant under conversion. Thus, internal negation with _<a id="id-1.17.13.18.8.1" class="indexterm"></a>naku_ is considered an advanced technique, used to achieve stylistic compatibility with natural languages.

It isn't always easy to see which quantifiers have to be inverted in a sentence. [Example 16.82](../section-na-outside-prenex#example-random-id-nvtf) is identical in meaning to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-S6y4"></a>

**Example 16.87. <a id="c16e11d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'o</td><td>verba</td><td>naku</td><td>klama</td><td>su'o</td><td>ckule</td></tr><tr class="gloss"><td>Some</td><td>children</td><td>don't</td><td>go-to</td><td>some</td><td>school.</td></tr></tbody></table>

</div>  

<a id="id-1.17.13.21.1" class="indexterm"></a>but in [Example 16.87](../section-na-outside-prenex#example-random-id-S6y4) , the bound variables _<a id="id-1.17.13.21.3.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ and _<a id="id-1.17.13.21.4.1" class="indexterm"></a>[_de_](../go01#valsi-de)_ have been hidden.

<a id="id-1.17.13.22.1" class="indexterm"></a><a id="id-1.17.13.22.2" class="indexterm"></a>It is trivial to export an internal bridi negation expressed with _<a id="id-1.17.13.22.3.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ to the prenex, as we saw in [Section 16.9](../section-negation-boundaries) ; you just move it to the left end of the prenex. In comparison, it is non-trivial to export a _<a id="id-1.17.13.22.5.1" class="indexterm"></a>naku_ to the prenex because of the quantifiers. The rules for exporting _<a id="id-1.17.13.22.6.1" class="indexterm"></a>naku_ require that you export all of the quantified variables (implicit or explicit) along with _<a id="id-1.17.13.22.7.1" class="indexterm"></a>naku_ , and you must export them from left to right, in the same order that they appear in the sentence. Thus [Example 16.82](../section-na-outside-prenex#example-random-id-nvtf) goes into prenex form as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3f22"></a>

**Example 16.88. <a id="c16e11d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'oda</td><td>poi</td><td>verba</td><td>ku'o</td><td>naku</td></tr><tr class="gloss"><td>For-some-X</td><td>which</td><td>is-a-child,</td><td></td><td>it-is-not-the-case-that</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'ode</td><td>poi</td><td>ckule</td><td>zo'u</td><td>da</td><td>klama</td><td>de</td></tr><tr class="gloss"><td>there-is-a-Y</td><td>which</td><td>is-a-school</td><td>such-that:</td><td>X</td><td>goes</td><td>to</td><td>Y.</td></tr></tbody></table>

</div>  

We can now move the _<a id="id-1.17.13.24.1.1" class="indexterm"></a>naku_ to the left end of the prenex, getting a contradictory negation that can be expressed with _<a id="id-1.17.13.24.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-gPvc"></a>

**Example 16.89. <a id="c16e11d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>naku</td><td>roda</td><td>poi</td><td>verba</td><td>ku'o</td></tr><tr class="gloss"><td>It-is-not-the-case-that</td><td>for-all-X's</td><td>which-are</td><td>children,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'ode</td><td>poi</td><td>ckule</td><td>zo'u</td><td>da</td><td>klama</td><td>de</td></tr><tr class="gloss"><td>there-is-a-Y</td><td>which-is</td><td>a-school</td><td>such-that:</td><td>X</td><td>goes-to</td><td>Y.</td></tr></tbody></table>

</div>  

from which we can restore the quantified variables to the sentence, giving:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Awc0"></a>

**Example 16.90. <a id="c16e11d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>naku</td><td>zo'u</td><td>roda</td><td>poi</td><td>verba</td><td>cu</td><td>klama</td><td>su'ode</td><td>poi</td><td>ckule</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is not the case that all children go to some school.</p></td></tr></tbody></table>

</div>  

or more briefly

<div class="interlinear-gloss-example example">
<a id="example-random-id-msIC"></a>

**Example 16.91. <a id="c16e11d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>verba</td><td>cu</td><td>na</td><td>klama</td><td>su'o</td><td>ckule</td></tr><tr class="gloss"><td>All</td><td>children</td><td></td><td>[false]</td><td>go-to</td><td>some</td><td>school(s).</td></tr></tbody></table>

</div>  

<a id="id-1.17.13.30.1" class="indexterm"></a>As noted in [Section 16.5](../section-prenex-elision) , a sentence with two different quantified variables, such as [Example 16.91](../section-na-outside-prenex#example-random-id-msIC) , cannot always be converted with _<a id="id-1.17.13.30.4.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ without first exporting the quantified variables. When the variables have been exported, the sentence proper can be converted, but the quantifier order in the prenex must remain unchanged:

<div class="interlinear-gloss-example example">
<a id="example-random-id-d8h3"></a>

**Example 16.92. <a id="c16e11d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>roda</td><td>poi</td><td>verba</td><td>ku'o</td><td>su'ode</td></tr><tr class="gloss"><td>for-all-X's</td><td>that-are</td><td>children</td><td>,</td><td>there-is-a-Y</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>poi</td><td>ckule</td><td>zo'u</td><td>de</td><td>na</td><td>se</td><td>klama</td><td>da</td></tr><tr class="gloss"><td>that</td><td>is-a-school</td><td>such-that:</td><td>Y</td><td>it-is-not-the-case-that:</td><td></td><td>is-gone-to-by</td><td>X.</td></tr></tbody></table>

</div>  

<a id="id-1.17.13.32.1" class="indexterm"></a><a id="id-1.17.13.32.2" class="indexterm"></a>While you can't freely convert with _<a id="id-1.17.13.32.3.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ when you have two quantified variables in a sentence, you can still freely move sumti to either side of the selbri, as long as the order isn't changed. If you use _<a id="id-1.17.13.32.4.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ negation in such a sentence, nothing special need be done. If you use _<a id="id-1.17.13.32.5.1" class="indexterm"></a>naku_ negation, then quantified variables that cross the negation boundary must be inverted.

<a id="id-1.17.13.33.1" class="indexterm"></a><a id="id-1.17.13.33.2" class="indexterm"></a>Clearly, if all of Lojban negation was built on _<a id="id-1.17.13.33.3.1" class="indexterm"></a>naku_ negation instead of _<a id="id-1.17.13.33.4.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ negation, logical manipulation in Lojban would be as difficult as in natural languages. In [Section 16.12](../section-demorgans-law) , for example, we'll discuss DeMorgan's Law, which must be used whenever a sumti with a logical connection is moved across a negation boundary.

<a id="id-1.17.13.34.1" class="indexterm"></a>Since _<a id="id-1.17.13.34.2.1" class="indexterm"></a>naku_ has the grammar of a sumti, it can be placed almost anywhere a sumti can go, including _<a id="id-1.17.13.34.3.1" class="indexterm"></a>[_be_](../go01#valsi-be)_ and _<a id="id-1.17.13.34.4.1" class="indexterm"></a>[_bei_](../go01#valsi-bei)_ clauses; it isn't clear what these mean, and we recommend avoiding such constructs.

<a id="id-1.17.13.35.1" class="indexterm"></a><a id="id-1.17.13.35.2" class="indexterm"></a>You can put multiple _<a id="id-1.17.13.35.3.1" class="indexterm"></a>naku_ compounds in a sentence, each forming a separate negation boundary. Two adjacent _<a id="id-1.17.13.35.4.1" class="indexterm"></a>naku_ compounds in a bridi are a double negative and cancel out:

<div class="interlinear-gloss-example example">
<a id="example-random-id-u784"></a>

**Example 16.93. <a id="c16e11d15"></a>** 

<a id="id-1.17.13.36.2.1" class="indexterm"></a>mi naku naku le zarci cu klama

</div>  

Other expressions using two _<a id="id-1.17.13.37.1.1" class="indexterm"></a>naku_ compounds may or may not cancel out. If there is no quantified variable between them, then the _<a id="id-1.17.13.37.2.1" class="indexterm"></a>naku_ compounds cancel.

Negation with internal _<a id="id-1.17.13.38.1.1" class="indexterm"></a>naku_ is clumsy and non-intuitive for logical manipulations, but then, so are the natural language features it is emulating.