<a id="section-n-part-lujvo"></a>12.8. <a id="c12s8"></a>lujvo with more than two parts.
----------------------------------------------------------------------------------------

<a id="id-1.13.10.2.1" class="indexterm"></a>The theory we have outlined so far is an account of lujvo with two parts. But often lujvo are made containing more than two parts. An example is _<a id="id-1.13.10.2.2.1" class="indexterm"></a>[_bavlamdei_](../go01#valsi-bavlamdei)_ , “tomorrow” : it is composed of the rafsi for “future” , “adjacent” , and “day”. How does the account we have given apply to lujvo like this?

The best way to approach such lujvo is to continue to classify them as based on binary tanru, the only difference being that the seltau or the tertau or both is itself a lujvo. So it is easiest to make sense of _<a id="id-1.13.10.3.1.1" class="indexterm"></a>[_bavlamdei_](../go01#valsi-bavlamdei)_ as having two components: _<a id="id-1.13.10.3.2.1" class="indexterm"></a>[_bavla'i_](../go01#valsi-bavlahi)_ , “next” , and _<a id="id-1.13.10.3.4.1" class="indexterm"></a>[_djedi_](../go01#valsi-djedi)_. If we know or invent the lujvo place structure for the components, we can compose the new lujvo place structure in the usual way.

In this case, _<a id="id-1.13.10.4.1.1" class="indexterm"></a>[_bavla'i_](../go01#valsi-bavlahi)_ is given the place structure

<div class="example">
<a id="example-random-id-aCg7"></a>

**Example 12.37. <a id="c12e8d1"></a>** 

> b1=l1 is next after b2=l2

</div>  

making it a symmetrical lujvo. We combine this with _<a id="id-1.13.10.6.1.1" class="indexterm"></a>[_djedi_](../go01#valsi-djedi)_ , which has the place structure:

<div class="example">
<a id="example-random-id-Lera"></a>

**Example 12.38. <a id="c12e8d2"></a>** 

duration d1 is d2 days long (default 1) by standard d3

</div>  

<a id="id-1.13.10.8.1" class="indexterm"></a>While symmetrical lujvo normally put any trailing tertau places before any seltau places, the day standard is a much less important concept than the day the tomorrow follows, in the definition of _<a id="id-1.13.10.8.2.1" class="indexterm"></a>[_bavlamdei_](../go01#valsi-bavlamdei)_. This is an example of how the guidelines presented for selecting and ordering lujvo places are just that, not laws that must be rigidly adhered to. In this case, we choose to rank places in order of relative importance. The resulting place structure is:

<div class="example">
<a id="example-random-id-KEwW"></a>

**Example 12.39. <a id="c12e8d3"></a><a id="id-1.13.10.9.1.2" class="indexterm"></a>** 

> d1=b1=l1 is a day following b2=l2, d2 days later (default 1) by standard d3

</div>  

<a id="id-1.13.10.10.1" class="indexterm"></a>Here is another example of a multi-part lujvo: _<a id="id-1.13.10.10.2.1" class="indexterm"></a>[_cladakyxa'i_](../go01#valsi-cladakyxahi)_ , meaning “long-sword” , a specific type of medieval weapon. The gismu place structures are:

<div class="example">
<a id="example-random-id-XpNf"></a>

**Example 12.40. <a id="c12e8d4"></a>** 

_<a id="id-1.13.10.11.2.1.1" class="indexterm"></a>[_clani_](../go01#valsi-clani)_ : c1 is long in direction c2 by standard c3

_<a id="id-1.13.10.11.3.1.1" class="indexterm"></a>[_dakfu_](../go01#valsi-dakfu)_ : d1 is a knife for cutting d2 with blade made of d3

_<a id="id-1.13.10.11.4.1.1" class="indexterm"></a>[_xarci_](../go01#valsi-xarci)_ : xa1 is a weapon for use against xa2 by wielder xa3

</div>  

<a id="id-1.13.10.12.1" class="indexterm"></a>Since _<a id="id-1.13.10.12.2.1" class="indexterm"></a>[_cladakyxa'i_](../go01#valsi-cladakyxahi)_ is a symmetrical lujvo based on _<a id="id-1.13.10.12.3.1" class="indexterm"></a>cladakfu xarci_ , and _<a id="id-1.13.10.12.4.1" class="indexterm"></a>[_cladakfu_](../go01#valsi-cladakfu)_ is itself a symmetrical lujvo, we can do the necessary analyses all at once. Plainly c1 (the long thing), d1 (the knife), and xa1 (the weapon) are all the same. Likewise, the d2 place (the thing cut) is the same as the xa2 place (the target of the weapon), given that swords are used to cut victims. Finally, the c2 place (direction of length) is always along the sword blade in a longsword, by definition, and so is dependent on c1=d1=xa1. Adding on the places of the remaining gismu in right-to-left order we get:

<div class="example">
<a id="example-random-id-eAbF"></a>

**Example 12.41. <a id="c12e8d5"></a><a id="id-1.13.10.13.1.2" class="indexterm"></a>** 

> xa1=d1=c1 is a long-sword for use against xa2=d2 by wielder xa3, with a blade made of d3, length measured by standard c3.

</div>  

If the last place sounds unimportant to you, notice that what counts legally as a “sword” , rather than just a “knife” , depends on the length of the blade (the legal limit varies in different jurisdictions). This fifth place of _<a id="id-1.13.10.14.3.1" class="indexterm"></a>[_cladakyxa'i_](../go01#valsi-cladakyxahi)_ may not often be explicitly filled, but it is still useful on occasion. Because it is so seldom important, it is best that it be last.