<a id="section-more-quotations"></a>19.10. <a id="c19s10"></a>More on quotations: ZO, ZOI
-----------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zo</p></td><td class="selmaho"><p class="selmaho">ZO</p></td><td class="description"><p class="description">quote single word</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zoi</p></td><td class="selmaho"><p class="selmaho">ZOI</p></td><td class="description"><p class="description">non-Lojban quotation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">la'o</p></td><td class="selmaho"><p class="selmaho">ZOI</p></td><td class="description"><p class="description">non-Lojban name</p></td></tr></tbody></table>

The cmavo _<a id="id-1.20.12.4.1.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ (of selma'o ZO) is a strong quotation mark for the single following word, which can be any Lojban word whatsoever. Among other uses, _<a id="id-1.20.12.4.2.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ allows a metalinguistic word to be referenced without having it act on the surrounding text. The word must be a morphologically legal (but not necessarily meaningful) single Lojban word; compound cmavo are not permitted. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qxjF"></a>

**Example 19.48. <a id="c19e10d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zo si cu lojbo valsi</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.12.5.3.1.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-si"><em class="glossterm">si</em></a></em></span> is a Lojbanic word.</p></td></tr></tbody></table>

</div>  

Since _<a id="id-1.20.12.6.1.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ acts on a single word only, there is no corresponding terminator. Brevity, then, is a great advantage of _<a id="id-1.20.12.6.2.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ , since the terminators for other kinds of quotation are rarely or never elidable.

The cmavo _<a id="id-1.20.12.7.1.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ (of selma'o ZOI) is a quotation mark for quoting non-Lojban text. Its syntax is _<a id="id-1.20.12.7.2.1" class="indexterm"></a>zoi .X. text .X_ , where X is a Lojban word (called the delimiting word) which is separated from the quoted text by pauses, and which is not found in the written text or spoken phoneme stream. It is common, but not required, to use the lerfu word (of selma'o BY) which corresponds to the Lojban name of the language being quoted:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wYzm"></a>

**Example 19.49. <a id="c19e10d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zoi gy. John is a man .gy. cu glico jufra</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span class="quote">“<span class="quote">John is a man</span>”</span> is an English sentence.</p></td></tr></tbody></table>

</div>  

where _<a id="id-1.20.12.9.1.1" class="indexterm"></a>[_gy._](../go01#valsi-gy)_ stands for _<a id="id-1.20.12.9.2.1" class="indexterm"></a>[_glico_](../go01#valsi-glico)_. Other popular choices of delimiting words are _.kuot._ , a cmevla which sounds like the English word “quote” , and the word _<a id="id-1.20.12.9.5.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ itself. Another possibility is a Lojban word suggesting the topic of the quotation.

Within written text, the Lojban written word used as a delimiting word may not appear, whereas within spoken text, the sound of the delimiting word may not be uttered. This leads to occasional breakdowns of audio-visual isomorphism: [Example 19.50](../section-more-quotations#example-random-id-qIsv) is fine in speech but ungrammatical as written, whereas [Example 19.51](../section-more-quotations#example-random-id-qIsx) is correct when written but ungrammatical in speech.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qIsv"></a>

**Example 19.50. <a id="c19e10d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi djuno fi le valsi po'u zoi gy. gyrations .gy.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I know about the word which-is <span class="quote">“<span class="quote">gyrations</span>”</span>.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qIsx"></a>

**Example 19.51. <a id="c19e10d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi djuno fi le valsi po'u zoi jai. gyrations .jai</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I know about the word which-is <span class="quote">“<span class="quote">gyrations</span>”</span>.</p></td></tr></tbody></table>

</div>  

The text _<a id="id-1.20.12.13.1.1" class="indexterm"></a>[_gy._](../go01#valsi-gy)_ appears in the written word “gyrations” , whereas the sound represented in Lojban by _<a id="id-1.20.12.13.3.1" class="indexterm"></a>[_jai_](../go01#valsi-jai)_ appears in the spoken word “gyrations”. Such borderline cases should be avoided as a matter of good style.

It should be noted particularly that _<a id="id-1.20.12.14.1.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ quotation is the only way to quote rafsi, specifically CCV rafsi, because they are not Lojban words, and _<a id="id-1.20.12.14.2.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ quotation is the only way to quote things which are not Lojban words. (CVC and CVV rafsi look like cmevla and cmavo respectively, and so can be quoted using other methods.) For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Eeya"></a>

**Example 19.52. <a id="c19e10d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zoi ry. sku .ry. cu rafsi zo cusku</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span class="quote">“<span class="quote"><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sku</em></span></span>”</span> is a rafsi of <span class="quote">“<span class="quote"><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.12.15.3.1.1.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cusku"><em class="glossterm">cusku</em></a></em></span></span>”</span>.</p></td></tr></tbody></table>

</div>  

(A minor note on interaction between _<a id="id-1.20.12.16.1.1" class="indexterm"></a>lo'u ... le'u_ and _<a id="id-1.20.12.16.2.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ : The text between _<a id="id-1.20.12.16.3.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ and _<a id="id-1.20.12.16.4.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ should consist of Lojban words only. In fact, non-Lojban material in the form of a _<a id="id-1.20.12.16.5.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ quotation may also appear. However, if the word _<a id="id-1.20.12.16.6.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ is used either as the delimiting word for the _<a id="id-1.20.12.16.7.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ quotation, or within the quotation itself, the outer _<a id="id-1.20.12.16.8.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation will be prematurely terminated. Therefore, _<a id="id-1.20.12.16.9.1" class="indexterm"></a>[_le'u_](../go01#valsi-lehu)_ should be avoided as the delimiting word in any _<a id="id-1.20.12.16.10.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ quotation.)

Lojban strictly avoids any confusion between things and the names of things:

<div class="interlinear-gloss-example example">
<a id="example-random-id-56m5"></a>

**Example 19.53. <a id="c19e10d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zo</td><td>.bab.</td><td>cmene</td><td>la</td><td>.bab.</td></tr><tr class="gloss"><td>The-word</td><td><span class="quote">“<span class="quote">Bob</span>”</span></td><td>is-the-name-of</td><td>the-one-named</td><td>Bob.</td></tr></tbody></table>

</div>  

In [Example 19.53](../section-more-quotations#example-random-id-56m5) , _<a id="id-1.20.12.19.2.1" class="indexterm"></a>zo .bab._ is the word, whereas _<a id="id-1.20.12.19.3.1" class="indexterm"></a>la .bab._ is the thing named by the word. The cmavo _<a id="id-1.20.12.19.4.1" class="indexterm"></a>[_la'e_](../go01#valsi-lahe)_ and _<a id="id-1.20.12.19.5.1" class="indexterm"></a>[_lu'e_](../go01#valsi-luhe)_ (of selma'o LAhE) convert back and forth between references and their referents:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qITB"></a>

**Example 19.54. <a id="c19e10d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zo</td><td>.bab.</td><td>cmene</td><td>la'e</td><td>zo</td><td>.bab.</td></tr><tr class="gloss"><td>The-word</td><td><span class="quote">“<span class="quote">Bob</span>”</span></td><td>is-the-name-of</td><td>the-referent-of</td><td>the-word</td><td><span class="quote">“<span class="quote">Bob</span>”</span></td><td>.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qiTd"></a>

**Example 19.55. <a id="c19e10d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lu'e</td><td>la</td><td>.bab.</td><td>cmene</td><td>la</td><td>.bab.</td></tr><tr class="gloss"><td>A-symbol-for</td><td></td><td>Bob</td><td>is-the-name-of</td><td></td><td>Bob.</td></tr></tbody></table>

</div>  

[Example 19.53](../section-more-quotations#example-random-id-56m5) through [Example 19.55](../section-more-quotations#example-random-id-qiTd) all mean approximately the same thing, except for differences in emphasis. [Example 19.56](../section-more-quotations#example-random-id-3yXJ) is different:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3yXJ"></a>

**Example 19.56. <a id="c19e10d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .bab. cmene la .bab.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Bob is the name of Bob.</p></td></tr></tbody></table>

</div>  

and says that Bob is both the name and the thing named, an unlikely situation. People are not names.

(In [Example 19.53](../section-more-quotations#example-random-id-56m5) through [Example 19.54](../section-more-quotations#example-random-id-qITB) , the name _.bab._ was separated from a preceding _<a id="id-1.20.12.25.4.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ by a pause, thus: _<a id="id-1.20.12.25.5.1" class="indexterm"></a>zo .bab._. The reason for this extra pause is that all Lojban names must be separated by pause from any preceding word. There are numerous other cmavo that may precede a name: of these, _<a id="id-1.20.12.25.6.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ is one of the most common.)

The cmavo _<a id="id-1.20.12.26.1.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ also belongs to selma'o ZOI, and is mentioned here for completeness, although it does not signal the beginning of a quotation. Instead, _<a id="id-1.20.12.26.2.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ serves to mark non-Lojban names, especially the Linnaean binomial names (such as “Homo sapiens”) which are the internationally standardized names for species of animals and plants. Internationally known names which can more easily be recognized by spelling rather than pronunciation, such as “Goethe” , can also appear in Lojban text with _<a id="id-1.20.12.26.5.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-Sn3u"></a>

**Example 19.57. <a id="c19e10d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Goethe is a Homo sapiens.</p></td></tr></tbody></table>

</div>  

Using _<a id="id-1.20.12.28.1.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ for all names rather than Lojbanizing, however, makes for very cumbersome text. A rough equivalent of _<a id="id-1.20.12.28.2.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ might be _<a id="id-1.20.12.28.3.1" class="indexterm"></a>la me zoi_.